/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.CodedName;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;

public class TinyAttributeCollection
implements AttributeCollection {
    int element;
    TinyTree tree;
    int firstAttribute;

    public TinyAttributeCollection(TinyTree tree, int element) {
        this.tree = tree;
        this.element = element;
        this.firstAttribute = tree.alpha[element];
    }

    public int getLength() {
        int i2;
        for (i2 = this.firstAttribute; i2 < this.tree.numberOfAttributes && this.tree.attParent[i2] == this.element; ++i2) {
        }
        return i2 - this.firstAttribute;
    }

    public int getNameCode(int index) {
        return this.tree.attCode[this.firstAttribute + index];
    }

    public NodeName getNodeName(int index) {
        return new CodedName(this.tree.attCode[this.firstAttribute + index], this.tree.getNamePool());
    }

    public SimpleType getTypeAnnotation(int index) {
        if (this.tree.attTypeCode == null) {
            return BuiltInAtomicType.UNTYPED_ATOMIC;
        }
        return (SimpleType)this.tree.getConfiguration().getSchemaType(this.tree.getAttributeAnnotation(this.firstAttribute + index));
    }

    public int getLocationId(int index) {
        return 0;
    }

    public String getSystemId(int index) {
        return this.tree.getSystemId(this.element);
    }

    public int getLineNumber(int index) {
        return -1;
    }

    public int getProperties(int index) {
        return 0;
    }

    public String getPrefix(int index) {
        return this.tree.getNamePool().getPrefix(this.tree.attCode[this.firstAttribute + index]);
    }

    public String getQName(int index) {
        return this.tree.getNamePool().getDisplayName(this.tree.attCode[this.firstAttribute + index]);
    }

    public String getLocalName(int index) {
        return this.tree.getNamePool().getLocalName(this.tree.attCode[this.firstAttribute + index]);
    }

    public String getURI(int index) {
        return this.tree.getNamePool().getURI(this.tree.attCode[this.firstAttribute + index]);
    }

    public int getIndex(String uri, String localname) {
        int fingerprint = this.tree.getNamePool().getFingerprint(uri, localname);
        return this.getIndexByFingerprint(fingerprint);
    }

    public int getIndexByFingerprint(int fingerprint) {
        int i2 = this.firstAttribute;
        while (this.tree.attParent[i2] == this.element) {
            if ((this.tree.attCode[i2] & 0xFFFFF) == fingerprint) {
                return i2 - this.firstAttribute;
            }
            ++i2;
        }
        return -1;
    }

    public String getValueByFingerprint(int fingerprint) {
        return this.getValue(this.getIndexByFingerprint(fingerprint));
    }

    public String getValue(String uri, String localname) {
        return this.getValue(this.getIndex(uri, localname));
    }

    public String getValue(int index) {
        CharSequence cs = this.tree.attValue[this.firstAttribute + index];
        return cs == null ? null : cs.toString();
    }

    public boolean isId(int index) {
        return this.getTypeAnnotation(index).getFingerprint() == 560 || (this.tree.attCode[this.firstAttribute + index] & 0xFFFFF) == 388;
    }

    public boolean isIdref(int index) {
        return this.getTypeAnnotation(index).getFingerprint() == 561 || this.getTypeAnnotation(index).getFingerprint() == 562;
    }
}

