/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.tiny;

import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.TinyBuilder;
import net.sf.saxon.tree.tiny.TinyTextImpl;
import net.sf.saxon.tree.tiny.TinyTree;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.z.IntHashMap;

public class TinyBuilderCondensed
extends TinyBuilder {
    public IntHashMap<int[]> textValues = new IntHashMap(100);

    public TinyBuilderCondensed(PipelineConfiguration pipe) {
        super(pipe);
    }

    public void endElement() throws XPathException {
        TinyTree tree = this.getTree();
        int n = tree.numberOfNodes - 1;
        if (tree.nodeKind[n] == 3 && tree.depth[n] == this.getCurrentDepth() && tree.beta[n] - tree.alpha[n] <= 256) {
            CharSequence chars = TinyTextImpl.getStringValue(tree, n);
            int hash = chars.hashCode();
            int[] nodes = this.textValues.get(hash);
            if (nodes != null) {
                int nodeNr;
                int used = nodes[0];
                for (int i2 = 1; i2 < used && (nodeNr = nodes[i2]) != 0; ++i2) {
                    if (!TinyBuilderCondensed.isEqual(chars, TinyTextImpl.getStringValue(tree, nodeNr))) continue;
                    int length = tree.alpha[n];
                    tree.alpha[n] = tree.alpha[nodeNr];
                    tree.beta[n] = tree.beta[nodeNr];
                    tree.getCharacterBuffer().setLength(length);
                    break;
                }
            } else {
                nodes = new int[4];
                nodes[0] = 1;
                this.textValues.put(hash, nodes);
            }
            if (nodes[0] + 1 > nodes.length) {
                int[] n2 = new int[nodes.length * 2];
                System.arraycopy(nodes, 0, n2, 0, nodes[0]);
                this.textValues.put(hash, n2);
                nodes = n2;
            }
            int n2 = nodes[0];
            nodes[0] = n2 + 1;
            nodes[n2] = n;
        }
        super.endElement();
    }

    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        super.attribute(nameCode, typeCode, value.toString().intern(), locationId, properties);
    }

    private static boolean isEqual(CharSequence a, CharSequence b) {
        if (a.getClass() == b.getClass()) {
            return a.equals(b);
        }
        return a.toString().equals(b.toString());
    }
}

