/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.Controller;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TeeOutputter;
import net.sf.saxon.expr.LastPositionFinder;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.GroundedIterator;
import net.sf.saxon.tree.iter.ListIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.SequenceExtent;

public class MemoClosure
extends Closure {
    private List<Item> reservoir = null;
    protected int state;
    private static final int UNREAD = 0;
    private static final int MAYBE_MORE = 1;
    private static final int ALL_READ = 3;
    private static final int BUSY = 4;
    protected static final int EMPTY = 5;

    public synchronized SequenceIterator iterate() throws XPathException {
        switch (this.state) {
            case 0: {
                this.state = 4;
                SequenceIterator in = this.expression.iterate(this.savedXPathContext);
                if (in instanceof EmptyIterator) {
                    this.state = 5;
                    this.inputIterator = EmptyIterator.emptyIterator();
                    return this.inputIterator;
                }
                this.inputIterator = in;
                this.reservoir = new ArrayList<Item>(50);
                this.state = 1;
                return new ProgressiveIterator();
            }
            case 1: {
                return new ProgressiveIterator();
            }
            case 3: {
                switch (this.reservoir.size()) {
                    case 0: {
                        this.state = 5;
                        return EmptyIterator.emptyIterator();
                    }
                    case 1: {
                        assert (this.reservoir != null);
                        return SingletonIterator.makeIterator(this.reservoir.get(0));
                    }
                }
                return new ListIterator(this.reservoir);
            }
            case 4: {
                XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
                de.setErrorCode("XTDE0640");
                throw de;
            }
            case 5: {
                return EmptyIterator.emptyIterator();
            }
        }
        throw new IllegalStateException("Unknown iterator state");
    }

    public synchronized void process(XPathContext context) throws XPathException {
        if (this.state == 5) {
            return;
        }
        if (this.state == 4) {
            XPathException de = new XPathException("Attempt to access a variable while it is being evaluated");
            de.setErrorCode("XTDE0640");
            de.setXPathContext(context);
            throw de;
        }
        if (this.reservoir != null) {
            Item it;
            SequenceIterator iter = this.iterate();
            SequenceReceiver out = context.getReceiver();
            while ((it = iter.next()) != null) {
                out.append(it, 0, 2);
            }
        } else {
            this.state = 4;
            Controller controller = context.getController();
            XPathContextMajor c2 = this.savedXPathContext.newContext();
            SequenceOutputter seq = controller.allocateSequenceOutputter(20);
            seq.open();
            TeeOutputter tee = new TeeOutputter(context.getReceiver(), seq);
            tee.setPipelineConfiguration(controller.makePipelineConfiguration());
            c2.setReceiver(tee);
            c2.setTemporaryOutputState(206);
            this.expression.process(c2);
            seq.close();
            List<Item> list = seq.getList();
            if (list.isEmpty()) {
                this.state = 5;
            } else {
                this.reservoir = list;
                this.state = 3;
            }
            this.savedXPathContext = null;
            seq.reset();
        }
    }

    private void append(Item item) {
        assert (this.reservoir != null);
        this.reservoir.add(item);
    }

    private void condense() {
        if (this.reservoir != null) {
            ((ArrayList)this.reservoir).trimToSize();
        }
        this.savedXPathContext = null;
    }

    public boolean isFullyRead() {
        return this.state == 5 || this.state == 3;
    }

    public synchronized Item itemAt(int n) throws XPathException {
        if (n < 0) {
            return null;
        }
        if (this.reservoir != null && n < this.reservoir.size()) {
            return this.reservoir.get(n);
        }
        if (this.state == 3 || this.state == 5) {
            return null;
        }
        if (this.state == 0) {
            Item item;
            if (this.inputIterator == null) {
                SequenceIterator in;
                this.state = 4;
                this.inputIterator = in = this.expression.iterate(this.savedXPathContext);
            }
            if ((item = this.inputIterator.next()) == null) {
                this.state = 5;
                return null;
            }
            this.state = 1;
            this.reservoir = new ArrayList<Item>(50);
            this.append(item);
            if (n == 0) {
                return item;
            }
        }
        int diff = n - this.reservoir.size() + 1;
        while (diff-- > 0) {
            Item i2 = this.inputIterator.next();
            if (i2 == null) {
                this.state = 3;
                this.condense();
                return null;
            }
            this.append(i2);
            this.state = 1;
        }
        return this.reservoir.get(n);
    }

    public GroundedValue materialize() throws XPathException {
        if (this.state == 3) {
            return new SequenceExtent(this.reservoir);
        }
        if (this.state == 5) {
            return EmptySequence.getInstance();
        }
        return new SequenceExtent(this.iterate());
    }

    public final class ProgressiveIterator
    implements SequenceIterator,
    LastPositionFinder,
    GroundedIterator {
        int position = -1;

        public MemoClosure getMemoClosure() {
            return MemoClosure.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Item next() throws XPathException {
            MemoClosure memoClosure = MemoClosure.this;
            synchronized (memoClosure) {
                if (this.position == -2) {
                    return null;
                }
                if (++this.position < MemoClosure.this.reservoir.size()) {
                    return (Item)MemoClosure.this.reservoir.get(this.position);
                }
                if (MemoClosure.this.state == 3) {
                    this.position = -2;
                    return null;
                }
                assert (MemoClosure.this.inputIterator != null);
                Item i2 = MemoClosure.this.inputIterator.next();
                if (i2 == null) {
                    MemoClosure.this.state = 3;
                    MemoClosure.this.condense();
                    this.position = -2;
                    return null;
                }
                this.position = MemoClosure.this.reservoir.size();
                MemoClosure.this.append(i2);
                MemoClosure.this.state = 1;
                return i2;
            }
        }

        public void close() {
        }

        public ProgressiveIterator getAnother() {
            return new ProgressiveIterator();
        }

        public int getLength() throws XPathException {
            Item item;
            if (MemoClosure.this.state == 3) {
                return MemoClosure.this.reservoir.size();
            }
            if (MemoClosure.this.state == 5) {
                return 0;
            }
            int savePos = this.position;
            while ((item = this.next()) != null) {
            }
            this.position = savePos;
            return MemoClosure.this.reservoir.size();
        }

        public GroundedValue materialize() throws XPathException {
            if (MemoClosure.this.state == 3) {
                assert (MemoClosure.this.reservoir != null);
                return new SequenceExtent(MemoClosure.this.reservoir);
            }
            if (MemoClosure.this.state == 5) {
                return EmptySequence.getInstance();
            }
            return new SequenceExtent(MemoClosure.this.iterate());
        }

        public int getProperties() {
            return 3;
        }
    }
}

