/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.xpath;

import java.util.ArrayList;
import javax.xml.xpath.XPathFunction;
import javax.xml.xpath.XPathFunctionException;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FunctionCall;
import net.sf.saxon.expr.JPConverter;
import net.sf.saxon.expr.PJConverter;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.EmptySequence;

public class XPathFunctionCall
extends FunctionCall
implements Callable {
    private XPathFunction function;

    public XPathFunctionCall(XPathFunction function) {
        this.function = function;
    }

    public Expression preEvaluate(ExpressionVisitor visitor) {
        return this;
    }

    public void checkArguments(ExpressionVisitor visitor) throws XPathException {
    }

    public int getIntrinsicDependencies() {
        return 0;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("XPathFunctionCall.copy()");
    }

    public PathMap.PathMapNodeSet addToPathMap(PathMap pathMap, PathMap.PathMapNodeSet pathMapNodeSet) {
        return this.addExternalFunctionCallToPathMap(pathMap, pathMapNodeSet);
    }

    public SequenceIterator iterate(XPathContext context) throws XPathException {
        Sequence[] argValues = new Sequence[this.argument.length];
        for (int i2 = 0; i2 < argValues.length; ++i2) {
            argValues[i2] = SequenceTool.toLazySequence(this.argument[i2].iterate(context));
        }
        return this.call(context, argValues).iterate();
    }

    public Sequence call(XPathContext context, Sequence[] argValues) throws XPathException {
        ArrayList convertedArgs = new ArrayList(argValues.length);
        Configuration config = context.getConfiguration();
        for (int i2 = 0; i2 < argValues.length; ++i2) {
            Item item;
            ArrayList<Object> target = new ArrayList<Object>();
            SequenceIterator iter = argValues[i2].iterate();
            while ((item = iter.next()) != null) {
                PJConverter converter = PJConverter.allocate(config, Type.getItemType(item, config.getTypeHierarchy()), 16384, Object.class);
                target.add(converter.convert(item, Object.class, context));
            }
            if (target.size() == 1) {
                convertedArgs.add(target.get(0));
                continue;
            }
            convertedArgs.add(target);
        }
        try {
            Object result = this.function.evaluate(convertedArgs);
            if (result == null) {
                return EmptySequence.getInstance();
            }
            JPConverter converter = JPConverter.allocate(result.getClass(), null, config);
            return converter.convert(result, context);
        }
        catch (XPathFunctionException e) {
            throw new XPathException(e);
        }
    }

    public ItemType getItemType() {
        return Type.ITEM_TYPE;
    }

    public int computeCardinality() {
        return 57344;
    }
}

