/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.z;

import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntToIntMap;

public class IntToIntHashMap
implements IntToIntMap {
    private static final int NBIT = 30;
    private static final int NMAX = 0x40000000;
    private double _factor;
    private int _defaultValue = Integer.MAX_VALUE;
    private int _nmax;
    private int _n;
    private int _nlo;
    private int _nhi;
    private int _shift;
    private int _mask;
    private int[] _key;
    private int[] _value;
    private boolean[] _filled;

    public IntToIntHashMap() {
        this(8, 0.25);
    }

    public IntToIntHashMap(int capacity) {
        this(capacity, 0.25);
    }

    public IntToIntHashMap(int capacity, double factor) {
        this._factor = factor;
        this.setCapacity(capacity);
    }

    public void setDefaultValue(int defaultValue) {
        this._defaultValue = defaultValue;
    }

    public int getDefaultValue() {
        return this._defaultValue;
    }

    public void clear() {
        this._n = 0;
        for (int i2 = 0; i2 < this._nmax; ++i2) {
            this._filled[i2] = false;
        }
    }

    public boolean find(int key) {
        return this._filled[this.indexOf(key)];
    }

    public int get(int key) {
        int i2 = this.indexOf(key);
        return this._filled[i2] ? this._value[i2] : this._defaultValue;
    }

    public int size() {
        return this._n;
    }

    public boolean remove(int key) {
        int i2 = this.indexOf(key);
        if (!this._filled[i2]) {
            return false;
        }
        --this._n;
        while (true) {
            int r;
            this._filled[i2] = false;
            int j = i2;
            do {
                if (this._filled[i2 = i2 - 1 & this._mask]) continue;
                return true;
            } while (i2 <= (r = this.hash(this._key[i2])) && r < j || r < j && j < i2 || j < i2 && i2 <= r);
            this._key[j] = this._key[i2];
            this._value[j] = this._value[i2];
            this._filled[j] = this._filled[i2];
        }
    }

    public void put(int key, int value) {
        int i2 = this.indexOf(key);
        if (this._filled[i2]) {
            this._value[i2] = value;
        } else {
            this._key[i2] = key;
            this._value[i2] = value;
            this._filled[i2] = true;
            this.grow();
        }
    }

    public IntIterator keyIterator() {
        return new IntToIntHashMapKeyIterator();
    }

    private int hash(int key) {
        return 1327217885 * key >> this._shift & this._mask;
    }

    private int indexOf(int key) {
        int i2 = this.hash(key);
        while (this._filled[i2]) {
            if (this._key[i2] == key) {
                return i2;
            }
            i2 = i2 - 1 & this._mask;
        }
        return i2;
    }

    private void grow() {
        ++this._n;
        if (this._n > 0x40000000) {
            throw new RuntimeException("number of keys mapped exceeds 1073741824");
        }
        if (this._nlo < this._n && this._n <= this._nhi) {
            this.setCapacity(this._n);
        }
    }

    private void setCapacity(int capacity) {
        int nmax;
        if (capacity < this._n) {
            capacity = this._n;
        }
        double factor = this._factor < 0.01 ? 0.01 : (this._factor > 0.99 ? 0.99 : this._factor);
        int nbit = 1;
        for (nmax = 2; (double)nmax * factor < (double)capacity && nmax < 0x40000000; nmax *= 2) {
            ++nbit;
        }
        int nold = this._nmax;
        if (nmax == nold) {
            return;
        }
        this._nmax = nmax;
        this._nlo = (int)((double)nmax * factor);
        this._nhi = (int)(1.073741824E9 * factor);
        this._shift = 31 - nbit;
        this._mask = nmax - 1;
        int[] key = this._key;
        int[] value = this._value;
        boolean[] filled = this._filled;
        this._n = 0;
        this._key = new int[nmax];
        this._value = new int[nmax];
        this._filled = new boolean[nmax];
        if (key != null) {
            for (int i2 = 0; i2 < nold; ++i2) {
                if (!filled[i2]) continue;
                this.put(key[i2], value[i2]);
            }
        }
    }

    private class IntToIntHashMapKeyIterator
    implements IntIterator {
        private int i = 0;
        private static final long serialVersionUID = -5978261613309710617L;

        public boolean hasNext() {
            while (this.i < IntToIntHashMap.this._key.length) {
                if (IntToIntHashMap.this._filled[this.i]) {
                    return true;
                }
                ++this.i;
            }
            return false;
        }

        public int next() {
            return IntToIntHashMap.this._key[this.i++];
        }
    }
}

