/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.controller;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import thredds.client.catalog.Dataset;
import thredds.core.AllowedServices;
import thredds.core.StandardService;
import thredds.server.metadata.controller.AbstractMetadataController;
import thredds.server.metadata.exception.ThreddsUtilitiesException;
import thredds.server.metadata.service.EnhancedMetadataService;
import thredds.server.metadata.util.DatasetHandlerAdapter;
import thredds.server.metadata.util.ThreddsTranslatorUtil;
import thredds.util.ContentType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;

@Controller
@RequestMapping(value={"/uddc/"})
public class UddcController
extends AbstractMetadataController
implements InitializingBean {
    private static Logger _log = LoggerFactory.getLogger(UddcController.class);
    @Autowired
    private AllowedServices as;

    @Override
    protected String getPath() {
        return this._metadataServiceType + "/";
    }

    @Override
    public void afterPropertiesSet() throws ServletException {
        this._metadataServiceType = "UDDC";
        this._servletPath = "/uddc";
        _logServerStartup.info("Metadata UDDC - initialization start");
        _logServerStartup.info("NCISO.uddcAllow = " + this._allow);
        String ncIsoXslFilePath = this.sc.getRealPath("/WEB-INF/classes/resources/xsl/nciso") + "/UnidataDDCount-HTML.xsl";
        this.xslFile = new File(ncIsoXslFilePath);
    }

    public void destroy() {
        NetcdfDatasets.shutdown();
        _logServerStartup.info("Metadata UDDC - destroy done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @RequestMapping(value={"**"}, params={})
    public void handleMetadataRequest(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        NetcdfDataset netCdfDataset;
        block11: {
            _log.info("Handling UDDC metadata request.");
            netCdfDataset = null;
            try {
                res.setContentType(ContentType.html.getContentHeader());
                this.isAllowed(this.as.isAllowed(StandardService.iso), this._metadataServiceType, res);
                netCdfDataset = DatasetHandlerAdapter.openDataset(req, res, this.getInfoPath(req));
                if (netCdfDataset == null) {
                    res.sendError(404, "ThreddsIso Extension: Requested resource not found.");
                    break block11;
                }
                StringWriter writer = new StringWriter();
                Dataset ids = this.getThreddsDataset(req, res);
                EnhancedMetadataService.enhance(netCdfDataset, ids, writer);
                String ncml = ((Object)writer).toString();
                ((Writer)writer).flush();
                ((Writer)writer).close();
                ByteArrayInputStream is = new ByteArrayInputStream(ncml.getBytes("UTF-8"));
                ThreddsTranslatorUtil.transform(this.xslFile, (InputStream)is, (Writer)res.getWriter());
                res.getWriter().flush();
            }
            catch (ThreddsUtilitiesException tue) {
                String errMsg = "Error in UDDCController: " + req.getQueryString();
                _log.error(errMsg, tue);
                try {
                    this.returnError(errMsg, this._metadataServiceType, res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DatasetHandlerAdapter.closeDataset(netCdfDataset);
            }
            catch (Exception e) {
                String errMsg = "Error in UDDCController: " + req.getQueryString();
                _log.error(errMsg, e);
                try {
                    this.returnError(errMsg, this._metadataServiceType, res);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                {
                    catch (Throwable throwable) {
                        DatasetHandlerAdapter.closeDataset(netCdfDataset);
                        throw throwable;
                    }
                }
                DatasetHandlerAdapter.closeDataset(netCdfDataset);
            }
        }
        DatasetHandlerAdapter.closeDataset(netCdfDataset);
    }
}

