/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.metadata.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.TransformerFactoryImpl;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.server.metadata.exception.ThreddsUtilitiesException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.NetcdfDatasets;
import ucar.nc2.write.NcmlWriter;

public class ThreddsTranslatorUtil {
    private static Logger _log = LoggerFactory.getLogger(ThreddsTranslatorUtil.class);
    private static final String _tempFileName = "theFile.out";
    private static final TransformerFactory transFact = new TransformerFactoryImpl();

    private static StreamSource getXSLT(String xslName) {
        return new StreamSource(ThreddsTranslatorUtil.class.getResourceAsStream("/resources/xsl/" + xslName));
    }

    public static File getNcml(String location) throws ThreddsUtilitiesException {
        return ThreddsTranslatorUtil.doGetNcml(location, null);
    }

    public static File getNcml(String location, String saveFileLocation) throws ThreddsUtilitiesException {
        return ThreddsTranslatorUtil.doGetNcml(location, saveFileLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File doGetNcml(String location, String saveFileLocation) {
        File ncml = null;
        try (NetcdfDataset ncd = NetcdfDatasets.openDataset((String)location);){
            ncml = !StringUtils.isEmpty((String)saveFileLocation) ? new File(saveFileLocation) : new File(_tempFileName);
            try (FileWriter writer = new FileWriter(ncml);){
                ncd.writeNcML((Writer)writer, null);
            }
        }
        catch (Exception e) {
            String err = "Could not load NETCDF file: " + location + " because of Exception. " + e.getLocalizedMessage();
            _log.error(err, (Throwable)e);
        }
        finally {
            if (StringUtils.isEmpty((String)saveFileLocation) && ncml != null && ncml.exists()) {
                ncml.deleteOnExit();
            }
        }
        return ncml;
    }

    public static File getNcml(NetcdfFile ncFile, String fileLocation) throws ThreddsUtilitiesException {
        return ThreddsTranslatorUtil.doGetNcml(ncFile, fileLocation);
    }

    public static File getNcml(NetcdfFile ncFile) throws ThreddsUtilitiesException {
        return ThreddsTranslatorUtil.doGetNcml(ncFile, null);
    }

    private static File doGetNcml(NetcdfFile ncFile, String fileLocation) throws ThreddsUtilitiesException {
        NcmlWriter ncMLWriter = new NcmlWriter();
        File returnFile = !StringUtils.isEmpty((String)fileLocation) ? new File(fileLocation) : new File(_tempFileName);
        FileWriter fw = null;
        try {
            fw = new FileWriter(returnFile);
            ncFile.writeNcML((Writer)fw, null);
        }
        catch (IOException e) {
            String err = "Could not load NETCDF file: " + ncFile.getLocation() + " because of IOException. " + e.getLocalizedMessage();
            _log.error(err, (Throwable)e);
            throw new ThreddsUtilitiesException(err, e, ThreddsUtilitiesException.EXCEPTION_TYPES.IO_EXCEPTION);
        }
        finally {
            if (fw != null) {
                try {
                    fw.flush();
                    fw.close();
                }
                catch (IOException e) {
                    String err = "Could not close NETCDF file: " + ncFile.getLocation() + " because of IOException. " + e.getLocalizedMessage();
                    _log.error(err, (Throwable)e);
                    throw new ThreddsUtilitiesException(err, e, ThreddsUtilitiesException.EXCEPTION_TYPES.IO_EXCEPTION);
                }
                if (StringUtils.isEmpty((String)fileLocation) && returnFile != null && returnFile.exists()) {
                    returnFile.deleteOnExit();
                }
            }
        }
        return returnFile;
    }

    public static File transform(File xsltFile, File xml) throws ThreddsUtilitiesException {
        return ThreddsTranslatorUtil.doTransform(xsltFile, xml, null);
    }

    public static File transform(String xsltFileStr, String xmlStr, String fileLocation) throws ThreddsUtilitiesException {
        File xml = new File(xmlStr);
        return ThreddsTranslatorUtil.doTransform(xsltFileStr, xml, fileLocation);
    }

    public static void transform(String xsltFileStr, InputStream is, Writer writer) throws ThreddsUtilitiesException {
        StreamSource xsltSS = ThreddsTranslatorUtil.getXSLT(xsltFileStr);
        ThreddsTranslatorUtil.doTransform(xsltSS, is, writer);
    }

    public static void transform(File xsltFile, InputStream is, Writer writer) throws ThreddsUtilitiesException {
        ThreddsTranslatorUtil.doTransform(xsltFile, is, writer);
    }

    public static void transform(String xsltFileStr, NetcdfFile netcdfFile, Writer writer) throws ThreddsUtilitiesException {
        ByteArrayInputStream is;
        StreamSource xsltSS = ThreddsTranslatorUtil.getXSLT(xsltFileStr);
        NcmlWriter ncMLWriter = new NcmlWriter();
        try {
            ByteArrayOutputStream dsToNcml = new ByteArrayOutputStream();
            netcdfFile.writeNcML((OutputStream)dsToNcml, null);
            is = new ByteArrayInputStream(dsToNcml.toByteArray());
        }
        catch (UnsupportedEncodingException uee) {
            String err = "UnsupportedEncodingException " + uee.getLocalizedMessage();
            _log.error(err, (Throwable)uee);
            throw new ThreddsUtilitiesException(err, uee, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMER_EXCEPTION);
        }
        catch (IOException ioe) {
            String err = "IOException " + ioe.getLocalizedMessage();
            _log.error(err, (Throwable)ioe);
            throw new ThreddsUtilitiesException(err, ioe, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMER_EXCEPTION);
        }
        ThreddsTranslatorUtil.doTransform(xsltSS, (InputStream)is, writer);
    }

    public static File transform(File xsltFile, File xml, String fileLocation) throws ThreddsUtilitiesException {
        return ThreddsTranslatorUtil.doTransform(xsltFile, xml, fileLocation);
    }

    private static File doTransform(File xsltFile, File srcFile, String fileLocation) throws ThreddsUtilitiesException {
        File returnFile = !StringUtils.isEmpty((String)fileLocation) ? new File(fileLocation) : new File(_tempFileName);
        StreamSource xsltSource = new StreamSource(xsltFile);
        StreamResult result = new StreamResult(returnFile);
        StreamSource xmlStream = new StreamSource(srcFile);
        try {
            Templates cachedXSLT = transFact.newTemplates(xsltSource);
            Transformer trans = cachedXSLT.newTransformer();
            trans.transform(xmlStream, result);
        }
        catch (TransformerConfigurationException tce) {
            String err = "Configuration problem: " + xsltFile + " TransformerConfigurationException. " + tce.getLocalizedMessage();
            _log.error(err, (Throwable)tce);
            throw new ThreddsUtilitiesException(err, tce, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMERCOFIGURATION_EXCEPTION);
        }
        catch (TransformerException te) {
            String err = "Transformer problem: " + srcFile.getName() + " TransformerException. " + te.getLocalizedMessage();
            _log.error(err, (Throwable)te);
            throw new ThreddsUtilitiesException(err, te, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMER_EXCEPTION);
        }
        finally {
            if (StringUtils.isEmpty((String)fileLocation) && returnFile != null && returnFile.exists()) {
                returnFile.deleteOnExit();
            }
        }
        return returnFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File doTransform(String xsltLocationStr, File srcFile, String fileLocation) throws ThreddsUtilitiesException {
        File returnFile = !StringUtils.isEmpty((String)fileLocation) ? new File(fileLocation) : new File(_tempFileName);
        StreamSource xsltSource = new StreamSource(xsltLocationStr);
        try {
            StreamResult result = new StreamResult(new FileOutputStream(returnFile));
            StreamSource xmlStream = new StreamSource(srcFile);
            Templates cachedXSLT = transFact.newTemplates(xsltSource);
            Transformer trans = cachedXSLT.newTransformer();
            trans.transform(xmlStream, result);
        }
        catch (TransformerConfigurationException tce) {
            String err = "Configuration problem: " + xsltLocationStr + " TransformerConfigurationException. " + tce.getLocalizedMessage();
            _log.error(err, (Throwable)tce);
            throw new ThreddsUtilitiesException(err, tce, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMERCOFIGURATION_EXCEPTION);
        }
        catch (TransformerException te) {
            String err = "Transformer problem: " + srcFile.getName() + " TransformerException. " + te.getLocalizedMessage();
            _log.error(err, (Throwable)te);
            throw new ThreddsUtilitiesException(err, te, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMER_EXCEPTION);
        }
        catch (FileNotFoundException fnfe) {
            String err = "FileNotFoundException in ThreddsTranslatorUtil: " + srcFile.getName();
            _log.error(err, (Throwable)fnfe);
        }
        finally {
            if (StringUtils.isEmpty((String)fileLocation) && returnFile != null && returnFile.exists()) {
                returnFile.deleteOnExit();
            }
        }
        return returnFile;
    }

    private static void doTransform(StreamSource xsltSS, InputStream is, Writer writer) throws ThreddsUtilitiesException {
        try {
            StreamResult result = new StreamResult(writer);
            StreamSource xmlStream = new StreamSource(is);
            Templates cachedXSLT = transFact.newTemplates(xsltSS);
            Transformer trans = cachedXSLT.newTransformer();
            trans.transform(xmlStream, result);
        }
        catch (TransformerConfigurationException tce) {
            String err = "TransformerConfigurationException. " + tce.getLocalizedMessage();
            _log.error(err, (Throwable)tce);
            throw new ThreddsUtilitiesException(err, tce, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMERCOFIGURATION_EXCEPTION);
        }
        catch (TransformerException te) {
            String err = "TransformerException. " + te.getLocalizedMessage();
            _log.error(err, (Throwable)te);
            throw new ThreddsUtilitiesException(err, te, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMER_EXCEPTION);
        }
    }

    private static void doTransform(File xslFile, InputStream is, Writer writer) throws ThreddsUtilitiesException {
        try {
            StreamSource xsltSource = new StreamSource(xslFile);
            Transformer transformer = transFact.newTransformer(xsltSource);
            StreamResult result = new StreamResult(writer);
            StreamSource xmlStream = new StreamSource(is);
            transformer.transform(xmlStream, result);
        }
        catch (TransformerConfigurationException tce) {
            String err = "TransformerConfigurationException. " + tce.getLocalizedMessage();
            _log.error(err, (Throwable)tce);
            throw new ThreddsUtilitiesException(err, tce, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMERCOFIGURATION_EXCEPTION);
        }
        catch (TransformerException te) {
            String err = "TransformerException. " + te.getLocalizedMessage();
            _log.error(err, (Throwable)te);
            throw new ThreddsUtilitiesException(err, te, ThreddsUtilitiesException.EXCEPTION_TYPES.TRANSFORMER_EXCEPTION);
        }
    }
}

