/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.util.Formatter;
import java.util.StringTokenizer;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class BufrCdm
extends TableConfigurerImpl {
    private final String BufrConvention = "BUFR/CDM";

    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        if (conv.equals("BUFR/CDM")) {
            return true;
        }
        StringTokenizer stoke = new StringTokenizer(conv, ",");
        while (stoke.hasMoreTokens()) {
            String toke = stoke.nextToken().trim();
            if (!toke.equals("BUFR/CDM")) continue;
            return true;
        }
        return false;
    }

    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) {
        CF.FeatureType ftype = CF.FeatureType.getFeatureTypeFromGlobalAttribute((NetcdfFile)ds);
        if (ftype == null) {
            ftype = CF.FeatureType.point;
        }
        switch (ftype) {
            case point: {
                return this.getPointConfig(ds, errlog);
            }
            case timeSeries: {
                return this.getStationConfig(ds, errlog);
            }
            case profile: {
                return this.getProfileConfig(ds, errlog);
            }
            case trajectory: {
                return this.getTrajectoryConfig(ds, errlog);
            }
            case timeSeriesProfile: {
                return this.getStationProfileConfig(ds, errlog);
            }
        }
        throw new IllegalStateException("invalid ftype= " + ftype);
    }

    protected TableConfig getPointConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig obsTable = new TableConfig(Table.Type.Structure, "obs");
        Structure obsStruct = (Structure)ds.findVariable("obs");
        obsTable.structName = obsStruct.getFullName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.lat = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Lat.toString());
        obsTable.lon = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Lon.toString());
        obsTable.elev = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Height.toString());
        obsTable.time = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Time.toString());
        return obsTable;
    }

    protected TableConfig getStationConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig stnTable = new TableConfig(Table.Type.Construct, "station");
        stnTable.featureType = FeatureType.STATION;
        stnTable.structName = "obs";
        TableConfig timeTable = new TableConfig(Table.Type.ParentId, "obs");
        Structure stnStruct = (Structure)ds.findVariable("obs");
        timeTable.lat = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"_CoordinateAxisType", (String)AxisType.Lat.toString());
        timeTable.lon = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"_CoordinateAxisType", (String)AxisType.Lon.toString());
        timeTable.stnAlt = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"_CoordinateAxisType", (String)AxisType.Height.toString());
        timeTable.stnId = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"standard_name", (String)"station_id");
        timeTable.stnWmoId = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"standard_name", (String)"station_WMO_id");
        if (timeTable.stnId == null) {
            timeTable.stnId = timeTable.stnWmoId;
        }
        timeTable.parentIndex = timeTable.stnId;
        timeTable.time = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"_CoordinateAxisType", (String)AxisType.Time.toString());
        timeTable.structName = "obs";
        stnTable.addChild(timeTable);
        return stnTable;
    }

    protected TableConfig getTrajectoryConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig topTable = new TableConfig(Table.Type.Top, "singleTrajectory");
        TableConfig obsTable = new TableConfig(Table.Type.Structure, "obs");
        Structure obsStruct = (Structure)ds.findVariable("obs");
        obsTable.structName = obsStruct.getFullName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.lat = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Lat.toString());
        obsTable.lon = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Lon.toString());
        obsTable.elev = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Height.toString());
        obsTable.time = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Time.toString());
        topTable.addChild(obsTable);
        return topTable;
    }

    protected TableConfig getProfileConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig profileTable = new TableConfig(Table.Type.Structure, "profile");
        profileTable.featureType = FeatureType.PROFILE;
        profileTable.structName = "obs";
        Structure profileStruct = (Structure)ds.findVariable("obs");
        profileTable.lat = Evaluator.findNameOfVariableWithAttributeValue((Structure)profileStruct, (String)"_CoordinateAxisType", (String)AxisType.Lat.toString());
        profileTable.lon = Evaluator.findNameOfVariableWithAttributeValue((Structure)profileStruct, (String)"_CoordinateAxisType", (String)AxisType.Lon.toString());
        profileTable.time = Evaluator.findNameOfVariableWithAttributeValue((Structure)profileStruct, (String)"_CoordinateAxisType", (String)AxisType.Time.toString());
        TableConfig obsTable = new TableConfig(Table.Type.NestedStructure, "struct5");
        Structure obsStruct = (Structure)profileStruct.findVariable("struct5");
        obsTable.structName = obsStruct.getFullName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.elev = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Pressure.toString());
        profileTable.addChild(obsTable);
        return profileTable;
    }

    protected TableConfig getStationProfileConfig(NetcdfDataset ds, Formatter errlog) {
        TableConfig stnTable = new TableConfig(Table.Type.Construct, "station");
        stnTable.featureType = FeatureType.STATION_PROFILE;
        stnTable.structName = "obs";
        TableConfig timeTable = new TableConfig(Table.Type.ParentId, "obs");
        Structure stnStruct = (Structure)ds.findVariable("obs");
        timeTable.lat = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"_CoordinateAxisType", (String)AxisType.Lat.toString());
        timeTable.lon = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"_CoordinateAxisType", (String)AxisType.Lon.toString());
        timeTable.stnAlt = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"_CoordinateAxisType", (String)AxisType.Height.toString());
        timeTable.stnId = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"standard_name", (String)"station_id");
        timeTable.stnWmoId = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"standard_name", (String)"station_WMO_id");
        if (timeTable.stnId == null) {
            timeTable.stnId = timeTable.stnWmoId;
        }
        timeTable.parentIndex = timeTable.stnId;
        timeTable.time = Evaluator.findNameOfVariableWithAttributeValue((Structure)stnStruct, (String)"_CoordinateAxisType", (String)AxisType.Time.toString());
        timeTable.structName = "obs";
        stnTable.addChild(timeTable);
        TableConfig obsTable = new TableConfig(Table.Type.NestedStructure, "levels");
        Structure obsStruct = (Structure)stnStruct.findVariable("seq1");
        if (obsStruct == null) {
            obsStruct = (Structure)stnStruct.findVariable("struct1");
        }
        obsTable.structName = obsStruct.getFullName();
        obsTable.nestedTableName = obsStruct.getShortName();
        obsTable.elev = Evaluator.findNameOfVariableWithAttributeValue((Structure)obsStruct, (String)"_CoordinateAxisType", (String)AxisType.Height.toString());
        timeTable.addChild(obsTable);
        return stnTable;
    }
}

