/*
 * Copyright 1998-2013 University Corporation for Atmospheric Research/Unidata
 *
 *  Portions of this software were developed by the Unidata Program at the
 *  University Corporation for Atmospheric Research.
 *
 *  Access and use of this software shall impose the following obligations
 *  and understandings on the user. The user is granted the right, without
 *  any fee or cost, to use, copy, modify, alter, enhance and distribute
 *  this software, and any derivative works thereof, and its supporting
 *  documentation for any purpose whatsoever, provided that this entire
 *  notice appears in all copies of the software, derivative works and
 *  supporting documentation.  Further, UCAR requests that the user credit
 *  UCAR/Unidata in any publications that result from the use of this
 *  software or in any product that includes this software. The names UCAR
 *  and/or Unidata, however, may not be used in any advertising or publicity
 *  to endorse or promote any products or commercial entity unless specific
 *  written permission is obtained from UCAR/Unidata. The user also
 *  understands that UCAR/Unidata is not obligated to provide the user with
 *  any support, consulting, training or assistance of any kind with regard
 *  to the use, operation and performance of this software nor to provide
 *  the user with any updates, revisions, new versions or "bug fixes."
 *
 *  THIS SOFTWARE IS PROVIDED BY UCAR/UNIDATA "AS IS" AND ANY EXPRESS OR
 *  IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL UCAR/UNIDATA BE LIABLE FOR ANY SPECIAL,
 *  INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING
 *  FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
 *  NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
 *  WITH THE ACCESS, USE OR PERFORMANCE OF THIS SOFTWARE.
 */

// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: ucar/nc2/ft/point/bufr/bufrCdmIndex.proto

package ucar.nc2.ft.point.bufr;

public final class BufrCdmIndexProto {
  private BufrCdmIndexProto() {}
  public static void registerAllExtensions(
      com.google.protobuf.ExtensionRegistry registry) {
  }
  /**
   * Protobuf enum {@code bufrCdmIndex.FldAction}
   */
  public enum FldAction
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>none = 1;</code>
     */
    none(0, 1),
    /**
     * <code>remove = 2;</code>
     */
    remove(1, 2),
    /**
     * <code>asMissing = 3;</code>
     */
    asMissing(2, 3),
    /**
     * <code>asArray = 4;</code>
     */
    asArray(3, 4),
    /**
     * <code>concat = 5;</code>
     */
    concat(4, 5),
    ;

    /**
     * <code>none = 1;</code>
     */
    public static final int none_VALUE = 1;
    /**
     * <code>remove = 2;</code>
     */
    public static final int remove_VALUE = 2;
    /**
     * <code>asMissing = 3;</code>
     */
    public static final int asMissing_VALUE = 3;
    /**
     * <code>asArray = 4;</code>
     */
    public static final int asArray_VALUE = 4;
    /**
     * <code>concat = 5;</code>
     */
    public static final int concat_VALUE = 5;


    public final int getNumber() { return value; }

    public static FldAction valueOf(int value) {
      switch (value) {
        case 1: return none;
        case 2: return remove;
        case 3: return asMissing;
        case 4: return asArray;
        case 5: return concat;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FldAction>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<FldAction>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<FldAction>() {
            public FldAction findValueByNumber(int number) {
              return FldAction.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.getDescriptor().getEnumTypes().get(0);
    }

    private static final FldAction[] VALUES = values();

    public static FldAction valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private FldAction(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bufrCdmIndex.FldAction)
  }

  /**
   * Protobuf enum {@code bufrCdmIndex.FldType}
   */
  public enum FldType
      implements com.google.protobuf.ProtocolMessageEnum {
    /**
     * <code>lat = 1;</code>
     */
    lat(0, 1),
    /**
     * <code>lon = 2;</code>
     */
    lon(1, 2),
    /**
     * <code>height = 3;</code>
     */
    height(2, 3),
    /**
     * <code>heightAboveStation = 4;</code>
     */
    heightAboveStation(3, 4),
    /**
     * <code>heightOfStation = 5;</code>
     */
    heightOfStation(4, 5),
    /**
     * <code>stationId = 10;</code>
     */
    stationId(5, 10),
    /**
     * <code>stationDesc = 11;</code>
     */
    stationDesc(6, 11),
    /**
     * <code>wmoId = 12;</code>
     */
    wmoId(7, 12),
    /**
     * <code>wmoBlock = 13;</code>
     */
    wmoBlock(8, 13),
    /**
     * <code>year = 15;</code>
     */
    year(9, 15),
    /**
     * <code>month = 16;</code>
     */
    month(10, 16),
    /**
     * <code>day = 17;</code>
     */
    day(11, 17),
    /**
     * <code>hour = 18;</code>
     */
    hour(12, 18),
    /**
     * <code>minute = 19;</code>
     */
    minute(13, 19),
    /**
     * <code>sec = 20;</code>
     */
    sec(14, 20),
    /**
     * <code>doy = 21;</code>
     */
    doy(15, 21),
    /**
     * <code>timeIncr = 22;</code>
     */
    timeIncr(16, 22),
    /**
     * <code>incrS = 23;</code>
     */
    incrS(17, 23),
    ;

    /**
     * <code>lat = 1;</code>
     */
    public static final int lat_VALUE = 1;
    /**
     * <code>lon = 2;</code>
     */
    public static final int lon_VALUE = 2;
    /**
     * <code>height = 3;</code>
     */
    public static final int height_VALUE = 3;
    /**
     * <code>heightAboveStation = 4;</code>
     */
    public static final int heightAboveStation_VALUE = 4;
    /**
     * <code>heightOfStation = 5;</code>
     */
    public static final int heightOfStation_VALUE = 5;
    /**
     * <code>stationId = 10;</code>
     */
    public static final int stationId_VALUE = 10;
    /**
     * <code>stationDesc = 11;</code>
     */
    public static final int stationDesc_VALUE = 11;
    /**
     * <code>wmoId = 12;</code>
     */
    public static final int wmoId_VALUE = 12;
    /**
     * <code>wmoBlock = 13;</code>
     */
    public static final int wmoBlock_VALUE = 13;
    /**
     * <code>year = 15;</code>
     */
    public static final int year_VALUE = 15;
    /**
     * <code>month = 16;</code>
     */
    public static final int month_VALUE = 16;
    /**
     * <code>day = 17;</code>
     */
    public static final int day_VALUE = 17;
    /**
     * <code>hour = 18;</code>
     */
    public static final int hour_VALUE = 18;
    /**
     * <code>minute = 19;</code>
     */
    public static final int minute_VALUE = 19;
    /**
     * <code>sec = 20;</code>
     */
    public static final int sec_VALUE = 20;
    /**
     * <code>doy = 21;</code>
     */
    public static final int doy_VALUE = 21;
    /**
     * <code>timeIncr = 22;</code>
     */
    public static final int timeIncr_VALUE = 22;
    /**
     * <code>incrS = 23;</code>
     */
    public static final int incrS_VALUE = 23;


    public final int getNumber() { return value; }

    public static FldType valueOf(int value) {
      switch (value) {
        case 1: return lat;
        case 2: return lon;
        case 3: return height;
        case 4: return heightAboveStation;
        case 5: return heightOfStation;
        case 10: return stationId;
        case 11: return stationDesc;
        case 12: return wmoId;
        case 13: return wmoBlock;
        case 15: return year;
        case 16: return month;
        case 17: return day;
        case 18: return hour;
        case 19: return minute;
        case 20: return sec;
        case 21: return doy;
        case 22: return timeIncr;
        case 23: return incrS;
        default: return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<FldType>
        internalGetValueMap() {
      return internalValueMap;
    }
    private static com.google.protobuf.Internal.EnumLiteMap<FldType>
        internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<FldType>() {
            public FldType findValueByNumber(int number) {
              return FldType.valueOf(number);
            }
          };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor
        getValueDescriptor() {
      return getDescriptor().getValues().get(index);
    }
    public final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptorForType() {
      return getDescriptor();
    }
    public static final com.google.protobuf.Descriptors.EnumDescriptor
        getDescriptor() {
      return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.getDescriptor().getEnumTypes().get(1);
    }

    private static final FldType[] VALUES = values();

    public static FldType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException(
          "EnumValueDescriptor is not for this type.");
      }
      return VALUES[desc.getIndex()];
    }

    private final int index;
    private final int value;

    private FldType(int index, int value) {
      this.index = index;
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:bufrCdmIndex.FldType)
  }

  public interface StationOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required string id = 1;
    /**
     * <code>required string id = 1;</code>
     */
    boolean hasId();
    /**
     * <code>required string id = 1;</code>
     */
    java.lang.String getId();
    /**
     * <code>required string id = 1;</code>
     */
    com.google.protobuf.ByteString
        getIdBytes();

    // required double lat = 2;
    /**
     * <code>required double lat = 2;</code>
     */
    boolean hasLat();
    /**
     * <code>required double lat = 2;</code>
     */
    double getLat();

    // required double lon = 3;
    /**
     * <code>required double lon = 3;</code>
     */
    boolean hasLon();
    /**
     * <code>required double lon = 3;</code>
     */
    double getLon();

    // optional double alt = 4;
    /**
     * <code>optional double alt = 4;</code>
     */
    boolean hasAlt();
    /**
     * <code>optional double alt = 4;</code>
     */
    double getAlt();

    // optional string desc = 5;
    /**
     * <code>optional string desc = 5;</code>
     */
    boolean hasDesc();
    /**
     * <code>optional string desc = 5;</code>
     */
    java.lang.String getDesc();
    /**
     * <code>optional string desc = 5;</code>
     */
    com.google.protobuf.ByteString
        getDescBytes();

    // optional string wmoId = 6;
    /**
     * <code>optional string wmoId = 6;</code>
     */
    boolean hasWmoId();
    /**
     * <code>optional string wmoId = 6;</code>
     */
    java.lang.String getWmoId();
    /**
     * <code>optional string wmoId = 6;</code>
     */
    com.google.protobuf.ByteString
        getWmoIdBytes();

    // required int32 count = 7;
    /**
     * <code>required int32 count = 7;</code>
     */
    boolean hasCount();
    /**
     * <code>required int32 count = 7;</code>
     */
    int getCount();
  }
  /**
   * Protobuf type {@code bufrCdmIndex.Station}
   */
  public static final class Station extends
      com.google.protobuf.GeneratedMessage
      implements StationOrBuilder {
    // Use Station.newBuilder() to construct.
    private Station(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Station(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Station defaultInstance;
    public static Station getDefaultInstance() {
      return defaultInstance;
    }

    public Station getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Station(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              id_ = input.readBytes();
              break;
            }
            case 17: {
              bitField0_ |= 0x00000002;
              lat_ = input.readDouble();
              break;
            }
            case 25: {
              bitField0_ |= 0x00000004;
              lon_ = input.readDouble();
              break;
            }
            case 33: {
              bitField0_ |= 0x00000008;
              alt_ = input.readDouble();
              break;
            }
            case 42: {
              bitField0_ |= 0x00000010;
              desc_ = input.readBytes();
              break;
            }
            case 50: {
              bitField0_ |= 0x00000020;
              wmoId_ = input.readBytes();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000040;
              count_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Station_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Station_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.class, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder.class);
    }

    public static com.google.protobuf.Parser<Station> PARSER =
        new com.google.protobuf.AbstractParser<Station>() {
      public Station parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Station(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Station> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required string id = 1;
    public static final int ID_FIELD_NUMBER = 1;
    private java.lang.Object id_;
    /**
     * <code>required string id = 1;</code>
     */
    public boolean hasId() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string id = 1;</code>
     */
    public java.lang.String getId() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          id_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string id = 1;</code>
     */
    public com.google.protobuf.ByteString
        getIdBytes() {
      java.lang.Object ref = id_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        id_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // required double lat = 2;
    public static final int LAT_FIELD_NUMBER = 2;
    private double lat_;
    /**
     * <code>required double lat = 2;</code>
     */
    public boolean hasLat() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required double lat = 2;</code>
     */
    public double getLat() {
      return lat_;
    }

    // required double lon = 3;
    public static final int LON_FIELD_NUMBER = 3;
    private double lon_;
    /**
     * <code>required double lon = 3;</code>
     */
    public boolean hasLon() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required double lon = 3;</code>
     */
    public double getLon() {
      return lon_;
    }

    // optional double alt = 4;
    public static final int ALT_FIELD_NUMBER = 4;
    private double alt_;
    /**
     * <code>optional double alt = 4;</code>
     */
    public boolean hasAlt() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional double alt = 4;</code>
     */
    public double getAlt() {
      return alt_;
    }

    // optional string desc = 5;
    public static final int DESC_FIELD_NUMBER = 5;
    private java.lang.Object desc_;
    /**
     * <code>optional string desc = 5;</code>
     */
    public boolean hasDesc() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional string desc = 5;</code>
     */
    public java.lang.String getDesc() {
      java.lang.Object ref = desc_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          desc_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string desc = 5;</code>
     */
    public com.google.protobuf.ByteString
        getDescBytes() {
      java.lang.Object ref = desc_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        desc_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string wmoId = 6;
    public static final int WMOID_FIELD_NUMBER = 6;
    private java.lang.Object wmoId_;
    /**
     * <code>optional string wmoId = 6;</code>
     */
    public boolean hasWmoId() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional string wmoId = 6;</code>
     */
    public java.lang.String getWmoId() {
      java.lang.Object ref = wmoId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          wmoId_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string wmoId = 6;</code>
     */
    public com.google.protobuf.ByteString
        getWmoIdBytes() {
      java.lang.Object ref = wmoId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        wmoId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // required int32 count = 7;
    public static final int COUNT_FIELD_NUMBER = 7;
    private int count_;
    /**
     * <code>required int32 count = 7;</code>
     */
    public boolean hasCount() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>required int32 count = 7;</code>
     */
    public int getCount() {
      return count_;
    }

    private void initFields() {
      id_ = "";
      lat_ = 0D;
      lon_ = 0D;
      alt_ = 0D;
      desc_ = "";
      wmoId_ = "";
      count_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasId()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasLat()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasLon()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasCount()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getIdBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeDouble(2, lat_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeDouble(3, lon_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeDouble(4, alt_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeBytes(5, getDescBytes());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeBytes(6, getWmoIdBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeInt32(7, count_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getIdBytes());
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(2, lat_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(3, lon_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeDoubleSize(4, alt_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(5, getDescBytes());
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(6, getWmoIdBytes());
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(7, count_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bufrCdmIndex.Station}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Station_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Station_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.class, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder.class);
      }

      // Construct using ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        id_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        lat_ = 0D;
        bitField0_ = (bitField0_ & ~0x00000002);
        lon_ = 0D;
        bitField0_ = (bitField0_ & ~0x00000004);
        alt_ = 0D;
        bitField0_ = (bitField0_ & ~0x00000008);
        desc_ = "";
        bitField0_ = (bitField0_ & ~0x00000010);
        wmoId_ = "";
        bitField0_ = (bitField0_ & ~0x00000020);
        count_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Station_descriptor;
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station getDefaultInstanceForType() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.getDefaultInstance();
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station build() {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station buildPartial() {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station result = new ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.id_ = id_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.lat_ = lat_;
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000004;
        }
        result.lon_ = lon_;
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000008;
        }
        result.alt_ = alt_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000010;
        }
        result.desc_ = desc_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000020;
        }
        result.wmoId_ = wmoId_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000040;
        }
        result.count_ = count_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station) {
          return mergeFrom((ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station other) {
        if (other == ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.getDefaultInstance()) return this;
        if (other.hasId()) {
          bitField0_ |= 0x00000001;
          id_ = other.id_;
          onChanged();
        }
        if (other.hasLat()) {
          setLat(other.getLat());
        }
        if (other.hasLon()) {
          setLon(other.getLon());
        }
        if (other.hasAlt()) {
          setAlt(other.getAlt());
        }
        if (other.hasDesc()) {
          bitField0_ |= 0x00000010;
          desc_ = other.desc_;
          onChanged();
        }
        if (other.hasWmoId()) {
          bitField0_ |= 0x00000020;
          wmoId_ = other.wmoId_;
          onChanged();
        }
        if (other.hasCount()) {
          setCount(other.getCount());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasId()) {
          
          return false;
        }
        if (!hasLat()) {
          
          return false;
        }
        if (!hasLon()) {
          
          return false;
        }
        if (!hasCount()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required string id = 1;
      private java.lang.Object id_ = "";
      /**
       * <code>required string id = 1;</code>
       */
      public boolean hasId() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string id = 1;</code>
       */
      public java.lang.String getId() {
        java.lang.Object ref = id_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          id_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string id = 1;</code>
       */
      public com.google.protobuf.ByteString
          getIdBytes() {
        java.lang.Object ref = id_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          id_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string id = 1;</code>
       */
      public Builder setId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        id_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string id = 1;</code>
       */
      public Builder clearId() {
        bitField0_ = (bitField0_ & ~0x00000001);
        id_ = getDefaultInstance().getId();
        onChanged();
        return this;
      }
      /**
       * <code>required string id = 1;</code>
       */
      public Builder setIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        id_ = value;
        onChanged();
        return this;
      }

      // required double lat = 2;
      private double lat_ ;
      /**
       * <code>required double lat = 2;</code>
       */
      public boolean hasLat() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>required double lat = 2;</code>
       */
      public double getLat() {
        return lat_;
      }
      /**
       * <code>required double lat = 2;</code>
       */
      public Builder setLat(double value) {
        bitField0_ |= 0x00000002;
        lat_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required double lat = 2;</code>
       */
      public Builder clearLat() {
        bitField0_ = (bitField0_ & ~0x00000002);
        lat_ = 0D;
        onChanged();
        return this;
      }

      // required double lon = 3;
      private double lon_ ;
      /**
       * <code>required double lon = 3;</code>
       */
      public boolean hasLon() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required double lon = 3;</code>
       */
      public double getLon() {
        return lon_;
      }
      /**
       * <code>required double lon = 3;</code>
       */
      public Builder setLon(double value) {
        bitField0_ |= 0x00000004;
        lon_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required double lon = 3;</code>
       */
      public Builder clearLon() {
        bitField0_ = (bitField0_ & ~0x00000004);
        lon_ = 0D;
        onChanged();
        return this;
      }

      // optional double alt = 4;
      private double alt_ ;
      /**
       * <code>optional double alt = 4;</code>
       */
      public boolean hasAlt() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional double alt = 4;</code>
       */
      public double getAlt() {
        return alt_;
      }
      /**
       * <code>optional double alt = 4;</code>
       */
      public Builder setAlt(double value) {
        bitField0_ |= 0x00000008;
        alt_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional double alt = 4;</code>
       */
      public Builder clearAlt() {
        bitField0_ = (bitField0_ & ~0x00000008);
        alt_ = 0D;
        onChanged();
        return this;
      }

      // optional string desc = 5;
      private java.lang.Object desc_ = "";
      /**
       * <code>optional string desc = 5;</code>
       */
      public boolean hasDesc() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional string desc = 5;</code>
       */
      public java.lang.String getDesc() {
        java.lang.Object ref = desc_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          desc_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string desc = 5;</code>
       */
      public com.google.protobuf.ByteString
          getDescBytes() {
        java.lang.Object ref = desc_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          desc_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string desc = 5;</code>
       */
      public Builder setDesc(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        desc_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string desc = 5;</code>
       */
      public Builder clearDesc() {
        bitField0_ = (bitField0_ & ~0x00000010);
        desc_ = getDefaultInstance().getDesc();
        onChanged();
        return this;
      }
      /**
       * <code>optional string desc = 5;</code>
       */
      public Builder setDescBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000010;
        desc_ = value;
        onChanged();
        return this;
      }

      // optional string wmoId = 6;
      private java.lang.Object wmoId_ = "";
      /**
       * <code>optional string wmoId = 6;</code>
       */
      public boolean hasWmoId() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional string wmoId = 6;</code>
       */
      public java.lang.String getWmoId() {
        java.lang.Object ref = wmoId_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          wmoId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string wmoId = 6;</code>
       */
      public com.google.protobuf.ByteString
          getWmoIdBytes() {
        java.lang.Object ref = wmoId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          wmoId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string wmoId = 6;</code>
       */
      public Builder setWmoId(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        wmoId_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string wmoId = 6;</code>
       */
      public Builder clearWmoId() {
        bitField0_ = (bitField0_ & ~0x00000020);
        wmoId_ = getDefaultInstance().getWmoId();
        onChanged();
        return this;
      }
      /**
       * <code>optional string wmoId = 6;</code>
       */
      public Builder setWmoIdBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000020;
        wmoId_ = value;
        onChanged();
        return this;
      }

      // required int32 count = 7;
      private int count_ ;
      /**
       * <code>required int32 count = 7;</code>
       */
      public boolean hasCount() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>required int32 count = 7;</code>
       */
      public int getCount() {
        return count_;
      }
      /**
       * <code>required int32 count = 7;</code>
       */
      public Builder setCount(int value) {
        bitField0_ |= 0x00000040;
        count_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required int32 count = 7;</code>
       */
      public Builder clearCount() {
        bitField0_ = (bitField0_ & ~0x00000040);
        count_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:bufrCdmIndex.Station)
    }

    static {
      defaultInstance = new Station(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:bufrCdmIndex.Station)
  }

  public interface FieldOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required uint32 fxy = 1;
    /**
     * <code>required uint32 fxy = 1;</code>
     */
    boolean hasFxy();
    /**
     * <code>required uint32 fxy = 1;</code>
     */
    int getFxy();

    // optional string name = 2;
    /**
     * <code>optional string name = 2;</code>
     */
    boolean hasName();
    /**
     * <code>optional string name = 2;</code>
     */
    java.lang.String getName();
    /**
     * <code>optional string name = 2;</code>
     */
    com.google.protobuf.ByteString
        getNameBytes();

    // repeated .bufrCdmIndex.Field flds = 3;
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field> 
        getFldsList();
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field getFlds(int index);
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    int getFldsCount();
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    java.util.List<? extends ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder> 
        getFldsOrBuilderList();
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder getFldsOrBuilder(
        int index);

    // optional .bufrCdmIndex.FldAction action = 4;
    /**
     * <code>optional .bufrCdmIndex.FldAction action = 4;</code>
     */
    boolean hasAction();
    /**
     * <code>optional .bufrCdmIndex.FldAction action = 4;</code>
     */
    ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction getAction();

    // optional .bufrCdmIndex.FldType type = 5;
    /**
     * <code>optional .bufrCdmIndex.FldType type = 5;</code>
     */
    boolean hasType();
    /**
     * <code>optional .bufrCdmIndex.FldType type = 5;</code>
     */
    ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType getType();

    // optional uint32 min = 6;
    /**
     * <code>optional uint32 min = 6;</code>
     */
    boolean hasMin();
    /**
     * <code>optional uint32 min = 6;</code>
     */
    int getMin();

    // optional uint32 max = 7;
    /**
     * <code>optional uint32 max = 7;</code>
     */
    boolean hasMax();
    /**
     * <code>optional uint32 max = 7;</code>
     */
    int getMax();

    // optional string desc = 8;
    /**
     * <code>optional string desc = 8;</code>
     */
    boolean hasDesc();
    /**
     * <code>optional string desc = 8;</code>
     */
    java.lang.String getDesc();
    /**
     * <code>optional string desc = 8;</code>
     */
    com.google.protobuf.ByteString
        getDescBytes();

    // optional string units = 9;
    /**
     * <code>optional string units = 9;</code>
     */
    boolean hasUnits();
    /**
     * <code>optional string units = 9;</code>
     */
    java.lang.String getUnits();
    /**
     * <code>optional string units = 9;</code>
     */
    com.google.protobuf.ByteString
        getUnitsBytes();

    // required int32 scale = 10;
    /**
     * <code>required int32 scale = 10;</code>
     *
     * <pre>
     * bufr scale and offset
     * </pre>
     */
    boolean hasScale();
    /**
     * <code>required int32 scale = 10;</code>
     *
     * <pre>
     * bufr scale and offset
     * </pre>
     */
    int getScale();

    // required int32 reference = 11;
    /**
     * <code>required int32 reference = 11;</code>
     */
    boolean hasReference();
    /**
     * <code>required int32 reference = 11;</code>
     */
    int getReference();

    // required int32 bitWidth = 12;
    /**
     * <code>required int32 bitWidth = 12;</code>
     */
    boolean hasBitWidth();
    /**
     * <code>required int32 bitWidth = 12;</code>
     */
    int getBitWidth();
  }
  /**
   * Protobuf type {@code bufrCdmIndex.Field}
   */
  public static final class Field extends
      com.google.protobuf.GeneratedMessage
      implements FieldOrBuilder {
    // Use Field.newBuilder() to construct.
    private Field(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private Field(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final Field defaultInstance;
    public static Field getDefaultInstance() {
      return defaultInstance;
    }

    public Field getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private Field(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 8: {
              bitField0_ |= 0x00000001;
              fxy_ = input.readUInt32();
              break;
            }
            case 18: {
              bitField0_ |= 0x00000002;
              name_ = input.readBytes();
              break;
            }
            case 26: {
              if (!((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
                flds_ = new java.util.ArrayList<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field>();
                mutable_bitField0_ |= 0x00000004;
              }
              flds_.add(input.readMessage(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.PARSER, extensionRegistry));
              break;
            }
            case 32: {
              int rawValue = input.readEnum();
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction value = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(4, rawValue);
              } else {
                bitField0_ |= 0x00000004;
                action_ = value;
              }
              break;
            }
            case 40: {
              int rawValue = input.readEnum();
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType value = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType.valueOf(rawValue);
              if (value == null) {
                unknownFields.mergeVarintField(5, rawValue);
              } else {
                bitField0_ |= 0x00000008;
                type_ = value;
              }
              break;
            }
            case 48: {
              bitField0_ |= 0x00000010;
              min_ = input.readUInt32();
              break;
            }
            case 56: {
              bitField0_ |= 0x00000020;
              max_ = input.readUInt32();
              break;
            }
            case 66: {
              bitField0_ |= 0x00000040;
              desc_ = input.readBytes();
              break;
            }
            case 74: {
              bitField0_ |= 0x00000080;
              units_ = input.readBytes();
              break;
            }
            case 80: {
              bitField0_ |= 0x00000100;
              scale_ = input.readInt32();
              break;
            }
            case 88: {
              bitField0_ |= 0x00000200;
              reference_ = input.readInt32();
              break;
            }
            case 96: {
              bitField0_ |= 0x00000400;
              bitWidth_ = input.readInt32();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000004) == 0x00000004)) {
          flds_ = java.util.Collections.unmodifiableList(flds_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Field_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Field_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.class, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder.class);
    }

    public static com.google.protobuf.Parser<Field> PARSER =
        new com.google.protobuf.AbstractParser<Field>() {
      public Field parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new Field(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<Field> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required uint32 fxy = 1;
    public static final int FXY_FIELD_NUMBER = 1;
    private int fxy_;
    /**
     * <code>required uint32 fxy = 1;</code>
     */
    public boolean hasFxy() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required uint32 fxy = 1;</code>
     */
    public int getFxy() {
      return fxy_;
    }

    // optional string name = 2;
    public static final int NAME_FIELD_NUMBER = 2;
    private java.lang.Object name_;
    /**
     * <code>optional string name = 2;</code>
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>optional string name = 2;</code>
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          name_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string name = 2;</code>
     */
    public com.google.protobuf.ByteString
        getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // repeated .bufrCdmIndex.Field flds = 3;
    public static final int FLDS_FIELD_NUMBER = 3;
    private java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field> flds_;
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    public java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field> getFldsList() {
      return flds_;
    }
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    public java.util.List<? extends ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder> 
        getFldsOrBuilderList() {
      return flds_;
    }
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    public int getFldsCount() {
      return flds_.size();
    }
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field getFlds(int index) {
      return flds_.get(index);
    }
    /**
     * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
     */
    public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder getFldsOrBuilder(
        int index) {
      return flds_.get(index);
    }

    // optional .bufrCdmIndex.FldAction action = 4;
    public static final int ACTION_FIELD_NUMBER = 4;
    private ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction action_;
    /**
     * <code>optional .bufrCdmIndex.FldAction action = 4;</code>
     */
    public boolean hasAction() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>optional .bufrCdmIndex.FldAction action = 4;</code>
     */
    public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction getAction() {
      return action_;
    }

    // optional .bufrCdmIndex.FldType type = 5;
    public static final int TYPE_FIELD_NUMBER = 5;
    private ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType type_;
    /**
     * <code>optional .bufrCdmIndex.FldType type = 5;</code>
     */
    public boolean hasType() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>optional .bufrCdmIndex.FldType type = 5;</code>
     */
    public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType getType() {
      return type_;
    }

    // optional uint32 min = 6;
    public static final int MIN_FIELD_NUMBER = 6;
    private int min_;
    /**
     * <code>optional uint32 min = 6;</code>
     */
    public boolean hasMin() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>optional uint32 min = 6;</code>
     */
    public int getMin() {
      return min_;
    }

    // optional uint32 max = 7;
    public static final int MAX_FIELD_NUMBER = 7;
    private int max_;
    /**
     * <code>optional uint32 max = 7;</code>
     */
    public boolean hasMax() {
      return ((bitField0_ & 0x00000020) == 0x00000020);
    }
    /**
     * <code>optional uint32 max = 7;</code>
     */
    public int getMax() {
      return max_;
    }

    // optional string desc = 8;
    public static final int DESC_FIELD_NUMBER = 8;
    private java.lang.Object desc_;
    /**
     * <code>optional string desc = 8;</code>
     */
    public boolean hasDesc() {
      return ((bitField0_ & 0x00000040) == 0x00000040);
    }
    /**
     * <code>optional string desc = 8;</code>
     */
    public java.lang.String getDesc() {
      java.lang.Object ref = desc_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          desc_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string desc = 8;</code>
     */
    public com.google.protobuf.ByteString
        getDescBytes() {
      java.lang.Object ref = desc_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        desc_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // optional string units = 9;
    public static final int UNITS_FIELD_NUMBER = 9;
    private java.lang.Object units_;
    /**
     * <code>optional string units = 9;</code>
     */
    public boolean hasUnits() {
      return ((bitField0_ & 0x00000080) == 0x00000080);
    }
    /**
     * <code>optional string units = 9;</code>
     */
    public java.lang.String getUnits() {
      java.lang.Object ref = units_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          units_ = s;
        }
        return s;
      }
    }
    /**
     * <code>optional string units = 9;</code>
     */
    public com.google.protobuf.ByteString
        getUnitsBytes() {
      java.lang.Object ref = units_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        units_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // required int32 scale = 10;
    public static final int SCALE_FIELD_NUMBER = 10;
    private int scale_;
    /**
     * <code>required int32 scale = 10;</code>
     *
     * <pre>
     * bufr scale and offset
     * </pre>
     */
    public boolean hasScale() {
      return ((bitField0_ & 0x00000100) == 0x00000100);
    }
    /**
     * <code>required int32 scale = 10;</code>
     *
     * <pre>
     * bufr scale and offset
     * </pre>
     */
    public int getScale() {
      return scale_;
    }

    // required int32 reference = 11;
    public static final int REFERENCE_FIELD_NUMBER = 11;
    private int reference_;
    /**
     * <code>required int32 reference = 11;</code>
     */
    public boolean hasReference() {
      return ((bitField0_ & 0x00000200) == 0x00000200);
    }
    /**
     * <code>required int32 reference = 11;</code>
     */
    public int getReference() {
      return reference_;
    }

    // required int32 bitWidth = 12;
    public static final int BITWIDTH_FIELD_NUMBER = 12;
    private int bitWidth_;
    /**
     * <code>required int32 bitWidth = 12;</code>
     */
    public boolean hasBitWidth() {
      return ((bitField0_ & 0x00000400) == 0x00000400);
    }
    /**
     * <code>required int32 bitWidth = 12;</code>
     */
    public int getBitWidth() {
      return bitWidth_;
    }

    private void initFields() {
      fxy_ = 0;
      name_ = "";
      flds_ = java.util.Collections.emptyList();
      action_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction.none;
      type_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType.lat;
      min_ = 0;
      max_ = 0;
      desc_ = "";
      units_ = "";
      scale_ = 0;
      reference_ = 0;
      bitWidth_ = 0;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasFxy()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasScale()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasReference()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasBitWidth()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getFldsCount(); i++) {
        if (!getFlds(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeUInt32(1, fxy_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeBytes(2, getNameBytes());
      }
      for (int i = 0; i < flds_.size(); i++) {
        output.writeMessage(3, flds_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeEnum(4, action_.getNumber());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeEnum(5, type_.getNumber());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt32(6, min_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        output.writeUInt32(7, max_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        output.writeBytes(8, getDescBytes());
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        output.writeBytes(9, getUnitsBytes());
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        output.writeInt32(10, scale_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        output.writeInt32(11, reference_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        output.writeInt32(12, bitWidth_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(1, fxy_);
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(2, getNameBytes());
      }
      for (int i = 0; i < flds_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, flds_.get(i));
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(4, action_.getNumber());
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeEnumSize(5, type_.getNumber());
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(6, min_);
      }
      if (((bitField0_ & 0x00000020) == 0x00000020)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt32Size(7, max_);
      }
      if (((bitField0_ & 0x00000040) == 0x00000040)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(8, getDescBytes());
      }
      if (((bitField0_ & 0x00000080) == 0x00000080)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(9, getUnitsBytes());
      }
      if (((bitField0_ & 0x00000100) == 0x00000100)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(10, scale_);
      }
      if (((bitField0_ & 0x00000200) == 0x00000200)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(11, reference_);
      }
      if (((bitField0_ & 0x00000400) == 0x00000400)) {
        size += com.google.protobuf.CodedOutputStream
          .computeInt32Size(12, bitWidth_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bufrCdmIndex.Field}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Field_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Field_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.class, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder.class);
      }

      // Construct using ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getFldsFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        fxy_ = 0;
        bitField0_ = (bitField0_ & ~0x00000001);
        name_ = "";
        bitField0_ = (bitField0_ & ~0x00000002);
        if (fldsBuilder_ == null) {
          flds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
        } else {
          fldsBuilder_.clear();
        }
        action_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction.none;
        bitField0_ = (bitField0_ & ~0x00000008);
        type_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType.lat;
        bitField0_ = (bitField0_ & ~0x00000010);
        min_ = 0;
        bitField0_ = (bitField0_ & ~0x00000020);
        max_ = 0;
        bitField0_ = (bitField0_ & ~0x00000040);
        desc_ = "";
        bitField0_ = (bitField0_ & ~0x00000080);
        units_ = "";
        bitField0_ = (bitField0_ & ~0x00000100);
        scale_ = 0;
        bitField0_ = (bitField0_ & ~0x00000200);
        reference_ = 0;
        bitField0_ = (bitField0_ & ~0x00000400);
        bitWidth_ = 0;
        bitField0_ = (bitField0_ & ~0x00000800);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_Field_descriptor;
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field getDefaultInstanceForType() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance();
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field build() {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field buildPartial() {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field result = new ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.fxy_ = fxy_;
        if (((from_bitField0_ & 0x00000002) == 0x00000002)) {
          to_bitField0_ |= 0x00000002;
        }
        result.name_ = name_;
        if (fldsBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004)) {
            flds_ = java.util.Collections.unmodifiableList(flds_);
            bitField0_ = (bitField0_ & ~0x00000004);
          }
          result.flds_ = flds_;
        } else {
          result.flds_ = fldsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000004;
        }
        result.action_ = action_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000008;
        }
        result.type_ = type_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000010;
        }
        result.min_ = min_;
        if (((from_bitField0_ & 0x00000040) == 0x00000040)) {
          to_bitField0_ |= 0x00000020;
        }
        result.max_ = max_;
        if (((from_bitField0_ & 0x00000080) == 0x00000080)) {
          to_bitField0_ |= 0x00000040;
        }
        result.desc_ = desc_;
        if (((from_bitField0_ & 0x00000100) == 0x00000100)) {
          to_bitField0_ |= 0x00000080;
        }
        result.units_ = units_;
        if (((from_bitField0_ & 0x00000200) == 0x00000200)) {
          to_bitField0_ |= 0x00000100;
        }
        result.scale_ = scale_;
        if (((from_bitField0_ & 0x00000400) == 0x00000400)) {
          to_bitField0_ |= 0x00000200;
        }
        result.reference_ = reference_;
        if (((from_bitField0_ & 0x00000800) == 0x00000800)) {
          to_bitField0_ |= 0x00000400;
        }
        result.bitWidth_ = bitWidth_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field) {
          return mergeFrom((ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field other) {
        if (other == ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance()) return this;
        if (other.hasFxy()) {
          setFxy(other.getFxy());
        }
        if (other.hasName()) {
          bitField0_ |= 0x00000002;
          name_ = other.name_;
          onChanged();
        }
        if (fldsBuilder_ == null) {
          if (!other.flds_.isEmpty()) {
            if (flds_.isEmpty()) {
              flds_ = other.flds_;
              bitField0_ = (bitField0_ & ~0x00000004);
            } else {
              ensureFldsIsMutable();
              flds_.addAll(other.flds_);
            }
            onChanged();
          }
        } else {
          if (!other.flds_.isEmpty()) {
            if (fldsBuilder_.isEmpty()) {
              fldsBuilder_.dispose();
              fldsBuilder_ = null;
              flds_ = other.flds_;
              bitField0_ = (bitField0_ & ~0x00000004);
              fldsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getFldsFieldBuilder() : null;
            } else {
              fldsBuilder_.addAllMessages(other.flds_);
            }
          }
        }
        if (other.hasAction()) {
          setAction(other.getAction());
        }
        if (other.hasType()) {
          setType(other.getType());
        }
        if (other.hasMin()) {
          setMin(other.getMin());
        }
        if (other.hasMax()) {
          setMax(other.getMax());
        }
        if (other.hasDesc()) {
          bitField0_ |= 0x00000080;
          desc_ = other.desc_;
          onChanged();
        }
        if (other.hasUnits()) {
          bitField0_ |= 0x00000100;
          units_ = other.units_;
          onChanged();
        }
        if (other.hasScale()) {
          setScale(other.getScale());
        }
        if (other.hasReference()) {
          setReference(other.getReference());
        }
        if (other.hasBitWidth()) {
          setBitWidth(other.getBitWidth());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasFxy()) {
          
          return false;
        }
        if (!hasScale()) {
          
          return false;
        }
        if (!hasReference()) {
          
          return false;
        }
        if (!hasBitWidth()) {
          
          return false;
        }
        for (int i = 0; i < getFldsCount(); i++) {
          if (!getFlds(i).isInitialized()) {
            
            return false;
          }
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required uint32 fxy = 1;
      private int fxy_ ;
      /**
       * <code>required uint32 fxy = 1;</code>
       */
      public boolean hasFxy() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required uint32 fxy = 1;</code>
       */
      public int getFxy() {
        return fxy_;
      }
      /**
       * <code>required uint32 fxy = 1;</code>
       */
      public Builder setFxy(int value) {
        bitField0_ |= 0x00000001;
        fxy_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint32 fxy = 1;</code>
       */
      public Builder clearFxy() {
        bitField0_ = (bitField0_ & ~0x00000001);
        fxy_ = 0;
        onChanged();
        return this;
      }

      // optional string name = 2;
      private java.lang.Object name_ = "";
      /**
       * <code>optional string name = 2;</code>
       */
      public boolean hasName() {
        return ((bitField0_ & 0x00000002) == 0x00000002);
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public com.google.protobuf.ByteString
          getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder setName(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        name_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder clearName() {
        bitField0_ = (bitField0_ & ~0x00000002);
        name_ = getDefaultInstance().getName();
        onChanged();
        return this;
      }
      /**
       * <code>optional string name = 2;</code>
       */
      public Builder setNameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000002;
        name_ = value;
        onChanged();
        return this;
      }

      // repeated .bufrCdmIndex.Field flds = 3;
      private java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field> flds_ =
        java.util.Collections.emptyList();
      private void ensureFldsIsMutable() {
        if (!((bitField0_ & 0x00000004) == 0x00000004)) {
          flds_ = new java.util.ArrayList<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field>(flds_);
          bitField0_ |= 0x00000004;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder> fldsBuilder_;

      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field> getFldsList() {
        if (fldsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(flds_);
        } else {
          return fldsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public int getFldsCount() {
        if (fldsBuilder_ == null) {
          return flds_.size();
        } else {
          return fldsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field getFlds(int index) {
        if (fldsBuilder_ == null) {
          return flds_.get(index);
        } else {
          return fldsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder setFlds(
          int index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field value) {
        if (fldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldsIsMutable();
          flds_.set(index, value);
          onChanged();
        } else {
          fldsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder setFlds(
          int index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder builderForValue) {
        if (fldsBuilder_ == null) {
          ensureFldsIsMutable();
          flds_.set(index, builderForValue.build());
          onChanged();
        } else {
          fldsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder addFlds(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field value) {
        if (fldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldsIsMutable();
          flds_.add(value);
          onChanged();
        } else {
          fldsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder addFlds(
          int index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field value) {
        if (fldsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureFldsIsMutable();
          flds_.add(index, value);
          onChanged();
        } else {
          fldsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder addFlds(
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder builderForValue) {
        if (fldsBuilder_ == null) {
          ensureFldsIsMutable();
          flds_.add(builderForValue.build());
          onChanged();
        } else {
          fldsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder addFlds(
          int index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder builderForValue) {
        if (fldsBuilder_ == null) {
          ensureFldsIsMutable();
          flds_.add(index, builderForValue.build());
          onChanged();
        } else {
          fldsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder addAllFlds(
          java.lang.Iterable<? extends ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field> values) {
        if (fldsBuilder_ == null) {
          ensureFldsIsMutable();
          super.addAll(values, flds_);
          onChanged();
        } else {
          fldsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder clearFlds() {
        if (fldsBuilder_ == null) {
          flds_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
        } else {
          fldsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public Builder removeFlds(int index) {
        if (fldsBuilder_ == null) {
          ensureFldsIsMutable();
          flds_.remove(index);
          onChanged();
        } else {
          fldsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder getFldsBuilder(
          int index) {
        return getFldsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder getFldsOrBuilder(
          int index) {
        if (fldsBuilder_ == null) {
          return flds_.get(index);  } else {
          return fldsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public java.util.List<? extends ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder> 
           getFldsOrBuilderList() {
        if (fldsBuilder_ != null) {
          return fldsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(flds_);
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder addFldsBuilder() {
        return getFldsFieldBuilder().addBuilder(
            ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance());
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder addFldsBuilder(
          int index) {
        return getFldsFieldBuilder().addBuilder(
            index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance());
      }
      /**
       * <code>repeated .bufrCdmIndex.Field flds = 3;</code>
       */
      public java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder> 
           getFldsBuilderList() {
        return getFldsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder> 
          getFldsFieldBuilder() {
        if (fldsBuilder_ == null) {
          fldsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder>(
                  flds_,
                  ((bitField0_ & 0x00000004) == 0x00000004),
                  getParentForChildren(),
                  isClean());
          flds_ = null;
        }
        return fldsBuilder_;
      }

      // optional .bufrCdmIndex.FldAction action = 4;
      private ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction action_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction.none;
      /**
       * <code>optional .bufrCdmIndex.FldAction action = 4;</code>
       */
      public boolean hasAction() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>optional .bufrCdmIndex.FldAction action = 4;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction getAction() {
        return action_;
      }
      /**
       * <code>optional .bufrCdmIndex.FldAction action = 4;</code>
       */
      public Builder setAction(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000008;
        action_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .bufrCdmIndex.FldAction action = 4;</code>
       */
      public Builder clearAction() {
        bitField0_ = (bitField0_ & ~0x00000008);
        action_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldAction.none;
        onChanged();
        return this;
      }

      // optional .bufrCdmIndex.FldType type = 5;
      private ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType type_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType.lat;
      /**
       * <code>optional .bufrCdmIndex.FldType type = 5;</code>
       */
      public boolean hasType() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>optional .bufrCdmIndex.FldType type = 5;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType getType() {
        return type_;
      }
      /**
       * <code>optional .bufrCdmIndex.FldType type = 5;</code>
       */
      public Builder setType(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        type_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional .bufrCdmIndex.FldType type = 5;</code>
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000010);
        type_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FldType.lat;
        onChanged();
        return this;
      }

      // optional uint32 min = 6;
      private int min_ ;
      /**
       * <code>optional uint32 min = 6;</code>
       */
      public boolean hasMin() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>optional uint32 min = 6;</code>
       */
      public int getMin() {
        return min_;
      }
      /**
       * <code>optional uint32 min = 6;</code>
       */
      public Builder setMin(int value) {
        bitField0_ |= 0x00000020;
        min_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 min = 6;</code>
       */
      public Builder clearMin() {
        bitField0_ = (bitField0_ & ~0x00000020);
        min_ = 0;
        onChanged();
        return this;
      }

      // optional uint32 max = 7;
      private int max_ ;
      /**
       * <code>optional uint32 max = 7;</code>
       */
      public boolean hasMax() {
        return ((bitField0_ & 0x00000040) == 0x00000040);
      }
      /**
       * <code>optional uint32 max = 7;</code>
       */
      public int getMax() {
        return max_;
      }
      /**
       * <code>optional uint32 max = 7;</code>
       */
      public Builder setMax(int value) {
        bitField0_ |= 0x00000040;
        max_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional uint32 max = 7;</code>
       */
      public Builder clearMax() {
        bitField0_ = (bitField0_ & ~0x00000040);
        max_ = 0;
        onChanged();
        return this;
      }

      // optional string desc = 8;
      private java.lang.Object desc_ = "";
      /**
       * <code>optional string desc = 8;</code>
       */
      public boolean hasDesc() {
        return ((bitField0_ & 0x00000080) == 0x00000080);
      }
      /**
       * <code>optional string desc = 8;</code>
       */
      public java.lang.String getDesc() {
        java.lang.Object ref = desc_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          desc_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string desc = 8;</code>
       */
      public com.google.protobuf.ByteString
          getDescBytes() {
        java.lang.Object ref = desc_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          desc_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string desc = 8;</code>
       */
      public Builder setDesc(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        desc_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string desc = 8;</code>
       */
      public Builder clearDesc() {
        bitField0_ = (bitField0_ & ~0x00000080);
        desc_ = getDefaultInstance().getDesc();
        onChanged();
        return this;
      }
      /**
       * <code>optional string desc = 8;</code>
       */
      public Builder setDescBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000080;
        desc_ = value;
        onChanged();
        return this;
      }

      // optional string units = 9;
      private java.lang.Object units_ = "";
      /**
       * <code>optional string units = 9;</code>
       */
      public boolean hasUnits() {
        return ((bitField0_ & 0x00000100) == 0x00000100);
      }
      /**
       * <code>optional string units = 9;</code>
       */
      public java.lang.String getUnits() {
        java.lang.Object ref = units_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          units_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>optional string units = 9;</code>
       */
      public com.google.protobuf.ByteString
          getUnitsBytes() {
        java.lang.Object ref = units_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          units_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>optional string units = 9;</code>
       */
      public Builder setUnits(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000100;
        units_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>optional string units = 9;</code>
       */
      public Builder clearUnits() {
        bitField0_ = (bitField0_ & ~0x00000100);
        units_ = getDefaultInstance().getUnits();
        onChanged();
        return this;
      }
      /**
       * <code>optional string units = 9;</code>
       */
      public Builder setUnitsBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000100;
        units_ = value;
        onChanged();
        return this;
      }

      // required int32 scale = 10;
      private int scale_ ;
      /**
       * <code>required int32 scale = 10;</code>
       *
       * <pre>
       * bufr scale and offset
       * </pre>
       */
      public boolean hasScale() {
        return ((bitField0_ & 0x00000200) == 0x00000200);
      }
      /**
       * <code>required int32 scale = 10;</code>
       *
       * <pre>
       * bufr scale and offset
       * </pre>
       */
      public int getScale() {
        return scale_;
      }
      /**
       * <code>required int32 scale = 10;</code>
       *
       * <pre>
       * bufr scale and offset
       * </pre>
       */
      public Builder setScale(int value) {
        bitField0_ |= 0x00000200;
        scale_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required int32 scale = 10;</code>
       *
       * <pre>
       * bufr scale and offset
       * </pre>
       */
      public Builder clearScale() {
        bitField0_ = (bitField0_ & ~0x00000200);
        scale_ = 0;
        onChanged();
        return this;
      }

      // required int32 reference = 11;
      private int reference_ ;
      /**
       * <code>required int32 reference = 11;</code>
       */
      public boolean hasReference() {
        return ((bitField0_ & 0x00000400) == 0x00000400);
      }
      /**
       * <code>required int32 reference = 11;</code>
       */
      public int getReference() {
        return reference_;
      }
      /**
       * <code>required int32 reference = 11;</code>
       */
      public Builder setReference(int value) {
        bitField0_ |= 0x00000400;
        reference_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required int32 reference = 11;</code>
       */
      public Builder clearReference() {
        bitField0_ = (bitField0_ & ~0x00000400);
        reference_ = 0;
        onChanged();
        return this;
      }

      // required int32 bitWidth = 12;
      private int bitWidth_ ;
      /**
       * <code>required int32 bitWidth = 12;</code>
       */
      public boolean hasBitWidth() {
        return ((bitField0_ & 0x00000800) == 0x00000800);
      }
      /**
       * <code>required int32 bitWidth = 12;</code>
       */
      public int getBitWidth() {
        return bitWidth_;
      }
      /**
       * <code>required int32 bitWidth = 12;</code>
       */
      public Builder setBitWidth(int value) {
        bitField0_ |= 0x00000800;
        bitWidth_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required int32 bitWidth = 12;</code>
       */
      public Builder clearBitWidth() {
        bitField0_ = (bitField0_ & ~0x00000800);
        bitWidth_ = 0;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:bufrCdmIndex.Field)
    }

    static {
      defaultInstance = new Field(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:bufrCdmIndex.Field)
  }

  public interface BufrIndexOrBuilder
      extends com.google.protobuf.MessageOrBuilder {

    // required string filename = 1;
    /**
     * <code>required string filename = 1;</code>
     */
    boolean hasFilename();
    /**
     * <code>required string filename = 1;</code>
     */
    java.lang.String getFilename();
    /**
     * <code>required string filename = 1;</code>
     */
    com.google.protobuf.ByteString
        getFilenameBytes();

    // repeated .bufrCdmIndex.Station stations = 2;
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station> 
        getStationsList();
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station getStations(int index);
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    int getStationsCount();
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    java.util.List<? extends ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder> 
        getStationsOrBuilderList();
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder getStationsOrBuilder(
        int index);

    // required .bufrCdmIndex.Field root = 3;
    /**
     * <code>required .bufrCdmIndex.Field root = 3;</code>
     */
    boolean hasRoot();
    /**
     * <code>required .bufrCdmIndex.Field root = 3;</code>
     */
    ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field getRoot();
    /**
     * <code>required .bufrCdmIndex.Field root = 3;</code>
     */
    ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder getRootOrBuilder();

    // required uint64 start = 4;
    /**
     * <code>required uint64 start = 4;</code>
     *
     * <pre>
     * msecs since epoch
     * </pre>
     */
    boolean hasStart();
    /**
     * <code>required uint64 start = 4;</code>
     *
     * <pre>
     * msecs since epoch
     * </pre>
     */
    long getStart();

    // required uint64 end = 5;
    /**
     * <code>required uint64 end = 5;</code>
     */
    boolean hasEnd();
    /**
     * <code>required uint64 end = 5;</code>
     */
    long getEnd();

    // required uint64 nobs = 6;
    /**
     * <code>required uint64 nobs = 6;</code>
     */
    boolean hasNobs();
    /**
     * <code>required uint64 nobs = 6;</code>
     */
    long getNobs();
  }
  /**
   * Protobuf type {@code bufrCdmIndex.BufrIndex}
   */
  public static final class BufrIndex extends
      com.google.protobuf.GeneratedMessage
      implements BufrIndexOrBuilder {
    // Use BufrIndex.newBuilder() to construct.
    private BufrIndex(com.google.protobuf.GeneratedMessage.Builder<?> builder) {
      super(builder);
      this.unknownFields = builder.getUnknownFields();
    }
    private BufrIndex(boolean noInit) { this.unknownFields = com.google.protobuf.UnknownFieldSet.getDefaultInstance(); }

    private static final BufrIndex defaultInstance;
    public static BufrIndex getDefaultInstance() {
      return defaultInstance;
    }

    public BufrIndex getDefaultInstanceForType() {
      return defaultInstance;
    }

    private final com.google.protobuf.UnknownFieldSet unknownFields;
    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet
        getUnknownFields() {
      return this.unknownFields;
    }
    private BufrIndex(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      initFields();
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            default: {
              if (!parseUnknownField(input, unknownFields,
                                     extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
            case 10: {
              bitField0_ |= 0x00000001;
              filename_ = input.readBytes();
              break;
            }
            case 18: {
              if (!((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
                stations_ = new java.util.ArrayList<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station>();
                mutable_bitField0_ |= 0x00000002;
              }
              stations_.add(input.readMessage(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.PARSER, extensionRegistry));
              break;
            }
            case 26: {
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder subBuilder = null;
              if (((bitField0_ & 0x00000002) == 0x00000002)) {
                subBuilder = root_.toBuilder();
              }
              root_ = input.readMessage(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.PARSER, extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(root_);
                root_ = subBuilder.buildPartial();
              }
              bitField0_ |= 0x00000002;
              break;
            }
            case 32: {
              bitField0_ |= 0x00000004;
              start_ = input.readUInt64();
              break;
            }
            case 40: {
              bitField0_ |= 0x00000008;
              end_ = input.readUInt64();
              break;
            }
            case 48: {
              bitField0_ |= 0x00000010;
              nobs_ = input.readUInt64();
              break;
            }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(
            e.getMessage()).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000002) == 0x00000002)) {
          stations_ = java.util.Collections.unmodifiableList(stations_);
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_BufrIndex_descriptor;
    }

    protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_BufrIndex_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex.class, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex.Builder.class);
    }

    public static com.google.protobuf.Parser<BufrIndex> PARSER =
        new com.google.protobuf.AbstractParser<BufrIndex>() {
      public BufrIndex parsePartialFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
        return new BufrIndex(input, extensionRegistry);
      }
    };

    @java.lang.Override
    public com.google.protobuf.Parser<BufrIndex> getParserForType() {
      return PARSER;
    }

    private int bitField0_;
    // required string filename = 1;
    public static final int FILENAME_FIELD_NUMBER = 1;
    private java.lang.Object filename_;
    /**
     * <code>required string filename = 1;</code>
     */
    public boolean hasFilename() {
      return ((bitField0_ & 0x00000001) == 0x00000001);
    }
    /**
     * <code>required string filename = 1;</code>
     */
    public java.lang.String getFilename() {
      java.lang.Object ref = filename_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = 
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (bs.isValidUtf8()) {
          filename_ = s;
        }
        return s;
      }
    }
    /**
     * <code>required string filename = 1;</code>
     */
    public com.google.protobuf.ByteString
        getFilenameBytes() {
      java.lang.Object ref = filename_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        filename_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    // repeated .bufrCdmIndex.Station stations = 2;
    public static final int STATIONS_FIELD_NUMBER = 2;
    private java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station> stations_;
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    public java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station> getStationsList() {
      return stations_;
    }
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    public java.util.List<? extends ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder> 
        getStationsOrBuilderList() {
      return stations_;
    }
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    public int getStationsCount() {
      return stations_.size();
    }
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station getStations(int index) {
      return stations_.get(index);
    }
    /**
     * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
     */
    public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder getStationsOrBuilder(
        int index) {
      return stations_.get(index);
    }

    // required .bufrCdmIndex.Field root = 3;
    public static final int ROOT_FIELD_NUMBER = 3;
    private ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field root_;
    /**
     * <code>required .bufrCdmIndex.Field root = 3;</code>
     */
    public boolean hasRoot() {
      return ((bitField0_ & 0x00000002) == 0x00000002);
    }
    /**
     * <code>required .bufrCdmIndex.Field root = 3;</code>
     */
    public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field getRoot() {
      return root_;
    }
    /**
     * <code>required .bufrCdmIndex.Field root = 3;</code>
     */
    public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder getRootOrBuilder() {
      return root_;
    }

    // required uint64 start = 4;
    public static final int START_FIELD_NUMBER = 4;
    private long start_;
    /**
     * <code>required uint64 start = 4;</code>
     *
     * <pre>
     * msecs since epoch
     * </pre>
     */
    public boolean hasStart() {
      return ((bitField0_ & 0x00000004) == 0x00000004);
    }
    /**
     * <code>required uint64 start = 4;</code>
     *
     * <pre>
     * msecs since epoch
     * </pre>
     */
    public long getStart() {
      return start_;
    }

    // required uint64 end = 5;
    public static final int END_FIELD_NUMBER = 5;
    private long end_;
    /**
     * <code>required uint64 end = 5;</code>
     */
    public boolean hasEnd() {
      return ((bitField0_ & 0x00000008) == 0x00000008);
    }
    /**
     * <code>required uint64 end = 5;</code>
     */
    public long getEnd() {
      return end_;
    }

    // required uint64 nobs = 6;
    public static final int NOBS_FIELD_NUMBER = 6;
    private long nobs_;
    /**
     * <code>required uint64 nobs = 6;</code>
     */
    public boolean hasNobs() {
      return ((bitField0_ & 0x00000010) == 0x00000010);
    }
    /**
     * <code>required uint64 nobs = 6;</code>
     */
    public long getNobs() {
      return nobs_;
    }

    private void initFields() {
      filename_ = "";
      stations_ = java.util.Collections.emptyList();
      root_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance();
      start_ = 0L;
      end_ = 0L;
      nobs_ = 0L;
    }
    private byte memoizedIsInitialized = -1;
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized != -1) return isInitialized == 1;

      if (!hasFilename()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasRoot()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasStart()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasEnd()) {
        memoizedIsInitialized = 0;
        return false;
      }
      if (!hasNobs()) {
        memoizedIsInitialized = 0;
        return false;
      }
      for (int i = 0; i < getStationsCount(); i++) {
        if (!getStations(i).isInitialized()) {
          memoizedIsInitialized = 0;
          return false;
        }
      }
      if (!getRoot().isInitialized()) {
        memoizedIsInitialized = 0;
        return false;
      }
      memoizedIsInitialized = 1;
      return true;
    }

    public void writeTo(com.google.protobuf.CodedOutputStream output)
                        throws java.io.IOException {
      getSerializedSize();
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        output.writeBytes(1, getFilenameBytes());
      }
      for (int i = 0; i < stations_.size(); i++) {
        output.writeMessage(2, stations_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        output.writeMessage(3, root_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        output.writeUInt64(4, start_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        output.writeUInt64(5, end_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        output.writeUInt64(6, nobs_);
      }
      getUnknownFields().writeTo(output);
    }

    private int memoizedSerializedSize = -1;
    public int getSerializedSize() {
      int size = memoizedSerializedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) == 0x00000001)) {
        size += com.google.protobuf.CodedOutputStream
          .computeBytesSize(1, getFilenameBytes());
      }
      for (int i = 0; i < stations_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(2, stations_.get(i));
      }
      if (((bitField0_ & 0x00000002) == 0x00000002)) {
        size += com.google.protobuf.CodedOutputStream
          .computeMessageSize(3, root_);
      }
      if (((bitField0_ & 0x00000004) == 0x00000004)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(4, start_);
      }
      if (((bitField0_ & 0x00000008) == 0x00000008)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(5, end_);
      }
      if (((bitField0_ & 0x00000010) == 0x00000010)) {
        size += com.google.protobuf.CodedOutputStream
          .computeUInt64Size(6, nobs_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSerializedSize = size;
      return size;
    }

    private static final long serialVersionUID = 0L;
    @java.lang.Override
    protected java.lang.Object writeReplace()
        throws java.io.ObjectStreamException {
      return super.writeReplace();
    }

    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseFrom(
        byte[] data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseDelimitedFrom(java.io.InputStream input)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseDelimitedFrom(
        java.io.InputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseDelimitedFrom(input, extensionRegistry);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseFrom(
        com.google.protobuf.CodedInputStream input)
        throws java.io.IOException {
      return PARSER.parseFrom(input);
    }
    public static ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return PARSER.parseFrom(input, extensionRegistry);
    }

    public static Builder newBuilder() { return Builder.create(); }
    public Builder newBuilderForType() { return newBuilder(); }
    public static Builder newBuilder(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex prototype) {
      return newBuilder().mergeFrom(prototype);
    }
    public Builder toBuilder() { return newBuilder(this); }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessage.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     * Protobuf type {@code bufrCdmIndex.BufrIndex}
     */
    public static final class Builder extends
        com.google.protobuf.GeneratedMessage.Builder<Builder>
       implements ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndexOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor
          getDescriptor() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_BufrIndex_descriptor;
      }

      protected com.google.protobuf.GeneratedMessage.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_BufrIndex_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex.class, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex.Builder.class);
      }

      // Construct using ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(
          com.google.protobuf.GeneratedMessage.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }
      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders) {
          getStationsFieldBuilder();
          getRootFieldBuilder();
        }
      }
      private static Builder create() {
        return new Builder();
      }

      public Builder clear() {
        super.clear();
        filename_ = "";
        bitField0_ = (bitField0_ & ~0x00000001);
        if (stationsBuilder_ == null) {
          stations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
        } else {
          stationsBuilder_.clear();
        }
        if (rootBuilder_ == null) {
          root_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance();
        } else {
          rootBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        start_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000008);
        end_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000010);
        nobs_ = 0L;
        bitField0_ = (bitField0_ & ~0x00000020);
        return this;
      }

      public Builder clone() {
        return create().mergeFrom(buildPartial());
      }

      public com.google.protobuf.Descriptors.Descriptor
          getDescriptorForType() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.internal_static_bufrCdmIndex_BufrIndex_descriptor;
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex getDefaultInstanceForType() {
        return ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex.getDefaultInstance();
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex build() {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex buildPartial() {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex result = new ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex(this);
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) == 0x00000001)) {
          to_bitField0_ |= 0x00000001;
        }
        result.filename_ = filename_;
        if (stationsBuilder_ == null) {
          if (((bitField0_ & 0x00000002) == 0x00000002)) {
            stations_ = java.util.Collections.unmodifiableList(stations_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.stations_ = stations_;
        } else {
          result.stations_ = stationsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) == 0x00000004)) {
          to_bitField0_ |= 0x00000002;
        }
        if (rootBuilder_ == null) {
          result.root_ = root_;
        } else {
          result.root_ = rootBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) == 0x00000008)) {
          to_bitField0_ |= 0x00000004;
        }
        result.start_ = start_;
        if (((from_bitField0_ & 0x00000010) == 0x00000010)) {
          to_bitField0_ |= 0x00000008;
        }
        result.end_ = end_;
        if (((from_bitField0_ & 0x00000020) == 0x00000020)) {
          to_bitField0_ |= 0x00000010;
        }
        result.nobs_ = nobs_;
        result.bitField0_ = to_bitField0_;
        onBuilt();
        return result;
      }

      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex) {
          return mergeFrom((ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex)other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex other) {
        if (other == ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex.getDefaultInstance()) return this;
        if (other.hasFilename()) {
          bitField0_ |= 0x00000001;
          filename_ = other.filename_;
          onChanged();
        }
        if (stationsBuilder_ == null) {
          if (!other.stations_.isEmpty()) {
            if (stations_.isEmpty()) {
              stations_ = other.stations_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureStationsIsMutable();
              stations_.addAll(other.stations_);
            }
            onChanged();
          }
        } else {
          if (!other.stations_.isEmpty()) {
            if (stationsBuilder_.isEmpty()) {
              stationsBuilder_.dispose();
              stationsBuilder_ = null;
              stations_ = other.stations_;
              bitField0_ = (bitField0_ & ~0x00000002);
              stationsBuilder_ = 
                com.google.protobuf.GeneratedMessage.alwaysUseFieldBuilders ?
                   getStationsFieldBuilder() : null;
            } else {
              stationsBuilder_.addAllMessages(other.stations_);
            }
          }
        }
        if (other.hasRoot()) {
          mergeRoot(other.getRoot());
        }
        if (other.hasStart()) {
          setStart(other.getStart());
        }
        if (other.hasEnd()) {
          setEnd(other.getEnd());
        }
        if (other.hasNobs()) {
          setNobs(other.getNobs());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        return this;
      }

      public final boolean isInitialized() {
        if (!hasFilename()) {
          
          return false;
        }
        if (!hasRoot()) {
          
          return false;
        }
        if (!hasStart()) {
          
          return false;
        }
        if (!hasEnd()) {
          
          return false;
        }
        if (!hasNobs()) {
          
          return false;
        }
        for (int i = 0; i < getStationsCount(); i++) {
          if (!getStations(i).isInitialized()) {
            
            return false;
          }
        }
        if (!getRoot().isInitialized()) {
          
          return false;
        }
        return true;
      }

      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage = (ucar.nc2.ft.point.bufr.BufrCdmIndexProto.BufrIndex) e.getUnfinishedMessage();
          throw e;
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }
      private int bitField0_;

      // required string filename = 1;
      private java.lang.Object filename_ = "";
      /**
       * <code>required string filename = 1;</code>
       */
      public boolean hasFilename() {
        return ((bitField0_ & 0x00000001) == 0x00000001);
      }
      /**
       * <code>required string filename = 1;</code>
       */
      public java.lang.String getFilename() {
        java.lang.Object ref = filename_;
        if (!(ref instanceof java.lang.String)) {
          java.lang.String s = ((com.google.protobuf.ByteString) ref)
              .toStringUtf8();
          filename_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       * <code>required string filename = 1;</code>
       */
      public com.google.protobuf.ByteString
          getFilenameBytes() {
        java.lang.Object ref = filename_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b = 
              com.google.protobuf.ByteString.copyFromUtf8(
                  (java.lang.String) ref);
          filename_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       * <code>required string filename = 1;</code>
       */
      public Builder setFilename(
          java.lang.String value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        filename_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required string filename = 1;</code>
       */
      public Builder clearFilename() {
        bitField0_ = (bitField0_ & ~0x00000001);
        filename_ = getDefaultInstance().getFilename();
        onChanged();
        return this;
      }
      /**
       * <code>required string filename = 1;</code>
       */
      public Builder setFilenameBytes(
          com.google.protobuf.ByteString value) {
        if (value == null) {
    throw new NullPointerException();
  }
  bitField0_ |= 0x00000001;
        filename_ = value;
        onChanged();
        return this;
      }

      // repeated .bufrCdmIndex.Station stations = 2;
      private java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station> stations_ =
        java.util.Collections.emptyList();
      private void ensureStationsIsMutable() {
        if (!((bitField0_ & 0x00000002) == 0x00000002)) {
          stations_ = new java.util.ArrayList<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station>(stations_);
          bitField0_ |= 0x00000002;
         }
      }

      private com.google.protobuf.RepeatedFieldBuilder<
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder> stationsBuilder_;

      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station> getStationsList() {
        if (stationsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(stations_);
        } else {
          return stationsBuilder_.getMessageList();
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public int getStationsCount() {
        if (stationsBuilder_ == null) {
          return stations_.size();
        } else {
          return stationsBuilder_.getCount();
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station getStations(int index) {
        if (stationsBuilder_ == null) {
          return stations_.get(index);
        } else {
          return stationsBuilder_.getMessage(index);
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder setStations(
          int index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station value) {
        if (stationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStationsIsMutable();
          stations_.set(index, value);
          onChanged();
        } else {
          stationsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder setStations(
          int index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder builderForValue) {
        if (stationsBuilder_ == null) {
          ensureStationsIsMutable();
          stations_.set(index, builderForValue.build());
          onChanged();
        } else {
          stationsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder addStations(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station value) {
        if (stationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStationsIsMutable();
          stations_.add(value);
          onChanged();
        } else {
          stationsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder addStations(
          int index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station value) {
        if (stationsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureStationsIsMutable();
          stations_.add(index, value);
          onChanged();
        } else {
          stationsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder addStations(
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder builderForValue) {
        if (stationsBuilder_ == null) {
          ensureStationsIsMutable();
          stations_.add(builderForValue.build());
          onChanged();
        } else {
          stationsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder addStations(
          int index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder builderForValue) {
        if (stationsBuilder_ == null) {
          ensureStationsIsMutable();
          stations_.add(index, builderForValue.build());
          onChanged();
        } else {
          stationsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder addAllStations(
          java.lang.Iterable<? extends ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station> values) {
        if (stationsBuilder_ == null) {
          ensureStationsIsMutable();
          super.addAll(values, stations_);
          onChanged();
        } else {
          stationsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder clearStations() {
        if (stationsBuilder_ == null) {
          stations_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          stationsBuilder_.clear();
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public Builder removeStations(int index) {
        if (stationsBuilder_ == null) {
          ensureStationsIsMutable();
          stations_.remove(index);
          onChanged();
        } else {
          stationsBuilder_.remove(index);
        }
        return this;
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder getStationsBuilder(
          int index) {
        return getStationsFieldBuilder().getBuilder(index);
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder getStationsOrBuilder(
          int index) {
        if (stationsBuilder_ == null) {
          return stations_.get(index);  } else {
          return stationsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public java.util.List<? extends ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder> 
           getStationsOrBuilderList() {
        if (stationsBuilder_ != null) {
          return stationsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(stations_);
        }
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder addStationsBuilder() {
        return getStationsFieldBuilder().addBuilder(
            ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.getDefaultInstance());
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder addStationsBuilder(
          int index) {
        return getStationsFieldBuilder().addBuilder(
            index, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.getDefaultInstance());
      }
      /**
       * <code>repeated .bufrCdmIndex.Station stations = 2;</code>
       */
      public java.util.List<ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder> 
           getStationsBuilderList() {
        return getStationsFieldBuilder().getBuilderList();
      }
      private com.google.protobuf.RepeatedFieldBuilder<
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder> 
          getStationsFieldBuilder() {
        if (stationsBuilder_ == null) {
          stationsBuilder_ = new com.google.protobuf.RepeatedFieldBuilder<
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Station.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.StationOrBuilder>(
                  stations_,
                  ((bitField0_ & 0x00000002) == 0x00000002),
                  getParentForChildren(),
                  isClean());
          stations_ = null;
        }
        return stationsBuilder_;
      }

      // required .bufrCdmIndex.Field root = 3;
      private ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field root_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance();
      private com.google.protobuf.SingleFieldBuilder<
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder> rootBuilder_;
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      public boolean hasRoot() {
        return ((bitField0_ & 0x00000004) == 0x00000004);
      }
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field getRoot() {
        if (rootBuilder_ == null) {
          return root_;
        } else {
          return rootBuilder_.getMessage();
        }
      }
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      public Builder setRoot(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field value) {
        if (rootBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          root_ = value;
          onChanged();
        } else {
          rootBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      public Builder setRoot(
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder builderForValue) {
        if (rootBuilder_ == null) {
          root_ = builderForValue.build();
          onChanged();
        } else {
          rootBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      public Builder mergeRoot(ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field value) {
        if (rootBuilder_ == null) {
          if (((bitField0_ & 0x00000004) == 0x00000004) &&
              root_ != ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance()) {
            root_ =
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.newBuilder(root_).mergeFrom(value).buildPartial();
          } else {
            root_ = value;
          }
          onChanged();
        } else {
          rootBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        return this;
      }
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      public Builder clearRoot() {
        if (rootBuilder_ == null) {
          root_ = ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.getDefaultInstance();
          onChanged();
        } else {
          rootBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000004);
        return this;
      }
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder getRootBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getRootFieldBuilder().getBuilder();
      }
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      public ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder getRootOrBuilder() {
        if (rootBuilder_ != null) {
          return rootBuilder_.getMessageOrBuilder();
        } else {
          return root_;
        }
      }
      /**
       * <code>required .bufrCdmIndex.Field root = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilder<
          ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder> 
          getRootFieldBuilder() {
        if (rootBuilder_ == null) {
          rootBuilder_ = new com.google.protobuf.SingleFieldBuilder<
              ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.Field.Builder, ucar.nc2.ft.point.bufr.BufrCdmIndexProto.FieldOrBuilder>(
                  root_,
                  getParentForChildren(),
                  isClean());
          root_ = null;
        }
        return rootBuilder_;
      }

      // required uint64 start = 4;
      private long start_ ;
      /**
       * <code>required uint64 start = 4;</code>
       *
       * <pre>
       * msecs since epoch
       * </pre>
       */
      public boolean hasStart() {
        return ((bitField0_ & 0x00000008) == 0x00000008);
      }
      /**
       * <code>required uint64 start = 4;</code>
       *
       * <pre>
       * msecs since epoch
       * </pre>
       */
      public long getStart() {
        return start_;
      }
      /**
       * <code>required uint64 start = 4;</code>
       *
       * <pre>
       * msecs since epoch
       * </pre>
       */
      public Builder setStart(long value) {
        bitField0_ |= 0x00000008;
        start_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 start = 4;</code>
       *
       * <pre>
       * msecs since epoch
       * </pre>
       */
      public Builder clearStart() {
        bitField0_ = (bitField0_ & ~0x00000008);
        start_ = 0L;
        onChanged();
        return this;
      }

      // required uint64 end = 5;
      private long end_ ;
      /**
       * <code>required uint64 end = 5;</code>
       */
      public boolean hasEnd() {
        return ((bitField0_ & 0x00000010) == 0x00000010);
      }
      /**
       * <code>required uint64 end = 5;</code>
       */
      public long getEnd() {
        return end_;
      }
      /**
       * <code>required uint64 end = 5;</code>
       */
      public Builder setEnd(long value) {
        bitField0_ |= 0x00000010;
        end_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 end = 5;</code>
       */
      public Builder clearEnd() {
        bitField0_ = (bitField0_ & ~0x00000010);
        end_ = 0L;
        onChanged();
        return this;
      }

      // required uint64 nobs = 6;
      private long nobs_ ;
      /**
       * <code>required uint64 nobs = 6;</code>
       */
      public boolean hasNobs() {
        return ((bitField0_ & 0x00000020) == 0x00000020);
      }
      /**
       * <code>required uint64 nobs = 6;</code>
       */
      public long getNobs() {
        return nobs_;
      }
      /**
       * <code>required uint64 nobs = 6;</code>
       */
      public Builder setNobs(long value) {
        bitField0_ |= 0x00000020;
        nobs_ = value;
        onChanged();
        return this;
      }
      /**
       * <code>required uint64 nobs = 6;</code>
       */
      public Builder clearNobs() {
        bitField0_ = (bitField0_ & ~0x00000020);
        nobs_ = 0L;
        onChanged();
        return this;
      }

      // @@protoc_insertion_point(builder_scope:bufrCdmIndex.BufrIndex)
    }

    static {
      defaultInstance = new BufrIndex(true);
      defaultInstance.initFields();
    }

    // @@protoc_insertion_point(class_scope:bufrCdmIndex.BufrIndex)
  }

  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_bufrCdmIndex_Station_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_bufrCdmIndex_Station_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_bufrCdmIndex_Field_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_bufrCdmIndex_Field_fieldAccessorTable;
  private static com.google.protobuf.Descriptors.Descriptor
    internal_static_bufrCdmIndex_BufrIndex_descriptor;
  private static
    com.google.protobuf.GeneratedMessage.FieldAccessorTable
      internal_static_bufrCdmIndex_BufrIndex_fieldAccessorTable;

  public static com.google.protobuf.Descriptors.FileDescriptor
      getDescriptor() {
    return descriptor;
  }
  private static com.google.protobuf.Descriptors.FileDescriptor
      descriptor;
  static {
    java.lang.String[] descriptorData = {
      "\n)ucar/nc2/ft/point/bufr/bufrCdmIndex.pr" +
      "oto\022\014bufrCdmIndex\"h\n\007Station\022\n\n\002id\030\001 \002(\t" +
      "\022\013\n\003lat\030\002 \002(\001\022\013\n\003lon\030\003 \002(\001\022\013\n\003alt\030\004 \001(\001\022" +
      "\014\n\004desc\030\005 \001(\t\022\r\n\005wmoId\030\006 \001(\t\022\r\n\005count\030\007 " +
      "\002(\005\"\376\001\n\005Field\022\013\n\003fxy\030\001 \002(\r\022\014\n\004name\030\002 \001(\t" +
      "\022!\n\004flds\030\003 \003(\0132\023.bufrCdmIndex.Field\022\'\n\006a" +
      "ction\030\004 \001(\0162\027.bufrCdmIndex.FldAction\022#\n\004" +
      "type\030\005 \001(\0162\025.bufrCdmIndex.FldType\022\013\n\003min" +
      "\030\006 \001(\r\022\013\n\003max\030\007 \001(\r\022\014\n\004desc\030\010 \001(\t\022\r\n\005uni" +
      "ts\030\t \001(\t\022\r\n\005scale\030\n \002(\005\022\021\n\treference\030\013 \002",
      "(\005\022\020\n\010bitWidth\030\014 \002(\005\"\223\001\n\tBufrIndex\022\020\n\010fi" +
      "lename\030\001 \002(\t\022\'\n\010stations\030\002 \003(\0132\025.bufrCdm" +
      "Index.Station\022!\n\004root\030\003 \002(\0132\023.bufrCdmInd" +
      "ex.Field\022\r\n\005start\030\004 \002(\004\022\013\n\003end\030\005 \002(\004\022\014\n\004" +
      "nobs\030\006 \002(\004*I\n\tFldAction\022\010\n\004none\020\001\022\n\n\006rem" +
      "ove\020\002\022\r\n\tasMissing\020\003\022\013\n\007asArray\020\004\022\n\n\006con" +
      "cat\020\005*\354\001\n\007FldType\022\007\n\003lat\020\001\022\007\n\003lon\020\002\022\n\n\006h" +
      "eight\020\003\022\026\n\022heightAboveStation\020\004\022\023\n\017heigh" +
      "tOfStation\020\005\022\r\n\tstationId\020\n\022\017\n\013stationDe" +
      "sc\020\013\022\t\n\005wmoId\020\014\022\014\n\010wmoBlock\020\r\022\010\n\004year\020\017\022",
      "\t\n\005month\020\020\022\007\n\003day\020\021\022\010\n\004hour\020\022\022\n\n\006minute\020" +
      "\023\022\007\n\003sec\020\024\022\007\n\003doy\020\025\022\014\n\010timeIncr\020\026\022\t\n\005inc" +
      "rS\020\027B+\n\026ucar.nc2.ft.point.bufrB\021BufrCdmI" +
      "ndexProto"
    };
    com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner assigner =
      new com.google.protobuf.Descriptors.FileDescriptor.InternalDescriptorAssigner() {
        public com.google.protobuf.ExtensionRegistry assignDescriptors(
            com.google.protobuf.Descriptors.FileDescriptor root) {
          descriptor = root;
          internal_static_bufrCdmIndex_Station_descriptor =
            getDescriptor().getMessageTypes().get(0);
          internal_static_bufrCdmIndex_Station_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_bufrCdmIndex_Station_descriptor,
              new java.lang.String[] { "Id", "Lat", "Lon", "Alt", "Desc", "WmoId", "Count", });
          internal_static_bufrCdmIndex_Field_descriptor =
            getDescriptor().getMessageTypes().get(1);
          internal_static_bufrCdmIndex_Field_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_bufrCdmIndex_Field_descriptor,
              new java.lang.String[] { "Fxy", "Name", "Flds", "Action", "Type", "Min", "Max", "Desc", "Units", "Scale", "Reference", "BitWidth", });
          internal_static_bufrCdmIndex_BufrIndex_descriptor =
            getDescriptor().getMessageTypes().get(2);
          internal_static_bufrCdmIndex_BufrIndex_fieldAccessorTable = new
            com.google.protobuf.GeneratedMessage.FieldAccessorTable(
              internal_static_bufrCdmIndex_BufrIndex_descriptor,
              new java.lang.String[] { "Filename", "Stations", "Root", "Start", "End", "Nobs", });
          return null;
        }
      };
    com.google.protobuf.Descriptors.FileDescriptor
      .internalBuildGeneratedFileFrom(descriptorData,
        new com.google.protobuf.Descriptors.FileDescriptor[] {
        }, assigner);
  }

  // @@protoc_insertion_point(outer_class_scope)
}
