/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.Range;
import ucar.ma2.StructureMembers;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.iosp.BitReader;
import ucar.nc2.iosp.bufr.BitCounterUncompressed;
import ucar.nc2.iosp.bufr.BufrConfig;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.DebugOut;
import ucar.nc2.iosp.bufr.Message;
import ucar.unidata.io.RandomAccessFile;

public class MessageUncompressedDataReader {
    public ArrayStructure readEntireMessage(Structure s, Message proto, Message m, RandomAccessFile raf, Formatter f) throws IOException {
        DataDescriptor.transferInfo(proto.getRootDataDescriptor().getSubKeys(), m.getRootDataDescriptor().getSubKeys());
        StructureMembers members = s.makeStructureMembers();
        ArrayStructureBB.setOffsets((StructureMembers)members);
        int n = m.getNumberDatasets();
        ArrayStructureBB abb = new ArrayStructureBB(members, new int[]{n});
        ByteBuffer bb = abb.getByteBuffer();
        bb.order(ByteOrder.BIG_ENDIAN);
        boolean addTime = false;
        this.readData(abb, m, raf, null, addTime, f);
        return abb;
    }

    public int readData(ArrayStructureBB abb, Message m, RandomAccessFile raf, Range r, boolean addTime, Formatter f) throws IOException {
        BitReader reader = new BitReader(raf, m.dataSection.getDataPos() + 4L);
        DataDescriptor root = m.getRootDataDescriptor();
        if (root.isBad) {
            return 0;
        }
        Request req = new Request(abb, r);
        int n = m.getNumberDatasets();
        m.counterDatasets = new BitCounterUncompressed[n];
        m.msg_nbits = 0;
        int count = 0;
        for (int i = 0; i < n; ++i) {
            if (f != null) {
                f.format("Count bits in observation %d%n", i);
            }
            m.counterDatasets[i] = new BitCounterUncompressed(root, 1, 0);
            DebugOut out = f == null ? null : new DebugOut(f);
            req.setRow(i);
            int timePos = 0;
            if (req.wantRow() && addTime) {
                timePos = req.bb.position();
                req.bb.putInt(0);
                ++count;
            }
            this.readData(out, reader, m.counterDatasets[i], root.subKeys, 0, req);
            m.msg_nbits += m.counterDatasets[i].countBits(m.msg_nbits);
        }
        return count;
    }

    private void readData(DebugOut out, BitReader reader, BitCounterUncompressed table, List<DataDescriptor> dkeys, int nestedRow, Request req) throws IOException {
        for (DataDescriptor dkey : dkeys) {
            if (!dkey.isOkForVariable()) {
                if (out == null) continue;
                out.f.format("%s %d %s (%s) %n", out.indent(), out.fldno++, dkey.name, dkey.getFxyName());
                continue;
            }
            if (dkey.replication == 0) {
                int count = (int)reader.bits2UInt(dkey.replicationCountSize);
                if (out != null) {
                    out.f.format("%4d delayed replication count=%d %n", out.fldno++, count);
                }
                if (out != null && count > 0) {
                    out.f.format("%4d %s read sequence %s count= %d bitSize=%d start at=0x%x %n", out.fldno, out.indent(), dkey.getFxyName(), count, dkey.replicationCountSize, reader.getPos());
                }
                BitCounterUncompressed bitCounterNested = table.makeNested(dkey, count, nestedRow, dkey.replicationCountSize);
                ArraySequence seq = this.makeArraySequenceUncompressed(out, reader, bitCounterNested, dkey, req);
                if (!req.wantRow()) continue;
                int index = req.abb.addObjectToHeap((Object)seq);
                req.bb.putInt(index);
                continue;
            }
            if (dkey.type == 3) {
                BitCounterUncompressed nested = table.makeNested(dkey, dkey.replication, nestedRow, 0);
                if (out != null) {
                    out.f.format("%4d %s read structure %s count= %d%n", out.fldno, out.indent(), dkey.getFxyName(), dkey.replication);
                }
                for (int i = 0; i < dkey.replication; ++i) {
                    if (out != null) {
                        out.f.format("%s read row %d (struct %s) %n", out.indent(), i, dkey.getFxyName());
                        out.indent.incr();
                        this.readData(out, reader, nested, dkey.subKeys, i, req);
                        out.indent.decr();
                        continue;
                    }
                    this.readData(null, reader, nested, dkey.subKeys, i, req);
                }
                continue;
            }
            if (dkey.type == 1) {
                byte[] vals = this.readCharData(dkey, reader, req);
                if (out == null) continue;
                String s = new String(vals, CDM.utf8Charset);
                out.f.format("%4d %s read char %s (%s) width=%d end at= 0x%x val=<%s>%n", out.fldno++, out.indent(), dkey.getFxyName(), dkey.getName(), dkey.bitWidth, reader.getPos(), s);
                continue;
            }
            long val = this.readNumericData(dkey, reader, req);
            if (out == null) continue;
            out.f.format("%4d %s read %s (%s %s) bitWidth=%d end at= 0x%x raw=%d convert=%f%n", out.fldno++, out.indent(), dkey.getFxyName(), dkey.getName(), dkey.getUnits(), dkey.bitWidth, reader.getPos(), val, Float.valueOf(dkey.convert(val)));
        }
    }

    private byte[] readCharData(DataDescriptor dkey, BitReader reader, Request req) throws IOException {
        int i;
        int nchars = dkey.getByteWidthCDM();
        byte[] b = new byte[nchars];
        for (i = 0; i < nchars; ++i) {
            b[i] = (byte)reader.bits2UInt(8);
        }
        if (req.wantRow()) {
            for (i = 0; i < nchars; ++i) {
                req.bb.put(b[i]);
            }
        }
        return b;
    }

    private long readNumericData(DataDescriptor dkey, BitReader reader, Request req) throws IOException {
        long result = reader.bits2UInt(dkey.bitWidth);
        if (req.wantRow()) {
            if (dkey.getByteWidthCDM() == 1) {
                req.bb.put((byte)result);
            } else if (dkey.getByteWidthCDM() == 2) {
                byte b1 = (byte)(result & 0xFFL);
                byte b2 = (byte)((result & 0xFF00L) >> 8);
                req.bb.put(b2);
                req.bb.put(b1);
            } else if (dkey.getByteWidthCDM() == 4) {
                byte b1 = (byte)(result & 0xFFL);
                byte b2 = (byte)((result & 0xFF00L) >> 8);
                byte b3 = (byte)((result & 0xFF0000L) >> 16);
                byte b4 = (byte)((result & 0xFFFFFFFFFF000000L) >> 24);
                req.bb.put(b4);
                req.bb.put(b3);
                req.bb.put(b2);
                req.bb.put(b1);
            } else {
                byte b1 = (byte)(result & 0xFFL);
                byte b2 = (byte)((result & 0xFF00L) >> 8);
                byte b3 = (byte)((result & 0xFF0000L) >> 16);
                byte b4 = (byte)((result & 0xFFFFFFFFFF000000L) >> 24);
                byte b5 = (byte)((result & 0xFF00000000L) >> 32);
                byte b6 = (byte)((result & 0xFF0000000000L) >> 40);
                byte b7 = (byte)((result & 0xFF000000000000L) >> 48);
                byte b8 = (byte)((result & 0xFF00000000000000L) >> 56);
                req.bb.put(b8);
                req.bb.put(b7);
                req.bb.put(b6);
                req.bb.put(b5);
                req.bb.put(b4);
                req.bb.put(b3);
                req.bb.put(b2);
                req.bb.put(b1);
            }
        }
        return result;
    }

    private ArraySequence makeArraySequenceUncompressed(DebugOut out, BitReader reader, BitCounterUncompressed bitCounterNested, DataDescriptor seqdd, Request req) throws IOException {
        int count = bitCounterNested.getNumberRows();
        ArrayStructureBB abb = null;
        StructureMembers members = null;
        if (req.wantRow()) {
            Sequence seq = (Sequence)seqdd.refersTo;
            assert (seq != null);
            int[] shape = new int[]{count};
            int offset = 0;
            members = seq.makeStructureMembers();
            for (StructureMembers.Member m : members.getMembers()) {
                m.setDataParam(offset);
                Variable mv = seq.findVariable(m.getName());
                BufrConfig.FieldConverter fld = (BufrConfig.FieldConverter)mv.getSPobject();
                DataDescriptor dk = fld.dds;
                offset = dk.replication == 0 ? (offset += 4) : (offset += dk.getByteWidthCDM());
                if (m.getStructureMembers() == null) continue;
                ArrayStructureBB.setOffsets((StructureMembers)m.getStructureMembers());
            }
            abb = new ArrayStructureBB(members, shape);
            ByteBuffer bb = abb.getByteBuffer();
            bb.order(ByteOrder.BIG_ENDIAN);
        }
        Request nreq = new Request(abb, null);
        for (int i = 0; i < count; ++i) {
            if (out != null) {
                out.f.format("%s read row %d (seq %s) %n", out.indent(), i, seqdd.getFxyName());
                out.indent.incr();
                this.readData(out, reader, bitCounterNested, seqdd.getSubKeys(), i, nreq);
                out.indent.decr();
                continue;
            }
            this.readData(null, reader, bitCounterNested, seqdd.getSubKeys(), i, nreq);
        }
        return req.wantRow() ? new ArraySequence(members, abb.getStructureDataIterator(), count) : null;
    }

    private static class Request {
        ArrayStructureBB abb;
        ByteBuffer bb;
        Range r;
        int row;

        Request(ArrayStructureBB abb, Range r) {
            this.abb = abb;
            if (abb != null) {
                this.bb = abb.getByteBuffer();
            }
            this.r = r;
            this.row = 0;
        }

        Request setRow(int row) {
            this.row = row;
            return this;
        }

        boolean wantRow() {
            if (this.abb == null) {
                return false;
            }
            if (this.r == null) {
                return true;
            }
            return this.r.contains(this.row);
        }
    }
}

