/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.N3iosp;

public class WriteT42_ncRect {
    private static boolean debug = true;

    WriteT42_ncRect(NetcdfFile bufr, String fileOutName, boolean fill) throws IOException, InvalidRangeException {
        try (NetcdfFileWriter ncfile = NetcdfFileWriter.createNew((String)fileOutName, (boolean)fill);){
            if (debug) {
                System.out.println("FileWriter write " + bufr.getLocation() + " to " + fileOutName);
            }
            List glist = bufr.getGlobalAttributes();
            for (Object att : glist) {
                String useName = N3iosp.makeValidNetcdfObjectName((String)att.getShortName());
                Attribute useAtt = att.isArray() ? ncfile.addGlobalAttribute(new Attribute(useName, att.getValues())) : (att.isString() ? ncfile.addGlobalAttribute(useName, att.getStringValue()) : ncfile.addGlobalAttribute(useName, att.getNumericValue()));
                if (!debug) continue;
                System.out.println("add gatt= " + useAtt);
            }
            Dimension recordDim = null;
            for (Object oldD : bufr.getDimensions()) {
                String useName;
                boolean isRecord = (useName = N3iosp.makeValidNetcdfObjectName((String)oldD.getShortName())).equals("record");
                Dimension newD = ncfile.addDimension(useName, isRecord ? 0 : oldD.getLength(), isRecord, oldD.isVariableLength());
                if (isRecord) {
                    recordDim = newD;
                }
                if (!debug) continue;
                System.out.println("add dim= " + newD);
            }
            Structure recordStruct = (Structure)bufr.findVariable("obs");
            for (Variable oldVar : recordStruct.getVariables()) {
                if (oldVar.getDataType() == DataType.SEQUENCE) continue;
                String varName = N3iosp.makeValidNetcdfObjectName((String)oldVar.getShortName());
                DataType newType = oldVar.getDataType();
                ArrayList<Dimension> newDims = new ArrayList<Dimension>();
                newDims.add(recordDim);
                for (Dimension dim : oldVar.getDimensions()) {
                    newDims.add(ncfile.addDimension(oldVar.getShortName() + "_strlen", dim.getLength()));
                }
                Variable newVar = ncfile.addVariable(varName, newType, newDims);
                if (debug) {
                    System.out.println("add var= " + newVar);
                }
                List attList = oldVar.getAttributes();
                for (Attribute att : attList) {
                    String useName = N3iosp.makeValidNetcdfObjectName((String)att.getShortName());
                    if (att.isArray()) {
                        newVar.addAttribute(new Attribute(useName, att.getValues()));
                        continue;
                    }
                    if (att.isString()) {
                        ncfile.addVariableAttribute(varName, useName, att.getStringValue());
                        continue;
                    }
                    ncfile.addVariableAttribute(varName, useName, att.getNumericValue());
                }
            }
            int max_seq = 0;
            Dimension seqD = ncfile.addDimension("level", max_seq);
            for (Variable v : recordStruct.getVariables()) {
                if (v.getDataType() != DataType.SEQUENCE) continue;
                Structure seq = (Structure)v;
                for (Variable seqVar : seq.getVariables()) {
                    String varName = N3iosp.makeValidNetcdfObjectName((String)seqVar.getShortName());
                    DataType newType = seqVar.getDataType();
                    ArrayList<Dimension> newDims = new ArrayList<Dimension>();
                    newDims.add(recordDim);
                    newDims.add(seqD);
                    for (Dimension dim : seqVar.getDimensions()) {
                        newDims.add(ncfile.addDimension(seqVar.getShortName() + "_strlen", dim.getLength()));
                    }
                    Variable newVar = ncfile.addVariable(varName, newType, newDims);
                    if (debug) {
                        System.out.println("add var= " + newVar);
                    }
                    List attList = seqVar.getAttributes();
                    for (Attribute att : attList) {
                        String useName = N3iosp.makeValidNetcdfObjectName((String)att.getShortName());
                        if (att.isArray()) {
                            newVar.addAttribute(new Attribute(useName, att.getValues()));
                            continue;
                        }
                        if (att.isString()) {
                            ncfile.addVariableAttribute(varName, useName, att.getStringValue());
                            continue;
                        }
                        ncfile.addVariableAttribute(varName, useName, att.getNumericValue());
                    }
                }
            }
            ncfile.create();
            if (debug) {
                System.out.println("File Out= " + ncfile);
            }
            double total = this.copyVarData(bufr, ncfile, recordStruct);
            ncfile.flush();
            if (debug) {
                System.out.println("FileWriter done total bytes = " + total);
            }
        }
    }

    private double copyVarData(NetcdfFile bufr, NetcdfFileWriter ncfile, Structure recordStruct) throws IOException, InvalidRangeException {
        int nrecs = (int)recordStruct.getSize();
        int sdataSize = recordStruct.getElementSize();
        double total = 0.0;
        double totalRecordBytes = 0.0;
        for (int count = 0; count < nrecs; ++count) {
            StructureData recordData = recordStruct.readStructure(count);
            for (StructureMembers.Member m : recordData.getMembers()) {
                if (m.getDataType() == DataType.SEQUENCE) {
                    int countLevel = 0;
                    ArraySequence seq1 = recordData.getArraySequence(m);
                    StructureDataIterator iter = seq1.getStructureDataIterator();
                    Throwable throwable = null;
                    try {
                        while (iter.hasNext()) {
                            StructureData seqData = iter.next();
                            for (StructureMembers.Member seqm : seqData.getMembers()) {
                                Array data = seqData.getArray(seqm);
                                int[] shape = data.getShape();
                                int[] newShape = new int[data.getRank() + 2];
                                newShape[0] = 1;
                                newShape[1] = 1;
                                System.arraycopy(shape, 0, newShape, 1, data.getRank());
                                int[] origin = new int[data.getRank() + 2];
                                origin[0] = count;
                                origin[1] = countLevel;
                                if (debug && count == 0 && countLevel == 0) {
                                    System.out.println("write to = " + seqm.getName());
                                }
                                ncfile.write(seqm.getName(), origin, data.reshape(newShape));
                            }
                            ++countLevel;
                        }
                        continue;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iter == null) continue;
                        if (throwable != null) {
                            try {
                                iter.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iter.close();
                        continue;
                    }
                }
                Array data = recordData.getArray(m);
                int[] shape = data.getShape();
                int[] newShape = new int[data.getRank() + 1];
                newShape[0] = 1;
                System.arraycopy(shape, 0, newShape, 1, data.getRank());
                int[] origin = new int[data.getRank() + 1];
                origin[0] = count;
                if (debug && count == 0) {
                    System.out.println("write to = " + m.getName());
                }
                ncfile.write(m.getName(), origin, data.reshape(newShape));
            }
            totalRecordBytes += (double)sdataSize;
        }
        total += totalRecordBytes;
        totalRecordBytes /= 1000000.0;
        if (debug) {
            System.out.println("write record var; total = " + totalRecordBytes + " Mbytes # recs=" + nrecs);
        }
        return total;
    }
}

