/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;

@Immutable
public class Property {
    private final String name;
    private final String value;

    public Property(String name, String value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Property property = (Property)o;
        if (!this.name.equals(property.name)) {
            return false;
        }
        return Objects.equals(this.value, property.value);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public static List<Property> removeDups(List<Property> org) {
        ArrayList<Property> result = new ArrayList<Property>(org.size());
        for (Property p : org) {
            if (result.contains(p)) continue;
            result.add(p);
        }
        return result;
    }

    public static List<Property> convertToProperties(AttributeContainer from) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (Attribute p : from.getAttributes()) {
            result.add(new Property(p.getShortName(), p.getStringValue()));
        }
        return result;
    }

    public String toString() {
        return "Property{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
    }
}

