/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.DatasetUrl;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.fmrc.EnsCoord;
import ucar.nc2.ft.fmrc.TimeCoord;
import ucar.nc2.ft.fmrc.VertCoord;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.units.DateUnit;

public class GridDatasetInv {
    private static final Logger logger = LoggerFactory.getLogger(GridDatasetInv.class);
    private static final int REQ_VERSION = 2;
    private static final int CURR_VERSION = 2;
    private static Cache<String, GridDatasetInv> cache = CacheBuilder.newBuilder().maximumSize(100L).build();
    private String location;
    private int version;
    private final List<TimeCoord> times = new ArrayList<TimeCoord>();
    private final List<VertCoord> vaxes = new ArrayList<VertCoord>();
    private final List<EnsCoord> eaxes = new ArrayList<EnsCoord>();
    private CalendarDate runDate;
    private String runTimeString;
    private Date lastModified;

    public static GridDatasetInv open(MCollection cm, MFile mfile, Element ncml) throws IOException {
        try {
            return (GridDatasetInv)cache.get((Object)(mfile.getPath() + "#fmrInv.xml"), (Callable)new GenerateInv(cm, mfile, ncml));
        }
        catch (ExecutionException e) {
            throw new IOException("Cache failed", e);
        }
    }

    private GridDatasetInv() {
    }

    public GridDatasetInv(GridDataset gds, CalendarDate runDate) {
        this.location = gds.getLocation();
        this.runDate = runDate;
        NetcdfFile ncfile = gds.getNetcdfFile();
        if (ncfile != null && this.runDate == null) {
            this.runTimeString = ncfile.findAttValueIgnoreCase(null, "_CoordinateModelBaseDate", null);
            if (this.runTimeString == null) {
                this.runTimeString = ncfile.findAttValueIgnoreCase(null, "_CoordinateModelRunDate", null);
            }
            if (this.runTimeString != null) {
                this.runDate = DateUnit.parseCalendarDate(this.runTimeString);
            }
            if (this.runDate == null) {
                this.runDate = gds.getCalendarDateStart();
                logger.warn("GridDatasetInv using gds.getStartDate() for run date = {} in {}", (Object)this.runTimeString, (Object)this.location);
            }
        }
        if (this.runDate == null) {
            throw new IllegalStateException("No run date");
        }
        this.runTimeString = this.runDate.toString();
        for (GridDatatype gg : gds.getGrids()) {
            CoordinateAxis1D vaxis;
            GridCoordSystem gcs = gg.getCoordinateSystem();
            Grid grid = new Grid(gg.getFullName());
            CoordinateAxis1DTime axis = gcs.getTimeAxis1D();
            if (axis != null) {
                TimeCoord tc = this.getTimeCoordinate(axis);
                tc.addGridInventory(grid);
                grid.tc = tc;
            }
            if ((vaxis = gcs.getVerticalAxis()) == null) continue;
            grid.vc = this.getVertCoordinate(vaxis);
        }
        int seqno = 0;
        for (TimeCoord tc : this.times) {
            tc.setId(seqno++);
        }
    }

    public String toString() {
        return this.location;
    }

    public String getLocation() {
        return this.location;
    }

    public long getLastModified() {
        return this.lastModified.getTime();
    }

    public CalendarDate getRunDate() {
        return this.runDate;
    }

    public String getRunDateString() {
        return this.runTimeString;
    }

    public List<TimeCoord> getTimeCoords() {
        return this.times;
    }

    public List<VertCoord> getVertCoords() {
        return this.vaxes;
    }

    public Grid findGrid(String name) {
        for (TimeCoord tc : this.times) {
            List<Grid> grids = tc.getGridInventory();
            for (Grid g : grids) {
                if (!g.name.equals(name)) continue;
                return g;
            }
        }
        return null;
    }

    private TimeCoord getTimeCoordinate(CoordinateAxis1DTime axis) {
        for (TimeCoord tc : this.times) {
            if (!tc.getAxisName().equals(axis.getFullName())) continue;
            return tc;
        }
        TimeCoord want = new TimeCoord(this.runDate, axis);
        for (TimeCoord tc : this.times) {
            if (!tc.equalsData(want)) continue;
            return tc;
        }
        this.times.add(want);
        return want;
    }

    private Grid makeGrid(String gridName) {
        return new Grid(gridName);
    }

    private VertCoord getVertCoordinate(int wantId) {
        if (wantId < 0) {
            return null;
        }
        for (VertCoord vc : this.vaxes) {
            if (vc.getId() != wantId) continue;
            return vc;
        }
        return null;
    }

    private VertCoord getVertCoordinate(CoordinateAxis1D axis) {
        for (VertCoord vc : this.vaxes) {
            if (!vc.getName().equals(axis.getFullName())) continue;
            return vc;
        }
        VertCoord want = new VertCoord(axis);
        for (VertCoord vc : this.vaxes) {
            if (!vc.equalsData(want)) continue;
            return vc;
        }
        this.vaxes.add(want);
        return want;
    }

    private EnsCoord getEnsCoordinate(int ens_id) {
        if (ens_id < 0) {
            return null;
        }
        for (EnsCoord ec : this.eaxes) {
            if (ec.getId() != ens_id) continue;
            return ec;
        }
        return null;
    }

    public String writeXML(Date lastModified) {
        XMLOutputter fmt = new XMLOutputter(Format.getPrettyFormat());
        return fmt.outputString(this.writeDocument(lastModified));
    }

    Document writeDocument(Date lastModified) {
        Object sbuff;
        Element rootElem = new Element("gridInventory");
        Document doc = new Document(rootElem);
        rootElem.setAttribute("location", this.location);
        rootElem.setAttribute("runTime", this.runTimeString);
        if (lastModified != null) {
            rootElem.setAttribute("lastModified", CalendarDateFormatter.toDateTimeString(lastModified));
        }
        rootElem.setAttribute("version", Integer.toString(2));
        Collections.sort(this.vaxes);
        int count = 0;
        for (VertCoord vc : this.vaxes) {
            vc.setId(count++);
            Element vcElem = new Element("vertCoord");
            rootElem.addContent((Content)vcElem);
            vcElem.setAttribute("id", Integer.toString(vc.getId()));
            vcElem.setAttribute("name", vc.getName());
            if (vc.getUnits() != null) {
                vcElem.setAttribute("units", vc.getUnits());
            }
            sbuff = new StringBuilder();
            double[] values1 = vc.getValues1();
            double[] values2 = vc.getValues2();
            for (int j = 0; j < values1.length; ++j) {
                if (j > 0) {
                    ((StringBuilder)sbuff).append(" ");
                }
                ((StringBuilder)sbuff).append(values1[j]);
                if (values2 == null) continue;
                ((StringBuilder)sbuff).append(",");
                ((StringBuilder)sbuff).append(values2[j]);
            }
            vcElem.addContent(((StringBuilder)sbuff).toString());
        }
        count = 0;
        for (TimeCoord tc : this.times) {
            tc.setId(count++);
            Element timeElement = new Element("timeCoord");
            rootElem.addContent((Content)timeElement);
            timeElement.setAttribute("id", Integer.toString(tc.getId()));
            timeElement.setAttribute("name", tc.getName());
            timeElement.setAttribute("isInterval", tc.isInterval() ? "true" : "false");
            sbuff = new Formatter();
            if (tc.isInterval()) {
                double[] bound1 = tc.getBound1();
                double[] bound2 = tc.getBound2();
                for (int j = 0; j < bound1.length; ++j) {
                    ((Formatter)sbuff).format((Locale)null, "%f %f,", bound1[j], bound2[j]);
                }
            } else {
                for (double offset : tc.getOffsetTimes()) {
                    ((Formatter)sbuff).format((Locale)null, "%f,", offset);
                }
            }
            timeElement.addContent(((Formatter)sbuff).toString());
            List<Grid> vars = tc.getGridInventory();
            Collections.sort(vars);
            for (Grid grid : vars) {
                Element varElem = new Element("grid");
                timeElement.addContent((Content)varElem);
                varElem.setAttribute("name", grid.name);
                if (grid.ec != null) {
                    varElem.setAttribute("ens_id", Integer.toString(grid.ec.getId()));
                }
                if (grid.vc == null) continue;
                varElem.setAttribute("vert_id", Integer.toString(grid.vc.getId()));
            }
        }
        return doc;
    }

    private static GridDatasetInv readXML(byte[] xmlString) throws IOException {
        String version;
        String lastModifiedS;
        Document doc;
        BufferedInputStream is = new BufferedInputStream(new ByteArrayInputStream(xmlString));
        try {
            SAXBuilder builder = new SAXBuilder();
            doc = builder.build((InputStream)is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage() + " reading from XML ");
        }
        Element rootElem = doc.getRootElement();
        GridDatasetInv fmr = new GridDatasetInv();
        fmr.runTimeString = rootElem.getAttributeValue("runTime");
        fmr.location = rootElem.getAttributeValue("location");
        if (fmr.location == null) {
            fmr.location = rootElem.getAttributeValue("name");
        }
        if ((lastModifiedS = rootElem.getAttributeValue("lastModified")) != null) {
            fmr.lastModified = CalendarDateFormatter.isoStringToDate(lastModifiedS);
        }
        int n = fmr.version = (version = rootElem.getAttributeValue("version")) == null ? 0 : Integer.parseInt(version);
        if (fmr.version < 2) {
            return fmr;
        }
        fmr.runDate = DateUnit.parseCalendarDate(fmr.runTimeString);
        List vList = rootElem.getChildren("vertCoord");
        for (Element vertElem : vList) {
            VertCoord vc = new VertCoord();
            fmr.vaxes.add(vc);
            vc.setId(Integer.parseInt(vertElem.getAttributeValue("id")));
            vc.setName(vertElem.getAttributeValue("name"));
            vc.setUnits(vertElem.getAttributeValue("units"));
            String values = vertElem.getTextNormalize();
            StringTokenizer stoke = new StringTokenizer(values);
            int n2 = stoke.countTokens();
            double[] values1 = new double[n2];
            double[] values2 = null;
            int count = 0;
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                int pos = toke.indexOf(44);
                if (pos < 0) {
                    values1[count] = Double.parseDouble(toke);
                } else {
                    if (values2 == null) {
                        values2 = new double[n2];
                    }
                    String val1 = toke.substring(0, pos);
                    String val2 = toke.substring(pos + 1);
                    values1[count] = Double.parseDouble(val1);
                    values2[count] = Double.parseDouble(val2);
                }
                ++count;
            }
            vc.setValues1(values1);
            vc.setValues2(values2);
        }
        List tList = rootElem.getChildren("timeCoord");
        for (Element timeElem : tList) {
            int n3;
            TimeCoord tc = new TimeCoord(fmr.runDate);
            fmr.times.add(tc);
            tc.setId(Integer.parseInt(timeElem.getAttributeValue("id")));
            String s = timeElem.getAttributeValue("isInterval");
            boolean isInterval = "true".equals(s);
            if (isInterval) {
                String boundsAll = timeElem.getTextNormalize();
                String[] bounds = boundsAll.split(",");
                n3 = bounds.length;
                double[] bound1 = new double[n3];
                double[] bound2 = new double[n3];
                int count = 0;
                String[] stringArray = bounds;
                int n4 = stringArray.length;
                for (int i = 0; i < n4; ++i) {
                    String b = stringArray[i];
                    String[] value = b.split(" ");
                    bound1[count] = Double.parseDouble(value[0]);
                    bound2[count] = Double.parseDouble(value[1]);
                    ++count;
                }
                tc.setBounds(bound1, bound2);
            } else {
                String values = timeElem.getTextNormalize();
                String[] value = values.split(",");
                n3 = value.length;
                double[] offsets = new double[n3];
                int count = 0;
                for (String v : value) {
                    offsets[count++] = Double.parseDouble(v);
                }
                tc.setOffsetTimes(offsets);
            }
            List varList = timeElem.getChildren("grid");
            for (Element vElem : varList) {
                Grid grid = fmr.makeGrid(vElem.getAttributeValue("name"));
                if (vElem.getAttributeValue("ens_id") != null) {
                    grid.ec = fmr.getEnsCoordinate(Integer.parseInt(vElem.getAttributeValue("ens_id")));
                }
                if (vElem.getAttributeValue("vert_id") != null) {
                    grid.vc = fmr.getVertCoordinate(Integer.parseInt(vElem.getAttributeValue("vert_id")));
                }
                tc.addGridInventory(grid);
                grid.tc = tc;
            }
        }
        return fmr;
    }

    public class Grid
    implements Comparable<Grid> {
        final String name;
        TimeCoord tc;
        EnsCoord ec;
        VertCoord vc;

        private Grid(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getLocation() {
            return GridDatasetInv.this.location;
        }

        public String getTimeCoordName() {
            return this.tc == null ? "" : this.tc.getName();
        }

        public String getVertCoordName() {
            return this.vc == null ? "" : this.vc.getName();
        }

        @Override
        public int compareTo(Grid o) {
            return this.name.compareTo(o.name);
        }

        public int countTotal() {
            int ntimes = this.tc.getNCoords();
            return ntimes * this.getVertCoordLength();
        }

        public String toString() {
            return this.name;
        }

        public int getVertCoordLength() {
            return this.vc == null ? 1 : this.vc.getValues1().length;
        }

        public TimeCoord getTimeCoord() {
            return this.tc;
        }

        public GridDatasetInv getFile() {
            return GridDatasetInv.this;
        }
    }

    private static class GenerateInv
    implements Callable<GridDatasetInv> {
        private final MCollection cm;
        private final MFile mfile;
        private final Element ncml;

        GenerateInv(MCollection cm, MFile mfile, Element ncml) {
            this.cm = cm;
            this.mfile = mfile;
            this.ncml = ncml;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public GridDatasetInv call() throws Exception {
            try (GridDataset gds = null;){
                if (this.ncml == null) {
                    gds = GridDataset.open(this.mfile.getPath());
                } else {
                    NetcdfFile nc = NetcdfDataset.acquireFile(new DatasetUrl(null, this.mfile.getPath()), null);
                    NetcdfDataset ncd = NcMLReader.mergeNcML(nc, this.ncml);
                    ncd.enhance();
                    gds = new GridDataset(ncd);
                }
                GridDatasetInv gridDatasetInv = new GridDatasetInv(gds, this.cm.extractDate(this.mfile));
                return gridDatasetInv;
            }
        }
    }
}

