/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.AttributeContainerHelper;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.CoordAxisReader;
import ucar.nc2.ft2.coverage.CoordSysContainer;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.TimeHelper;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.Indent;
import ucar.nc2.util.Optional;

public abstract class CoverageCoordAxis
implements Comparable<CoverageCoordAxis> {
    private static final Logger logger = LoggerFactory.getLogger(CoverageCoordAxis.class);
    protected final String name;
    protected final String description;
    protected final DataType dataType;
    protected final AxisType axisType;
    protected final AttributeContainer attributes;
    protected final DependenceType dependenceType;
    protected final List<String> dependsOn;
    protected final int ncoords;
    protected final Spacing spacing;
    protected final double startValue;
    protected final double endValue;
    protected final double resolution;
    protected final CoordAxisReader reader;
    protected final boolean isSubset;
    protected final TimeHelper timeHelper;
    protected final String units;
    protected double[] values;
    private boolean valuesLoaded;

    protected CoverageCoordAxis(CoverageCoordAxisBuilder builder) {
        this.name = builder.name;
        this.units = builder.units;
        this.description = builder.description;
        this.dataType = builder.dataType;
        this.axisType = builder.axisType;
        this.attributes = builder.attributes;
        this.dependenceType = builder.dependenceType;
        this.spacing = builder.spacing;
        this.values = builder.values;
        this.reader = builder.reader;
        this.dependsOn = builder.dependsOn == null ? Collections.emptyList() : builder.dependsOn;
        this.startValue = builder.startValue;
        this.endValue = builder.endValue;
        this.resolution = builder.resolution;
        this.ncoords = builder.ncoords;
        this.isSubset = builder.isSubset;
        this.timeHelper = builder.timeHelper != null ? builder.timeHelper : (this.axisType == AxisType.Time || this.axisType == AxisType.RunTime ? TimeHelper.factory(this.units, this.attributes) : (this.axisType == AxisType.TimeOffset ? TimeHelper.factory(null, this.attributes) : null));
    }

    protected void setDataset(CoordSysContainer dataset) {
    }

    @Override
    public int compareTo(CoverageCoordAxis o) {
        return this.axisType.axisOrder() - o.axisType.axisOrder();
    }

    public abstract CoverageCoordAxis copy();

    public abstract Optional<CoverageCoordAxis> subset(SubsetParams var1);

    public abstract Optional<CoverageCoordAxis> subset(double var1, double var3, int var5);

    public abstract Optional<CoverageCoordAxis> subsetDependent(CoverageCoordAxis1D var1);

    public abstract Array getCoordsAsArray();

    public abstract Array getCoordBoundsAsArray();

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public AxisType getAxisType() {
        return this.axisType;
    }

    public List<Attribute> getAttributes() {
        return this.attributes.getAttributes();
    }

    public Attribute findAttribute(String attName) {
        return this.attributes.findAttribute(attName);
    }

    public AttributeContainer getAttributeContainer() {
        return new AttributeContainerHelper(this.name, this.attributes.getAttributes());
    }

    public int getNcoords() {
        return this.ncoords;
    }

    public Spacing getSpacing() {
        return this.spacing;
    }

    public boolean isRegular() {
        return this.spacing == Spacing.regularPoint || this.spacing == Spacing.regularInterval;
    }

    public double getResolution() {
        return this.resolution;
    }

    public double getStartValue() {
        return this.startValue;
    }

    public double getEndValue() {
        return this.endValue;
    }

    public String getUnits() {
        return this.units;
    }

    public String getDescription() {
        return this.description;
    }

    public DependenceType getDependenceType() {
        return this.dependenceType;
    }

    public boolean isScalar() {
        return this.dependenceType == DependenceType.scalar;
    }

    public String getDependsOn() {
        Formatter result = new Formatter();
        for (String name : this.dependsOn) {
            result.format("%s ", name);
        }
        return result.toString().trim();
    }

    public List<String> getDependsOnList() {
        return this.dependsOn;
    }

    public boolean getHasData() {
        return this.values != null;
    }

    public boolean isSubset() {
        return this.isSubset;
    }

    public boolean isInterval() {
        return this.spacing == Spacing.regularInterval || this.spacing == Spacing.contiguousInterval || this.spacing == Spacing.discontiguousInterval;
    }

    public String toString() {
        Formatter f = new Formatter();
        Indent indent = new Indent(2);
        this.toString(f, indent);
        return f.toString();
    }

    public int[] getShape() {
        if (this.getDependenceType() == DependenceType.scalar) {
            return new int[0];
        }
        return new int[]{this.ncoords};
    }

    public Range getRange() {
        if (this.getDependenceType() == DependenceType.scalar) {
            return Range.EMPTY;
        }
        try {
            return new Range(this.axisType.toString(), 0, this.ncoords - 1);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    public RangeIterator getRangeIterator() {
        if (this.getDependenceType() == DependenceType.scalar) {
            return Range.EMPTY;
        }
        try {
            return new Range(this.axisType.toString(), 0, this.ncoords - 1);
        }
        catch (InvalidRangeException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public void toString(Formatter f, Indent indent) {
        f.format("%sCoordAxis '%s' (%s) ", indent, this.name, this.getClass().getName());
        indent.incr();
        f.format("%s", new Object[]{this.getDependenceType()});
        if (!this.dependsOn.isEmpty()) {
            f.format(" :", new Object[0]);
            for (String string : this.dependsOn) {
                f.format(" %s", string);
            }
        }
        f.format("%n", new Object[0]);
        f.format("%saxisType=%s dataType=%s units='%s' desc='%s'", new Object[]{indent, this.axisType, this.dataType, this.units, this.description});
        if (this.timeHelper != null) {
            f.format(" refDate=%s", this.timeHelper.getRefDate());
        }
        f.format("%n", new Object[0]);
        AttributeContainerHelper.show(this.attributes, indent, f);
        f.format("%snpts: %d [%f,%f] spacing=%s", new Object[]{indent, this.ncoords, this.startValue, this.endValue, this.spacing});
        if (this.getResolution() != 0.0) {
            f.format(" resolution=%f", this.resolution);
        }
        f.format("%n", new Object[0]);
        if (this.values != null) {
            int n = this.values.length;
            switch (this.spacing) {
                case irregularPoint: 
                case contiguousInterval: {
                    f.format("%scontiguous values (%d)=", indent, n);
                    for (double v : this.values) {
                        f.format("%f,", v);
                    }
                    f.format("%n", new Object[0]);
                    break;
                }
                case discontiguousInterval: {
                    void var4_8;
                    f.format("%sdiscontiguous values (%d)=", indent, n);
                    boolean bl = false;
                    while (var4_8 < n) {
                        f.format("(%f,%f) ", this.values[var4_8], this.values[var4_8 + true]);
                        var4_8 += 2;
                    }
                    f.format("%n", new Object[0]);
                }
            }
        }
        indent.decr();
    }

    public String getSummary() {
        Formatter f = new Formatter();
        f.format("start=%f end=%f %s %s resolution=%f", new Object[]{this.startValue, this.endValue, this.units, this.spacing, this.resolution});
        f.format(" (npts=%d)", this.ncoords);
        return f.toString();
    }

    public double convert(CalendarDate date) {
        return this.timeHelper.offsetFromRefDate(date);
    }

    public CalendarDate makeDate(double value) {
        return this.timeHelper.makeDate(value);
    }

    public CalendarDateRange getDateRange() {
        return this.timeHelper.getDateRange(this.startValue, this.endValue);
    }

    public double getOffsetInTimeUnits(CalendarDate start, CalendarDate end) {
        return this.timeHelper.getOffsetInTimeUnits(start, end);
    }

    public CalendarDate makeDateInTimeUnits(CalendarDate start, double addTo) {
        return this.timeHelper.makeDateInTimeUnits(start, addTo);
    }

    public CalendarDate getRefDate() {
        return this.timeHelper.getRefDate();
    }

    public Calendar getCalendar() {
        return this.timeHelper.getCalendar();
    }

    public CalendarDateUnit getCalendarDateUnit() {
        return this.timeHelper.getCalendarDateUnit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadValuesIfNeeded() {
        CoverageCoordAxis coverageCoordAxis = this;
        synchronized (coverageCoordAxis) {
            if (this.isRegular() || this.valuesLoaded) {
                return;
            }
            if (this.values == null && this.reader != null) {
                try {
                    this.values = this.reader.readCoordValues(this);
                }
                catch (IOException e) {
                    logger.error("Failed to read " + this.name, (Throwable)e);
                }
            }
            this.valuesLoaded = true;
        }
    }

    public double[] getValues() {
        this.loadValuesIfNeeded();
        return this.values == null ? null : Arrays.copyOf(this.values, this.values.length);
    }

    public static enum DependenceType {
        independent,
        dependent,
        scalar,
        twoD,
        fmrcReg,
        dimension;

    }

    public static enum Spacing {
        regularPoint,
        irregularPoint,
        regularInterval,
        contiguousInterval,
        discontiguousInterval;

    }
}

