/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc.ogc;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.util.Parameter;

public class EPSG_OGC_CF_Helper {
    private static Logger log = LoggerFactory.getLogger(EPSG_OGC_CF_Helper.class);

    public static String getWcs1_0CrsId(Projection proj) {
        String paramName = null;
        if (proj == null) {
            paramName = "LatLon";
        } else {
            for (Parameter curParam : proj.getProjectionParameters()) {
                if (!curParam.getName().equalsIgnoreCase("grid_mapping_name") || !curParam.isString()) continue;
                paramName = curParam.getStringValue();
            }
        }
        if (paramName == null) {
            log.warn("getWcs1_0CrsId(): Unknown projection - " + EPSG_OGC_CF_Helper.projToString(proj));
            return ProjectionStandardsInfo.Unknown.getOgcName();
        }
        if (paramName.equalsIgnoreCase("LatLon")) {
            return "OGC:CRS84";
        }
        ProjectionStandardsInfo psi = ProjectionStandardsInfo.getProjectionByCfName(paramName);
        String crsId = "EPSG:" + psi.getEpsgCode() + " [" + psi.name();
        if (psi == ProjectionStandardsInfo.Unknown) {
            log.warn("getWcs1_0CrsId(): Unknown projection - " + EPSG_OGC_CF_Helper.projToString(proj));
            crsId = crsId + " - " + paramName;
        }
        return crsId + "]";
    }

    private static String projToString(Projection proj) {
        if (proj == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(proj.getName()).append(" [").append(proj.getClassName()).append("] - parameters=[");
        for (Parameter curProjParam : proj.getProjectionParameters()) {
            sb.append("(").append(curProjParam).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    public String getWcs1_0CrsId(GridDatatype gridDatatype, GridDataset gridDataset) throws IllegalArgumentException {
        gridDataset.getTitle();
        gridDatatype.getFullName();
        StringBuilder buf = new StringBuilder();
        Attribute gridMappingAtt = gridDatatype.findAttributeIgnoreCase("grid_mapping");
        if (gridMappingAtt != null) {
            Attribute gridMappingNameAtt;
            String gridMapping = gridMappingAtt.getStringValue();
            Variable gridMapVar = gridDataset.getNetcdfFile().getRootGroup().findVariable(gridMapping);
            if (gridMapVar != null && (gridMappingNameAtt = gridMapVar.findAttributeIgnoreCase("grid_mapping_name")) != null) {
                buf.append("EPSG:").append((Object)ProjectionStandardsInfo.getProjectionByCfName(gridMappingNameAtt.getStringValue()));
            }
        }
        return buf.toString();
    }

    public static enum ProjectionStandardsInfo {
        Unknown(0, "Unknown", "unknown"),
        Albers_Conic_Equal_Area(9822, "Albers Equal Area", "albers_conical_equal_area"),
        Azimuthal_Equidistant(-1, "", "azimuthal_equidistant"),
        Lambert_Azimuthal_Equal_Area(9820, "Lambert Azimuthal Equal Area", "lambert_azimuthal_equal_area"),
        Lambert_Conformal_Conic_2SP(9802, "Lambert Conic Conformal (2SP)", "lambert_conformal_conic"),
        Polar_Stereographic(9810, "Polar Stereographic (Variant A)", "polar_stereographic"),
        Rotated_Pole(-2, "", "rotated_latitude_longitude"),
        Stereographic(-3, "", "stereographic"),
        Transverse_Mercator(9807, "Transverse Mercator", "transverse_mercator"),
        Latitude_Longitude(0, "", "latitude_longitude"),
        Vertical_Perspective(9838, "Vertical Perspective", "vertical_perspective"),
        Lambert_Cylindrical_Equal_Area(9835, "Lambert Cylindrical Equal Area", "lambert_cylindrical_equal_area"),
        Mercator(9805, "Mercator (2SP)", "mercator"),
        Orthographic(9840, "Orthographic", "orthographic");

        private final int epsgCode;
        private final String epsgName;
        private final String cfName;

        public String getOgcName() {
            return this.name();
        }

        public int getEpsgCode() {
            return this.epsgCode;
        }

        public String getEpsgName() {
            return this.epsgName;
        }

        public String getCfName() {
            return this.cfName;
        }

        private ProjectionStandardsInfo(int epsgCode, String epsgName, String cfName) {
            this.epsgCode = epsgCode;
            this.epsgName = epsgName;
            this.cfName = cfName;
        }

        public String toString() {
            String buf = "[[OGC: " + this.name() + "] [EPSG " + this.getEpsgCode() + ": " + this.getEpsgName() + "] [CF: " + this.getCfName() + "]]";
            return buf;
        }

        public static ProjectionStandardsInfo getProjectionByOgcName(String ogcName) {
            for (ProjectionStandardsInfo curProjStdInfo : ProjectionStandardsInfo.values()) {
                if (!curProjStdInfo.name().equals(ogcName)) continue;
                return curProjStdInfo;
            }
            return Unknown;
        }

        public static ProjectionStandardsInfo getProjectionByEpsgCode(int epsgCode) {
            for (ProjectionStandardsInfo curProjStdInfo : ProjectionStandardsInfo.values()) {
                if (curProjStdInfo.getEpsgCode() != epsgCode) continue;
                return curProjStdInfo;
            }
            return Unknown;
        }

        public static ProjectionStandardsInfo getProjectionByEpsgName(String epsgName) {
            for (ProjectionStandardsInfo curProjStdInfo : ProjectionStandardsInfo.values()) {
                if (!curProjStdInfo.getEpsgName().equals(epsgName)) continue;
                return curProjStdInfo;
            }
            return Unknown;
        }

        public static ProjectionStandardsInfo getProjectionByCfName(String cfName) {
            for (ProjectionStandardsInfo curProjStdInfo : ProjectionStandardsInfo.values()) {
                if (!curProjStdInfo.getCfName().equals(cfName)) continue;
                return curProjStdInfo;
            }
            return Unknown;
        }
    }
}

