/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.nio.ByteBuffer;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.Index;
import ucar.nc2.CDMNode;
import ucar.nc2.EnumTypedef;
import ucar.nc2.NetcdfFiles;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public class Attribute
extends CDMNode {
    private static final String SPECIALPREFIX = "_";
    @Deprecated
    static final String[] SPECIALS = new String[]{"_NCProperties", "_IsNetcdf4", "_SuperblockVersion", "_DAP4_Little_Endian", "_edu.ucar"};
    private static char[] org = new char[]{'\b', '\f', '\n', '\r', '\t', '\\', '\'', '\"'};
    private static String[] replace = new String[]{"\\b", "\\f", "\\n", "\\r", "\\t", "\\\\", "\\'", "\\\""};
    private String svalue;
    private DataType dataType;
    private EnumTypedef enumtype;
    private int nelems;
    private Array values;

    @Deprecated
    public static Map<String, Attribute> makeMap(List<Attribute> atts) {
        int size = atts == null ? 1 : atts.size();
        HashMap<String, Attribute> result = new HashMap<String, Attribute>(size);
        if (atts == null) {
            return result;
        }
        for (Attribute att : atts) {
            result.put(att.getShortName(), att);
        }
        return result;
    }

    @Deprecated
    public static boolean isspecial(Attribute a) {
        String nm = a.getShortName();
        if (nm.startsWith(SPECIALPREFIX)) {
            for (String s : SPECIALS) {
                if (!nm.startsWith(s)) continue;
                return true;
            }
        }
        return false;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    @Deprecated
    public void setDataType(DataType dt) {
        this.dataType = dt;
    }

    @Nullable
    public EnumTypedef getEnumType() {
        return this.enumtype;
    }

    @Deprecated
    public void setEnumType(EnumTypedef en) {
        this.enumtype = en;
    }

    public boolean isArray() {
        return this.getLength() > 1;
    }

    public int getLength() {
        return this.nelems;
    }

    @Nullable
    public Array getValues() {
        if (this.values == null && this.svalue != null) {
            this.values = Array.factory(DataType.STRING, new int[]{1});
            this.values.setObject(this.values.getIndex(), (Object)this.svalue);
            return this.values;
        }
        return this.values == null ? null : this.values.copy();
    }

    @Nullable
    public Object getValue(int index) {
        if (this.isString()) {
            return this.getStringValue(index);
        }
        return this.getNumericValue(index);
    }

    public boolean isString() {
        return this.dataType == DataType.STRING && null != this.getStringValue();
    }

    @Nullable
    public String getStringValue() {
        if (this.dataType != DataType.STRING) {
            return null;
        }
        return this.svalue != null ? this.svalue : this._getStringValue(0);
    }

    @Nullable
    public String getStringValue(int index) {
        if (this.dataType != DataType.STRING) {
            return null;
        }
        if (this.svalue != null && index == 0) {
            return this.svalue;
        }
        return this._getStringValue(index);
    }

    private String _getStringValue(int index) {
        if (index < 0 || index >= this.nelems) {
            return null;
        }
        return (String)this.values.getObject(index);
    }

    @Nullable
    public Number getNumericValue() {
        return this.getNumericValue(0);
    }

    @Nullable
    public Number getNumericValue(int index) {
        if (index < 0 || index >= this.nelems) {
            return null;
        }
        switch (this.dataType) {
            case STRING: {
                try {
                    return new Double(this.getStringValue(index));
                }
                catch (NumberFormatException e) {
                    return null;
                }
            }
            case BYTE: 
            case UBYTE: {
                return this.values.getByte(index);
            }
            case SHORT: 
            case USHORT: {
                return this.values.getShort(index);
            }
            case INT: 
            case UINT: {
                return this.values.getInt(index);
            }
            case FLOAT: {
                return Float.valueOf(this.values.getFloat(index));
            }
            case DOUBLE: {
                return this.values.getDouble(index);
            }
            case LONG: 
            case ULONG: {
                return this.values.getLong(index);
            }
        }
        return null;
    }

    public String toString() {
        return this.toString(false);
    }

    @Deprecated
    public String toString(boolean strict) {
        Formatter f = new Formatter();
        this.writeCDL(f, strict, null);
        return f.toString();
    }

    @Deprecated
    protected void writeCDL(Formatter f, boolean strict, String parentname) {
        if (strict && (this.isString() || this.getEnumType() != null)) {
            f.format("string ", new Object[0]);
        }
        if (strict && parentname != null) {
            f.format(NetcdfFiles.makeValidCDLName(parentname), new Object[0]);
        }
        f.format(":", new Object[0]);
        f.format("%s", strict ? NetcdfFiles.makeValidCDLName(this.getShortName()) : this.getShortName());
        if (this.isString()) {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                String val;
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                if ((val = this.getStringValue(i)) == null) continue;
                f.format("\"%s\"", Attribute.encodeString(val));
            }
        } else if (this.getEnumType() != null) {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                String econst;
                EnumTypedef en;
                Integer ecint;
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                if ((ecint = (en = this.getEnumType()).lookupEnumInt(econst = this.getStringValue(i))) == null) {
                    throw new ForbiddenConversionException("Illegal enum constant: " + econst);
                }
                f.format("\"%s\"", Attribute.encodeString(econst));
            }
        } else {
            f.format(" = ", new Object[0]);
            for (int i = 0; i < this.getLength(); ++i) {
                if (i != 0) {
                    f.format(", ", new Object[0]);
                }
                Number number = this.getNumericValue(i);
                if (this.dataType.isUnsigned()) {
                    number = DataType.widenNumber(number);
                }
                f.format("%s", number);
                if (this.dataType.isUnsigned()) {
                    f.format("U", new Object[0]);
                }
                if (this.dataType == DataType.FLOAT) {
                    f.format("f", new Object[0]);
                    continue;
                }
                if (this.dataType == DataType.SHORT || this.dataType == DataType.USHORT) {
                    f.format("S", new Object[0]);
                    continue;
                }
                if (this.dataType == DataType.BYTE || this.dataType == DataType.UBYTE) {
                    f.format("B", new Object[0]);
                    continue;
                }
                if (this.dataType != DataType.LONG && this.dataType != DataType.ULONG) continue;
                f.format("L", new Object[0]);
            }
        }
    }

    @Deprecated
    private static String encodeString(String s) {
        return StringUtil2.replace(s, org, replace);
    }

    @Deprecated
    public Attribute(String name, Attribute from) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
        this.setDataType(from.dataType);
        this.setEnumType(from.enumtype);
        this.nelems = from.nelems;
        this.svalue = from.svalue;
        this.values = from.values;
        this.setImmutable();
    }

    public Attribute(String name, String val) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
        this.dataType = DataType.STRING;
        this.setStringValue(val);
        this.setImmutable();
    }

    public Attribute(String name, Number val) {
        this(name, val, false);
    }

    public Attribute(String name, Number val, boolean isUnsigned) {
        super(name);
        DataType dt;
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
        int[] shape = new int[]{1};
        this.dataType = dt = DataType.getType(val.getClass(), isUnsigned);
        Array vala = Array.factory(dt, shape);
        Index ima = vala.getIndex();
        vala.setObject(ima.set0(0), (Object)val);
        this.setValues(vala);
        this.setImmutable();
    }

    public Attribute(String name, Array values) {
        this(name, values.getDataType());
        this.setValues(values);
        this.setImmutable();
    }

    @Deprecated
    public Attribute(String name, DataType dataType) {
        this(name);
        this.setDataType(dataType);
    }

    @Deprecated
    public Attribute(String name, List values) {
        this(name, values, false);
    }

    public Attribute(String name, List values, boolean isUnsigned) {
        this(name);
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("Cannot determine attribute's type");
        }
        Class<?> c = values.get(0).getClass();
        this.dataType = DataType.getType(c, isUnsigned);
        this.setValues(values);
        this.setImmutable();
    }

    public Attribute(Parameter param) {
        this(param.getName());
        if (param.isString()) {
            this.setStringValue(param.getStringValue());
        } else {
            double[] values = param.getNumericValues();
            int n = values.length;
            Array vala = Array.factory(DataType.DOUBLE, new int[]{n}, (Object)values);
            this.setValues(vala);
        }
        this.setImmutable();
    }

    private void setStringValue(String val) {
        int len;
        if (val == null) {
            throw new IllegalArgumentException("Attribute value cannot be null");
        }
        for (len = val.length(); len > 0 && val.charAt(len - 1) == '\u0000'; --len) {
        }
        if (len != val.length()) {
            val = val.substring(0, len);
        }
        this.svalue = val;
        this.nelems = 1;
        this.dataType = DataType.STRING;
    }

    @Deprecated
    protected Attribute(String name) {
        super(name);
        if (name == null) {
            throw new IllegalArgumentException("Trying to set name to null on " + this);
        }
    }

    @Deprecated
    public void setValues(List values) {
        Object[] pa;
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException("Cannot determine attribute's type");
        }
        int n = values.size();
        Class<?> c = values.get(0).getClass();
        if (c == String.class) {
            String[] va;
            pa = va = new String[n];
            for (int i = 0; i < n; ++i) {
                va[i] = (String)values.get(i);
            }
        } else if (c == Integer.class) {
            int[] va = new int[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Integer)values.get(i);
            }
        } else if (c == Double.class) {
            double[] va = new double[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Double)values.get(i);
            }
        } else if (c == Float.class) {
            float[] va = new float[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = ((Float)values.get(i)).floatValue();
            }
        } else if (c == Short.class) {
            short[] va = new short[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Short)values.get(i);
            }
        } else if (c == Byte.class) {
            byte[] va = new byte[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Byte)values.get(i);
            }
        } else if (c == Long.class) {
            long[] va = new long[n];
            pa = va;
            for (int i = 0; i < n; ++i) {
                va[i] = (Long)values.get(i);
            }
        } else {
            throw new IllegalArgumentException("Unknown type for Attribute = " + c.getName());
        }
        this.setValues(Array.factory(this.dataType, new int[]{n}, (Object)pa));
    }

    @Deprecated
    public void setValues(Array arr) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        if (arr == null) {
            this.dataType = DataType.STRING;
            return;
        }
        if (arr.getElementType() == Character.TYPE) {
            ArrayChar carr = (ArrayChar)arr;
            if (carr.getRank() == 1) {
                this.svalue = carr.getString();
                this.nelems = 1;
                this.dataType = DataType.STRING;
                return;
            }
            arr = carr.make1DStringArray();
        }
        if (arr.getElementType() == ByteBuffer.class) {
            int totalLen = 0;
            arr.resetLocalIterator();
            while (arr.hasNext()) {
                ByteBuffer bb = (ByteBuffer)arr.next();
                totalLen += bb.limit();
            }
            byte[] ba = new byte[totalLen];
            int pos = 0;
            arr.resetLocalIterator();
            while (arr.hasNext()) {
                ByteBuffer bb = (ByteBuffer)arr.next();
                System.arraycopy(bb.array(), 0, ba, pos, bb.limit());
                pos += bb.limit();
            }
            arr = Array.factory(DataType.BYTE, new int[]{totalLen}, (Object)ba);
        }
        if (DataType.getType(arr) == DataType.OBJECT) {
            throw new IllegalArgumentException("Cant set Attribute with type " + arr.getElementType());
        }
        if (arr.getRank() > 1) {
            arr = arr.reshape(new int[]{(int)arr.getSize()});
        }
        this.values = arr;
        this.nelems = (int)arr.getSize();
        this.dataType = DataType.getType(arr);
    }

    @Deprecated
    public synchronized void setName(String name) {
        if (this.immutable) {
            throw new IllegalStateException("Cant modify");
        }
        this.setShortName(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Attribute)) {
            return false;
        }
        Attribute att = (Attribute)o;
        String name = this.getShortName();
        if (!name.equals(att.getShortName())) {
            return false;
        }
        if (this.nelems != att.nelems) {
            return false;
        }
        if (this.dataType != att.dataType) {
            return false;
        }
        if (this.isString()) {
            return att.getStringValue().equals(this.getStringValue());
        }
        if (this.values != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                int r2;
                int r1 = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                int n = r2 = att.isString() ? att.getStringValue(i).hashCode() : att.getNumericValue(i).hashCode();
                if (r1 == r2) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.getShortName().hashCode();
        result = 37 * result + this.nelems;
        result = 37 * result + this.getDataType().hashCode();
        if (this.svalue != null) {
            result = 37 * result + this.svalue.hashCode();
        } else if (this.values != null) {
            for (int i = 0; i < this.getLength(); ++i) {
                int h = this.isString() ? this.getStringValue(i).hashCode() : this.getNumericValue(i).hashCode();
                result = 37 * result + h;
            }
        }
        return result;
    }

    private Attribute(Builder builder) {
        super(builder.name);
        this.svalue = builder.svalue;
        this.dataType = builder.dataType;
        this.enumtype = builder.enumtype;
        this.nelems = builder.nelems;
        this.values = builder.values;
        this.nelems = this.svalue != null ? 1 : (this.values != null ? (int)this.values.getSize() : 0);
    }

    public Builder toBuilder() {
        Builder b = Attribute.builder().setName(this.shortName).setDataType(this.dataType).setEnumType(this.enumtype);
        if (this.svalue != null) {
            b.setStringValue(this.svalue);
        } else if (this.values != null) {
            b.setValues(this.values);
        }
        return b;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(String name) {
        return new Builder().setName(name);
    }

    public static class Builder {
        private String name;
        private DataType dataType;
        private String svalue;
        private Array values;
        private int nelems;
        private EnumTypedef enumtype;
        private boolean built;

        private Builder() {
        }

        public Builder setName(String name) {
            this.name = NetcdfFiles.makeValidCdmObjectName(name);
            return this;
        }

        public Builder setDataType(DataType dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder setEnumType(EnumTypedef enumtype) {
            this.enumtype = enumtype;
            return this;
        }

        public Builder setNumericValue(Number val, boolean isUnsigned) {
            int[] shape = new int[]{1};
            DataType dt = DataType.getType(val.getClass(), isUnsigned);
            this.setDataType(dt);
            Array vala = Array.factory(dt, shape);
            Index ima = vala.getIndex();
            vala.setObject(ima.set0(0), (Object)val);
            this.setValues(vala);
            return this;
        }

        public Builder setStringValue(String svalue) {
            int len;
            if (svalue == null) {
                throw new IllegalArgumentException("Attribute value cannot be null");
            }
            for (len = svalue.length(); len > 0 && svalue.charAt(len - 1) == '\u0000'; --len) {
            }
            if (len != svalue.length()) {
                svalue = svalue.substring(0, len);
            }
            this.svalue = svalue;
            this.nelems = 1;
            this.dataType = DataType.STRING;
            return this;
        }

        public Builder setValues(List<Object> values, boolean unsigned) {
            Object[] pa;
            if (values == null || values.isEmpty()) {
                throw new IllegalArgumentException("Cannot determine attribute's type");
            }
            int n = values.size();
            Class<?> c = values.get(0).getClass();
            if (c == String.class) {
                String[] va;
                this.dataType = DataType.STRING;
                pa = va = new String[n];
                for (int i = 0; i < n; ++i) {
                    va[i] = (String)values.get(i);
                }
            } else if (c == Integer.class) {
                this.dataType = unsigned ? DataType.UINT : DataType.INT;
                int[] va = new int[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Integer)values.get(i);
                }
            } else if (c == Double.class) {
                this.dataType = DataType.DOUBLE;
                double[] va = new double[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Double)values.get(i);
                }
            } else if (c == Float.class) {
                this.dataType = DataType.FLOAT;
                float[] va = new float[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = ((Float)values.get(i)).floatValue();
                }
            } else if (c == Short.class) {
                this.dataType = unsigned ? DataType.USHORT : DataType.SHORT;
                short[] va = new short[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Short)values.get(i);
                }
            } else if (c == Byte.class) {
                this.dataType = unsigned ? DataType.UBYTE : DataType.BYTE;
                byte[] va = new byte[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Byte)values.get(i);
                }
            } else if (c == Long.class) {
                this.dataType = unsigned ? DataType.ULONG : DataType.LONG;
                long[] va = new long[n];
                pa = va;
                for (int i = 0; i < n; ++i) {
                    va[i] = (Long)values.get(i);
                }
            } else {
                throw new IllegalArgumentException("Unknown type for Attribute = " + c.getName());
            }
            return this.setValues(Array.factory(this.dataType, new int[]{n}, (Object)pa));
        }

        public Builder setValues(Array arr) {
            if (arr == null) {
                this.dataType = DataType.STRING;
                return this;
            }
            if (arr.getElementType() == Character.TYPE) {
                ArrayChar carr = (ArrayChar)arr;
                if (carr.getRank() == 1) {
                    this.svalue = carr.getString();
                    this.nelems = 1;
                    this.dataType = DataType.STRING;
                    return this;
                }
                arr = carr.make1DStringArray();
            }
            if (arr.getElementType() == ByteBuffer.class) {
                int totalLen = 0;
                arr.resetLocalIterator();
                while (arr.hasNext()) {
                    ByteBuffer bb = (ByteBuffer)arr.next();
                    totalLen += bb.limit();
                }
                byte[] ba = new byte[totalLen];
                int pos = 0;
                arr.resetLocalIterator();
                while (arr.hasNext()) {
                    ByteBuffer bb = (ByteBuffer)arr.next();
                    System.arraycopy(bb.array(), 0, ba, pos, bb.limit());
                    pos += bb.limit();
                }
                arr = Array.factory(DataType.BYTE, new int[]{totalLen}, (Object)ba);
            }
            if (DataType.getType(arr) == DataType.OBJECT) {
                throw new IllegalArgumentException("Cant set Attribute with type " + arr.getElementType());
            }
            if (arr.getRank() > 1) {
                arr = arr.reshape(new int[]{(int)arr.getSize()});
            }
            this.values = arr;
            this.nelems = (int)arr.getSize();
            this.dataType = DataType.getType(arr);
            return this;
        }

        public Attribute build() {
            if (this.built) {
                throw new IllegalStateException("already built");
            }
            this.built = true;
            return new Attribute(this);
        }
    }
}

