/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorFiltered;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Station;

public abstract class StationTimeSeriesFeatureImpl
extends PointCollectionImpl
implements StationTimeSeriesFeature {
    protected StationFeature s;

    public StationTimeSeriesFeatureImpl(String name, String desc, String wmoId, double lat, double lon, double alt, CalendarDateUnit timeUnit, String altUnits, int npts, StructureData sdata) {
        super(name, timeUnit, altUnits);
        this.s = new StationFeatureImpl(name, desc, wmoId, lat, lon, alt, npts, sdata);
    }

    public StationTimeSeriesFeatureImpl(StationFeature s, CalendarDateUnit timeUnit, String altUnits, int nfeatures) {
        super(s.getName(), timeUnit, altUnits);
        this.s = s;
        if (nfeatures >= 0) {
            this.getInfo();
            this.info.nfeatures = nfeatures;
        }
    }

    @Override
    public String getWmoId() {
        return this.s.getWmoId();
    }

    @Override
    public String getDescription() {
        return this.s.getDescription();
    }

    @Override
    public double getLatitude() {
        return this.s.getLatitude();
    }

    @Override
    public double getLongitude() {
        return this.s.getLongitude();
    }

    @Override
    public double getAltitude() {
        return this.s.getAltitude();
    }

    @Override
    public LatLonPoint getLatLon() {
        return this.s.getLatLon();
    }

    @Override
    public boolean isMissing() {
        return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
    }

    @Override
    @Nonnull
    public FeatureType getCollectionFeatureType() {
        return FeatureType.STATION;
    }

    public String toString() {
        return "StationFeatureImpl{s=" + this.s + '}';
    }

    @Override
    public StationTimeSeriesFeature subset(CalendarDateRange dateRange) {
        if (dateRange == null) {
            return this;
        }
        return new StationFeatureSubset(this, dateRange);
    }

    @Override
    public int compareTo(@Nonnull Station so) {
        return this.name.compareTo(so.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StationTimeSeriesFeatureImpl)) {
            return false;
        }
        StationTimeSeriesFeatureImpl that = (StationTimeSeriesFeatureImpl)o;
        return this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class StationFeatureSubset
    extends StationTimeSeriesFeatureImpl {
        private final StationTimeSeriesFeatureImpl from;
        private CalendarDateRange filter_date;

        public StationFeatureSubset(StationTimeSeriesFeatureImpl from, CalendarDateRange filter_date) {
            super(from.s, from.getTimeUnit(), from.getAltUnits(), -1);
            this.from = from;
            this.filter_date = filter_date;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            return new PointIteratorFiltered(this.from.getPointFeatureIterator(), null, this.filter_date);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return this.from.getFeatureData();
        }
    }
}

