/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.point.standard.PointConfigXML;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class FslWindProfiler
extends TableConfigurerImpl {
    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String title = ds.getRootGroup().findAttributeString("title", null);
        if (title == null && (title = ds.getRootGroup().findAttributeString("DD_reference", null)) != null) {
            title = ds.findVariable("staLat") != null ? title : null;
        }
        return title != null && (title.startsWith("WPDN data") || title.startsWith("RASS data") || title.contains("88-21-R2"));
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        String title = ds.getRootGroup().findAttributeString("title", null);
        if (title == null) {
            title = ds.getRootGroup().findAttributeString("DD_reference", null);
        }
        assert (title != null);
        boolean isRass = title.startsWith("RASS data");
        String xml = isRass ? "resources/nj22/pointConfig/FslRassProfiler.xml" : "resources/nj22/pointConfig/FslWindProfiler.xml";
        PointConfigXML reader = new PointConfigXML();
        TableConfig tc = reader.readConfigXMLfromResource(xml, wantFeatureType, ds, errlog);
        for (TableConfig inner : tc.children.get((int)0).children) {
            this.makeMultidimInner(ds, tc, inner, inner.outerName, inner.innerName);
        }
        return tc;
    }

    private void makeMultidimInner(NetcdfDataset ds, TableConfig parentTable, TableConfig childTable, String outerDin, String innerDim) {
        Dimension parentDim = ds.findDimension(outerDin);
        Dimension childDim = ds.findDimension(innerDim);
        ImmutableList<Variable> vars = ds.getVariables();
        ArrayList<String> parentVars = new ArrayList<String>(vars.size());
        ArrayList<String> obsVars = new ArrayList<String>(vars.size());
        for (Variable orgV : vars) {
            Dimension dim0;
            if (orgV instanceof Structure || (dim0 = orgV.getDimension(0)) == null || !dim0.equals(parentDim)) continue;
            if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                parentVars.add(orgV.getShortName());
                continue;
            }
            Dimension dim1 = orgV.getDimension(1);
            if (dim1 == null || !dim1.equals(childDim)) continue;
            obsVars.add(orgV.getShortName());
        }
        parentTable.vars = parentVars;
        childTable.vars = obsVars;
    }
}

