/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import thredds.client.catalog.Access;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.tools.CatalogCrawler;
import thredds.client.catalog.tools.DataFactory;
import thredds.inventory.CollectionManagerAbstract;
import thredds.inventory.DateExtractorFromName;
import thredds.inventory.MFile;
import ucar.nc2.units.DateType;

@ThreadSafe
public class CollectionManagerCatalog
extends CollectionManagerAbstract
implements CatalogCrawler.Listener {
    private final String catalogUrl;
    private long lastScanned;
    private boolean debug;
    private List<MFile> mfiles;

    public CollectionManagerCatalog(String collectionName, String collectionSpec, String olderThan, Formatter errlog) {
        super(collectionName, null);
        int pos;
        if (collectionSpec.startsWith("catalog:")) {
            collectionSpec = collectionSpec.substring("catalog:".length());
        }
        if ((pos = collectionSpec.indexOf(63)) > 0) {
            this.dateExtractor = new DateExtractorFromName(collectionSpec.substring(pos + 1), true);
            collectionSpec = collectionSpec.substring(0, pos);
        }
        this.catalogUrl = collectionSpec;
        this.root = System.getProperty("user.dir");
    }

    @Override
    public String getRoot() {
        return null;
    }

    @Override
    public long getLastScanned() {
        return this.lastScanned;
    }

    @Override
    public long getLastChanged() {
        return 0L;
    }

    @Override
    public boolean isScanNeeded() {
        return this.mfiles == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean scan(boolean sendEvent) throws IOException {
        this.mfiles = new ArrayList<MFile>(100);
        CatalogCrawler crawler = new CatalogCrawler(CatalogCrawler.Type.all_direct, 0, null, this, null, null, null);
        long start = System.currentTimeMillis();
        try {
            crawler.crawl(this.catalogUrl);
        }
        finally {
            long took = System.currentTimeMillis() - start;
            if (this.debug) {
                System.out.format("***Done " + this.catalogUrl + " took = " + took + " msecs%n", new Object[0]);
            }
        }
        this.lastScanned = System.currentTimeMillis();
        return true;
    }

    @Override
    public Iterable<MFile> getFilesSorted() {
        return this.mfiles == null ? new ArrayList() : this.mfiles;
    }

    @Override
    public void getDataset(Dataset ds, Object context) {
        if (ds.hasAccess()) {
            DataFactory tdataFactory = new DataFactory();
            Access access = tdataFactory.chooseDatasetAccess(ds.getAccess());
            if (access == null) {
                throw new IllegalStateException();
            }
            MFileRemote mfile = new MFileRemote(access);
            if (mfile.getPath().endsWith(".xml")) {
                return;
            }
            this.mfiles.add(mfile);
            if (this.debug) {
                System.out.format("add %s %n", mfile.getPath());
            }
        }
    }

    private static class MFileRemote
    implements MFile {
        private Object info;
        private final Access access;
        private Date lastModified;

        MFileRemote(Access access) {
            this.access = access;
            for (DateType dateType : access.getDataset().getDates()) {
                if (!dateType.getType().equals("modified")) continue;
                this.lastModified = dateType.getDate();
            }
        }

        @Override
        public long getLastModified() {
            return this.lastModified == null ? -1L : this.lastModified.getTime();
        }

        @Override
        public long getLength() {
            return this.access.getDataSize();
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public String getPath() {
            return this.access.getWrappedUrlName();
        }

        @Override
        public String getName() {
            return this.access.getDataset().getName();
        }

        @Override
        public MFile getParent() {
            return null;
        }

        @Override
        public int compareTo(MFile o) {
            return this.getPath().compareTo(o.getPath());
        }

        @Override
        public Object getAuxInfo() {
            return this.info;
        }

        @Override
        public void setAuxInfo(Object info) {
            this.info = info;
        }
    }
}

