/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.net.URI;
import ucar.unidata.util.StringUtil2;

public class URLnaming {
    public static String canonicalizeWrite(String location) {
        try {
            URI refURI = URI.create(location);
            if (refURI.isAbsolute()) {
                return location;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "file:" + location;
    }

    public static String resolve(String baseUri, String relativeUri) {
        if (baseUri == null || relativeUri == null) {
            return relativeUri;
        }
        if (relativeUri.startsWith("file:")) {
            return relativeUri;
        }
        if (baseUri.startsWith("file:")) {
            try {
                URI uriRelative = URI.create(relativeUri);
                if (uriRelative.isAbsolute()) {
                    return relativeUri;
                }
            }
            catch (Exception uriRelative) {
                // empty catch block
            }
            if (!relativeUri.isEmpty() && relativeUri.charAt(0) == '#') {
                return baseUri + relativeUri;
            }
            if (!relativeUri.isEmpty() && relativeUri.charAt(0) == '/') {
                return relativeUri;
            }
            int pos = (baseUri = StringUtil2.substitute(baseUri, "\\", "/")).lastIndexOf(47);
            if (pos > 0) {
                String baseDir = baseUri.substring(0, pos + 1);
                if (relativeUri.equals(".")) {
                    return baseDir;
                }
                return baseDir + relativeUri;
            }
        }
        try {
            URI relativeURI = URI.create(relativeUri);
            if (relativeURI.isAbsolute()) {
                return relativeUri;
            }
            URI baseURI = URI.create(baseUri);
            URI resolvedURI = baseURI.resolve(relativeURI);
            return resolvedURI.toASCIIString();
        }
        catch (IllegalArgumentException e) {
            return relativeUri;
        }
    }

    public static String resolveFile(String baseDir, String filepath) {
        File base;
        if (baseDir == null) {
            return filepath;
        }
        if (filepath == null) {
            return null;
        }
        File file = new File(filepath);
        if (file.isAbsolute()) {
            return filepath;
        }
        if (baseDir.startsWith("file:")) {
            baseDir = baseDir.substring(5);
        }
        if (!(base = new File(baseDir)).isDirectory()) {
            base = base.getParentFile();
        }
        if (base == null) {
            return filepath;
        }
        return base.getAbsolutePath() + "/" + filepath;
    }
}

