/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import com.google.common.primitives.Ints;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import ucar.nc2.filter.Filter;
import ucar.nc2.filter.FilterProvider;

public class Checksum32
extends Filter {
    private static final int nbytes = 4;
    private final CType type;
    private final ByteOrder byteOrder;

    public Checksum32(CType type, ByteOrder bo) {
        this.type = type;
        this.byteOrder = bo;
    }

    public Checksum32(CType type) {
        this(type, ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public byte[] encode(byte[] dataIn) {
        int checksum = this.getChecksum(dataIn);
        byte[] dataOut = new byte[dataIn.length + 4];
        System.arraycopy(dataIn, 0, dataOut, 4, dataIn.length);
        System.arraycopy(Ints.toByteArray((int)checksum), 0, dataOut, 0, 4);
        return dataOut;
    }

    @Override
    public byte[] decode(byte[] dataIn) {
        byte[] dataOut = new byte[dataIn.length - 4];
        System.arraycopy(dataIn, 4, dataOut, 0, dataOut.length);
        int checksum = this.getChecksum(dataOut);
        byte[] bytes = new byte[4];
        System.arraycopy(dataIn, 0, bytes, 0, 4);
        int i = Ints.fromByteArray((byte[])bytes);
        if (i != checksum) {
            throw new RuntimeException("Checksum invalid");
        }
        return dataOut;
    }

    private int getChecksum(byte[] data) {
        Checksum checksum;
        switch (this.type) {
            case ADLER: {
                checksum = new Adler32();
                break;
            }
            case CRC: {
                checksum = new CRC32();
                break;
            }
            default: {
                checksum = new Fletcher32();
            }
        }
        checksum.update(data, 0, data.length);
        int val = (int)checksum.getValue();
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            val = Integer.reverseBytes(val);
        }
        return val;
    }

    public static class CRC32Provider
    implements FilterProvider {
        private static final String name = "crc32";
        private static final int id = -1;

        @Override
        public String getName() {
            return name;
        }

        @Override
        public int getId() {
            return -1;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Checksum32(CType.CRC);
        }
    }

    public static class Adler32Provider
    implements FilterProvider {
        private static final String name = "adler32";
        private static final int id = -1;

        @Override
        public String getName() {
            return name;
        }

        @Override
        public int getId() {
            return -1;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Checksum32(CType.ADLER);
        }
    }

    public static class Fletcher32Provider
    implements FilterProvider {
        private static final String name = "fletcher32";
        private static final int id = -1;

        @Override
        public String getName() {
            return name;
        }

        @Override
        public int getId() {
            return -1;
        }

        @Override
        public Filter create(Map<String, Object> properties) {
            return new Checksum32(CType.FLETCHER);
        }
    }

    private class Fletcher32
    extends Adler32 {
        private int sum1 = 0;
        private int sum2 = 0;

        private Fletcher32() {
        }

        @Override
        public void update(byte[] b, int off, int len) {
            if (b == null) {
                throw new NullPointerException();
            }
            if (off < 0 || len < 0 || off > b.length - len) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = off; i < len; ++i) {
                this.sum1 = (this.sum1 + (b[i] & 0xFF)) % 65535;
                this.sum2 = (this.sum2 + this.sum1) % 65535;
            }
        }
    }

    public static enum CType {
        FLETCHER,
        ADLER,
        CRC;

    }
}

