/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCCIterator;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.DsgCollectionImpl;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationProfileCollectionImpl;
import ucar.nc2.ft.point.StationProfileFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.Station;

public class StandardStationProfileCollectionImpl
extends StationProfileCollectionImpl {
    private NestedTable ft;

    StandardStationProfileCollectionImpl(NestedTable ft, CalendarDateUnit timeUnit, String altUnits) {
        super(ft.getName(), timeUnit, altUnits);
        this.ft = ft;
    }

    StandardStationProfileCollectionImpl(NestedTable ft, List<CoordinateAxis> coordVars) {
        super(ft.getName(), coordVars);
        this.ft = ft;
    }

    @Override
    protected StationHelper createStationHelper() throws IOException {
        StationHelper stationHelper = new StationHelper();
        StationProfileIterator iter = new StationProfileIterator();
        while (iter.hasNext()) {
            stationHelper.addStation(iter.next());
        }
        return stationHelper;
    }

    @Override
    public IOIterator<PointFeatureCC> getCollectionIterator() throws IOException {
        return new StationProfileIterator();
    }

    @Override
    public PointFeatureCCIterator getNestedPointFeatureCollectionIterator() throws IOException {
        return new StationProfileIterator();
    }

    private class StandardProfileFeature
    extends ProfileFeatureImpl {
        private Cursor cursor;
        StructureData profileData;

        StandardProfileFeature(Station s, String timeName, CalendarDateUnit timeUnit, String altName, String altUnits, double time, Cursor cursor, StructureData profileData) {
            super(timeUnit.makeCalendarDate(time).toString(), timeUnit, altUnits, s.getLatitude(), s.getLongitude(), time, -1);
            this.cursor = cursor;
            this.profileData = profileData;
            if (Double.isNaN(time)) {
                try {
                    PointFeatureIterator iter = this.getPointFeatureIterator();
                    if (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        this.time = pf.getObservationTime();
                        this.name = timeUnit.makeCalendarDate(this.time).toString();
                    } else {
                        this.name = "empty";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator structIter = StandardStationProfileCollectionImpl.this.ft.getLeafFeatureDataIterator(cursorIter);
            return new StandardProfileFeatureIterator(StandardStationProfileCollectionImpl.this.ft, this.timeUnit, structIter, cursorIter);
        }

        @Override
        @Nonnull
        public CalendarDate getTime() {
            return this.timeUnit.makeCalendarDate(this.time);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() {
            return this.profileData;
        }

        private class StandardProfileFeatureIterator
        extends StandardPointFeatureIterator {
            StandardProfileFeatureIterator(NestedTable ft, CalendarDateUnit timeUnit, StructureDataIterator structIter, Cursor cursor) {
                super(StandardProfileFeature.this, ft, timeUnit, structIter, cursor);
            }

            @Override
            protected boolean isMissing() throws IOException {
                if (super.isMissing()) {
                    return true;
                }
                return this.ft.isAltMissing(this.cursor);
            }
        }
    }

    private class StandardStationProfileFeature
    extends StationProfileFeatureImpl {
        Cursor cursor;

        StandardStationProfileFeature(Station s, Cursor cursor, StructureData stationProfileData, int recnum) {
            super(s, StandardStationProfileCollectionImpl.this.getTimeUnit(), StandardStationProfileCollectionImpl.this.getAltUnits(), -1);
            this.cursor = cursor;
            cursor = new Cursor(StandardStationProfileCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[2] = recnum;
            cursor.tableData[2] = stationProfileData;
            cursor.currentIndex = 2;
            StandardStationProfileCollectionImpl.this.ft.addParentJoin(cursor);
        }

        @Override
        public List<CalendarDate> getTimes() {
            ArrayList<CalendarDate> result = new ArrayList<CalendarDate>();
            for (ProfileFeature pf : this) {
                result.add(pf.getTime());
            }
            return result;
        }

        @Override
        public ProfileFeature getProfileByDate(CalendarDate date) {
            for (ProfileFeature pf : this) {
                if (!pf.getTime().equals(date)) continue;
                return pf;
            }
            return null;
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return ((StationFeature)this.station).getFeatureData();
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
            return new ProfileFeatureIterator(this.cursor.copy());
        }

        @Override
        public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
            return new ProfileFeatureIterator(this.cursor.copy());
        }

        private class ProfileFeatureIterator
        implements PointFeatureCollectionIterator,
        IOIterator<PointFeatureCollection> {
            private Cursor cursor;
            private StructureDataIterator sdataIter;
            private int count;
            private StructureData profileData;
            DsgCollectionImpl prev;
            CollectionInfo calcInfo;

            ProfileFeatureIterator(Cursor cursor) throws IOException {
                this.cursor = cursor;
                this.sdataIter = StandardStationProfileCollectionImpl.this.ft.getMiddleFeatureDataIterator(cursor);
                CollectionInfo info = StandardStationProfileFeature.this.getInfo();
                if (!info.isComplete()) {
                    this.calcInfo = info;
                }
            }

            @Override
            public boolean hasNext() throws IOException {
                do {
                    if (this.prev != null && this.calcInfo != null) {
                        this.calcInfo.extend(this.prev.getInfo());
                    }
                    if (!this.sdataIter.hasNext()) {
                        this.close();
                        StandardStationProfileFeature.this.timeSeriesNpts = this.count;
                        if (this.calcInfo != null) {
                            this.calcInfo.setComplete();
                        }
                        return false;
                    }
                    this.cursor.tableData[1] = this.profileData = this.sdataIter.next();
                    this.cursor.recnum[1] = this.sdataIter.getCurrentRecno();
                    this.cursor.currentIndex = 1;
                    StandardStationProfileCollectionImpl.this.ft.addParentJoin(this.cursor);
                } while (StandardStationProfileCollectionImpl.this.ft.isMissing(this.cursor));
                return true;
            }

            @Override
            public PointFeatureCollection next() {
                ++this.count;
                StandardProfileFeature result = new StandardProfileFeature(StandardStationProfileFeature.this.station, StandardStationProfileFeature.this.getTimeName(), StandardStationProfileFeature.this.getTimeUnit(), StandardStationProfileFeature.this.getAltName(), StandardStationProfileFeature.this.getAltUnits(), StandardStationProfileCollectionImpl.this.ft.getObsTime(this.cursor), this.cursor.copy(), this.profileData);
                this.prev = result;
                return result;
            }

            @Override
            public void close() {
                this.sdataIter.close();
            }
        }
    }

    private class StationProfileIterator
    implements PointFeatureCCIterator,
    IOIterator<PointFeatureCC> {
        private StructureDataIterator sdataIter;
        private StructureData stationProfileData;
        private DsgCollectionImpl prev;
        private CollectionInfo calcInfo;

        StationProfileIterator() throws IOException {
            this.sdataIter = StandardStationProfileCollectionImpl.this.ft.getRootFeatureDataIterator();
            this.sdataIter = StandardStationProfileCollectionImpl.this.ft.getRootFeatureDataIterator();
            CollectionInfo info = StandardStationProfileCollectionImpl.this.getInfo();
            if (!info.isComplete()) {
                this.calcInfo = info;
            }
        }

        @Override
        public boolean hasNext() throws IOException {
            StationFeature s;
            do {
                if (this.prev != null && this.calcInfo != null) {
                    this.calcInfo.extend(this.prev.getInfo());
                }
                if (!this.sdataIter.hasNext()) {
                    this.close();
                    if (this.calcInfo != null) {
                        this.calcInfo.setComplete();
                    }
                    return false;
                }
                this.stationProfileData = this.sdataIter.next();
            } while ((s = StandardStationProfileCollectionImpl.this.ft.makeStation(this.stationProfileData)) == null || StandardStationProfileCollectionImpl.this.ft.isFeatureMissing(this.stationProfileData));
            return true;
        }

        @Override
        public StationProfileFeature next() {
            Cursor cursor = new Cursor(StandardStationProfileCollectionImpl.this.ft.getNumberOfLevels());
            cursor.recnum[2] = this.sdataIter.getCurrentRecno();
            cursor.tableData[2] = this.stationProfileData;
            cursor.currentIndex = 2;
            StandardStationProfileCollectionImpl.this.ft.addParentJoin(cursor);
            StandardStationProfileFeature result = new StandardStationProfileFeature(StandardStationProfileCollectionImpl.this.ft.makeStation(this.stationProfileData), cursor, this.stationProfileData, cursor.recnum[2]);
            this.prev = result;
            return result;
        }

        @Override
        public void close() {
            this.sdataIter.close();
        }
    }
}

