/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.fmrc;

import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import ucar.nc2.Attribute;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.ft.fmrc.FmrcInv;
import ucar.nc2.ft.fmrc.GridDatasetInv;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.Misc;

public class TimeCoord
implements Comparable<TimeCoord> {
    public static final TimeCoord EMPTY = new TimeCoord(CalendarDate.of((Date)new Date()), new double[0]);
    private CalendarDate runDate;
    private List<GridDatasetInv.Grid> gridInv;
    private int id;
    private String axisName;
    private boolean isInterval;
    private double[] offset;
    private double[] bound1;
    private double[] bound2;

    TimeCoord(CalendarDate runDate) {
        this.runDate = runDate;
    }

    TimeCoord(CalendarDate runDate, double[] offset) {
        this.runDate = runDate;
        this.offset = offset;
    }

    TimeCoord(TimeCoord from) {
        this.runDate = from.runDate;
        this.axisName = from.axisName;
        this.offset = from.offset;
        this.isInterval = from.isInterval;
        this.bound1 = from.bound1;
        this.bound2 = from.bound2;
        this.id = from.id;
    }

    TimeCoord(CalendarDate runDate, CoordinateAxis1DTime axis) {
        Calendar cal;
        DateUnit unit;
        this.runDate = runDate;
        this.axisName = axis.getFullName();
        try {
            unit = new DateUnit(axis.getUnitsString());
            Attribute atrCal = axis.findAttribute("calendar");
            cal = atrCal != null ? Calendar.get((String)((String)atrCal.getValue(0))) : Calendar.getDefault();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Not a unit of time " + axis.getUnitsString());
        }
        int n = (int)axis.getSize();
        if (axis.isInterval()) {
            this.isInterval = true;
            this.bound1 = new double[n];
            this.bound2 = new double[n];
            double[] orgBound1 = axis.getBound1();
            double[] orgBound2 = axis.getBound2();
            this.bound2 = new double[n];
            int i = 0;
            while ((long)i < axis.getSize()) {
                this.bound1[i] = this.getValueInHours(unit, orgBound1[i]);
                this.bound2[i] = this.getValueInHours(unit, orgBound2[i]);
                ++i;
            }
        } else {
            this.offset = new double[n];
            int i = 0;
            while ((long)i < axis.getSize()) {
                this.offset[i] = this.getValueInHours(cal, unit, axis.getCoordValue(i));
                ++i;
            }
        }
    }

    double getValueInHours(Calendar cal, DateUnit unit, double value) {
        CalendarDateUnit dateUnit = CalendarDateUnit.withCalendar((Calendar)cal, (String)unit.getUnitsString());
        CalendarDate d = dateUnit.makeCalendarDate(value);
        return FmrcInv.getOffsetInHours(this.runDate, d);
    }

    double getValueInHours(DateUnit unit, double value) {
        CalendarDate d = unit.makeCalendarDate(value);
        return FmrcInv.getOffsetInHours(this.runDate, d);
    }

    void addGridInventory(GridDatasetInv.Grid grid) {
        if (this.gridInv == null) {
            this.gridInv = new ArrayList<GridDatasetInv.Grid>();
        }
        this.gridInv.add(grid);
    }

    public CalendarDate getRunDate() {
        return this.runDate;
    }

    public boolean isInterval() {
        return this.isInterval;
    }

    public List<GridDatasetInv.Grid> getGridInventory() {
        return this.gridInv == null ? new ArrayList() : this.gridInv;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public String getName() {
        if (this == EMPTY) {
            return "EMPTY";
        }
        return this.id == 0 ? "time" : "time" + this.id;
    }

    public String getAxisName() {
        return this.axisName;
    }

    public int getNCoords() {
        return this.isInterval ? this.bound1.length : this.offset.length;
    }

    public double[] getOffsetTimes() {
        return this.isInterval ? this.bound2 : this.offset;
    }

    public double[] getBound1() {
        return this.bound1;
    }

    public double[] getBound2() {
        return this.bound2;
    }

    public void setOffsetTimes(double[] offset) {
        this.offset = offset;
    }

    public void setBounds(double[] bound1, double[] bound2) {
        this.bound1 = bound1;
        this.bound2 = bound2;
        this.isInterval = true;
    }

    public void setBounds(List<Tinv> tinvs) {
        this.bound1 = new double[tinvs.size()];
        this.bound2 = new double[tinvs.size()];
        int count = 0;
        for (Tinv tinv : tinvs) {
            this.bound1[count] = tinv.b1;
            this.bound2[count] = tinv.b2;
            ++count;
        }
        this.isInterval = true;
    }

    public String toString() {
        Formatter out = new Formatter();
        out.format("%-10s %-26s offsets=", this.getName(), this.runDate);
        if (this.isInterval) {
            for (int i = 0; i < this.bound1.length; ++i) {
                out.format((Locale)null, "(%3.1f,%3.1f) ", this.bound1[i], this.bound2[i]);
            }
        } else {
            for (double val : this.offset) {
                out.format((Locale)null, "%3.1f, ", val);
            }
        }
        return out.toString();
    }

    public boolean equalsData(TimeCoord tother) {
        if (this.getRunDate() != null && !this.getRunDate().equals((Object)tother.getRunDate())) {
            return false;
        }
        if (this.isInterval != tother.isInterval) {
            return false;
        }
        if (this.isInterval) {
            if (this.bound1.length != tother.bound1.length) {
                return false;
            }
            for (int i = 0; i < this.bound1.length; ++i) {
                if (!Misc.nearlyEquals((double)this.bound1[i], (double)tother.bound1[i])) {
                    return false;
                }
                if (Misc.nearlyEquals((double)this.bound2[i], (double)tother.bound2[i])) continue;
                return false;
            }
            return true;
        }
        if (this.offset.length != tother.offset.length) {
            return false;
        }
        for (int i = 0; i < this.offset.length; ++i) {
            if (Misc.nearlyEquals((double)this.offset[i], (double)tother.offset[i])) continue;
            return false;
        }
        return true;
    }

    public int findInterval(double b1, double b2) {
        for (int i = 0; i < this.getNCoords(); ++i) {
            if (!Misc.nearlyEquals((double)this.bound1[i], (double)b1) || !Misc.nearlyEquals((double)this.bound2[i], (double)b2)) continue;
            return i;
        }
        return -1;
    }

    public int findIndex(double offsetHour) {
        double[] off = this.getOffsetTimes();
        for (int i = 0; i < off.length; ++i) {
            if (!Misc.nearlyEquals((double)off[i], (double)offsetHour)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int compareTo(TimeCoord o) {
        return Integer.compare(this.id, o.id);
    }

    public static TimeCoord findTimeCoord(List<TimeCoord> timeCoords, TimeCoord want) {
        if (want == null) {
            return null;
        }
        for (TimeCoord tc : timeCoords) {
            if (!want.equalsData(tc)) continue;
            return tc;
        }
        TimeCoord result = new TimeCoord(want);
        timeCoords.add(result);
        return result;
    }

    public static TimeCoord makeUnion(List<TimeCoord> timeCoords, CalendarDate baseDate) {
        if (timeCoords.isEmpty()) {
            return new TimeCoord(baseDate);
        }
        if (timeCoords.size() == 1) {
            return timeCoords.get(0);
        }
        if (timeCoords.get((int)0).isInterval) {
            return TimeCoord.makeUnionIntv(timeCoords, baseDate);
        }
        return TimeCoord.makeUnionReg(timeCoords, baseDate);
    }

    private static TimeCoord makeUnionReg(List<TimeCoord> timeCoords, CalendarDate baseDate) {
        HashSet<Double> offsets = new HashSet<Double>();
        for (TimeCoord tc : timeCoords) {
            if (tc.isInterval) {
                throw new IllegalArgumentException("Cant mix interval coordinates");
            }
            for (double off : tc.getOffsetTimes()) {
                offsets.add(off);
            }
        }
        List offsetList = offsets.stream().sorted().collect(Collectors.toList());
        double[] offset = new double[offsetList.size()];
        int count = 0;
        Iterator iterator = offsetList.iterator();
        while (iterator.hasNext()) {
            double off = (Double)iterator.next();
            offset[count++] = off;
        }
        TimeCoord result = new TimeCoord(baseDate);
        result.setOffsetTimes(offset);
        return result;
    }

    private static TimeCoord makeUnionIntv(List<TimeCoord> timeCoords, CalendarDate baseDate) {
        HashSet<Tinv> offsets = new HashSet<Tinv>();
        for (TimeCoord tc : timeCoords) {
            if (!tc.isInterval) {
                throw new IllegalArgumentException("Cant mix non-interval coordinates");
            }
            for (int i = 0; i < tc.bound1.length; ++i) {
                offsets.add(new Tinv(tc.bound1[i], tc.bound2[i]));
            }
        }
        List bounds = offsets.stream().sorted().collect(Collectors.toList());
        int n = bounds.size();
        double[] bounds1 = new double[n];
        double[] bounds2 = new double[n];
        for (int i = 0; i < n; ++i) {
            Tinv tinv = (Tinv)bounds.get(i);
            bounds1[i] = tinv.b1;
            bounds2[i] = tinv.b2;
        }
        TimeCoord result = new TimeCoord(baseDate);
        result.setBounds(bounds1, bounds2);
        return result;
    }

    public static class Tinv
    implements Comparable<Tinv> {
        private double b1;
        private double b2;

        public Tinv(double offset) {
            this.b2 = offset;
        }

        public Tinv(double b1, double b2) {
            this.b1 = b1;
            this.b2 = b2;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Tinv tinv = (Tinv)o;
            if (!Misc.nearlyEquals((double)this.b2, (double)tinv.b2)) {
                return false;
            }
            return Misc.nearlyEquals((double)this.b1, (double)tinv.b1);
        }

        public int hashCode() {
            int result = (int)Math.round(this.b1 / 1.0E-8);
            result = 31 * result + (int)Math.round(this.b2 / 1.0E-8);
            return result;
        }

        @Override
        public int compareTo(Tinv o) {
            boolean b1close = Misc.nearlyEquals((double)this.b1, (double)o.b1);
            boolean b2close = Misc.nearlyEquals((double)this.b2, (double)o.b2);
            if (b1close && b2close) {
                return 0;
            }
            if (b2close) {
                return Double.compare(this.b1, o.b1);
            }
            return Double.compare(this.b2, o.b2);
        }
    }
}

