/*
 * Decompiled with CFR 0.152.
 */
package ucar.gcdm;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Ints;
import com.google.protobuf.ByteString;
import com.google.protobuf.ProtocolStringList;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.gcdm.GcdmNetcdfProto;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.EnumTypedef;
import ucar.nc2.Group;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.IospHelper;

public class GcdmConverter {
    private static final BiMap<DataType, GcdmNetcdfProto.DataType> dataTypeProtoDataTypeMap = new ImmutableBiMap.Builder().put((Object)DataType.CHAR, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_CHAR).put((Object)DataType.BYTE, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_BYTE).put((Object)DataType.SHORT, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_SHORT).put((Object)DataType.INT, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_INT).put((Object)DataType.LONG, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_LONG).put((Object)DataType.FLOAT, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_FLOAT).put((Object)DataType.DOUBLE, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_DOUBLE).put((Object)DataType.STRING, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_STRING).put((Object)DataType.STRUCTURE, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_STRUCTURE).put((Object)DataType.SEQUENCE, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_SEQUENCE).put((Object)DataType.ENUM1, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_ENUM1).put((Object)DataType.ENUM2, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_ENUM2).put((Object)DataType.ENUM4, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_ENUM4).put((Object)DataType.OPAQUE, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_OPAQUE).put((Object)DataType.UBYTE, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_UBYTE).put((Object)DataType.USHORT, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_USHORT).put((Object)DataType.UINT, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_UINT).put((Object)DataType.ULONG, (Object)GcdmNetcdfProto.DataType.DATA_TYPE_ULONG).build();

    public static GcdmNetcdfProto.Group.Builder encodeGroup(Group group, int sizeToCache) throws IOException {
        GcdmNetcdfProto.Group.Builder groupBuilder = GcdmNetcdfProto.Group.newBuilder();
        groupBuilder.setName(group.getShortName());
        for (Dimension dimension : group.getDimensions()) {
            groupBuilder.addDimensions(GcdmConverter.encodeDimension(dimension));
        }
        for (Attribute attribute : group.attributes()) {
            groupBuilder.addAttributes(GcdmConverter.encodeAttribute(attribute));
        }
        for (EnumTypedef enumType : group.getEnumTypedefs()) {
            groupBuilder.addEnumTypes(GcdmConverter.encodeEnumTypedef(enumType));
        }
        for (Variable variable : group.getVariables()) {
            if (variable instanceof Structure) {
                groupBuilder.addStructures(GcdmConverter.encodeStructure((Structure)variable));
                continue;
            }
            groupBuilder.addVariables(GcdmConverter.encodeVariable(variable, sizeToCache));
        }
        for (Group nestedGroup : group.getGroups()) {
            groupBuilder.addGroups(GcdmConverter.encodeGroup(nestedGroup, sizeToCache));
        }
        return groupBuilder;
    }

    private static GcdmNetcdfProto.Attribute.Builder encodeAttribute(Attribute attribute) {
        GcdmNetcdfProto.Attribute.Builder attributeBuilder = GcdmNetcdfProto.Attribute.newBuilder();
        attributeBuilder.setName(attribute.getShortName());
        attributeBuilder.setDataType(GcdmConverter.convertDataType(attribute.getDataType()));
        attributeBuilder.setLength(attribute.getLength());
        if (attribute.getValues() != null && attribute.getLength() > 0) {
            if (attribute.isString()) {
                GcdmNetcdfProto.Data.Builder dataBuilder = GcdmNetcdfProto.Data.newBuilder();
                for (int i = 0; i < attribute.getLength(); ++i) {
                    dataBuilder.addStringData(attribute.getStringValue(i));
                }
                dataBuilder.setDataType(GcdmConverter.convertDataType(attribute.getDataType()));
                attributeBuilder.setData(dataBuilder);
            } else {
                attributeBuilder.setData(GcdmConverter.encodeData(attribute.getDataType(), attribute.getValues()));
            }
        }
        return attributeBuilder;
    }

    private static GcdmNetcdfProto.Dimension.Builder encodeDimension(Dimension dimension) {
        GcdmNetcdfProto.Dimension.Builder dimensionBuilder = GcdmNetcdfProto.Dimension.newBuilder();
        if (dimension.getShortName() != null) {
            dimensionBuilder.setName(dimension.getShortName());
        }
        if (!dimension.isVariableLength()) {
            dimensionBuilder.setLength(dimension.getLength());
        }
        dimensionBuilder.setIsPrivate(!dimension.isShared());
        dimensionBuilder.setIsVlen(dimension.isVariableLength());
        dimensionBuilder.setIsUnlimited(dimension.isUnlimited());
        return dimensionBuilder;
    }

    private static GcdmNetcdfProto.EnumTypedef.Builder encodeEnumTypedef(EnumTypedef enumType) {
        GcdmNetcdfProto.EnumTypedef.Builder enumTypdefBuilder = GcdmNetcdfProto.EnumTypedef.newBuilder();
        enumTypdefBuilder.setName(enumType.getShortName());
        enumTypdefBuilder.setBaseType(GcdmConverter.convertDataType(enumType.getBaseType()));
        ImmutableMap map = enumType.getMap();
        GcdmNetcdfProto.EnumTypedef.EnumType.Builder enumTypeBuilder = GcdmNetcdfProto.EnumTypedef.EnumType.newBuilder();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            int code = (Integer)iterator.next();
            enumTypeBuilder.clear();
            enumTypeBuilder.setCode(code);
            enumTypeBuilder.setValue((String)map.get(code));
            enumTypdefBuilder.addMaps(enumTypeBuilder);
        }
        return enumTypdefBuilder;
    }

    private static GcdmNetcdfProto.Variable.Builder encodeVariable(Variable variable, int sizeToCache) throws IOException {
        Object enumType;
        GcdmNetcdfProto.Variable.Builder builder = GcdmNetcdfProto.Variable.newBuilder();
        builder.setName(variable.getShortName());
        builder.setDataType(GcdmConverter.convertDataType(variable.getDataType()));
        if (variable.getDataType().isEnum() && (enumType = variable.getEnumTypedef()) != null) {
            builder.setEnumType(enumType.getShortName());
        }
        for (Dimension dimension : variable.getDimensions()) {
            builder.addShapes(GcdmConverter.encodeDimension(dimension));
        }
        for (Attribute attribute : variable.attributes()) {
            builder.addAttributes(GcdmConverter.encodeAttribute(attribute));
        }
        if (variable.isCaching() && variable.getDataType().isNumeric() && (variable.isCoordinateVariable() || variable.getSize() * (long)variable.getElementSize() < (long)sizeToCache)) {
            Array data = variable.read();
            builder.setData(GcdmConverter.encodeData(variable.getDataType(), data));
        }
        return builder;
    }

    private static GcdmNetcdfProto.Structure.Builder encodeStructure(Structure structure) throws IOException {
        GcdmNetcdfProto.Structure.Builder builder = GcdmNetcdfProto.Structure.newBuilder();
        builder.setName(structure.getShortName());
        builder.setDataType(GcdmConverter.convertDataType(structure.getDataType()));
        for (Dimension dimension : structure.getDimensions()) {
            builder.addShapes(GcdmConverter.encodeDimension(dimension));
        }
        for (Attribute attribute : structure.attributes()) {
            builder.addAttributes(GcdmConverter.encodeAttribute(attribute));
        }
        for (Variable variable : structure.getVariables()) {
            if (variable instanceof Structure) {
                builder.addStructs(GcdmConverter.encodeStructure((Structure)variable));
                continue;
            }
            builder.addVariables(GcdmConverter.encodeVariable(variable, -1));
        }
        return builder;
    }

    public static GcdmNetcdfProto.Data encodeData(DataType dataType, Array data) {
        if (data.isVlen()) {
            return GcdmConverter.encodeVlenData(dataType, (ArrayObject)data);
        }
        if (data instanceof ArrayStructure) {
            return GcdmConverter.encodeArrayStructureData(dataType, (ArrayStructure)data);
        }
        return GcdmConverter.encodePrimitiveData(dataType, data);
    }

    private static void encodeShape(GcdmNetcdfProto.Data.Builder data, int[] shape) {
        for (int i : shape) {
            data.addShapes(i);
        }
    }

    private static GcdmNetcdfProto.Data encodePrimitiveData(DataType dataType, Array data) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverter.convertDataType(dataType));
        GcdmConverter.encodeShape(builder, data.getShape());
        IndexIterator indexIterator = data.getIndexIterator();
        switch (dataType) {
            case CHAR: {
                byte[] array = IospHelper.convertCharToByte((char[])((char[])data.get1DJavaArray(DataType.CHAR)));
                builder.addByteData(ByteString.copyFrom((byte[])array));
                break;
            }
            case ENUM1: 
            case UBYTE: 
            case BYTE: {
                byte[] array = (byte[])data.get1DJavaArray(DataType.UBYTE);
                builder.addByteData(ByteString.copyFrom((byte[])array));
                break;
            }
            case SHORT: 
            case INT: {
                while (indexIterator.hasNext()) {
                    builder.addIntData(indexIterator.getIntNext());
                }
                break;
            }
            case ENUM2: 
            case ENUM4: 
            case USHORT: 
            case UINT: {
                while (indexIterator.hasNext()) {
                    builder.addUintData(indexIterator.getIntNext());
                }
                break;
            }
            case LONG: {
                while (indexIterator.hasNext()) {
                    builder.addLongData(indexIterator.getLongNext());
                }
                break;
            }
            case ULONG: {
                while (indexIterator.hasNext()) {
                    builder.addUlongData(indexIterator.getLongNext());
                }
                break;
            }
            case FLOAT: {
                while (indexIterator.hasNext()) {
                    builder.addFloatData(indexIterator.getFloatNext());
                }
                break;
            }
            case DOUBLE: {
                while (indexIterator.hasNext()) {
                    builder.addDoubleData(indexIterator.getDoubleNext());
                }
                break;
            }
            case STRING: {
                while (indexIterator.hasNext()) {
                    builder.addStringData((String)indexIterator.getObjectNext());
                }
                break;
            }
            case OPAQUE: {
                while (indexIterator.hasNext()) {
                    ByteBuffer bb = (ByteBuffer)indexIterator.getObjectNext();
                    builder.addByteData(ByteString.copyFrom((byte[])bb.array()));
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown datatype " + dataType);
            }
        }
        return builder.build();
    }

    private static GcdmNetcdfProto.Data encodeVlenData(DataType dataType, ArrayObject data) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverter.convertDataType(dataType));
        GcdmConverter.encodeShape(builder, data.getShape());
        IndexIterator objectIterator = data.getIndexIterator();
        while (objectIterator.hasNext()) {
            Array array = (Array)objectIterator.next();
            builder.addVlenData(GcdmConverter.encodeData(dataType, array));
        }
        return builder.build();
    }

    private static GcdmNetcdfProto.Data encodeArrayStructureData(DataType dataType, ArrayStructure arrayStructure) {
        GcdmNetcdfProto.Data.Builder builder = GcdmNetcdfProto.Data.newBuilder();
        builder.setDataType(GcdmConverter.convertDataType(dataType));
        GcdmConverter.encodeShape(builder, arrayStructure.getShape());
        builder.setMembers(GcdmConverter.encodeStructureMembers(arrayStructure.getStructureMembers()));
        for (StructureData structureData : arrayStructure) {
            builder.addRows(GcdmConverter.encodeStructureData(structureData));
        }
        return builder.build();
    }

    private static GcdmNetcdfProto.StructureMembersProto encodeStructureMembers(StructureMembers members) {
        GcdmNetcdfProto.StructureMembersProto.Builder builder = GcdmNetcdfProto.StructureMembersProto.newBuilder();
        builder.setName(members.getName());
        for (StructureMembers.Member member : members.getMembers()) {
            GcdmNetcdfProto.StructureMemberProto.Builder structureMemberBuilder = GcdmNetcdfProto.StructureMemberProto.newBuilder().setName(member.getName()).setDataType(GcdmConverter.convertDataType(member.getDataType())).addAllShapes(Ints.asList((int[])member.getShape()));
            if (member.getStructureMembers() != null) {
                structureMemberBuilder.setMembers(GcdmConverter.encodeStructureMembers(member.getStructureMembers()));
            }
            builder.addMembers(structureMemberBuilder);
        }
        return builder.build();
    }

    private static GcdmNetcdfProto.StructureDataProto encodeStructureData(StructureData structureData) {
        GcdmNetcdfProto.StructureDataProto.Builder builder = GcdmNetcdfProto.StructureDataProto.newBuilder();
        for (StructureMembers.Member member : structureData.getMembers()) {
            Array data = structureData.getArray(member);
            builder.addMemberData(GcdmConverter.encodeData(member.getDataType(), data));
        }
        return builder.build();
    }

    private static Dimension decodeDimension(GcdmNetcdfProto.Dimension dimension) {
        String name = dimension.getName().isEmpty() ? null : dimension.getName();
        int dimLen = dimension.getIsVlen() ? -1 : (int)dimension.getLength();
        return Dimension.builder().setName(name).setIsShared(!dimension.getIsPrivate()).setIsUnlimited(dimension.getIsUnlimited()).setIsVariableLength(dimension.getIsVlen()).setLength(dimLen).build();
    }

    public static void decodeGroup(GcdmNetcdfProto.Group protoGroup, Group.Builder groupBuilder) {
        for (GcdmNetcdfProto.Dimension dim : protoGroup.getDimensionsList()) {
            groupBuilder.addDimension(GcdmConverter.decodeDimension(dim));
        }
        for (GcdmNetcdfProto.Attribute att : protoGroup.getAttributesList()) {
            groupBuilder.addAttribute(GcdmConverter.decodeAttribute(att));
        }
        for (GcdmNetcdfProto.EnumTypedef enumType : protoGroup.getEnumTypesList()) {
            groupBuilder.addEnumTypedef(GcdmConverter.decodeEnumTypedef(enumType));
        }
        for (GcdmNetcdfProto.Variable var : protoGroup.getVariablesList()) {
            groupBuilder.addVariable(GcdmConverter.decodeVariable(var));
        }
        for (GcdmNetcdfProto.Structure s : protoGroup.getStructuresList()) {
            groupBuilder.addVariable(GcdmConverter.decodeStructure(s));
        }
        for (GcdmNetcdfProto.Group nestedProtoGroup : protoGroup.getGroupsList()) {
            Group.Builder nestedGroup = Group.builder().setName(nestedProtoGroup.getName());
            groupBuilder.addGroup(nestedGroup);
            GcdmConverter.decodeGroup(nestedProtoGroup, nestedGroup);
        }
    }

    private static EnumTypedef decodeEnumTypedef(GcdmNetcdfProto.EnumTypedef enumTypedef) {
        List<GcdmNetcdfProto.EnumTypedef.EnumType> enumTypes = enumTypedef.getMapsList();
        HashMap<Integer, String> map = new HashMap<Integer, String>(2 * enumTypes.size());
        for (GcdmNetcdfProto.EnumTypedef.EnumType enumType : enumTypes) {
            map.put(enumType.getCode(), enumType.getValue());
        }
        DataType baseType = GcdmConverter.convertDataType(enumTypedef.getBaseType());
        return new EnumTypedef(enumTypedef.getName(), map, baseType);
    }

    private static Attribute decodeAttribute(GcdmNetcdfProto.Attribute protoAttribute) {
        DataType dataType = GcdmConverter.convertDataType(protoAttribute.getDataType());
        int length = protoAttribute.getLength();
        if (length == 0) {
            return Attribute.builder((String)protoAttribute.getName()).setDataType(dataType).build();
        }
        GcdmNetcdfProto.Data attributeData = protoAttribute.getData();
        if (dataType == DataType.STRING) {
            ProtocolStringList values = attributeData.getStringDataList();
            if (values.size() != length) {
                throw new IllegalStateException();
            }
            if (values.size() == 1) {
                return new Attribute(protoAttribute.getName(), (String)values.get(0));
            }
            Array data = Array.factory((DataType)dataType, (int[])new int[]{length});
            for (int i = 0; i < length; ++i) {
                data.setObject(i, values.get(i));
            }
            return Attribute.builder((String)protoAttribute.getName()).setValues(data).build();
        }
        Array array = GcdmConverter.decodeData(protoAttribute.getData());
        return Attribute.builder((String)protoAttribute.getName()).setValues(array).build();
    }

    private static Variable.Builder<?> decodeVariable(GcdmNetcdfProto.Variable protoVariable) {
        DataType dataType = GcdmConverter.convertDataType(protoVariable.getDataType());
        Variable.Builder variableBuilder = Variable.builder().setName(protoVariable.getName()).setDataType(dataType);
        if (dataType.isEnum()) {
            variableBuilder.setEnumTypeName(protoVariable.getEnumType());
        }
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(6);
        Section.Builder section = Section.builder();
        for (GcdmNetcdfProto.Dimension dimension : protoVariable.getShapesList()) {
            dimensions.add(GcdmConverter.decodeDimension(dimension));
            section.appendRange((int)dimension.getLength());
        }
        variableBuilder.addDimensions(dimensions);
        for (GcdmNetcdfProto.Attribute attribute : protoVariable.getAttributesList()) {
            variableBuilder.addAttribute(GcdmConverter.decodeAttribute(attribute));
        }
        if (protoVariable.hasData()) {
            Array data = GcdmConverter.decodeData(protoVariable.getData());
            variableBuilder.setCachedData(data, false);
        }
        return variableBuilder;
    }

    private static Structure.Builder<?> decodeStructure(GcdmNetcdfProto.Structure protoStructure) {
        Sequence.Builder structureBuilder = protoStructure.getDataType() == GcdmNetcdfProto.DataType.DATA_TYPE_SEQUENCE ? Sequence.builder() : Structure.builder();
        ((Structure.Builder)structureBuilder.setName(protoStructure.getName())).setDataType(GcdmConverter.convertDataType(protoStructure.getDataType()));
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>(6);
        for (GcdmNetcdfProto.Dimension dimension : protoStructure.getShapesList()) {
            dimensions.add(GcdmConverter.decodeDimension(dimension));
        }
        structureBuilder.addDimensions(dimensions);
        for (GcdmNetcdfProto.Attribute attribute : protoStructure.getAttributesList()) {
            structureBuilder.addAttribute(GcdmConverter.decodeAttribute(attribute));
        }
        for (GcdmNetcdfProto.Variable protoVariable : protoStructure.getVariablesList()) {
            structureBuilder.addMemberVariable(GcdmConverter.decodeVariable(protoVariable));
        }
        for (GcdmNetcdfProto.Structure nestedProtoStructure : protoStructure.getStructsList()) {
            structureBuilder.addMemberVariable(GcdmConverter.decodeStructure(nestedProtoStructure));
        }
        return structureBuilder;
    }

    public static Array decodeData(GcdmNetcdfProto.Data protoData) {
        if (protoData.getVlenDataCount() > 0) {
            return GcdmConverter.decodeVlenData(protoData);
        }
        if (protoData.hasMembers()) {
            return GcdmConverter.decodeArrayStructureData(protoData);
        }
        return GcdmConverter.decodePrimitiveData(protoData);
    }

    private static int[] decodeShape(GcdmNetcdfProto.Data data) {
        int[] shape = new int[data.getShapesCount()];
        for (int i = 0; i < shape.length; ++i) {
            shape[i] = data.getShapes(i);
        }
        return shape;
    }

    private static Array decodePrimitiveData(GcdmNetcdfProto.Data data) {
        DataType dataType = GcdmConverter.convertDataType(data.getDataType());
        int[] shape = GcdmConverter.decodeShape(data);
        Object storage = GcdmConverter.decodePrimitiveData(data, dataType);
        return Array.factory((DataType)dataType, (int[])shape, (Object)storage);
    }

    private static Object decodePrimitiveData(GcdmNetcdfProto.Data data, DataType dataType) {
        switch (dataType) {
            case CHAR: {
                return IospHelper.convertByteToChar((byte[])data.getByteData(0).toByteArray());
            }
            case ENUM1: 
            case UBYTE: 
            case BYTE: {
                return data.getByteData(0).toByteArray();
            }
            case SHORT: {
                int i = 0;
                short[] array = new short[data.getIntDataCount()];
                for (int val : data.getIntDataList()) {
                    array[i++] = (short)val;
                }
                return array;
            }
            case INT: {
                int i = 0;
                int[] array = new int[data.getIntDataCount()];
                for (int val : data.getIntDataList()) {
                    array[i++] = val;
                }
                return array;
            }
            case ENUM2: 
            case USHORT: {
                int i = 0;
                short[] array = new short[data.getUintDataCount()];
                for (int val : data.getUintDataList()) {
                    array[i++] = (short)val;
                }
                return array;
            }
            case ENUM4: 
            case UINT: {
                int i = 0;
                int[] array = new int[data.getUintDataCount()];
                for (int val : data.getUintDataList()) {
                    array[i++] = val;
                }
                return array;
            }
            case LONG: {
                int i = 0;
                long[] array = new long[data.getLongDataCount()];
                for (long val : data.getLongDataList()) {
                    array[i++] = val;
                }
                return array;
            }
            case ULONG: {
                int i = 0;
                long[] array = new long[data.getUlongDataCount()];
                for (long val : data.getUlongDataList()) {
                    array[i++] = val;
                }
                return array;
            }
            case FLOAT: {
                int i = 0;
                float[] array = new float[data.getFloatDataCount()];
                for (float val : data.getFloatDataList()) {
                    array[i++] = val;
                }
                return array;
            }
            case DOUBLE: {
                int i = 0;
                double[] array = new double[data.getDoubleDataCount()];
                for (double val : data.getDoubleDataList()) {
                    array[i++] = val;
                }
                return array;
            }
            case STRING: {
                int i = 0;
                Object[] array = new Object[data.getStringDataCount()];
                for (String val : data.getStringDataList()) {
                    array[i++] = val;
                }
                return array;
            }
            case OPAQUE: {
                int i = 0;
                Object[] array = new Object[data.getByteDataCount()];
                for (ByteString val : data.getByteDataList()) {
                    array[i++] = ByteBuffer.wrap(val.toByteArray());
                }
                return array;
            }
        }
        throw new IllegalStateException("Unknown datatype " + dataType);
    }

    private static Array decodeVlenData(GcdmNetcdfProto.Data vlenData) {
        Preconditions.checkArgument((vlenData.getVlenDataCount() > 0 ? 1 : 0) != 0);
        int[] shape = GcdmConverter.decodeShape(vlenData);
        int length = (int)Index.computeSize((int[])shape);
        Preconditions.checkArgument((length == vlenData.getVlenDataCount() ? 1 : 0) != 0);
        Array[] storage = new Array[length];
        for (int i = 0; i < length; ++i) {
            GcdmNetcdfProto.Data inner = vlenData.getVlenData(i);
            storage[i] = GcdmConverter.decodeData(inner);
        }
        return Array.makeVlenArray((int[])shape, (Array[])storage);
    }

    public static GcdmNetcdfProto.DataType convertDataType(DataType dataType) {
        GcdmNetcdfProto.DataType protoDataType = (GcdmNetcdfProto.DataType)((Object)dataTypeProtoDataTypeMap.get((Object)dataType));
        if (protoDataType == null) {
            throw new IllegalStateException("illegal data type " + dataType);
        }
        return protoDataType;
    }

    public static DataType convertDataType(GcdmNetcdfProto.DataType protoDataType) {
        DataType dataType = (DataType)dataTypeProtoDataTypeMap.inverse().get((Object)protoDataType);
        if (protoDataType == null) {
            throw new IllegalStateException("illegal data type " + dataType);
        }
        return dataType;
    }

    private static ArrayStructure decodeArrayStructureData(GcdmNetcdfProto.Data arrayStructureProto) {
        DataType dataType = GcdmConverter.convertDataType(arrayStructureProto.getDataType());
        int numberOfRows = arrayStructureProto.getRowsCount();
        int[] shape = GcdmConverter.decodeShape(arrayStructureProto);
        Preconditions.checkArgument((Index.computeSize((int[])shape) == (long)numberOfRows ? 1 : 0) != 0);
        StructureMembers members = GcdmConverter.decodeStructureMembers(arrayStructureProto.getMembers());
        ArrayStructureW result = new ArrayStructureW(members, shape);
        int index = 0;
        for (GcdmNetcdfProto.StructureDataProto row : arrayStructureProto.getRowsList()) {
            result.setStructureData(GcdmConverter.decodeStructureData(row, members), index);
            ++index;
        }
        if (dataType == DataType.SEQUENCE) {
            return new ArraySequence(members, result.getStructureDataIterator(), -1);
        }
        return result;
    }

    private static StructureMembers decodeStructureMembers(GcdmNetcdfProto.StructureMembersProto membersProto) {
        StructureMembers.Builder structureMembersBuilder = StructureMembers.builder();
        structureMembersBuilder.setName(membersProto.getName());
        for (GcdmNetcdfProto.StructureMemberProto memberProto : membersProto.getMembersList()) {
            StructureMembers.MemberBuilder memberBuilder = StructureMembers.memberBuilder().setName(memberProto.getName()).setDataType(GcdmConverter.convertDataType(memberProto.getDataType())).setShape(Ints.toArray(memberProto.getShapesList()));
            if (memberProto.hasMembers()) {
                memberBuilder.setStructureMembers(GcdmConverter.decodeStructureMembers(memberProto.getMembers()));
            }
            structureMembersBuilder.addMember(memberBuilder);
        }
        return structureMembersBuilder.build();
    }

    private static StructureData decodeStructureData(GcdmNetcdfProto.StructureDataProto structDataProto, StructureMembers members) {
        StructureDataW structureData = new StructureDataW(members);
        for (int i = 0; i < structDataProto.getMemberDataCount(); ++i) {
            GcdmNetcdfProto.Data data = structDataProto.getMemberData(i);
            StructureMembers.Member member = members.getMember(i);
            structureData.setMemberData(member, GcdmConverter.decodeData(data));
        }
        return structureData;
    }
}

