/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.NoSuchVariableException;
import thredds.server.opendap.HasNetcdfVariable;
import thredds.server.opendap.servers.CEEvaluator;
import thredds.server.opendap.servers.DAP2ServerSideException;
import thredds.server.opendap.servers.SDStructure;
import thredds.server.opendap.servers.ServerMethods;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class NcSDStructure
extends SDStructure {
    private Structure ncVar = null;
    protected List<BaseType> memberBTlist;
    protected NcSDStructure org;
    protected StructureData sdata;

    public NcSDStructure(Structure s, List<BaseType> list) {
        super(s.getShortName());
        this.ncVar = s;
        for (BaseType aList : list) {
            this.addVariable(aList, 0);
        }
        this.memberBTlist = list;
    }

    public NcSDStructure(NcSDStructure org, StructureData sdata) {
        super(org.getEncodedName());
        this.org = org;
        this.sdata = sdata;
    }

    public Variable getVariable() {
        return this.ncVar;
    }

    @Override
    public boolean read(String datasetName, Object specialO) throws NoSuchVariableException, IOException {
        StructureData sdata;
        try {
            sdata = this.ncVar.readStructure(0);
        }
        catch (InvalidRangeException e) {
            throw new IOException(e);
        }
        this.setData(sdata);
        return false;
    }

    public void setData(StructureData sdata) {
        int count = 0;
        StructureMembers sm = sdata.getStructureMembers();
        for (BaseType bt : this.org.getVariables()) {
            HasNetcdfVariable hasNetcdf = (HasNetcdfVariable)bt;
            StructureMembers.Member m = sm.getMember(count++);
            Array data = sdata.getArray(m);
            hasNetcdf.setData(data);
        }
        this.setRead(true);
    }

    @Override
    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        if (this.org == null) {
            super.serialize(dataset, sink, ce, specialO);
            return;
        }
        StructureMembers sm = this.sdata.getStructureMembers();
        int count = 0;
        for (BaseType bt : this.org.getVariables()) {
            HasNetcdfVariable sm_org = (HasNetcdfVariable)bt;
            boolean isProjected = ((ServerMethods)((Object)sm_org)).isProject();
            if (isProjected) {
                StructureMembers.Member m = sm.getMember(count);
                sm_org.serialize(sink, this.sdata, m);
            }
            ++count;
        }
    }
}

