/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servers;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import opendap.dap.BaseType;
import thredds.server.opendap.servers.AbstractClause;
import thredds.server.opendap.servers.BTFunction;
import thredds.server.opendap.servers.Clause;
import thredds.server.opendap.servers.DAP2ServerSideException;
import thredds.server.opendap.servers.SubClause;
import thredds.server.opendap.servers.ValueClause;

public class BTFunctionClause
extends AbstractClause
implements SubClause {
    protected Clause parent;
    protected BTFunction function;
    protected BaseType value;

    protected BTFunctionClause(BTFunction function, List children) throws DAP2ServerSideException {
        function.checkArgs(children);
        this.function = function;
        this.children = children;
        this.constant = true;
        for (SubClause current : children) {
            current.setParent(this);
            if (current.isConstant()) continue;
            this.constant = false;
        }
        this.value = function.getReturnType(children);
        if (this.constant) {
            this.evaluate();
        }
    }

    @Override
    public Clause getParent() {
        return this.parent;
    }

    @Override
    public BaseType getValue() {
        return this.value;
    }

    @Override
    public BaseType evaluate() throws DAP2ServerSideException {
        if (!this.constant || !this.defined) {
            this.value = this.function.evaluate(this.children);
            this.defined = true;
        }
        return this.value;
    }

    @Override
    public void setParent(Clause parent) {
        this.parent = parent;
    }

    public BTFunction getFunction() {
        return this.function;
    }

    @Override
    public void printConstraint(PrintWriter os) {
        os.print(this.function.getName() + "(");
        Iterator it = this.children.iterator();
        boolean first = true;
        while (it.hasNext()) {
            ValueClause vc = (ValueClause)it.next();
            if (!first) {
                os.print(",");
            }
            vc.printConstraint(os);
            first = false;
        }
        os.print(")");
    }
}

