/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servers;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import opendap.dap.BaseType;
import opendap.dap.ConstraintException;
import opendap.dap.DAP2Exception;
import opendap.dap.DArrayDimension;
import opendap.dap.NoSuchVariableException;
import opendap.dap.parsers.ParseException;
import thredds.server.opendap.servers.Clause;
import thredds.server.opendap.servers.ClauseFactory;
import thredds.server.opendap.servers.DAP2ServerSideException;
import thredds.server.opendap.servers.SBHException;
import thredds.server.opendap.servers.SDArray;
import thredds.server.opendap.servers.SDGrid;
import thredds.server.opendap.servers.ServerDDS;
import thredds.server.opendap.servers.ServerMethods;
import thredds.server.opendap.servers.TopLevelClause;
import thredds.server.opendap.servers.parsers.CeParser;

public class CEEvaluator {
    private ServerDDS _dds;
    private final ArrayList<Clause> clauses = new ArrayList();
    private ClauseFactory clauseFactory;

    public CEEvaluator(ServerDDS dds) {
        this._dds = dds;
    }

    public CEEvaluator(ServerDDS dds, ClauseFactory clauseFactory) {
        this._dds = dds;
        this.clauseFactory = clauseFactory;
    }

    public ServerDDS getDDS() {
        return this._dds;
    }

    public void parseConstraint(String constraint, String urlencoded) throws ParseException, DAP2Exception {
        if (this.clauseFactory == null) {
            this.clauseFactory = new ClauseFactory();
        }
        try {
            CeParser.constraint_expression(this, this._dds.getFactory(), this.clauseFactory, constraint, urlencoded);
        }
        catch (ConstraintException ce) {
            ce.printStackTrace();
            throw new DAP2Exception((Exception)((Object)ce));
        }
    }

    public void appendClause(Clause c) {
        if (c != null) {
            this.clauses.add(c);
        }
    }

    public boolean removeClause(Clause c) {
        if (c != null) {
            return this.clauses.remove(c);
        }
        return false;
    }

    public final ImmutableList<Clause> getClauses() {
        return ImmutableList.copyOf(this.clauses);
    }

    public void send(String dataset, OutputStream sink, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        for (BaseType bt : this._dds.getVariables()) {
            ServerMethods s = (ServerMethods)bt;
            if (!s.isProject()) continue;
            s.serialize(dataset, (DataOutputStream)sink, this, specialO);
        }
    }

    public boolean evalClauses(Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        boolean result = true;
        for (Clause clause : this.clauses) {
            result = ((TopLevelClause)clause).evaluate();
        }
        return result;
    }

    public void markAll(boolean state) throws DAP2Exception, NoSuchVariableException, SBHException {
        for (BaseType bt : this._dds.getVariables()) {
            if (state) {
                if (bt instanceof SDArray) {
                    SDArray SDA = (SDArray)bt;
                    for (DArrayDimension dad : SDA.getDimensions()) {
                        dad.setProjection(0, 1, dad.getSize() - 1);
                    }
                } else if (bt instanceof SDGrid) {
                    SDGrid SDG = (SDGrid)bt;
                    SDArray sdgA = (SDArray)SDG.getVar(0);
                    for (DArrayDimension dad : sdgA.getDimensions()) {
                        dad.setProjection(0, 1, dad.getSize() - 1);
                    }
                }
            }
            ServerMethods s = (ServerMethods)bt;
            s.setProject(state);
        }
    }

    public void printConstraint(PrintWriter pw) {
        boolean first = true;
        for (Clause clause : this.clauses) {
            if (!first) {
                pw.print(" & ");
            }
            clause.printConstraint(pw);
            first = false;
        }
        pw.flush();
    }
}

