/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servers;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import opendap.dap.BaseType;
import opendap.dap.DSequence;
import opendap.dap.NoSuchVariableException;
import thredds.server.opendap.servers.CEEvaluator;
import thredds.server.opendap.servers.DAP2ServerSideException;
import thredds.server.opendap.servers.InvalidOperatorException;
import thredds.server.opendap.servers.RegExpException;
import thredds.server.opendap.servers.RelOps;
import thredds.server.opendap.servers.SBHException;
import thredds.server.opendap.servers.ServerMethods;

public abstract class SDSequence
extends DSequence
implements ServerMethods,
RelOps {
    private boolean Synthesized = false;
    private boolean ReadMe = false;

    public SDSequence() {
    }

    public SDSequence(String n) {
        super(n);
    }

    public List<BaseType> getRowVector() throws NoSuchVariableException {
        if (this.getRowCount() == 0) {
            ArrayList<BaseType> rv = new ArrayList<BaseType>();
            for (int i = 0; i < this.elementCount(false); ++i) {
                rv.add(this.getVar(i));
            }
            this.addRow(rv);
        }
        return this.getRow(0);
    }

    public void printDecl(PrintWriter os, String space, boolean print_semi, boolean constrained) {
        if (constrained && !this.isProject()) {
            return;
        }
        super.printDecl(os, space, print_semi, constrained);
    }

    public void printVal(PrintWriter os, String space, boolean print_decl_p) {
        if (!this.isProject()) {
            return;
        }
        if (print_decl_p) {
            this.printDecl(os, space, false, true);
            os.print(" = ");
        }
        os.print("{ ");
        try {
            boolean firstPass = true;
            for (BaseType bt : this.getRowVector()) {
                if (!((ServerMethods)bt).isProject()) continue;
                if (!firstPass) {
                    os.print(", ");
                }
                bt.printVal(os, "", false);
                firstPass = false;
            }
        }
        catch (NoSuchVariableException e) {
            os.println("Very Bad Things Happened When I Tried To Print A Row Of The Sequence: " + this.getEncodedName());
        }
        os.print(" }");
        if (print_decl_p) {
            os.println(";");
        }
    }

    @Override
    public void setProject(boolean state, boolean all) {
        this.setProjected(state);
        if (all) {
            for (BaseType bt : this.varTemplate) {
                ServerMethods sm = (ServerMethods)bt;
                sm.setProject(state);
            }
        }
    }

    @Override
    public boolean equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Equals (=) operator does not work with the type SDSequence!");
    }

    @Override
    public boolean not_equal(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Not Equals (!=) operator does not work with the type SDSequence!");
    }

    @Override
    public boolean greater(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Greater Than (>)operator does not work with the type SDSequence!");
    }

    @Override
    public boolean greater_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("GreaterThan or equals (<=) operator does not work with the type SDSequence!");
    }

    @Override
    public boolean less(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan (<) operator does not work with the type SDSequence!");
    }

    @Override
    public boolean less_eql(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("LessThan oe equals (<=) operator does not work with the type SDSequence!");
    }

    @Override
    public boolean regexp(BaseType bt) throws InvalidOperatorException, RegExpException, SBHException {
        throw new InvalidOperatorException("Regular Expression's don't work with the type SDSequence!");
    }

    @Override
    public void setSynthesized(boolean state) {
        this.Synthesized = state;
    }

    @Override
    public boolean isSynthesized() {
        return this.Synthesized;
    }

    @Override
    public void setRead(boolean state) {
        this.ReadMe = state;
    }

    public void setAllReadFlags(boolean state) {
        this.ReadMe = state;
        for (BaseType bt : this.varTemplate) {
            ServerMethods sm = (ServerMethods)bt;
            sm.setRead(state);
        }
    }

    @Override
    public boolean isRead() {
        return this.ReadMe;
    }

    @Override
    public abstract boolean read(String var1, Object var2) throws NoSuchVariableException, IOException, EOFException;

    @Override
    public void serialize(String dataset, DataOutputStream sink, CEEvaluator ce, Object specialO) throws NoSuchVariableException, DAP2ServerSideException, IOException {
        boolean moreToRead = true;
        while (moreToRead) {
            if (!this.isRead()) {
                moreToRead = this.read(dataset, specialO);
            }
            if (ce.evalClauses(specialO)) {
                this.writeMarker(sink, DSequence.START_OF_INSTANCE);
                for (BaseType bt : this.varTemplate) {
                    ServerMethods sm = (ServerMethods)bt;
                    if (!sm.isProject()) continue;
                    sm.serialize(dataset, sink, ce, specialO);
                }
            }
            if (!moreToRead) continue;
            this.setAllReadFlags(false);
        }
        this.writeMarker(sink, DSequence.END_OF_SEQUENCE);
    }

    public void printXML(PrintWriter pw, String pad, boolean constrained) {
        if (constrained && !this.isProject()) {
            return;
        }
        super.printXML(pw, pad, constrained);
    }
}

