/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servlet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DConstructor;
import opendap.dap.DString;
import opendap.dap.DVector;
import opendap.dap.NoSuchAttributeException;
import opendap.dap.PrimitiveVector;
import opendap.dap.parsers.ParseException;
import thredds.server.opendap.servers.ServerDDS;
import thredds.server.opendap.servlet.GuardedDataset;
import thredds.server.opendap.servlet.ReqState;
import thredds.server.opendap.servlet.www.dasTools;

public class GetInfoHandler {
    private static final boolean _Debug = false;
    private String infoDir = null;

    public void sendINFO(PrintWriter pw, GuardedDataset gds, ReqState rs) throws DAP2Exception, ParseException {
        String responseDoc = null;
        ServerDDS myDDS = null;
        DAS myDAS = null;
        myDDS = gds.getDDS();
        myDAS = gds.getDAS();
        this.infoDir = rs.getINFOCache(rs.getRootPath());
        responseDoc = this.loadOverrideDoc(this.infoDir, rs.getDataSet());
        if (responseDoc != null) {
            pw.print(responseDoc);
        } else {
            String user_html = this.get_user_supplied_docs(rs.getServerClassName(), rs.getDataSet());
            String global_attrs = this.buildGlobalAttributes(myDAS, myDDS);
            String variable_sum = this.buildVariableSummaries(myDAS, myDDS);
            pw.println("<html><head><title>Dataset Information</title>");
            pw.println("<style type=\"text/css\">");
            pw.println("<!-- ul {list-style-type: none;} -->");
            pw.println("</style>");
            pw.println("</head>");
            pw.println("<body>");
            if (global_attrs.length() > 0) {
                pw.println(global_attrs);
                pw.println("<hr>");
            }
            pw.println(variable_sum);
            pw.println("<hr>");
            pw.println(user_html);
            pw.println("</body></html>");
            pw.flush();
        }
    }

    public String loadOverrideDoc(String infoDir, String dataSet) throws DAP2Exception {
        StringBuilder userDoc = new StringBuilder();
        String overrideFile = dataSet + ".ovr";
        try {
            File fin = new File(infoDir + overrideFile);
            try (BufferedReader svIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fin), StandardCharsets.UTF_8));){
                boolean done = false;
                while (!done) {
                    String line = svIn.readLine();
                    if (line == null) {
                        done = true;
                        continue;
                    }
                    userDoc.append(line);
                    userDoc.append("\n");
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            userDoc.append("<h2>No Could Not Open Override Document.</h2><hr>");
            return null;
        }
        catch (IOException ioe) {
            throw new DAP2Exception(0, ioe.getMessage());
        }
        return userDoc.toString();
    }

    private String get_user_supplied_docs(String serverName, String dataSet) throws DAP2Exception {
        String line;
        boolean done;
        BufferedReader svIn;
        StringBuilder userDoc = new StringBuilder();
        try {
            File fin = new File(this.infoDir + dataSet + ".html");
            try (FileInputStream fis = new FileInputStream(fin);){
                svIn = new BufferedReader(new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8));
                try {
                    done = false;
                    while (!done) {
                        line = svIn.readLine();
                        if (line == null) {
                            done = true;
                            continue;
                        }
                        userDoc.append(line);
                        userDoc.append("\n");
                    }
                }
                finally {
                    svIn.close();
                }
            }
        }
        catch (FileNotFoundException fnfe) {
            userDoc.append("<h2>No Dataset Specific Information Available.</h2><hr>");
        }
        catch (IOException ioe) {
            throw new DAP2Exception(0, ioe.getMessage());
        }
        userDoc.append("<hr>\n");
        try {
            String serverFile = this.infoDir + serverName + ".html";
            File fin = new File(serverFile);
            svIn = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fin), StandardCharsets.UTF_8));
            try {
                done = false;
                while (!done) {
                    line = svIn.readLine();
                    if (line == null) {
                        done = true;
                        continue;
                    }
                    userDoc.append(line);
                    userDoc.append("\n");
                }
            }
            finally {
                svIn.close();
            }
        }
        catch (FileNotFoundException fnfe) {
            userDoc.append("<h2>No Server Specific Information Available.</h2><hr>");
        }
        catch (IOException ioe) {
            throw new DAP2Exception(0, ioe.getMessage());
        }
        return userDoc.toString();
    }

    private String buildGlobalAttributes(DAS das, ServerDDS dds) {
        boolean found = false;
        StringBuilder ga = new StringBuilder();
        ga.append("<h3>Dataset Information</h3>\n<table>\n");
        for (String name : das) {
            if (dasTools.nameInKillFile(name) || !dasTools.nameIsGlobal(name) && dasTools.nameInDDS(name, dds)) continue;
            try {
                AttributeTable attTable = das.getAttributeTable(name);
                if (attTable == null) continue;
                for (String attName : attTable) {
                    Attribute a = attTable.getAttribute(attName);
                    found = true;
                    ga.append("\n<tr><td align=right valign=top><b>");
                    ga.append(attName + "</b>:</td>\n");
                    ga.append("<td align=left>");
                    for (String val : a.getValues()) {
                        ga.append(val);
                        ga.append("<br>");
                    }
                    ga.append("</td></tr>\n");
                }
            }
            catch (NoSuchAttributeException noSuchAttributeException) {
            }
        }
        ga.append("</table>\n<p>\n");
        if (!found) {
            ga.setLength(0);
        }
        return ga.toString();
    }

    private String buildVariableSummaries(DAS das, ServerDDS dds) {
        StringBuilder vs = new StringBuilder();
        vs.append("<h3>Variables in this Dataset</h3>\n<table>\n");
        for (BaseType bt : dds.getVariables()) {
            vs.append("<tr>");
            vs.append(this.summarizeVariable(bt, das));
            vs.append("</tr>");
        }
        vs.append("</table>\n<p>\n");
        return vs.toString();
    }

    private String summarizeAttributes(AttributeTable attr) {
        StringBuilder vOut = new StringBuilder();
        if (attr != null) {
            for (String name : attr) {
                Attribute a = attr.getAttribute(name);
                if (a == null) continue;
                if (a.isContainer()) {
                    vOut.append("<li> <b> ");
                    vOut.append(name);
                    vOut.append(": </b> </li>\n");
                    vOut.append("<ul>\n");
                    try {
                        vOut.append(this.summarizeAttributes(a.getContainer()));
                    }
                    catch (NoSuchAttributeException noSuchAttributeException) {
                        // empty catch block
                    }
                    vOut.append("</ul>\n");
                    continue;
                }
                vOut.append("<li> <b> ");
                vOut.append(name);
                vOut.append(": </b> ");
                try {
                    int count = 0;
                    for (String val : a.getValues()) {
                        if (count > 0) {
                            vOut.append(", ");
                        }
                        vOut.append(val);
                        ++count;
                    }
                }
                catch (NoSuchAttributeException noSuchAttributeException) {
                    // empty catch block
                }
                vOut.append(" </li>\n");
            }
        }
        return vOut.toString();
    }

    private String summarizeVariable(BaseType bt, DAS das) {
        StringBuilder vOut = new StringBuilder();
        vOut.append("<td align=right valign=top><b>");
        vOut.append(bt.getEncodedName());
        vOut.append("</b>:</td>\n");
        vOut.append("<td align=left valign=top>");
        vOut.append(dasTools.fancyTypeName(bt));
        try {
            BaseType bt2;
            DVector da;
            PrimitiveVector pv;
            AttributeTable attr = das.getAttributeTable(bt.getEncodedName());
            vOut.append("\n<ul>\n");
            vOut.append(this.summarizeAttributes(attr));
            vOut.append("\n</ul>\n");
            if (bt instanceof DConstructor) {
                vOut.append("<table>\n");
                DConstructor dc = (DConstructor)bt;
                for (BaseType bt22 : dc.getVariables()) {
                    vOut.append("<tr>\n");
                    vOut.append(this.summarizeVariable(bt22, das));
                    vOut.append("</tr>\n");
                }
                vOut.append("</table>\n");
            } else if (bt instanceof DVector && (pv = (da = (DVector)bt).getPrimitiveVector()) instanceof BaseTypePrimitiveVector && !((bt2 = pv.getTemplate()) instanceof DArray) && !(bt2 instanceof DString)) {
                vOut.append("<table>\n");
                vOut.append("<tr>\n");
                vOut.append(this.summarizeVariable(bt2, das));
                vOut.append("</tr>\n");
                vOut.append("</table>\n");
            }
        }
        catch (NoSuchAttributeException noSuchAttributeException) {
            // empty catch block
        }
        vOut.append("</td>\n");
        return vOut.toString();
    }
}

