/*
 * Decompiled with CFR 0.152.
 */
package thredds.server.opendap.servlet;

class HttpUtil {
    public static final String LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    public static final String UPPERCASE = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static final String DRIVELETTERS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";

    HttpUtil() {
    }

    public static String canonjoin(String prefix, String suffix) {
        if (prefix == null) {
            prefix = "";
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = HttpUtil.canonicalpath(prefix);
        suffix = HttpUtil.canonicalpath(suffix);
        StringBuilder result = new StringBuilder();
        result.append(prefix);
        int prelen = prefix.length();
        if (prelen > 0 && result.charAt(prelen - 1) != '/') {
            result.append('/');
            ++prelen;
        }
        if (suffix.length() > 0 && suffix.charAt(0) == '/') {
            result.append(suffix.substring(1));
        } else {
            result.append(suffix);
        }
        int len = result.length();
        if (len > 0 && result.charAt(len - 1) == '/') {
            result.deleteCharAt(len - 1);
            --len;
        }
        return result.toString();
    }

    public static String canonicalpath(String path) {
        if (path == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(path);
        HttpUtil.canonicalpath(b);
        return b.toString();
    }

    public static void canonicalpath(StringBuilder s) {
        boolean isabs;
        if (s == null || s.length() == 0) {
            return;
        }
        int index = 0;
        while ((index = s.indexOf("\\", index)) >= 0) {
            s.replace(index, index + 1, "/");
        }
        boolean bl = isabs = s.charAt(0) == '/';
        while (s.length() != 0 && s.charAt(0) == '/') {
            s.deleteCharAt(0);
        }
        boolean hasdrive = HttpUtil.hasDriveLetter(s);
        if (hasdrive) {
            s.setCharAt(0, Character.toLowerCase(s.charAt(0)));
        }
        while (s.length() > 0 && s.charAt(s.length() - 1) == '/') {
            s.deleteCharAt(s.length() - 1);
        }
        if (!hasdrive && isabs) {
            s.insert(0, '/');
        }
    }

    public static String relpath(String path) {
        if (path == null) {
            return null;
        }
        StringBuilder b = new StringBuilder(path);
        HttpUtil.canonicalpath(b);
        if (b.length() > 0) {
            if (b.charAt(0) == '/') {
                b.deleteCharAt(0);
            }
            if (HttpUtil.hasDriveLetter(b)) {
                b.delete(0, 2);
            }
        }
        return b.toString();
    }

    public static boolean hasDriveLetter(String path) {
        return path != null && path.length() >= 2 && path.charAt(1) == ':' && DRIVELETTERS.indexOf(path.charAt(0)) >= 0;
    }

    protected static boolean hasDriveLetter(StringBuilder path) {
        return path.length() >= 2 && path.charAt(1) == ':' && DRIVELETTERS.indexOf(path.charAt(0)) >= 0;
    }

    public static boolean isAbsolutePath(String path) {
        return path != null && path.length() > 0 && (path.charAt(0) == '/' || HttpUtil.hasDriveLetter(path));
    }
}

