/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gempak;

import java.io.IOException;
import java.util.List;
import ucar.nc2.iosp.gempak.AbstractGempakStationFileReader;
import ucar.nc2.iosp.gempak.GempakFileReader;
import ucar.nc2.iosp.gempak.GempakParameter;
import ucar.nc2.iosp.gempak.GempakStation;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

public class GempakSurfaceFileReader
extends AbstractGempakStationFileReader {
    private static final String SFTX = "SFTX";
    static final String SFDT = "SFDT";
    public static final String SFSP = "SFSP";
    static final String STANDARD = "standard";
    private static final String CLIMATE = "climate";
    static final String SHIP = "ship";

    GempakSurfaceFileReader() {
    }

    public static GempakSurfaceFileReader getInstance(RandomAccessFile raf, boolean fullCheck) throws IOException {
        GempakSurfaceFileReader gsfr = new GempakSurfaceFileReader();
        gsfr.init(raf, fullCheck);
        return gsfr;
    }

    @Override
    protected boolean init() throws IOException {
        return this.init(true);
    }

    @Override
    protected boolean init(boolean fullCheck) throws IOException {
        if (!super.init(fullCheck)) {
            return false;
        }
        if (this.dmLabel.kftype != 1) {
            this.logError("not a surface data file ");
            return false;
        }
        String partType = this.dmLabel.kfsrce == 100 && this.dmLabel.kprt == 1 ? SFTX : SFDT;
        GempakFileReader.DMPart part = this.getPart(partType);
        if (part == null) {
            this.logError("No part named " + partType + " found");
            return false;
        }
        if (!this.readStationsAndTimes(true)) {
            this.logError("Unable to read stations and times");
            return false;
        }
        if (this.subType.equals(STANDARD)) {
            this.rf.setBufferSize(256);
        }
        return true;
    }

    @Override
    protected List<String> makeDateList(boolean uniqueTimes) {
        return super.makeDateList(!this.getFileSubType().equals(SHIP));
    }

    @Override
    protected void makeFileSubType() {
        GempakFileReader.Key key = this.findKey("SLAT");
        if (key == null) {
            throw new IllegalStateException("File does not have key=SLAT");
        }
        String latType = key.type;
        GempakFileReader.Key dateKey = this.findKey("DATE");
        this.subType = dateKey != null && !dateKey.type.equals(latType) ? (latType.equals("ROW") ? CLIMATE : STANDARD) : SHIP;
    }

    public void printOb(int row, int col) {
        GempakFileReader.RData rd;
        int stnIndex = this.getFileSubType().equals(CLIMATE) ? row : col;
        List<GempakStation> stations = this.getStations();
        if (stations.isEmpty() || stnIndex > stations.size()) {
            System.out.println("\nNo data available");
            return;
        }
        GempakStation station = this.getStations().get(stnIndex - 1);
        StringBuilder builder = new StringBuilder();
        builder.append("\nStation:\n");
        builder.append(station);
        builder.append("\nObs\n\t");
        List<GempakParameter> params = this.getParameters(SFDT);
        for (GempakParameter parm : params) {
            builder.append(StringUtil2.padLeft((String)parm.getName(), (int)7));
            builder.append("\t");
        }
        builder.append("\n");
        try {
            rd = this.DM_RDTR(row, col, SFDT);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            rd = null;
        }
        if (rd == null) {
            builder.append("No Data Available");
        } else {
            float[] data;
            builder.append("\t");
            for (float datum : data = rd.data) {
                builder.append(StringUtil2.padLeft((String)Format.formatDouble((double)datum, (int)7, (int)1), (int)7));
                builder.append("\t");
            }
            int[] header = rd.header;
            if (header.length > 0) {
                builder.append("\nOb Time = ");
                builder.append(header[0]);
            }
        }
        System.out.println(builder);
    }

    public String getSurfaceFileType() {
        return this.getFileSubType();
    }
}

