/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grid;

import java.util.Objects;
import ucar.nc2.wmo.Util;

public class GridParameter {
    protected int number;
    protected String name;
    protected String description;
    protected String unit;
    protected String cf_name;

    public GridParameter() {
        this.number = -1;
        this.name = "undefined";
        this.description = "undefined";
        this.unit = "undefined";
    }

    public GridParameter(int number, String name, String description, String unit) {
        this.number = number;
        this.name = name;
        this.setDescription(description);
        this.setUnit(unit);
    }

    public GridParameter(int center, int subcenter, int version, int number) {
        this.number = number;
        this.name = "undefined";
        this.description = "Unknown-C" + center + "-S" + subcenter + "-V" + version + ":" + number;
        this.unit = "undefined";
    }

    public GridParameter(int number, String name, String description, String unit, String cf_name) {
        this.number = number;
        this.name = name;
        this.setDescription(description);
        this.setUnit(unit);
        this.cf_name = cf_name;
    }

    public final int getNumber() {
        return this.number;
    }

    public final String getName() {
        return this.name;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getUnit() {
        return this.unit;
    }

    public String getCFname() {
        return this.cf_name;
    }

    public final void setNumber(int number) {
        this.number = number;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setDescription(String description) {
        this.description = Util.cleanName((String)description);
    }

    public final void setUnit(String unit) {
        this.unit = Util.cleanUnit((String)unit);
    }

    public String toString() {
        return "GridParameter{number=" + this.number + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", unit='" + this.unit + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GridParameter that = (GridParameter)o;
        if (this.number != that.number) {
            return false;
        }
        if (!Objects.equals(this.cf_name, that.cf_name)) {
            return false;
        }
        if (!Objects.equals(this.description, that.description)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        return Objects.equals(this.unit, that.unit);
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        result = 31 * result + (this.cf_name != null ? this.cf_name.hashCode() : 0);
        return result;
    }
}

