/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.geotiff;

import java.io.Closeable;
import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.IsMissingEvaluator;
import ucar.ma2.MAMath;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.geotiff.FieldType;
import ucar.nc2.geotiff.GeoKey;
import ucar.nc2.geotiff.GeoTiff;
import ucar.nc2.geotiff.IFDEntry;
import ucar.nc2.geotiff.Tag;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse;

public class GeotiffWriter
implements Closeable {
    protected GeoTiff geotiff;
    protected short pageNumber = 1;

    public GeotiffWriter(String fileOut) {
        this.geotiff = new GeoTiff(fileOut);
    }

    @Override
    public void close() throws IOException {
        this.geotiff.close();
    }

    public void writeGrid(GridDataset dataset, GridDatatype grid, Array data, boolean greyScale) throws IOException {
        GridCoordSystem gcs = grid.getCoordinateSystem();
        if (!gcs.isRegularSpatial()) {
            throw new IllegalArgumentException("Must have 1D x and y axes for " + grid.getFullName());
        }
        CoordinateAxis1D xaxis = (CoordinateAxis1D)gcs.getXHorizAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
        double scaler = xaxis.getUnitsString().equalsIgnoreCase("km") ? 1000.0 : 1.0;
        double xStart = xaxis.getCoordEdge(0) * scaler;
        double yStart = yaxis.getCoordEdge(0) * scaler;
        double xInc = xaxis.getIncrement() * scaler;
        double yInc = Math.abs(yaxis.getIncrement()) * scaler;
        if (yaxis.getCoordValue(0) < yaxis.getCoordValue(1)) {
            data = data.flip(0);
            yStart = yaxis.getCoordEdge((int)yaxis.getSize()) * scaler;
        }
        if (!xaxis.isRegular() || !yaxis.isRegular()) {
            throw new IllegalArgumentException("Must be evenly spaced grid = " + grid.getFullName());
        }
        if (this.pageNumber > 1) {
            this.geotiff.initTags();
        }
        this.writeGrid(grid, data, greyScale, xStart, yStart, xInc, yInc, this.pageNumber);
        this.pageNumber = (short)(this.pageNumber + 1);
    }

    void writeGrid(GridDatatype grid, Array data, boolean greyScale, double xStart, double yStart, double xInc, double yInc, int imageNumber) throws IOException {
        int nextStart;
        ArrayByte result;
        GridCoordSystem gcs = grid.getCoordinateSystem();
        if (!(gcs.isLatLon() || gcs.getProjection() instanceof LambertConformal || gcs.getProjection() instanceof Stereographic || gcs.getProjection() instanceof Mercator || gcs.getProjection() instanceof AlbersEqualAreaEllipse || gcs.getProjection() instanceof AlbersEqualArea)) {
            throw new IllegalArgumentException("Unsupported projection = " + gcs.getProjection().getClass().getName());
        }
        MAMath.MinMax dataMinMax = grid.getMinMaxSkipMissingData(data);
        if (greyScale) {
            result = this.replaceMissingValuesAndScale((IsMissingEvaluator)grid, data, dataMinMax);
            nextStart = this.geotiff.writeData((byte[])result.getStorage(), imageNumber);
        } else {
            result = this.replaceMissingValues((IsMissingEvaluator)grid, data, dataMinMax);
            nextStart = this.geotiff.writeData((float[])result.getStorage(), imageNumber);
        }
        int height = data.getShape()[0];
        int width = data.getShape()[1];
        this.writeMetadata(greyScale, xStart, yStart, xInc, yInc, height, width, imageNumber, nextStart, dataMinMax, (Projection)gcs.getProjection());
    }

    private void writeMetadata(boolean greyScale, double xStart, double yStart, double xInc, double yInc, int height, int width, int imageNumber, int nextStart, MAMath.MinMax dataMinMax, Projection proj) throws IOException {
        this.geotiff.addTag(new IFDEntry(Tag.ImageWidth, FieldType.SHORT).setValue(width));
        this.geotiff.addTag(new IFDEntry(Tag.ImageLength, FieldType.SHORT).setValue(height));
        int ff = 2;
        int page = imageNumber - 1;
        this.geotiff.addTag(new IFDEntry(Tag.NewSubfileType, FieldType.SHORT).setValue(ff));
        this.geotiff.addTag(new IFDEntry(Tag.PageNumber, FieldType.SHORT).setValue(page, 2));
        this.geotiff.addTag(new IFDEntry(Tag.RowsPerStrip, FieldType.SHORT).setValue(1));
        int elemSize = greyScale ? 1 : 4;
        int[] soffset = new int[height];
        int[] sbytecount = new int[height];
        soffset[0] = imageNumber == 1 ? 8 : nextStart;
        sbytecount[0] = width * elemSize;
        for (int i = 1; i < height; ++i) {
            soffset[i] = soffset[i - 1] + width * elemSize;
            sbytecount[i] = width * elemSize;
        }
        this.geotiff.addTag(new IFDEntry(Tag.StripByteCounts, FieldType.LONG, width).setValue(sbytecount));
        this.geotiff.addTag(new IFDEntry(Tag.StripOffsets, FieldType.LONG, width).setValue(soffset));
        this.geotiff.addTag(new IFDEntry(Tag.Orientation, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.Compression, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.Software, FieldType.ASCII).setValue("nc2geotiff"));
        this.geotiff.addTag(new IFDEntry(Tag.PhotometricInterpretation, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.PlanarConfiguration, FieldType.SHORT).setValue(1));
        if (greyScale) {
            this.geotiff.addTag(new IFDEntry(Tag.BitsPerSample, FieldType.SHORT).setValue(8));
            this.geotiff.addTag(new IFDEntry(Tag.SamplesPerPixel, FieldType.SHORT).setValue(1));
            this.geotiff.addTag(new IFDEntry(Tag.XResolution, FieldType.RATIONAL).setValue(1, 1));
            this.geotiff.addTag(new IFDEntry(Tag.YResolution, FieldType.RATIONAL).setValue(1, 1));
            this.geotiff.addTag(new IFDEntry(Tag.ResolutionUnit, FieldType.SHORT).setValue(1));
        } else {
            this.geotiff.addTag(new IFDEntry(Tag.BitsPerSample, FieldType.SHORT).setValue(32));
            this.geotiff.addTag(new IFDEntry(Tag.SampleFormat, FieldType.SHORT).setValue(3));
            this.geotiff.addTag(new IFDEntry(Tag.SamplesPerPixel, FieldType.SHORT).setValue(1));
            float min = (float)dataMinMax.min;
            float max = (float)dataMinMax.max;
            this.geotiff.addTag(new IFDEntry(Tag.SMinSampleValue, FieldType.FLOAT).setValue(min));
            this.geotiff.addTag(new IFDEntry(Tag.SMaxSampleValue, FieldType.FLOAT).setValue(max));
            this.geotiff.addTag(new IFDEntry(Tag.GDALNoData, FieldType.FLOAT).setValue(min - 1.0f));
        }
        this.geotiff.setTransform(xStart, yStart, xInc, yInc);
        if (proj instanceof LatLonProjection) {
            this.addLatLonTags();
        } else if (proj instanceof LambertConformal) {
            this.addLambertConformalTags((LambertConformal)proj, xStart, yStart);
        } else if (proj instanceof Stereographic) {
            this.addPolarStereographicTags((Stereographic)proj, xStart, yStart);
        } else if (proj instanceof Mercator) {
            this.addMercatorTags((Mercator)proj);
        } else if (proj instanceof TransverseMercator) {
            this.addTransverseMercatorTags((TransverseMercator)proj);
        } else if (proj instanceof AlbersEqualArea) {
            this.addAlbersEqualAreaTags((AlbersEqualArea)proj);
        } else if (proj instanceof AlbersEqualAreaEllipse) {
            this.addAlbersEqualAreaEllipseTags((AlbersEqualAreaEllipse)proj);
        } else {
            throw new IllegalArgumentException("Unsupported projection = " + proj.getClass().getName());
        }
        this.geotiff.writeMetadata(imageNumber);
    }

    private ArrayFloat replaceMissingValues(IsMissingEvaluator grid, Array data, MAMath.MinMax dataMinMax) {
        float minValue = (float)(dataMinMax.min - 1.0);
        ArrayFloat floatArray = (ArrayFloat)Array.factory((DataType)DataType.FLOAT, (int[])data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator floatIter = floatArray.getIndexIterator();
        while (dataIter.hasNext()) {
            float v = dataIter.getFloatNext();
            if (grid.isMissing((double)v)) {
                v = minValue;
            }
            floatIter.setFloatNext(v);
        }
        return floatArray;
    }

    private ArrayByte replaceMissingValuesAndScale(IsMissingEvaluator grid, Array data, MAMath.MinMax dataMinMax) {
        double scale = 254.0 / (dataMinMax.max - dataMinMax.min);
        ArrayByte byteArray = (ArrayByte)Array.factory((DataType)DataType.BYTE, (int[])data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator resultIter = byteArray.getIndexIterator();
        while (dataIter.hasNext()) {
            byte bv;
            double v = dataIter.getDoubleNext();
            if (grid.isMissing(v)) {
                bv = 0;
            } else {
                int iv = (int)((v - dataMinMax.min) * scale + 1.0);
                bv = (byte)(iv & 0xFF);
            }
            resultIter.setByteNext(bv);
        }
        return byteArray;
    }

    private void addLatLonTags1() {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Geographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogGeodeticDatumGeoKey, GeoKey.TagValue.GeogGeodeticDatum6267));
    }

    private void addLatLonTags() {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Geographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogPrimeMeridianGeoKey, GeoKey.TagValue.GeogPrimeMeridian_GREENWICH));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
    }

    private void addPolarStereographicTags(Stereographic proj, double FalseEasting, double FalseNorthing) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Snyder"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_Stereographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCenterLongGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, 90.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addLambertConformalTags(LambertConformal proj, double FalseEasting, double FalseNorthing) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Snyder"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_LambertConfConic_2SP));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel1GeoKey, proj.getParallelOne()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel2GeoKey, proj.getParallelTwo()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCenterLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addMercatorTags(Mercator proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Mercator"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_Mercator));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getParallel()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addTransverseMercatorTags(TransverseMercator proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Transvers Mercator"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_TransverseMercator));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getTangentLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, proj.getScale()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addAlbersEqualAreaEllipseTags(AlbersEqualAreaEllipse proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogSemiMajorAxisGeoKey, proj.getEarth().getMajor()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogSemiMinorAxisGeoKey, proj.getEarth().getMinor()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Albers Conial Equal Area"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_AlbersEqualAreaEllipse));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel1GeoKey, proj.getParallelOne()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel2GeoKey, proj.getParallelTwo()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addAlbersEqualAreaTags(AlbersEqualArea proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Albers Conial Equal Area"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_AlbersConicalEqualArea));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel1GeoKey, proj.getParallelOne()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel2GeoKey, proj.getParallelTwo()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void dump(Array data, int col) {
        int[] shape = data.getShape();
        Index ima = data.getIndex();
        for (int j = 0; j < shape[0]; ++j) {
            float dd = data.getFloat(ima.set(j, col));
            System.out.println(j + " value= " + dd);
        }
    }

    private double geoShiftGetXstart(Array lon, double inc) {
        Index ilon = lon.getIndex();
        int[] lonShape = lon.getShape();
        IndexIterator lonIter = lon.getIndexIterator();
        LatLonPointImpl p0 = new LatLonPointImpl(0.0, (double)lon.getFloat(ilon.set(0)));
        LatLonPointImpl pN = new LatLonPointImpl(0.0, (double)lon.getFloat(ilon.set(lonShape[0] - 1)));
        double xlon = p0.getLongitude();
        while (lonIter.hasNext()) {
            float l = lonIter.getFloatNext();
            LatLonPointImpl pn = new LatLonPointImpl(0.0, (double)l);
            if (!(pn.getLongitude() < xlon)) continue;
            xlon = pn.getLongitude();
        }
        if (p0.getLongitude() == pN.getLongitude()) {
            xlon -= inc;
        }
        return xlon;
    }

    public void writeGrid(GeoReferencedArray array, boolean greyScale) throws IOException {
        int nextStart;
        ArrayByte result;
        CoverageCoordSys gcs = array.getCoordSysForData();
        if (!gcs.isRegularSpatial()) {
            throw new IllegalArgumentException("Must have 1D x and y axes for " + array.getCoverageName());
        }
        ProjectionImpl proj = gcs.getProjection();
        CoverageCoordAxis1D xaxis = (CoverageCoordAxis1D)gcs.getXAxis();
        CoverageCoordAxis1D yaxis = (CoverageCoordAxis1D)gcs.getYAxis();
        double scaler = xaxis.getUnits().equalsIgnoreCase("km") ? 1000.0 : 1.0;
        double xStart = xaxis.getCoordEdge1(0) * scaler;
        double yStart = yaxis.getCoordEdge1(0) * scaler;
        double xInc = xaxis.getResolution() * scaler;
        double yInc = Math.abs(yaxis.getResolution()) * scaler;
        Array data = array.getData().reduce();
        if (yaxis.getCoordMidpoint(0) < yaxis.getCoordMidpoint(1)) {
            data = data.flip(0);
            yStart = yaxis.getCoordEdgeLast();
        }
        if (this.pageNumber > 1) {
            this.geotiff.initTags();
        }
        MAMath.MinMax dataMinMax = MAMath.getMinMaxSkipMissingData((Array)data, (IsMissingEvaluator)array);
        if (greyScale) {
            result = this.replaceMissingValuesAndScale((IsMissingEvaluator)array, data, dataMinMax);
            nextStart = this.geotiff.writeData((byte[])result.getStorage(), (int)this.pageNumber);
        } else {
            result = this.replaceMissingValues((IsMissingEvaluator)array, data, dataMinMax);
            nextStart = this.geotiff.writeData((float[])result.getStorage(), (int)this.pageNumber);
        }
        int height = data.getShape()[0];
        int width = data.getShape()[1];
        this.writeMetadata(greyScale, xStart, yStart, xInc, yInc, height, width, this.pageNumber, nextStart, dataMinMax, (Projection)proj);
        this.pageNumber = (short)(this.pageNumber + 1);
    }
}

