/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.noaa;

import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayScalar;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.util.TableParser;

public class StructureDataAscii
extends StructureData {
    protected String line;

    public StructureDataAscii(StructureMembers members, String line) {
        super(members);
        this.line = line;
    }

    public Array getArray(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        if (m.getDataType() == DataType.STRING) {
            String result = (String)f.parse(this.line);
            return Array.factory((DataType)DataType.STRING, (int[])new int[0], (Object)new Object[]{result.trim()});
        }
        if (m.getDataType() == DataType.SEQUENCE) {
            return this.getArraySequence(m);
        }
        if (!m.isScalar()) {
            if (m.getDataType() == DataType.FLOAT) {
                float[] ja = this.getJavaArrayFloat(m);
                return Array.factory((DataType)DataType.FLOAT, (int[])m.getShape(), (Object)ja);
            }
            if (m.getDataType() == DataType.CHAR) {
                char[] ja = this.getJavaArrayChar(m);
                return Array.factory((DataType)DataType.CHAR, (int[])m.getShape(), (Object)ja);
            }
            if (m.getDataType() == DataType.BYTE) {
                byte[] ja = this.getJavaArrayByte(m);
                return Array.factory((DataType)DataType.BYTE, (int[])m.getShape(), (Object)ja);
            }
        }
        Object result = f.parse(this.line);
        if (m.getDataType() == DataType.CHAR) {
            return new ArrayChar((String)result);
        }
        return new ArrayScalar(result, m.getDataType().isUnsigned());
    }

    public float convertScalarFloat(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return ((Number)f.parse(this.line)).floatValue();
    }

    public double convertScalarDouble(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return ((Number)f.parse(this.line)).doubleValue();
    }

    public int convertScalarInt(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return ((Number)f.parse(this.line)).intValue();
    }

    public long convertScalarLong(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return ((Number)f.parse(this.line)).longValue();
    }

    public double getScalarDouble(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return (Double)f.parse(this.line);
    }

    public double[] getJavaArrayDouble(StructureMembers.Member m) {
        return new double[0];
    }

    public float getScalarFloat(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        Object result = f.parse(this.line);
        return result instanceof Float ? ((Float)f.parse(this.line)).floatValue() : ((Double)f.parse(this.line)).floatValue();
    }

    public float[] getJavaArrayFloat(StructureMembers.Member m) {
        int n = m.getSize();
        float[] result = new float[n];
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        for (int i = 0; i < n; ++i) {
            Float val = (Float)f.parse(this.line, i * 8);
            result[i] = val == null ? Float.NaN : val.floatValue();
        }
        return result;
    }

    public byte getScalarByte(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return (Byte)f.parse(this.line);
    }

    public byte[] getJavaArrayByte(StructureMembers.Member m) {
        int n = m.getSize();
        byte[] result = new byte[n];
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        for (int i = 0; i < n; ++i) {
            String s = (String)f.parse(this.line, i * 8);
            result[i] = s == null ? (byte)0 : (byte)s.charAt(0);
        }
        return result;
    }

    public int getScalarInt(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return (Integer)f.parse(this.line);
    }

    public int[] getJavaArrayInt(StructureMembers.Member m) {
        return new int[0];
    }

    public short getScalarShort(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return (Short)f.parse(this.line);
    }

    public short[] getJavaArrayShort(StructureMembers.Member m) {
        return new short[0];
    }

    public long getScalarLong(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return (Long)f.parse(this.line);
    }

    public long[] getJavaArrayLong(StructureMembers.Member m) {
        return new long[0];
    }

    public char getScalarChar(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        String result = (String)f.parse(this.line);
        return result.charAt(0);
    }

    public char[] getJavaArrayChar(StructureMembers.Member m) {
        int n = m.getSize();
        char[] result = new char[n];
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        for (int i = 0; i < n; ++i) {
            String s = (String)f.parse(this.line, i * 8);
            result[i] = s == null ? (char)'\u0000' : s.charAt(0);
        }
        return result;
    }

    public String getScalarString(StructureMembers.Member m) {
        TableParser.Field f = (TableParser.Field)m.getDataObject();
        return ((String)f.parse(this.line)).trim();
    }

    public String[] getJavaArrayString(StructureMembers.Member m) {
        return new String[]{this.getScalarString(m)};
    }

    public StructureData getScalarStructure(StructureMembers.Member m) {
        return null;
    }

    public ArrayStructure getArrayStructure(StructureMembers.Member m) {
        return null;
    }

    public ArraySequence getArraySequence(StructureMembers.Member m) {
        return null;
    }
}

