/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.s3;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.services.s3.model.HeadObjectResponse;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.ReadableRemoteFile;
import ucar.unidata.io.RemoteRandomAccessFile;
import ucar.unidata.io.s3.CdmS3Client;
import ucar.unidata.io.s3.CdmS3Uri;
import ucar.unidata.io.spi.RandomAccessFileProvider;

public final class S3RandomAccessFile
extends RemoteRandomAccessFile
implements ReadableRemoteFile,
Closeable {
    private static final int s3BufferSize = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.bufferSize", String.valueOf(262144)));
    private static final long s3MaxReadCacheSize = Long.parseLong(System.getProperty("ucar.unidata.io.s3.maxReadCacheSize", String.valueOf(0xA00000L)));
    private final CdmS3Uri uri;
    private S3Client client;
    private HeadObjectResponse objectHeadResponse;

    private S3RandomAccessFile(String url) throws IOException {
        super(url, s3BufferSize, s3MaxReadCacheSize);
        try {
            this.uri = new CdmS3Uri(url);
        }
        catch (URISyntaxException urie) {
            throw new IOException(urie.getCause());
        }
        Preconditions.checkState((boolean)this.uri.getKey().isPresent(), (Object)"The cdmS3Uri must reference an object - object key is missing.");
        this.client = CdmS3Client.acquire(this.uri);
        HeadObjectRequest headdObjectRequest = (HeadObjectRequest)HeadObjectRequest.builder().bucket(this.uri.getBucket()).key(this.uri.getKey().get()).build();
        this.objectHeadResponse = this.client.headObject(headdObjectRequest);
    }

    public void closeRemote() {
        this.client = null;
        this.objectHeadResponse = null;
    }

    public int readRemote(long pos, byte[] buff, int offset, int len) throws IOException {
        String range = String.format("bytes=%d-%d", pos, pos + (long)len);
        GetObjectRequest rangeObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(this.uri.getBucket()).key(this.uri.getKey().get()).range(range).build();
        ResponseBytes objectPortion = this.client.getObjectAsBytes(rangeObjectRequest);
        int totalBytes = 0;
        try (InputStream objectData = objectPortion.asInputStream();){
            int bytes = objectData.read(buff, offset + totalBytes, len - totalBytes);
            while (bytes > 0 && len - totalBytes > 0) {
                bytes = objectData.read(buff, offset + (totalBytes += bytes), len - totalBytes);
            }
        }
        return totalBytes;
    }

    static int getDefaultRemoteFileTimeout() {
        return 10000;
    }

    public long length() {
        return this.objectHeadResponse.contentLength();
    }

    public long getLastModified() {
        return this.objectHeadResponse.lastModified().toEpochMilli();
    }

    public String getLocation() {
        return this.uri.toString();
    }

    public String getObjectName() {
        return this.uri.getKey().get();
    }

    public static class Provider
    implements RandomAccessFileProvider {
        public boolean isOwnerOf(String location) {
            return location.startsWith("cdms3:") || location.startsWith("s3:");
        }

        public RandomAccessFile open(String location) throws IOException {
            return new S3RandomAccessFile(location);
        }
    }
}

