/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.s3;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.IOException;
import java.net.URISyntaxException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProviderChain;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.http.SdkHttpClient;
import software.amazon.awssdk.http.apache.ApacheHttpClient;
import software.amazon.awssdk.profiles.ProfileFile;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import ucar.unidata.io.s3.CdmS3Uri;
import ucar.unidata.io.s3.S3RandomAccessFile;

public class CdmS3Client {
    private static final Logger logger;
    private static final String AWS_REGION_ENV_VAR_NAME = "AWS_REGION";
    private static final String AWS_REGION_PROP_NAME = "aws.region";
    private static final int maxConnections;
    private static final int connectionTimeout;
    private static final int socketTimeout;
    private static final LoadingCache<CdmS3Uri, S3Client> s3ClientCache;
    private static boolean useCache;

    public static S3Client acquire(String uri) throws IOException {
        CdmS3Uri cdmS3Uri;
        try {
            cdmS3Uri = new CdmS3Uri(uri);
        }
        catch (URISyntaxException urie) {
            throw new IOException("Error making a CdmS3Uri from:" + uri, urie);
        }
        return CdmS3Client.acquire(cdmS3Uri);
    }

    public static S3Client acquire(CdmS3Uri uri) throws IOException {
        S3Client s3Client;
        CdmS3Uri key = CdmS3Client.makeKey(uri);
        if (key == null) {
            throw new IOException("Failed to make cache key from the given URI");
        }
        try {
            s3Client = useCache ? (S3Client)s3ClientCache.get((Object)key) : CdmS3Client.createS3Client(uri);
        }
        catch (ExecutionException e) {
            throw new IOException("Error obtaining S3Client from the cache.", e.getCause());
        }
        return s3Client;
    }

    static void enableCache(boolean enableCache) {
        useCache = enableCache;
    }

    private static CdmS3Uri makeKey(CdmS3Uri cdmS3Uri) {
        int chop;
        CdmS3Uri bucketUri = null;
        String bucketUriString = cdmS3Uri.toString();
        if (cdmS3Uri.getKey().isPresent() && (chop = bucketUriString.lastIndexOf("?" + cdmS3Uri.getKey().get())) > 0) {
            bucketUriString = bucketUriString.substring(0, chop);
        }
        try {
            bucketUri = new CdmS3Uri(bucketUriString);
        }
        catch (URISyntaxException e) {
            bucketUri = null;
        }
        return bucketUri;
    }

    private static S3Client createS3Client(CdmS3Uri uri) {
        Optional<Region> profileRegion = ProfileFile.defaultProfileFile().profile("default").map(p -> (String)p.properties().get("region")).map(Region::of);
        if (!profileRegion.isPresent()) {
            logger.debug("Checking system property {} for Region.", (Object)AWS_REGION_PROP_NAME);
            String regionName = System.getProperty(AWS_REGION_PROP_NAME);
            if (regionName == null) {
                logger.debug("Checking environmental variable {} for Region.", (Object)AWS_REGION_ENV_VAR_NAME);
                regionName = System.getenv(AWS_REGION_ENV_VAR_NAME);
            }
            if (regionName != null) {
                logger.debug("Region found: {}", (Object)regionName);
                profileRegion = Optional.ofNullable(Region.of((String)regionName));
            }
        }
        ApacheHttpClient.Builder httpConfig = ApacheHttpClient.builder().maxConnections(Integer.valueOf(maxConnections)).connectionTimeout(Duration.ofMillis(connectionTimeout)).socketTimeout(Duration.ofMillis(socketTimeout));
        S3ClientBuilder s3ClientBuilder = (S3ClientBuilder)S3Client.builder().httpClientBuilder((SdkHttpClient.Builder)httpConfig);
        uri.getEndpoint().ifPresent(arg_0 -> ((S3ClientBuilder)s3ClientBuilder).endpointOverride(arg_0));
        AwsCredentialsProviderChain.Builder cdmCredentialsProviderChainBuilder = AwsCredentialsProviderChain.builder();
        if (uri.getProfile().isPresent()) {
            String profileName = uri.getProfile().get();
            ProfileCredentialsProvider namedProfileCredentials = ProfileCredentialsProvider.builder().profileName(profileName).build();
            cdmCredentialsProviderChainBuilder.addCredentialsProvider((AwsCredentialsProvider)namedProfileCredentials);
            Optional<Region> namedProfileRegion = ProfileFile.defaultProfileFile().profile(profileName).map(p -> (String)p.properties().get("region")).map(Region::of);
            if (namedProfileRegion.isPresent()) {
                logger.debug("Region {} found for profile {} - will be using this region.", (Object)namedProfileRegion.get(), (Object)profileName);
                profileRegion = namedProfileRegion;
            }
        }
        cdmCredentialsProviderChainBuilder.addCredentialsProvider((AwsCredentialsProvider)DefaultCredentialsProvider.create());
        cdmCredentialsProviderChainBuilder.addCredentialsProvider((AwsCredentialsProvider)AnonymousCredentialsProvider.create());
        AwsCredentialsProviderChain cdmCredentialsProviderChain = cdmCredentialsProviderChainBuilder.build();
        s3ClientBuilder.credentialsProvider((AwsCredentialsProvider)cdmCredentialsProviderChain);
        s3ClientBuilder.region(profileRegion.orElse(Region.AWS_GLOBAL));
        return (S3Client)s3ClientBuilder.build();
    }

    static {
        s3ClientCache = CacheBuilder.newBuilder().removalListener((RemovalListener)new RemovalListener<CdmS3Uri, S3Client>(){

            public void onRemoval(RemovalNotification<CdmS3Uri, S3Client> entry) {
                ((S3Client)entry.getValue()).close();
            }
        }).build((CacheLoader)new CacheLoader<CdmS3Uri, S3Client>(){

            public S3Client load(@Nonnull CdmS3Uri key) {
                return CdmS3Client.createS3Client(key);
            }
        });
        logger = LoggerFactory.getLogger(CdmS3Client.class);
        maxConnections = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.httpMaxConnections", "128"));
        connectionTimeout = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.connectionTimeout", String.valueOf(S3RandomAccessFile.getDefaultRemoteFileTimeout())));
        socketTimeout = Integer.parseInt(System.getProperty("ucar.unidata.io.s3.socketTimeout", "100000"));
        useCache = true;
    }
}

