/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util.test;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.invoke.MethodHandles;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.IOIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCCC;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.TrajectoryProfileFeature;
import ucar.nc2.ft.TrajectoryProfileFeatureCollection;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.nc2.ft.point.DsgCollectionHelper;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.write.Ncdump;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.util.StringUtil2;

public class CheckPointFeatureDataset {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static boolean showStructureData = false;
    private static boolean showAll = false;
    private final String location;
    private final FeatureType ftype;
    private final boolean show;

    public CheckPointFeatureDataset(String location, FeatureType ftype, boolean show) {
        this.location = location;
        this.ftype = ftype;
        this.show = show;
    }

    public int check() throws IOException {
        return this.checkPointFeatureDataset(this.location, this.ftype, this.show);
    }

    private int checkPointFeatureDataset(String location, FeatureType type, boolean show) throws IOException {
        File fileIn = new File(location);
        String absIn = fileIn.getCanonicalPath();
        absIn = StringUtil2.replace((String)absIn, (String)"\\", (String)"/");
        System.out.printf("================ TestPointFeatureCollection read %s %n", absIn);
        File cwd = new File(".");
        System.out.printf("**** CWD = %s%n", cwd.getAbsolutePath());
        File f = new File(absIn);
        System.out.printf("**** %s = %s%n", f.getAbsolutePath(), f.exists());
        Formatter out = new Formatter();
        try (FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)type, (String)location, null, (Formatter)out);){
            if (fdataset == null) {
                System.out.printf("**failed on %s %n --> %s %n", location, out);
                assert (false);
            }
            if (showAll) {
                System.out.printf("----------- testPointDataset getDetailInfo -----------------%n", new Object[0]);
                fdataset.getDetailInfo(out);
                System.out.printf("%s %n", out);
            } else {
                System.out.printf("  Feature Type %s %n", fdataset.getFeatureType());
            }
            int n = CheckPointFeatureDataset.checkPointFeatureDataset(fdataset, show);
            return n;
        }
    }

    public static int checkPointFeatureDataset(FeatureDataset fdataset, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        CalendarDate d1 = fdataset.getCalendarDateStart();
        CalendarDate d2 = fdataset.getCalendarDateEnd();
        if (d1 != null && d2 != null) {
            Assert.assertTrue((String)"calendar date min <= max", (d1.isBefore(d2) || d1.equals((Object)d2) ? 1 : 0) != 0);
        }
        List dataVars = fdataset.getDataVariables();
        Assert.assertNotNull((String)"fdataset.getDataVariables()", (Object)dataVars);
        for (Object v : dataVars) {
            Assert.assertNotNull((String)v.getShortName(), (Object)fdataset.getDataVariable(v.getShortName()));
        }
        Assert.assertTrue((String)"fdataset instanceof FeatureDatasetPoint", (boolean)(fdataset instanceof FeatureDatasetPoint));
        FeatureDatasetPoint fdpoint = (FeatureDatasetPoint)fdataset;
        for (DsgFeatureCollection fc : fdpoint.getPointFeatureCollectionList()) {
            CheckPointFeatureDataset.checkDsgFeatureCollection(fc);
            if (fc instanceof PointFeatureCollection) {
                PointFeatureCollection pfc = (PointFeatureCollection)fc;
                count = CheckPointFeatureDataset.checkPointFeatureCollection(pfc, show);
                Assert.assertEquals((String)"PointFeatureCollection getData count = size", (long)count, (long)pfc.size());
            } else if (fc instanceof StationTimeSeriesFeatureCollection) {
                count = CheckPointFeatureDataset.checkStationFeatureCollection((StationTimeSeriesFeatureCollection)fc);
            } else if (fc instanceof StationProfileFeatureCollection) {
                count = CheckPointFeatureDataset.checkStationProfileFeatureCollection((StationProfileFeatureCollection)fc, show);
                if (showStructureData) {
                    CheckPointFeatureDataset.showStructureData((PointFeatureCCC)((StationProfileFeatureCollection)fc));
                }
            } else {
                count = fc instanceof TrajectoryProfileFeatureCollection ? CheckPointFeatureDataset.checkSectionFeatureCollection((TrajectoryProfileFeatureCollection)fc, show) : (fc instanceof ProfileFeatureCollection ? CheckPointFeatureDataset.checkProfileFeatureCollection((ProfileFeatureCollection)fc, show) : CheckPointFeatureDataset.checkOther(fc, show));
            }
            CheckPointFeatureDataset.checkInfo(fc);
        }
        long took = System.currentTimeMillis() - start;
        System.out.printf(" nobs=%d took= %d msec%n", count, took);
        return count;
    }

    static void checkDsgFeatureCollection(DsgFeatureCollection dsg) throws IOException {
        String what = dsg.getClass().getName();
        Assert.assertNotNull((String)(what + " name"), (Object)dsg.getName());
        Assert.assertNotNull((String)(what + " featureTYpe"), (Object)dsg.getCollectionFeatureType());
        Assert.assertNotNull((String)(what + " timeUnit"), (Object)dsg.getTimeUnit());
    }

    static void checkInfo(DsgFeatureCollection dsg) throws IOException {
        Assert.assertNotNull((Object)dsg.getBoundingBox());
        Assert.assertNotNull((Object)dsg.getCalendarDateRange());
        Assert.assertNotNull((Object)(dsg.size() > 0 ? 1 : 0));
    }

    static int checkPointFeatureCollection(PointFeatureCollection pfc, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int counts = 0;
        for (PointFeature pf : pfc) {
            CheckPointFeatureDataset.checkPointFeature(pf, pfc.getTimeUnit());
            ++counts;
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testPointFeatureCollection subset count= " + counts + " full iter took= " + took + " msec");
        }
        CheckPointFeatureDataset.checkPointFeatureCollectionBB(pfc, show);
        return counts;
    }

    static int checkProfileFeatureCollection(ProfileFeatureCollection profileFeatureCollection, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        HashSet<String> profileNames = new HashSet<String>();
        for (ProfileFeature profile : profileFeatureCollection) {
            CheckPointFeatureDataset.checkDsgFeatureCollection((DsgFeatureCollection)profile);
            Assert.assertNotNull((String)"ProfileFeature time", (Object)profile.getTime());
            Assert.assertNotNull((String)"ProfileFeature latlon", (Object)profile.getLatLon());
            Assert.assertNotNull((String)"ProfileFeature featureData", (Object)profile.getFeatureData());
            Assert.assertTrue((!profileNames.contains(profile.getName()) ? 1 : 0) != 0);
            profileNames.add(profile.getName());
            count += CheckPointFeatureDataset.checkPointFeatureCollection((PointFeatureCollection)profile, show);
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testStationProfileFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        return count;
    }

    static int checkStationFeatureCollection(StationTimeSeriesFeatureCollection sfc) throws IOException {
        System.out.printf("--------------------------\nComplete Iteration for %s %n", sfc.getName());
        int countStns = CheckPointFeatureDataset.countLocations(sfc);
        LatLonRect bb = sfc.getBoundingBox();
        Assert.assertNotNull((Object)bb);
        LatLonRect bb2 = new LatLonRect.Builder(bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0).build();
        System.out.println(" BB Subset= " + bb2.toString2());
        StationTimeSeriesFeatureCollection sfcSub = sfc.subset(bb2);
        int countSub = CheckPointFeatureDataset.countLocations(sfcSub);
        Assert.assertTrue((countSub <= countStns ? 1 : 0) != 0);
        System.out.println("  nobs= " + sfcSub.size());
        System.out.println("Flatten= " + bb2.toString2());
        PointFeatureCollection flatten = sfc.flatten(bb2, null);
        int countFlat = CheckPointFeatureDataset.countLocations(flatten);
        assert (countFlat <= countStns);
        flatten = sfc.flatten(null, null, null);
        return CheckPointFeatureDataset.countObs(flatten);
    }

    static int countLocations(StationTimeSeriesFeatureCollection sfc) throws IOException {
        System.out.printf(" Station List Size = %d %n", sfc.getStationFeatures().size());
        HashMap<String, StationTimeSeriesFeature> stns = new HashMap<String, StationTimeSeriesFeature>(5000);
        HashMap<MyLocation, StationTimeSeriesFeature> locs = new HashMap<MyLocation, StationTimeSeriesFeature>(5000);
        int dups = 0;
        for (StationTimeSeriesFeature sf : sfc) {
            StationTimeSeriesFeature other = (StationTimeSeriesFeature)stns.get(sf.getName());
            if (other != null && dups < 10) {
                System.out.printf("  duplicate name = %s %n", sf);
                System.out.printf("   of = %s %n", other);
                ++dups;
            } else {
                stns.put(sf.getName(), sf);
            }
            MyLocation loc = new MyLocation((EarthLocation)sf.getStation());
            StationTimeSeriesFeature already = (StationTimeSeriesFeature)locs.get(loc);
            if (already != null) {
                System.out.printf("  duplicate location %s(%s) of %s(%s) %n", sf.getName(), sf.getStation().getDescription(), already.getName(), already.getStation().getDescription());
                continue;
            }
            locs.put(loc, sf);
        }
        System.out.printf(" duplicate names = %d %n", dups);
        System.out.printf(" unique locs = %d %n", locs.size());
        System.out.printf(" unique stns = %d %n", stns.size());
        return stns.size();
    }

    static int checkStationProfileFeatureCollection(StationProfileFeatureCollection stationProfileFeatureCollection, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        for (StationProfileFeature spf : stationProfileFeatureCollection) {
            CheckPointFeatureDataset.checkDsgFeatureCollection((DsgFeatureCollection)spf);
            Assert.assertNotNull((String)"StationProfileFeature latlon", (Object)spf.getStation().getLatLon());
            Assert.assertNotNull((String)"StationProfileFeature featureData", (Object)spf.getFeatureData());
            List times = spf.getTimes();
            if (showAll) {
                System.out.printf("  times= ", new Object[0]);
                for (CalendarDate t : times) {
                    System.out.printf("%s, ", t);
                }
                System.out.printf("%n", new Object[0]);
            }
            HashSet<String> profileNames = new HashSet<String>();
            for (ProfileFeature profile : spf) {
                CheckPointFeatureDataset.checkDsgFeatureCollection((DsgFeatureCollection)profile);
                Assert.assertNotNull((String)"ProfileFeature time", (Object)profile.getTime());
                Assert.assertNotNull((String)"ProfileFeature latlon", (Object)profile.getLatLon());
                Assert.assertNotNull((String)"ProfileFeature featureData", (Object)profile.getFeatureData());
                Assert.assertTrue((!profileNames.contains(profile.getName()) ? 1 : 0) != 0);
                profileNames.add(profile.getName());
                if (show) {
                    System.out.printf(" ProfileFeature=%s %n", profile.getName());
                }
                count += CheckPointFeatureDataset.checkPointFeatureCollection((PointFeatureCollection)profile, show);
            }
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testStationProfileFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        return count;
    }

    static int checkSectionFeatureCollection(TrajectoryProfileFeatureCollection sectionFeatureCollection, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        for (TrajectoryProfileFeature section : sectionFeatureCollection) {
            CheckPointFeatureDataset.checkDsgFeatureCollection((DsgFeatureCollection)section);
            Assert.assertNotNull((String)"SectionFeature featureData", (Object)section.getFeatureData());
            HashSet<String> profileNames = new HashSet<String>();
            for (ProfileFeature profile : section) {
                CheckPointFeatureDataset.checkDsgFeatureCollection((DsgFeatureCollection)profile);
                Assert.assertNotNull((String)"ProfileFeature time", (Object)profile.getTime());
                Assert.assertNotNull((String)"ProfileFeature latlon", (Object)profile.getLatLon());
                Assert.assertNotNull((String)"ProfileFeature featureData", (Object)profile.getFeatureData());
                Assert.assertTrue((!profileNames.contains(profile.getName()) ? 1 : 0) != 0);
                profileNames.add(profile.getName());
                if (show) {
                    System.out.printf(" ProfileFeature=%s %n", profile.getName());
                }
                count += CheckPointFeatureDataset.checkPointFeatureCollection((PointFeatureCollection)profile, show);
            }
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testStationProfileFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        return count;
    }

    static int checkOther(DsgFeatureCollection dsg, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        try {
            CollectionInfo info = new DsgCollectionHelper(dsg).calcBounds();
            if (show) {
                System.out.printf(" info=%s%n", info);
            }
            count = info.nobs;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 0;
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testNestedPointFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        return count;
    }

    private static void checkPointFeature(PointFeature pobs, CalendarDateUnit timeUnit) throws IOException {
        Assert.assertNotNull((String)"PointFeature location", (Object)pobs.getLocation());
        Assert.assertNotNull((String)"PointFeature time", (Object)pobs.getNominalTimeAsCalendarDate());
        Assert.assertNotNull((String)"PointFeature dataAll", (Object)pobs.getDataAll());
        Assert.assertNotNull((String)"PointFeature featureData", (Object)pobs.getFeatureData());
        Assert.assertEquals((String)"PointFeature makeCalendarDate", (Object)timeUnit.makeCalendarDate(pobs.getObservationTime()), (Object)pobs.getObservationTimeAsCalendarDate());
        assert (timeUnit.makeCalendarDate(pobs.getObservationTime()).equals((Object)pobs.getObservationTimeAsCalendarDate()));
        CheckPointFeatureDataset.checkData(pobs.getDataAll());
    }

    private static void checkData(StructureData sdata) {
        for (StructureMembers.Member member : sdata.getMembers()) {
            DataType dt = member.getDataType();
            if (dt == DataType.FLOAT) {
                sdata.getScalarFloat(member);
                sdata.getJavaArrayFloat(member);
            } else if (dt == DataType.DOUBLE) {
                sdata.getScalarDouble(member);
                sdata.getJavaArrayDouble(member);
            } else if (dt == DataType.BYTE) {
                sdata.getScalarByte(member);
                sdata.getJavaArrayByte(member);
            } else if (dt == DataType.SHORT) {
                sdata.getScalarShort(member);
                sdata.getJavaArrayShort(member);
            } else if (dt == DataType.INT) {
                sdata.getScalarInt(member);
                sdata.getJavaArrayInt(member);
            } else if (dt == DataType.LONG) {
                sdata.getScalarLong(member);
                sdata.getJavaArrayLong(member);
            } else if (dt == DataType.CHAR) {
                sdata.getScalarChar(member);
                sdata.getJavaArrayChar(member);
                sdata.getScalarString(member);
            } else if (dt == DataType.STRING) {
                sdata.getScalarString(member);
            }
            if (dt == DataType.STRING || dt == DataType.CHAR || dt == DataType.STRUCTURE || dt == DataType.SEQUENCE) continue;
            sdata.convertScalarFloat(member.getName());
        }
    }

    static void showStructureData(PointFeatureCCC ccc) throws IOException {
        PrintWriter pw = new PrintWriter(System.out);
        IOIterator iter = ccc.getCollectionIterator();
        while (iter.hasNext()) {
            PointFeatureCC cc = (PointFeatureCC)iter.next();
            System.out.printf(" 1.hashCode=%d %n", cc.hashCode());
            IOIterator iter2 = cc.getCollectionIterator();
            while (iter2.hasNext()) {
                PointFeatureCollection pfc = (PointFeatureCollection)iter2.next();
                System.out.printf("  2.hashcode%d %n", pfc.hashCode());
                for (PointFeature pointFeature : pfc) {
                    System.out.printf("   3.hashcode=%d %n", pointFeature.hashCode());
                    StructureData sdata = pointFeature.getDataAll();
                    logger.debug(Ncdump.printStructureData((StructureData)sdata));
                }
            }
        }
    }

    static int checkPointFeatureCollectionBB(PointFeatureCollection pfc, boolean show) throws IOException {
        int n;
        if (show) {
            System.out.printf("----------- testPointFeatureCollection -----------------%n", new Object[0]);
            System.out.println(" test PointFeatureCollection " + pfc.getName());
            System.out.println(" calcBounds");
        }
        if (show) {
            System.out.println("  bb= " + pfc.getBoundingBox());
            System.out.println("  dateRange= " + pfc.getCalendarDateRange());
            System.out.println("  npts= " + pfc.size());
        }
        if ((n = pfc.size()) == 0) {
            System.out.println("  empty " + pfc.getName());
            return 0;
        }
        LatLonRect bb = pfc.getBoundingBox();
        assert (bb != null);
        CalendarDateRange dr = pfc.getCalendarDateRange();
        assert (dr != null);
        if (show) {
            System.out.println(" complete iteration");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        for (PointFeature pf : pfc) {
            CheckPointFeatureDataset.checkPointFeature(pf, pfc.getTimeUnit());
            if (!bb.contains(pf.getLocation().getLatLon())) {
                System.out.printf("  point not in BB = %s on %s %n", pf.getLocation().getLatLon(), pfc.getName());
            }
            if (!dr.includes(pf.getObservationTimeAsCalendarDate())) {
                System.out.printf("  date out of Range= %s on %s %n", pf.getObservationTimeAsCalendarDate(), pfc.getName());
            }
            ++count;
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testPointFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        LatLonRect bb2 = new LatLonRect.Builder(bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0).build();
        PointFeatureCollection subset = pfc.subset(bb2, null);
        if (show) {
            System.out.println(" subset bb= " + bb2.toString2());
        }
        assert (subset != null);
        start = System.currentTimeMillis();
        int counts = 0;
        for (PointFeature pf : subset) {
            LatLonPoint llpt = pf.getLocation().getLatLon();
            if (!bb2.contains(llpt)) {
                System.out.printf("  point not in BB = %s on %s %n", llpt, pfc.getName());
                bb2.contains(llpt);
            }
            CheckPointFeatureDataset.checkPointFeature(pf, pfc.getTimeUnit());
            ++counts;
        }
        took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testPointFeatureCollection subset count= " + counts + " full iter took= " + took + " msec");
        }
        return count;
    }

    public static void checkLocation(String location, FeatureType type, boolean show) throws IOException {
        Formatter out = new Formatter();
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)type, (String)location, null, (Formatter)out);
        if (fdataset == null) {
            System.out.printf("**failed on %s %n --> %s %n", location, out);
            assert (false);
        }
        assert (fdataset instanceof FeatureDatasetPoint);
        FeatureDatasetPoint fdpoint = (FeatureDatasetPoint)fdataset;
        List collectionList = fdpoint.getPointFeatureCollectionList();
        DsgFeatureCollection fc = (DsgFeatureCollection)collectionList.get(0);
        if (fc instanceof PointFeatureCollection) {
            PointFeatureCollection pfc = (PointFeatureCollection)fc;
            CheckPointFeatureDataset.countLocations(pfc);
            LatLonRect bb = pfc.getBoundingBox();
            LatLonRect bb2 = new LatLonRect.Builder(bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0).build();
            PointFeatureCollection subset = pfc.subset(bb2, (CalendarDateRange)null);
            CheckPointFeatureDataset.countLocations(subset);
        } else if (fc instanceof StationTimeSeriesFeatureCollection) {
            StationTimeSeriesFeatureCollection sfc = (StationTimeSeriesFeatureCollection)fc;
            PointFeatureCollection pfcAll = sfc.flatten(null, (CalendarDateRange)null);
            System.out.printf("Unique Locations all = %d %n", CheckPointFeatureDataset.countLocations(pfcAll));
            LatLonRect bb = sfc.getBoundingBox();
            assert (bb != null);
            LatLonRect bb2 = new LatLonRect.Builder(bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0).build();
            PointFeatureCollection pfcSub = sfc.flatten(bb2, (CalendarDateRange)null);
            System.out.printf("Unique Locations sub1 = %d %n", CheckPointFeatureDataset.countLocations(pfcSub));
            StationTimeSeriesFeatureCollection sfcSub = sfc.subset(bb2);
            PointFeatureCollection pfcSub2 = sfcSub.flatten(null, (CalendarDateRange)null);
            System.out.printf("Unique Locations sub2 = %d %n", CheckPointFeatureDataset.countLocations(pfcSub2));
            sfc = sfc.subset(bb2);
            PointFeatureCollection subDon = sfc.flatten(bb2, (CalendarDateRange)null);
            System.out.printf("Unique Locations subDon = %d %n", CheckPointFeatureDataset.countLocations(subDon));
        }
    }

    static int countLocations(PointFeatureCollection pfc) throws IOException {
        int count = 0;
        HashSet<MyLocation> locs = new HashSet<MyLocation>(80000);
        pfc.resetIteration();
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            MyLocation loc = new MyLocation(pf.getLocation());
            if (!locs.contains(loc)) {
                locs.add(loc);
            }
            ++count;
        }
        System.out.printf("Count Points  = %d Unique points = %d %n", count, locs.size());
        return locs.size();
    }

    static int countObs(PointFeatureCollection pfc) throws IOException {
        int count = 0;
        pfc.resetIteration();
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            StructureData sd = pf.getDataAll();
            ++count;
        }
        return count;
    }

    private static class MyLocation {
        double lat;
        double lon;
        double alt;
        private int hashCode = 0;

        public MyLocation(EarthLocation from) {
            this.lat = from.getLatitude();
            this.lon = from.getLongitude();
            this.alt = Double.isNaN(from.getAltitude()) ? 0.0 : from.getAltitude();
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof MyLocation)) {
                return false;
            }
            MyLocation other = (MyLocation)oo;
            return this.lat == other.lat && this.lon == other.lon && this.alt == other.alt;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = (int)((double)result + ((double)(37 * result) + this.lat * 10000.0));
                result = (int)((double)result + ((double)(37 * result) + this.lon * 10000.0));
                this.hashCode = result = (int)((double)result + ((double)(37 * result) + this.alt * 10000.0));
            }
            return this.hashCode;
        }
    }
}

