/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grid;

import com.google.common.truth.Truth;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.grid.Grid;
import ucar.nc2.grid.GridAxis;
import ucar.nc2.grid.GridAxisDependenceType;
import ucar.nc2.grid.GridAxisInterval;
import ucar.nc2.grid.GridAxisPoint;
import ucar.nc2.grid.GridAxisSpacing;
import ucar.nc2.grid.GridCoordinateSystem;
import ucar.nc2.grid.GridDataset;
import ucar.nc2.grid.GridHorizCoordinateSystem;
import ucar.nc2.grid.GridTimeCoordinateSystem;
import ucar.nc2.util.Misc;

public class CompareGridDataset {
    private static final float TOL = 1.0E-5f;
    private final GridDataset roundtrip;
    private final GridDataset expected;
    private final boolean gribIosp;

    public CompareGridDataset(GridDataset roundtrip, GridDataset expected, boolean gribIosp) {
        this.roundtrip = roundtrip;
        this.expected = expected;
        this.gribIosp = gribIosp;
    }

    public void compare() {
        System.out.printf(" GridDataset (%s) = %s%n%n", this.roundtrip.getClass().getName(), this.roundtrip.getLocation());
        System.out.printf("    expected (%s) = %s%n%n", this.expected.getClass().getName(), this.expected.getLocation());
        Truth.assertThat((String)this.roundtrip.getName()).startsWith(this.expected.getName());
        Truth.assertThat((Comparable)this.roundtrip.getFeatureType()).isEqualTo((Object)this.expected.getFeatureType());
        this.compareAttributes(this.roundtrip.attributes(), this.expected.attributes());
        Truth.assertThat((Iterable)this.roundtrip.getGridAxes()).hasSize(this.expected.getGridAxes().size());
        for (GridAxis axis : this.roundtrip.getGridAxes()) {
            GridAxis expectedAxis = this.expected.getGridAxes().stream().filter(a -> a.getName().equals(axis.getName())).findFirst().orElseThrow(() -> new RuntimeException("Cant find axis: " + axis.getName()));
            if (this.gribIosp && axis.getAxisType().isTime()) continue;
            this.compareGridAxis(axis, expectedAxis);
        }
        Truth.assertThat((Iterable)this.roundtrip.getGridCoordinateSystems()).hasSize(this.expected.getGridCoordinateSystems().size());
        for (GridCoordinateSystem csys : this.roundtrip.getGridCoordinateSystems()) {
            GridCoordinateSystem expectedCsys = this.expected.getGridCoordinateSystems().stream().filter(cs -> cs.getName().equals(csys.getName())).findFirst().orElseThrow(() -> new RuntimeException("Cant find csys: " + csys.getName()));
            this.compareGridCoordinateSystem(csys, expectedCsys);
        }
        Truth.assertThat((Iterable)this.roundtrip.getGrids()).hasSize(this.expected.getGrids().size());
        for (Grid grid : this.roundtrip.getGrids()) {
            Grid expectedGrid = this.expected.getGrids().stream().filter(a -> a.getName().equals(grid.getName())).findFirst().orElseThrow(() -> new RuntimeException("Cant find grid: " + grid.getName()));
            this.compareGrid(grid, expectedGrid);
        }
    }

    public boolean compareGridCoordinateSystem(GridCoordinateSystem roundtrip, GridCoordinateSystem expected) {
        boolean ok = true;
        Truth.assertThat((String)roundtrip.getName()).isEqualTo((Object)expected.getName());
        Truth.assertThat((Comparable)roundtrip.getFeatureType()).isEqualTo((Object)expected.getFeatureType());
        Truth.assertThat((Boolean)(roundtrip.getVerticalTransform() == null ? 1 : 0)).isEqualTo((Object)(expected.getVerticalTransform() == null ? 1 : 0));
        if (roundtrip.getVerticalTransform() != null) {
            Truth.assertThat((String)roundtrip.getVerticalTransform().getName()).isEqualTo((Object)expected.getVerticalTransform().getName());
        }
        Truth.assertThat((Iterable)roundtrip.getNominalShape()).isEqualTo((Object)expected.getNominalShape());
        Truth.assertThat((Boolean)roundtrip.isZPositive()).isEqualTo((Object)expected.isZPositive());
        Truth.assertWithMessage((String)roundtrip.getName()).that(Boolean.valueOf(this.compareGridHorizCoordinateSystem(roundtrip.getHorizCoordinateSystem(), expected.getHorizCoordinateSystem()))).isTrue();
        Truth.assertWithMessage((String)roundtrip.getName()).that(Boolean.valueOf(this.compareGridTimeCoordinateSystem(roundtrip.getTimeCoordinateSystem(), expected.getTimeCoordinateSystem()))).isTrue();
        Truth.assertThat((Iterable)roundtrip.getGridAxes()).hasSize(expected.getGridAxes().size());
        for (GridAxis axis : roundtrip.getGridAxes()) {
            GridAxis raxis = expected.getGridAxes().stream().filter(cs -> cs.getName().equals(axis.getName())).findFirst().orElse(null);
            Truth.assertThat((Object)raxis).isNotNull();
        }
        return ok;
    }

    public boolean compareGridHorizCoordinateSystem(GridHorizCoordinateSystem hsys, GridHorizCoordinateSystem expected) {
        this.compareGridAxis((GridAxis<?>)hsys.getXHorizAxis(), (GridAxis<?>)expected.getXHorizAxis());
        this.compareGridAxis((GridAxis<?>)hsys.getYHorizAxis(), (GridAxis<?>)expected.getYHorizAxis());
        Truth.assertThat((Object)hsys.getProjection()).isEqualTo((Object)expected.getProjection());
        Truth.assertThat((Boolean)hsys.isLatLon()).isEqualTo((Object)expected.isLatLon());
        Truth.assertThat((Boolean)hsys.isCurvilinear()).isEqualTo((Object)expected.isCurvilinear());
        Truth.assertThat((Boolean)hsys.isGlobalLon()).isEqualTo((Object)expected.isGlobalLon());
        Truth.assertThat((Iterable)hsys.getShape()).isEqualTo((Object)expected.getShape());
        Truth.assertThat((String)hsys.getGeoUnits()).isEqualTo((Object)expected.getGeoUnits());
        Truth.assertThat((Boolean)hsys.getLatLonBoundingBox().nearlyEquals(expected.getLatLonBoundingBox())).isTrue();
        Truth.assertThat((Boolean)hsys.getBoundingBox().nearlyEquals(expected.getBoundingBox())).isTrue();
        return true;
    }

    public boolean compareGridTimeCoordinateSystem(GridTimeCoordinateSystem roundtrip, GridTimeCoordinateSystem expected) {
        Truth.assertThat((Boolean)(roundtrip == null ? 1 : 0)).isEqualTo((Object)(expected == null ? 1 : 0));
        if (roundtrip == null) {
            return true;
        }
        Truth.assertThat((Comparable)roundtrip.getType()).isEqualTo((Object)expected.getType());
        Truth.assertThat((Object)roundtrip.getRuntimeDateUnit()).isEqualTo((Object)expected.getRuntimeDateUnit());
        Truth.assertThat((Comparable)roundtrip.getBaseDate()).isEqualTo((Object)expected.getBaseDate());
        Truth.assertWithMessage((String)roundtrip.toString()).that((Iterable)roundtrip.getNominalShape()).isEqualTo((Object)expected.getNominalShape());
        if (!this.gribIosp) {
            Truth.assertThat((Iterable)roundtrip.getMaterializedShape()).isEqualTo((Object)expected.getMaterializedShape());
        }
        this.compareGridAxis((GridAxis<?>)roundtrip.getRunTimeAxis(), (GridAxis<?>)expected.getRunTimeAxis());
        Truth.assertThat((Boolean)(roundtrip.getRunTimeAxis() == null ? 1 : 0)).isEqualTo((Object)(expected.getRunTimeAxis() == null ? 1 : 0));
        if (roundtrip.getRunTimeAxis() != null) {
            Truth.assertThat((String)roundtrip.getRunTimeAxis().getName()).isEqualTo((Object)expected.getRunTimeAxis().getName());
            Truth.assertThat((Integer)roundtrip.getRunTimeAxis().getNominalSize()).isEqualTo((Object)expected.getRunTimeAxis().getNominalSize());
            int nruns = roundtrip.getRunTimeAxis().getNominalSize();
            for (int i = 0; i < nruns; ++i) {
                Truth.assertThat((Comparable)roundtrip.getRuntimeDate(i)).isEqualTo((Object)expected.getRuntimeDate(i));
                Truth.assertThat((Boolean)this.compareGridAxis(roundtrip.getTimeOffsetAxis(i), expected.getTimeOffsetAxis(i))).isTrue();
            }
        } else {
            Truth.assertThat((Comparable)roundtrip.getRuntimeDate(0)).isEqualTo((Object)expected.getRuntimeDate(0));
            Truth.assertThat((Boolean)this.compareGridAxis(roundtrip.getTimeOffsetAxis(0), expected.getTimeOffsetAxis(0))).isTrue();
        }
        Truth.assertThat((Boolean)this.compareGridAxis(roundtrip.getTimeOffsetAxis(0), expected.getTimeOffsetAxis(0))).isTrue();
        return true;
    }

    public boolean compareGridAxis(GridAxis<?> roundtrip, GridAxis<?> expected) {
        Truth.assertThat((Boolean)(roundtrip == null ? 1 : 0)).isEqualTo((Object)(expected == null ? 1 : 0));
        if (roundtrip == null) {
            return true;
        }
        Truth.assertThat((String)roundtrip.getName()).isEqualTo((Object)expected.getName());
        Truth.assertWithMessage((String)(roundtrip.getName() + " has description")).that(roundtrip.getDescription()).isEqualTo((Object)expected.getDescription());
        if (!this.gribIosp || !roundtrip.getAxisType().isTime()) {
            Truth.assertWithMessage((String)(roundtrip.getName() + " has units")).that(roundtrip.getUnits()).isEqualTo((Object)expected.getUnits());
            Truth.assertThat((Comparable)roundtrip.getAxisType()).isEqualTo((Object)expected.getAxisType());
        }
        Truth.assertThat((Integer)roundtrip.getNominalSize()).isEqualTo((Object)expected.getNominalSize());
        Truth.assertThat((Iterable)roundtrip.getDependsOn()).isEqualTo((Object)expected.getDependsOn());
        Truth.assertThat((Boolean)roundtrip.isInterval()).isEqualTo((Object)expected.isInterval());
        Truth.assertThat((Boolean)roundtrip.isRegular()).isEqualTo((Object)expected.isRegular());
        Truth.assertWithMessage((String)roundtrip.getName()).that((Comparable)roundtrip.getSpacing()).isEqualTo((Object)expected.getSpacing());
        if (roundtrip.getSpacing() != GridAxisSpacing.discontiguousInterval) {
            Truth.assertThat((Double)roundtrip.getResolution()).isWithin((double)1.0E-5f).of(expected.getResolution());
        }
        if (roundtrip.getDependenceType() != GridAxisDependenceType.scalar && expected.getDependenceType() != GridAxisDependenceType.independent) {
            Truth.assertWithMessage((String)roundtrip.getName()).that((Comparable)roundtrip.getDependenceType()).isEqualTo((Object)expected.getDependenceType());
        }
        if (roundtrip.isInterval()) {
            GridAxisInterval intvLocal = (GridAxisInterval)roundtrip;
            GridAxisInterval intvRemote = (GridAxisInterval)expected;
            for (int i = 0; i < roundtrip.getNominalSize(); ++i) {
                Truth.assertWithMessage((String)String.format("%s != %s", intvLocal.getCoordDouble(i), intvRemote.getCoordDouble(i))).that(Boolean.valueOf(Misc.nearlyEquals((double)intvLocal.getCoordDouble(i), (double)intvRemote.getCoordDouble(i), (double)1.0E-5f))).isTrue();
                Truth.assertWithMessage((String)String.format("%s != %s", intvLocal.getCoordInterval(i), intvRemote.getCoordInterval(i))).that(Boolean.valueOf(intvLocal.getCoordInterval(i).fuzzyEquals(intvRemote.getCoordInterval(i), (double)1.0E-5f))).isTrue();
            }
        } else {
            GridAxisPoint intvLocal = (GridAxisPoint)roundtrip;
            GridAxisPoint intvRemote = (GridAxisPoint)expected;
            for (int i = 0; i < roundtrip.getNominalSize(); ++i) {
                Truth.assertWithMessage((String)String.format("%s != %s", intvLocal.getCoordDouble(i), intvRemote.getCoordDouble(i))).that(Boolean.valueOf(Misc.nearlyEquals((double)intvLocal.getCoordDouble(i), (double)intvRemote.getCoordDouble(i), (double)1.0E-5f))).isTrue();
                Truth.assertWithMessage((String)String.format("%s != %s", intvLocal.getCoordInterval(i), intvRemote.getCoordInterval(i))).that(Boolean.valueOf(intvLocal.getCoordInterval(i).fuzzyEquals(intvRemote.getCoordInterval(i), (double)1.0E-5f))).isTrue();
            }
        }
        this.compareAttributes(roundtrip.attributes(), expected.attributes());
        return true;
    }

    public boolean compareGrid(Grid grid, Grid expectedGrid) {
        if (grid.getClass() == expectedGrid.getClass()) {
            Truth.assertThat((Object)grid).isEqualTo((Object)expectedGrid);
        }
        Truth.assertThat((String)grid.getCoordinateSystem().getName()).isEqualTo((Object)expectedGrid.getCoordinateSystem().getName());
        Truth.assertThat((String)grid.getName()).isEqualTo((Object)expectedGrid.getName());
        Truth.assertThat((String)grid.getDescription()).isEqualTo((Object)expectedGrid.getDescription());
        Truth.assertThat((String)grid.getUnits()).isEqualTo((Object)expectedGrid.getUnits());
        Truth.assertThat((Comparable)grid.getArrayType()).isEqualTo((Object)expectedGrid.getArrayType());
        this.compareAttributes(grid.attributes(), expectedGrid.attributes());
        Truth.assertWithMessage((String)grid.getName()).that(Boolean.valueOf(this.compareGridHorizCoordinateSystem(grid.getHorizCoordinateSystem(), grid.getHorizCoordinateSystem()))).isTrue();
        Truth.assertWithMessage((String)grid.getName()).that(Boolean.valueOf(this.compareGridTimeCoordinateSystem(grid.getTimeCoordinateSystem(), grid.getTimeCoordinateSystem()))).isTrue();
        return true;
    }

    public void compareAttributes(AttributeContainer atts, AttributeContainer expected) {
        for (Attribute att : expected) {
            Attribute expectedAtt = atts.findAttribute(att.getName());
            Truth.assertWithMessage((String)att.getName()).that((Object)expectedAtt).isNotNull();
            Truth.assertThat((Object)att).isEqualTo((Object)expectedAtt);
        }
    }
}

