/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.util.test;

import org.junit.Assert;
import org.junit.internal.ComparisonCriteria;
import ucar.nc2.util.Misc;

public class Assert2 {
    public static void assertNearlyEquals(float expected, float actual) {
        Assert2.assertNearlyEquals(expected, actual, 1.0E-5f);
    }

    public static void assertNearlyEquals(float expected, float actual, float maxRelDiff) {
        if (!Misc.nearlyEquals((float)expected, (float)actual, (float)maxRelDiff)) {
            Assert2.failNotEquals(null, Float.valueOf(expected), Float.valueOf(actual));
        }
    }

    public static void assertNearlyEquals(double expected, double actual) {
        Assert2.assertNearlyEquals(expected, actual, 1.0E-8);
    }

    public static void assertNearlyEquals(double expected, double actual, double maxRelDiff) {
        if (!Misc.nearlyEquals((double)expected, (double)actual, (double)maxRelDiff)) {
            Assert2.failNotEquals(null, expected, actual);
        }
    }

    public static void assertArrayNearlyEquals(float[] expecteds, float[] actuals) {
        Assert2.assertArrayNearlyEquals(expecteds, actuals, 1.0E-5f);
    }

    public static void assertArrayNearlyEquals(float[] expecteds, float[] actuals, float maxRelDiff) {
        new NearlyEqualsComparisonCriteria(maxRelDiff).arrayEquals(null, expecteds, actuals);
    }

    public static void assertArrayNearlyEquals(double[] expecteds, double[] actuals) {
        Assert2.assertArrayNearlyEquals(expecteds, actuals, 1.0E-8);
    }

    public static void assertArrayNearlyEquals(double[] expecteds, double[] actuals, double maxRelDiff) {
        new NearlyEqualsComparisonCriteria(maxRelDiff).arrayEquals(null, expecteds, actuals);
    }

    private static void failNotEquals(String message, Object expected, Object actual) {
        Assert.fail((String)Assert2.format(message, expected, actual));
    }

    static String format(String message, Object expected, Object actual) {
        String actualString;
        String expectedString;
        Object formatted = "";
        if (message != null && !message.equals("")) {
            formatted = message + " ";
        }
        if ((expectedString = String.valueOf(expected)).equals(actualString = String.valueOf(actual))) {
            return (String)formatted + "expected: " + Assert2.formatClassAndValue(expected, expectedString) + " but was: " + Assert2.formatClassAndValue(actual, actualString);
        }
        return (String)formatted + "expected:<" + expectedString + "> but was:<" + actualString + ">";
    }

    private static String formatClassAndValue(Object value, String valueString) {
        String className = value == null ? "null" : value.getClass().getName();
        return className + "<" + valueString + ">";
    }

    private Assert2() {
    }

    private static class NearlyEqualsComparisonCriteria
    extends ComparisonCriteria {
        public Object maxRelDiff;

        public NearlyEqualsComparisonCriteria(double maxRelDiff) {
            this.maxRelDiff = maxRelDiff;
        }

        public NearlyEqualsComparisonCriteria(float maxRelDiff) {
            this.maxRelDiff = Float.valueOf(maxRelDiff);
        }

        protected void assertElementsEqual(Object expected, Object actual) {
            if (expected instanceof Double) {
                Assert2.assertNearlyEquals((Double)expected, (Double)actual, (Double)this.maxRelDiff);
            } else {
                Assert2.assertNearlyEquals(((Float)expected).floatValue(), ((Float)actual).floatValue(), ((Float)this.maxRelDiff).floatValue());
            }
        }
    }
}

