/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.zarr;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.Variable;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.iosp.LayoutBBTiled;
import ucar.nc2.iosp.zarr.ZArray;
import ucar.nc2.iosp.zarr.ZarrHeader;
import ucar.nc2.iosp.zarr.ZarrUtils;
import ucar.unidata.io.RandomAccessFile;

public class ZarrLayoutBB
implements LayoutBB {
    private LayoutBBTiled delegate;
    private RandomAccessFile raf;
    private ByteOrder byteOrder;
    private final long varOffset;
    private final Section want;
    private int[] chunkSize;
    private int elemSize;
    private int[] nChunks;
    private int nBytes;
    private int totalNChunks;
    private int totalChunkSize;
    private boolean F_order = false;
    private Set<Integer> initializedChunks;
    private static final int ZARR_COMPRESSOR_OFFSET = 16;
    private int data_bytes_offset;

    public ZarrLayoutBB(Variable v2, Section wantSection, RandomAccessFile raf) {
        this.raf = raf;
        ZarrHeader.VInfo vinfo = (ZarrHeader.VInfo)v2.getSPobject();
        this.byteOrder = vinfo.getByteOrder();
        this.varOffset = vinfo.getOffset();
        this.data_bytes_offset = vinfo.getCompressor() == null ? 0 : 16;
        this.chunkSize = vinfo.getChunks();
        int ndims = this.chunkSize.length;
        this.initializedChunks = vinfo.getInitializedChunks();
        this.nChunks = new int[ndims];
        this.totalNChunks = 1;
        this.totalChunkSize = 1;
        for (int i = 0; i < ndims; ++i) {
            Dimension dim = v2.getDimension(i);
            this.nChunks[i] = (int)Math.ceil(dim.getLength() / this.chunkSize[i]);
            this.totalNChunks *= this.nChunks[i];
            this.totalChunkSize *= this.chunkSize[i];
        }
        if (vinfo.getOrder() == ZArray.Order.F) {
            this.F_order = true;
            List ranges = wantSection.getRanges();
            ArrayList transpose = new ArrayList();
            int[] temp = new int[ndims];
            for (int i = 0; i < ndims; ++i) {
                transpose.add(ranges.get(ndims - i - 1));
                temp[i] = this.chunkSize[ndims - i - 1];
            }
            this.want = new Section(transpose);
            this.chunkSize = temp;
        } else {
            this.want = wantSection;
        }
        this.elemSize = v2.getDataType().getSize();
        this.nBytes = this.totalChunkSize * this.elemSize;
        DataChunkIterator iter = new DataChunkIterator();
        this.delegate = new LayoutBBTiled((LayoutBBTiled.DataChunkIterator)iter, this.chunkSize, this.elemSize, this.want);
    }

    public long getTotalNelems() {
        return this.delegate.getTotalNelems();
    }

    public int getElemSize() {
        return this.delegate.getElemSize();
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public LayoutBB.Chunk next() {
        return this.delegate.next();
    }

    private class DataChunk
    implements LayoutBBTiled.DataChunk {
        private int[] offset;
        private long rafOffset;
        private int chunkNum;

        DataChunk(int[] index, int chunkNum) {
            this.offset = new int[index.length];
            this.rafOffset = ZarrLayoutBB.this.varOffset + (long)(chunkNum * (ZarrLayoutBB.this.nBytes + ZarrLayoutBB.this.data_bytes_offset)) + (long)ZarrLayoutBB.this.data_bytes_offset;
            for (int i = 0; i < index.length; ++i) {
                int j = ZarrLayoutBB.this.F_order ? index.length - i - 1 : i;
                this.offset[i] = index[j] * ZarrLayoutBB.this.chunkSize[i];
            }
            this.chunkNum = chunkNum;
        }

        public int[] getOffset() {
            return this.offset;
        }

        public ByteBuffer getByteBuffer() throws IOException {
            byte[] data;
            if (!ZarrLayoutBB.this.initializedChunks.contains(this.chunkNum)) {
                data = new byte[]{};
            } else {
                data = new byte[ZarrLayoutBB.this.nBytes];
                ZarrLayoutBB.this.raf.seek(this.rafOffset);
                ZarrLayoutBB.this.raf.readFully(data);
            }
            ByteBuffer result = ByteBuffer.wrap(data);
            result.order(ZarrLayoutBB.this.byteOrder);
            return result;
        }
    }

    private class DataChunkIterator
    implements LayoutBBTiled.DataChunkIterator {
        private int[] currChunk;
        private int chunkNum;

        DataChunkIterator() {
            this.currChunk = new int[ZarrLayoutBB.this.chunkSize.length];
            this.chunkNum = 0;
        }

        public boolean hasNext() {
            return this.chunkNum < ZarrLayoutBB.this.totalNChunks;
        }

        public LayoutBBTiled.DataChunk next() {
            DataChunk chunk = new DataChunk(this.currChunk, this.chunkNum);
            this.incrementChunk();
            return chunk;
        }

        private void incrementChunk() {
            int i;
            for (i = this.currChunk.length - 1; this.currChunk[i] + 1 >= ZarrLayoutBB.this.nChunks[i] && i > 0; --i) {
                this.currChunk[i] = 0;
            }
            int n = i;
            this.currChunk[n] = this.currChunk[n] + 1;
            this.chunkNum = ZarrUtils.subscriptsToIndex(this.currChunk, ZarrLayoutBB.this.nChunks);
        }
    }
}

