/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem.zarr;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.filesystem.ControllerOS;
import thredds.inventory.CollectionConfig;
import thredds.inventory.MController;
import thredds.inventory.MControllerProvider;
import thredds.inventory.MFile;
import thredds.inventory.zarr.MFileZip;

public class ControllerZip
extends ControllerOS
implements MController {
    private static final Logger logger = LoggerFactory.getLogger(ControllerZip.class);
    private static final String prefix = "file:";

    public Iterator<MFile> getInventoryAll(CollectionConfig mc, boolean recheck) {
        String path = mc.getDirectoryName();
        if (path.startsWith(prefix)) {
            path = path.substring(prefix.length());
        }
        try {
            MFileZip mfile = new MFileZip(path);
            return new MFileIteratorLeaves(mfile);
        }
        catch (IOException ioe) {
            logger.warn(ioe.getMessage(), (Throwable)ioe);
            return null;
        }
    }

    public Iterator<MFile> getInventoryTop(CollectionConfig mc, boolean recheck) {
        String path = mc.getDirectoryName();
        if (path.startsWith(prefix)) {
            path = path.substring(prefix.length());
        }
        try {
            MFileZip mfile = new MFileZip(path);
            return new FilteredIterator(mfile, false);
        }
        catch (IOException ioe) {
            logger.warn(ioe.getMessage(), (Throwable)ioe);
            return null;
        }
    }

    public Iterator<MFile> getSubdirs(CollectionConfig mc, boolean recheck) {
        String path = mc.getDirectoryName();
        if (path.startsWith(prefix)) {
            path = path.substring(prefix.length());
        }
        try {
            MFileZip mfile = new MFileZip(path);
            return new FilteredIterator(mfile, true);
        }
        catch (IOException ioe) {
            logger.warn(ioe.getMessage(), (Throwable)ioe);
            return null;
        }
    }

    public void close() {
    }

    public static class Provider
    implements MControllerProvider {
        private static final String ext = ".zip";

        public String getProtocol() {
            return null;
        }

        public boolean canScan(String location) {
            return location.contains(ext);
        }

        public MController create() {
            return new ControllerZip();
        }
    }

    protected static class MFileIteratorLeaves
    extends MFileIterator
    implements Iterator<MFile> {
        MFileIteratorLeaves(MFileZip file) {
            List<ZipEntry> entries = file.getLeafEntries();
            for (ZipEntry entry : entries) {
                try {
                    this.files.add(new MFileZip(file.getRootPath() + File.separator + entry.getName()));
                }
                catch (IOException ioe) {
                    logger.error(ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    protected static class FilteredIterator
    extends MFileIterator
    implements Iterator<MFile> {
        FilteredIterator(MFileZip file, boolean wantDirs) throws IOException {
            HashSet<Path> fileNames = new HashSet<Path>();
            List<ZipEntry> entries = file.getLeafEntries();
            Path relativePath = file.getRelativePath();
            for (ZipEntry entry : entries) {
                Path entryPath = Paths.get(File.separator + entry.getName(), new String[0]);
                if (!entryPath.startsWith(relativePath)) {
                    logger.warn(entryPath.toString() + " is not an entry in " + relativePath.toString());
                    continue;
                }
                Path childPath = entryPath.subpath(0, relativePath.getNameCount() + 1);
                fileNames.add(childPath);
            }
            for (Path location : fileNames) {
                try {
                    MFileZip mfile = new MFileZip(file.getRootPath().toString() + File.separator + location.toString());
                    if (mfile.isDirectory() != wantDirs) continue;
                    this.files.add(mfile);
                }
                catch (IOException ioe) {
                    logger.error(ioe.getMessage(), (Throwable)ioe);
                }
            }
        }
    }

    protected static class MFileIterator
    implements Iterator<MFile> {
        List<MFileZip> files = new ArrayList<MFileZip>();
        int count = 0;

        protected MFileIterator() {
        }

        @Override
        public MFile next() {
            return this.files.get(this.count++);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.files.size();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

