/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.zarr;

import java.io.IOException;
import ucar.nc2.NetcdfFiles;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.zarr.RandomAccessDirectoryItem;

public class VirtualRandomAccessFile
implements RandomAccessDirectoryItem {
    private final String location;
    private long startIndex;
    private long length;
    private long lastModified;
    private RandomAccessFile raf;
    private final int bufferSize;

    public VirtualRandomAccessFile(String location, long startIndex, long length, long lastModified, int bufferSize) {
        this.location = location;
        this.startIndex = startIndex;
        this.length = length;
        this.lastModified = lastModified;
        this.raf = null;
        this.bufferSize = bufferSize;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public long startIndex() {
        return this.startIndex;
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public long getLastModified() {
        return this.raf == null ? this.lastModified : this.raf.getLastModified();
    }

    @Override
    public RandomAccessFile getRaf() {
        return this.raf;
    }

    @Override
    public RandomAccessFile getOrOpenRaf() throws IOException {
        if (this.raf == null) {
            this.raf = NetcdfFiles.getRaf((String)this.location, (int)this.bufferSize);
        }
        return this.raf;
    }
}

