/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util.xml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import ucar.nc2.NetcdfFile;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordTransBuilder;
import ucar.nc2.dt.TypedDatasetFactory;

public class RuntimeConfigParser {
    public static void read(InputStream is, StringBuilder errlog) throws IOException {
        Document doc;
        SAXBuilder saxBuilder = new SAXBuilder();
        saxBuilder.setExpandEntities(false);
        try {
            doc = saxBuilder.build(is);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
        RuntimeConfigParser.read(doc.getRootElement(), errlog);
    }

    public static void read(Element root, StringBuilder errlog) {
        List children = root.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            boolean useForReading;
            Class<?> c;
            String filename;
            String editionS;
            String className;
            Element elem = (Element)children.get(i);
            if (elem.getName().equals("ioServiceProvider")) {
                String className2 = elem.getAttributeValue("class");
                try {
                    NetcdfFile.registerIOProvider(className2);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className2 + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("IOServiceProvider " + className2 + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("coordSysBuilder")) {
                String conventionName = elem.getAttributeValue("convention");
                className = elem.getAttributeValue("class");
                try {
                    CoordSysBuilder.registerConvention(conventionName, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("CoordSysBuilder " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("coordTransBuilder")) {
                String transformName = elem.getAttributeValue("name");
                className = elem.getAttributeValue("class");
                try {
                    CoordTransBuilder.registerTransform(transformName, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("CoordTransBuilder " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("typedDatasetFactory")) {
                String typeName = elem.getAttributeValue("datatype");
                className = elem.getAttributeValue("class");
                FeatureType datatype = FeatureType.valueOf(typeName.toUpperCase());
                if (null == datatype) {
                    errlog.append("TypedDatasetFactory " + className + " unknown datatype= " + typeName + "\n");
                    continue;
                }
                try {
                    TypedDatasetFactory.registerFactory(datatype, className);
                }
                catch (ClassNotFoundException e) {
                    errlog.append("CoordSysBuilder class not found= " + className + "; check your classpath\n");
                }
                catch (Exception e) {
                    errlog.append("TypedDatasetFactory " + className + " failed= " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("gribParameterTable")) {
                editionS = elem.getAttributeValue("edition");
                String centerS = elem.getAttributeValue("center");
                String subcenterS = elem.getAttributeValue("subcenter");
                String versionS = elem.getAttributeValue("version");
                String filename2 = elem.getText();
                if (centerS == null || versionS == null || filename2 == null) {
                    errlog.append("table element must center, version and filename attributes\n");
                    continue;
                }
                try {
                    int center = Integer.parseInt(centerS);
                    int subcenter = subcenterS == null ? -1 : Integer.parseInt(subcenterS);
                    int version = Integer.parseInt(versionS);
                    Class<?> c2 = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.nc2.grib.grib1.tables.Grib1ParamTables");
                    Method m = c2.getMethod("addParameterTable", Integer.TYPE, Integer.TYPE, Integer.TYPE, String.class);
                    m.invoke(null, center, subcenter, version, filename2);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String strictS = elem.getAttributeValue("strict");
                if (strictS == null) continue;
                boolean notStrict = strictS.equalsIgnoreCase("false");
                try {
                    Class<?> c3 = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.grib.grib1.tables.Grib1ParamTables");
                    Method m = c3.getMethod("setStrict", Boolean.TYPE);
                    m.invoke(null, !notStrict);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (elem.getName().equals("gribParameterTableLookup")) {
                editionS = elem.getAttributeValue("edition");
                filename = elem.getText();
                try {
                    c = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.nc2.grib.grib1.tables.Grib1ParamTables");
                    Method m = c.getMethod("addParameterTableLookup", String.class);
                    m.invoke(null, filename);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (elem.getName().equals("table")) {
                String type = elem.getAttributeValue("type");
                filename = elem.getAttributeValue("filename");
                if (type == null || filename == null) {
                    errlog.append("table element must have both type and filename attributes\n");
                    continue;
                }
                try {
                    if (type.equalsIgnoreCase("GRIB1")) {
                        try {
                            c = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.grib.grib1.GribPDSParamTable");
                            Method m = c.getMethod("addParameterUserLookup", String.class);
                            m.invoke(null, filename);
                        }
                        catch (ClassNotFoundException e) {
                            e.printStackTrace();
                        }
                        catch (NoSuchMethodException e) {
                            e.printStackTrace();
                        }
                        catch (InvocationTargetException e) {
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    if (type.equalsIgnoreCase("GRIB2")) {
                        try {
                            c = RuntimeConfigParser.class.getClassLoader().loadClass(" ucar.grib.grib2.ParameterTable");
                            Method m = c.getMethod("addParametersUser", String.class);
                            m.invoke(null, filename);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        continue;
                    }
                    errlog.append("Unknown table type " + type + "\n");
                }
                catch (Exception e) {
                    errlog.append("table read failed on  " + filename + " = " + e.getMessage() + "\n");
                }
                continue;
            }
            if (elem.getName().equals("bufrtable")) {
                String filename3 = elem.getAttributeValue("filename");
                if (filename3 == null) {
                    errlog.append("bufrtable must have filename attribute\n");
                    continue;
                }
                try {
                    Class<?> bufrTablesClass = RuntimeConfigParser.class.getClassLoader().loadClass("ucar.nc2.iosp.bufr.tables.BufrTables");
                    Class[] params = new Class[]{String.class};
                    Method method = bufrTablesClass.getMethod("addLookupFile", params);
                    Object[] args = new Object[]{filename3};
                    method.invoke(null, args);
                }
                catch (Throwable e) {
                    if (e instanceof FileNotFoundException) {
                        errlog.append("bufrtable read failed on  " + filename3 + " = " + e.getMessage() + "\n");
                        continue;
                    }
                    errlog.append("bufr.jar is not on classpath\n");
                }
                continue;
            }
            if (!elem.getName().equals("Netcdf4Clibrary")) continue;
            String nc4IospClassName = "ucar.nc2.jni.netcdf.Nc4Iosp";
            String path = elem.getChildText("libraryPath");
            String name = elem.getChildText("libraryName");
            if (path != null && name != null) {
                try {
                    Class<?> nc4IospClass = RuntimeConfigParser.class.getClassLoader().loadClass(nc4IospClassName);
                    Method method = nc4IospClass.getMethod("setLibraryAndPath", String.class, String.class);
                    method.invoke(null, path, name);
                }
                catch (Throwable e) {
                    errlog.append(nc4IospClassName + " is not on classpath\n");
                }
            }
            if (!(useForReading = Boolean.parseBoolean(elem.getChildText("useForReading")))) continue;
            try {
                NetcdfFile.registerIOProvider(nc4IospClassName);
                continue;
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                errlog.append(String.format("Could not register IOSP '%s': %s%n", nc4IospClassName, e.getMessage()));
            }
        }
    }
}

