/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.stream;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.Formatter;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.httpservices.HTTPFactory;
import ucar.httpservices.HTTPMethod;
import ucar.httpservices.HTTPSession;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.stream.NcStream;
import ucar.nc2.stream.NcStreamReader;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.IO;

public class CdmRemote
extends NetcdfFile {
    public static final String PROTOCOL = "cdmremote";
    public static final String SCHEME = "cdmremote:";
    private static Logger logger = LoggerFactory.getLogger(CdmRemote.class);
    private static boolean showRequest = false;
    private HTTPSession httpClient = null;
    private final String remoteURI;

    public static void setDebugFlags(DebugFlags debugFlag) {
        showRequest = debugFlag.isSet("CdmRemote/showRequest");
    }

    public static String canonicalURL(String urlName) {
        if (urlName.startsWith("http:")) {
            return SCHEME + urlName.substring(5);
        }
        return urlName;
    }

    public CdmRemote(String _remoteURI) throws IOException {
        long start = System.currentTimeMillis();
        String temp = _remoteURI;
        try {
            if (temp.startsWith(SCHEME)) {
                temp = temp.substring(SCHEME.length());
            }
            if (!temp.startsWith("http:")) {
                temp = "http:" + temp;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.remoteURI = temp;
        String url = this.remoteURI + "?req=header";
        this.httpClient = HTTPFactory.newSession((String)this.remoteURI);
        try (HTTPMethod method = HTTPFactory.Get((HTTPSession)this.httpClient, (String)url);){
            int statusCode;
            method.setFollowRedirects(true);
            if (showRequest) {
                System.out.printf("CdmRemote request %s %n", url);
            }
            if ((statusCode = method.execute()) == 404) {
                throw new FileNotFoundException(method.getURL() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getURL() + " " + method.getStatusLine());
            }
            InputStream is = method.getResponseAsStream();
            NcStreamReader reader = new NcStreamReader();
            reader.readStream(is, this);
            this.location = SCHEME + this.remoteURI;
        }
        long took = System.currentTimeMillis() - start;
        if (showRequest) {
            System.out.printf(" took %d msecs %n", took);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CdmRemote(InputStream is, String location) throws IOException {
        long start = System.currentTimeMillis();
        this.remoteURI = location;
        try {
            NcStreamReader reader = new NcStreamReader();
            reader.readStream(is, this);
            this.location = SCHEME + this.remoteURI;
        }
        finally {
            is.close();
        }
        long took = System.currentTimeMillis() - start;
        if (showRequest) {
            System.out.printf(" took %d msecs %n", took);
        }
    }

    @Override
    protected Array readData(Variable v, Section section) throws IOException, InvalidRangeException {
        if (v.getDataType() == DataType.SEQUENCE) {
            Structure s = (Structure)v;
            StructureDataIterator siter = this.getStructureIterator(s, -1);
            return new ArraySequence(s.makeStructureMembers(), siter, -1);
        }
        Formatter f = new Formatter();
        f.format("%s?var=%s", this.remoteURI, v.getFullNameEscaped());
        if (section != null && v.getDataType() != DataType.SEQUENCE) {
            f.format("(%s)", section.toString());
        }
        if (showRequest) {
            System.out.println(" CdmRemote data request for variable: " + v.getFullName() + " section= " + section + " " + "url=" + f);
        }
        try (HTTPMethod method = HTTPFactory.Get((HTTPSession)this.httpClient, (String)f.toString());){
            int statusCode = method.execute();
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 300) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            Header h = method.getResponseHeader("Content-Length");
            if (h != null) {
                int wantSize;
                String s = h.getValue();
                int readLen = Integer.parseInt(s);
                if (showRequest) {
                    System.out.printf(" content-length = %d%n", readLen);
                }
                if (v.getDataType() != DataType.SEQUENCE && readLen != (wantSize = (int)((long)v.getElementSize() * (section == null ? v.getSize() : section.computeSize())))) {
                    throw new IOException("content-length= " + readLen + " not equal expected Size= " + wantSize);
                }
            }
            InputStream is = method.getResponseAsStream();
            NcStreamReader reader = new NcStreamReader();
            NcStreamReader.DataResult result = reader.readData(is, this);
            assert (v.getFullNameEscaped().equals(result.varNameFullEsc));
            result.data.setUnsigned(v.isUnsigned());
            Array array = result.data;
            return array;
        }
    }

    @Override
    protected StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        try {
            InputStream is = CdmRemote.sendQuery(this.remoteURI, s.getFullNameEscaped());
            NcStreamReader reader = new NcStreamReader();
            return reader.getStructureIterator(is, this);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new IllegalStateException(e);
        }
    }

    public static InputStream sendQuery(String remoteURI, String query) throws IOException {
        long start = System.currentTimeMillis();
        StringBuilder sbuff = new StringBuilder(remoteURI);
        sbuff.append("?");
        sbuff.append(query);
        if (showRequest) {
            System.out.printf(" CdmRemote sendQuery= %s", sbuff);
        }
        HTTPMethod method = HTTPFactory.Get((String)sbuff.toString());
        try {
            int statusCode = method.execute();
            if (statusCode == 404) {
                throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
            }
            if (statusCode >= 400) {
                throw new IOException(method.getPath() + " " + method.getStatusLine());
            }
            InputStream stream = method.getResponseBodyAsStream();
            if (showRequest) {
                System.out.printf(" took %d msecs %n", System.currentTimeMillis() - start);
            }
            return stream;
        }
        catch (IOException e) {
            method.close();
            throw e;
        }
    }

    @Override
    public String getFileTypeId() {
        return "ncstreamRemote";
    }

    @Override
    public String getFileTypeDescription() {
        return "ncstreamRemote";
    }

    public void writeToFile(String filename) throws IOException {
        File file = new File(filename);
        try (FileOutputStream fos = new FileOutputStream(file);){
            long size = 4L;
            fos.write(NcStream.MAGIC_START);
            String url = this.remoteURI + "?req=header";
            try (HTTPMethod method = HTTPFactory.Get((HTTPSession)this.httpClient, (String)url);){
                int statusCode;
                if (showRequest) {
                    System.out.printf("CdmRemote request %s %n", url);
                }
                if ((statusCode = method.execute()) == 404) {
                    throw new FileNotFoundException(method.getURL() + " " + method.getStatusLine());
                }
                if (statusCode >= 300) {
                    throw new IOException(method.getURL() + " " + method.getStatusLine());
                }
                InputStream is = method.getResponseBodyAsStream();
                size += IO.copyB(is, fos, 64000);
            }
            for (Variable v : this.getVariables()) {
                StringBuilder sbuff = new StringBuilder(this.remoteURI);
                sbuff.append("?var=");
                sbuff.append(URLEncoder.encode(v.getShortName(), "UTF-8"));
                if (showRequest) {
                    System.out.println(" CdmRemote data request for variable: " + v.getFullName() + " url=" + sbuff);
                }
                HTTPMethod method = HTTPFactory.Get((HTTPSession)this.httpClient, (String)sbuff.toString());
                Throwable throwable = null;
                try {
                    String s;
                    int readLen;
                    int statusCode = method.execute();
                    if (statusCode == 404) {
                        throw new FileNotFoundException(method.getPath() + " " + method.getStatusLine());
                    }
                    if (statusCode >= 300) {
                        throw new IOException(method.getPath() + " " + method.getStatusLine());
                    }
                    int wantSize = (int)v.getSize();
                    Header h = method.getResponseHeader("Content-Length");
                    if (h != null && (readLen = Integer.parseInt(s = h.getValue())) != wantSize) {
                        throw new IOException("content-length= " + readLen + " not equal expected Size= " + wantSize);
                    }
                    InputStream is = method.getResponseBodyAsStream();
                    size += IO.copyB(is, fos, 64000);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (method == null) continue;
                    if (throwable != null) {
                        try {
                            method.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    method.close();
                }
            }
            fos.flush();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.httpClient != null) {
            this.httpClient.close();
        }
    }
}

