/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.Structure;

public class StructureDataIteratorLinked
implements StructureDataIterator {
    private static Logger log = LoggerFactory.getLogger(StructureDataIteratorLinked.class);
    private Structure s;
    private int firstRecord;
    private int nextRecno;
    private int numRecords;
    private String linkVarName;
    private int currRecno;
    private boolean isContiguous;

    public StructureDataIteratorLinked(Structure s, int firstRecord, int numRecords, String linkVarName) {
        this.s = s;
        this.firstRecord = firstRecord;
        this.nextRecno = firstRecord;
        this.numRecords = numRecords;
        this.linkVarName = linkVarName;
        this.isContiguous = linkVarName == null;
    }

    @Override
    public StructureData next() throws IOException {
        StructureData sdata;
        this.currRecno = this.nextRecno++;
        try {
            sdata = this.s.readStructure(this.currRecno);
        }
        catch (InvalidRangeException e) {
            log.error("StructureDataLinkedIterator.nextStructureData recno=" + this.currRecno, (Throwable)e);
            throw new IOException(e.getMessage());
        }
        if (!this.isContiguous) {
            this.nextRecno = sdata.getScalarInt(this.linkVarName);
            if (this.currRecno == this.nextRecno) {
                throw new IllegalStateException("Infinite loop in linked list at recno= " + this.nextRecno);
            }
        }
        return sdata;
    }

    @Override
    public boolean hasNext() {
        return this.isContiguous ? this.nextRecno < this.firstRecord + this.numRecords : this.nextRecno >= 0;
    }

    @Override
    public StructureDataIterator reset() {
        this.nextRecno = this.firstRecord;
        return this;
    }

    @Override
    public int getCurrentRecno() {
        return this.currRecno;
    }
}

