/*
 * Decompiled with CFR 0.152.
 */
package thredds.wcs.v1_1_0;

import java.util.Date;
import java.util.List;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import thredds.wcs.v1_1_0.GetCapabilities;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.units.DateFormatter;

public class XMLwriter {
    protected static final Namespace wcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs/1.1");
    protected static final Namespace owcsNS = Namespace.getNamespace((String)"http://www.opengis.net/wcs/1.1/ows");
    protected static final Namespace owsNS = Namespace.getNamespace((String)"http://www.opengis.net/ows");
    private XMLOutputter xmlOutputter = new XMLOutputter(Format.getPrettyFormat());
    public static String seqDate;

    public Document generateExceptionReport(ExceptionCodes code, String locator, String message) {
        Element rootElem = new Element("ExceptionReport", owsNS);
        rootElem.addNamespaceDeclaration(owsNS);
        rootElem.setAttribute("version", "1.0.0");
        Element exceptionElem = new Element("Exception", owsNS);
        exceptionElem.setAttribute("code", code.toString());
        if (locator != null && locator.length() != 0) {
            exceptionElem.setAttribute("locator", locator);
        }
        if (message != null && message.length() != 0) {
            Element excTextElem = new Element("ExceptionText", owsNS);
            excTextElem.addContent(message);
            exceptionElem.addContent((Content)excTextElem);
        }
        rootElem.addContent((Content)exceptionElem);
        return new Document(rootElem);
    }

    public Document generateCapabilities(String serverURL, GridDataset dataset, List<GetCapabilities.Section> sections) {
        Element capabilitiesElem = new Element("Capabilities", owsNS);
        capabilitiesElem.addNamespaceDeclaration(owsNS);
        return new Document(capabilitiesElem);
    }

    static {
        DateFormatter formatter = new DateFormatter();
        seqDate = formatter.toDateTimeStringISO(new Date());
    }

    public static enum ExceptionCodes {
        MissingParameterValue,
        InvalidParameterValue,
        VersionNegotiationFailed,
        InvalidUpdateSequence,
        NoApplicableCode;

    }
}

