/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.image.image;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.IndexIterator;
import ucar.ma2.MAMath;

public class ImageArrayAdapter {
    public static BufferedImage makeGrayscaleImage(Array ma) {
        if (ma.getRank() < 2) {
            return null;
        }
        if (ma.getRank() == 3) {
            ma = ma.reduce();
        }
        if (ma.getRank() == 3) {
            ma = ma.slice(0, 0);
        }
        int h = ma.getShape()[0];
        int w = ma.getShape()[1];
        DataBuffer dataBuffer = ImageArrayAdapter.makeDataBuffer(ma);
        WritableRaster raster = WritableRaster.createInterleavedRaster(dataBuffer, w, h, w, 1, new int[]{0}, null);
        ColorSpace cs = ColorSpace.getInstance(1003);
        ComponentColorModel colorModel = new ComponentColorModel(cs, new int[]{8}, false, false, 1, 0);
        return new BufferedImage(colorModel, raster, false, null);
    }

    private static DataBuffer makeDataBuffer(Array ma) {
        if (ma instanceof ArrayByte) {
            return ImageArrayAdapter.makeByteDataBuffer((ArrayByte)ma);
        }
        int h = ma.getShape()[0];
        int w = ma.getShape()[1];
        double min = MAMath.getMinimum((Array)ma);
        double max = MAMath.getMaximum((Array)ma);
        double scale = max - min;
        if (scale > 0.0) {
            scale = 255.0 / scale;
        }
        IndexIterator ii = ma.getIndexIterator();
        byte[] byteData = new byte[h * w];
        for (int i = 0; i < byteData.length; ++i) {
            double val = ii.getDoubleNext();
            double sval = (val - min) * scale;
            byteData[i] = (byte)sval;
        }
        return new DataBufferByte(byteData, byteData.length);
    }

    private static DataBuffer makeByteDataBuffer(ArrayByte ma) {
        byte[] byteData = (byte[])ma.copyTo1DJavaArray();
        return new DataBufferByte(byteData, byteData.length);
    }
}

