/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gini;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CDM;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.iosp.gini.Giniiosp;
import ucar.nc2.units.DateFormatter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

class Giniheader {
    private static final int GINI_PIB_LEN = 21;
    private static final int GINI_PDB_LEN = 512;
    private static final int GINI_HED_LEN = 533;
    private static final double DEG_TO_RAD = 0.017453292;
    private boolean debug = false;
    private NetcdfFile ncfile;
    private static Logger log = LoggerFactory.getLogger(Giniheader.class);
    int dataStart = 0;
    protected int Z_type = 0;

    Giniheader() {
    }

    public static boolean isValidFile(RandomAccessFile raf) {
        try {
            return Giniheader.validatePIB(raf);
        }
        catch (IOException e) {
            return false;
        }
    }

    private static int findWMOHeader(String pib) {
        int pos = pib.indexOf("KNES");
        if (pos == -1) {
            pos = pib.indexOf("CHIZ");
        }
        if (pos != -1) {
            pos = pib.indexOf("\r\r\n");
            if (pos != -1) {
                pos += 3;
            }
        } else {
            pos = 0;
        }
        return pos;
    }

    static boolean validatePIB(RandomAccessFile raf) throws IOException {
        int pos = 0;
        raf.seek((long)pos);
        String pib = raf.readString(554);
        return Giniheader.findWMOHeader(pib) != 0;
    }

    byte[] readPIB(RandomAccessFile raf) throws IOException {
        int pos = 0;
        raf.seek((long)pos);
        byte[] b = new byte[554];
        byte[] buf = new byte[533];
        byte[] head = new byte[512];
        raf.readFully(b);
        String pib = new String(b, CDM.utf8Charset);
        pos = Giniheader.findWMOHeader(pib);
        this.dataStart = pos + 512;
        byte[] b2 = new byte[]{b[pos], b[pos + 1]};
        int pos1 = 0;
        if (Giniiosp.isZlibHed(b2)) {
            this.Z_type = 1;
            Inflater inflater = new Inflater(false);
            inflater.setInput(b, pos, 533);
            try {
                int resultLength = inflater.inflate(buf, 0, 533);
                if (resultLength != 533) {
                    log.warn("GINI: Zlib inflated image header size error");
                }
            }
            catch (DataFormatException ex) {
                log.error("ERROR on inflation " + ex.getMessage());
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
            int inflatedLen = 533 - inflater.getRemaining();
            String inf = new String(buf, CDM.utf8Charset);
            pos1 = Giniheader.findWMOHeader(inf);
            System.arraycopy(buf, pos1, head, 0, 512);
            this.dataStart = pos + inflatedLen;
        } else {
            System.arraycopy(b, pos, head, 0, 512);
        }
        if (pos == 0 && pos1 == 0) {
            throw new IOException("Error on Gini File");
        }
        return head;
    }

    void read(RandomAccessFile raf, NetcdfFile ncfile) throws IOException {
        this.ncfile = ncfile;
        double lon1 = 0.0;
        double lon2 = 0.0;
        double lat1 = 0.0;
        double lat2 = 0.0;
        double imageScale = 0.0;
        byte[] head = this.readPIB(raf);
        ByteBuffer bos = ByteBuffer.wrap(head);
        Attribute att = new Attribute("Conventions", "GRIB");
        this.ncfile.addAttribute(null, att);
        bos.position(0);
        Byte nv = bos.get();
        att = new Attribute("source_id", (Number)nv);
        this.ncfile.addAttribute(null, att);
        nv = bos.get();
        int ent_id = nv.intValue();
        att = new Attribute("entity_id", (Number)nv);
        this.ncfile.addAttribute(null, att);
        nv = bos.get();
        int sec_id = nv.intValue();
        att = new Attribute("sector_id", (Number)nv);
        this.ncfile.addAttribute(null, att);
        nv = bos.get();
        int phys_elem = nv.intValue();
        att = new Attribute("phys_elem", (Number)nv);
        this.ncfile.addAttribute(null, att);
        bos.position(bos.position() + 4);
        int gyear = bos.get();
        gyear += gyear < 50 ? 2000 : 1900;
        byte gmonth = bos.get();
        byte gday = bos.get();
        byte ghour = bos.get();
        byte gminute = bos.get();
        byte gsecond = bos.get();
        SimpleDateFormat dformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        dformat.setTimeZone(TimeZone.getTimeZone("GMT"));
        Calendar cal = Calendar.getInstance();
        cal.set(14, 0);
        cal.set(gyear, gmonth - 1, gday, ghour, gminute, gsecond);
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dstring = dformat.format(cal.getTime());
        Dimension dimT = new Dimension("time", 1, true, false, false);
        ncfile.addDimension(null, dimT);
        String timeCoordName = "time";
        Variable taxis = new Variable(ncfile, null, null, timeCoordName);
        taxis.setDataType(DataType.DOUBLE);
        taxis.setDimensions("time");
        taxis.addAttribute(new Attribute("long_name", "time since base date"));
        taxis.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Time.toString()));
        double[] tdata = new double[]{cal.getTimeInMillis()};
        Array dataA = Array.factory((Class)DataType.DOUBLE.getPrimitiveClassType(), (int[])new int[]{1}, (Object)tdata);
        taxis.setCachedData(dataA, false);
        DateFormatter formatter = new DateFormatter();
        taxis.addAttribute(new Attribute("units", "msecs since " + formatter.toDateTimeStringISO(new Date(0L))));
        ncfile.addVariable(null, taxis);
        this.ncfile.addAttribute(null, new Attribute("time_coverage_start", dstring));
        this.ncfile.addAttribute(null, new Attribute("time_coverage_end", dstring));
        bos.get();
        nv = bos.get();
        att = new Attribute("ProjIndex", (Number)nv);
        this.ncfile.addAttribute(null, att);
        int proj = nv.intValue();
        if (proj == 1) {
            att = new Attribute("ProjName", "MERCATOR");
        } else if (proj == 3) {
            att = new Attribute("ProjName", "LAMBERT_CONFORNAL");
        } else if (proj == 5) {
            att = new Attribute("ProjName", "POLARSTEREOGRAPHIC");
        }
        this.ncfile.addAttribute(null, att);
        short nx = bos.getShort();
        att = new Attribute("NX", (Number)nx);
        this.ncfile.addAttribute(null, att);
        short ny = bos.getShort();
        att = new Attribute("NY", (Number)ny);
        this.ncfile.addAttribute(null, att);
        Mercator projection = null;
        double dxKm = 0.0;
        double dyKm = 0.0;
        switch (proj) {
            case 1: {
                double lonv;
                lat1 = this.readScaledInt(bos);
                att = new Attribute("Latitude0", (Number)lat1);
                this.ncfile.addAttribute(null, att);
                lon1 = this.readScaledInt(bos);
                att = new Attribute("Longitude0", (Number)lon1);
                this.ncfile.addAttribute(null, att);
                bos.get();
                lat2 = this.readScaledInt(bos);
                att = new Attribute("LatitudeN", (Number)lat2);
                this.ncfile.addAttribute(null, att);
                lon2 = this.readScaledInt(bos);
                att = new Attribute("LongitudeN", (Number)lon2);
                this.ncfile.addAttribute(null, att);
                double lon_1 = lon1;
                double lon_2 = lon2;
                if (lon1 < 0.0) {
                    lon_1 += 360.0;
                }
                if (lon2 < 0.0) {
                    lon_2 += 360.0;
                }
                if ((lonv = (lon_1 + lon_2) / 2.0) > 180.0) {
                    lonv -= 360.0;
                }
                if (lonv < -180.0) {
                    lonv += 360.0;
                }
                bos.getInt();
                bos.get();
                double latin = this.readScaledInt(bos);
                att = new Attribute("LatitudeX", (Number)latin);
                this.ncfile.addAttribute(null, att);
                projection = new Mercator(lonv, latin);
                break;
            }
            case 3: 
            case 5: {
                double lonv;
                lat1 = this.readScaledInt(bos);
                lon1 = this.readScaledInt(bos);
                bos.get();
                double lonProjectionOrigin = lonv = this.readScaledInt(bos);
                att = new Attribute("Lov", (Number)lonv);
                this.ncfile.addAttribute(null, att);
                dxKm = this.readScaledInt(bos);
                att = new Attribute("DxKm", (Number)dxKm);
                this.ncfile.addAttribute(null, att);
                dyKm = this.readScaledInt(bos);
                att = new Attribute("DyKm", (Number)dyKm);
                this.ncfile.addAttribute(null, att);
                if (proj == 5) {
                    double latt = 60.0;
                    imageScale = (1.0 + Math.sin(0.017453292 * latt)) / 2.0;
                }
                lat2 = lat1 + dyKm * (double)(ny - 1) / 111.26;
                if (lonv < 0.0) {
                    lonv += 360.0;
                }
                if (lon1 < 0.0) {
                    lon1 += 360.0;
                }
                lon2 = lon1 + dxKm * (double)(nx - 1) / 111.26 * Math.cos(0.017453292 * lat1);
                lonv = lonv > 180.0 ? -(360.0 - lonv) : lonv;
                lon1 = lon1 > 180.0 ? -(360.0 - lon1) : lon1;
                lon2 = lon2 > 180.0 ? -(360.0 - lon2) : lon2;
                nv = bos.get();
                int pole = nv.intValue();
                pole = pole > 127 ? -1 : 1;
                att = new Attribute("ProjCenter", (Number)pole);
                this.ncfile.addAttribute(null, att);
                bos.get();
                double latin = this.readScaledInt(bos);
                att = new Attribute("Latin", (Number)latin);
                this.ncfile.addAttribute(null, att);
                if (proj == 3) {
                    projection = new LambertConformal(latin, lonProjectionOrigin, latin, latin);
                    break;
                }
                projection = new Stereographic(90.0, lonv, imageScale);
                break;
            }
            default: {
                System.out.println("unimplemented projection");
            }
        }
        this.ncfile.addAttribute(null, new Attribute("title", this.gini_GetEntityID(ent_id)));
        this.ncfile.addAttribute(null, new Attribute("summary", this.getPhysElemSummary(phys_elem, ent_id)));
        this.ncfile.addAttribute(null, new Attribute("id", this.gini_GetSectorID(sec_id)));
        this.ncfile.addAttribute(null, new Attribute("keywords_vocabulary", this.gini_GetPhysElemID(phys_elem, ent_id)));
        this.ncfile.addAttribute(null, new Attribute("cdm_data_type", FeatureType.GRID.toString()));
        this.ncfile.addAttribute(null, new Attribute("featureType", FeatureType.GRID.toString()));
        this.ncfile.addAttribute(null, new Attribute("standard_name_vocabulary", this.getPhysElemLongName(phys_elem, ent_id)));
        this.ncfile.addAttribute(null, new Attribute("creator_name", "UNIDATA"));
        this.ncfile.addAttribute(null, new Attribute("creator_url", "http://www.unidata.ucar.edu/"));
        this.ncfile.addAttribute(null, new Attribute("naming_authority", "UCAR/UCP"));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_min", (Number)lat1));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lat_max", (Number)lat2));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_min", (Number)lon1));
        this.ncfile.addAttribute(null, new Attribute("geospatial_lon_max", (Number)lon2));
        bos.position(41);
        nv = bos.get();
        att = new Attribute("imageResolution", (Number)nv);
        this.ncfile.addAttribute(null, att);
        nv = bos.get();
        att = new Attribute("compressionFlag", (Number)nv);
        this.ncfile.addAttribute(null, att);
        if (DataType.unsignedByteToShort((byte)nv) == 128) {
            this.Z_type = 2;
        }
        bos.position(46);
        nv = bos.get();
        short navcal = DataType.unsignedByteToShort((byte)nv);
        int[] calcods = null;
        if (navcal == 128) {
            calcods = this.getCalibrationInfo(bos, phys_elem, ent_id);
        }
        String vname = this.gini_GetPhysElemID(phys_elem, ent_id);
        Variable var = new Variable(ncfile, ncfile.getRootGroup(), null, vname);
        var.addAttribute(new Attribute("long_name", this.getPhysElemLongName(phys_elem, ent_id)));
        var.addAttribute(new Attribute("units", this.getPhysElemUnits(phys_elem, ent_id)));
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        Dimension dimX = new Dimension("x", (int)nx, true, false, false);
        Dimension dimY = new Dimension("y", (int)ny, true, false, false);
        ncfile.addDimension(null, dimY);
        ncfile.addDimension(null, dimX);
        dims.add(dimT);
        dims.add(dimY);
        dims.add(dimX);
        var.setDimensions(dims);
        long begin = this.dataStart;
        if (this.debug) {
            log.warn(" name= " + vname + " velems=" + var.getSize() + " begin= " + begin + "\n");
        }
        if (navcal == 128) {
            var.setDataType(DataType.FLOAT);
            var.setSPobject((Object)new Vinfo(begin, nx, ny, calcods));
        } else {
            var.setDataType(DataType.BYTE);
            var.addAttribute(new Attribute("_Unsigned", "true"));
            var.addAttribute(new Attribute("scale_factor", (Number)1));
            var.addAttribute(new Attribute("add_offset", (Number)0));
            var.setSPobject((Object)new Vinfo(begin, nx, ny));
        }
        String coordinates = "x y time";
        var.addAttribute(new Attribute("_CoordinateAxes", coordinates));
        ncfile.addVariable(null, var);
        ProjectionPoint start = projection.latLonToProj((LatLonPoint)new LatLonPointImpl(lat1, lon1));
        if (this.debug) {
            log.warn("start at proj coord " + start);
        }
        double startx = start.getX();
        double starty = start.getY();
        Variable xaxis = new Variable(ncfile, null, null, "x");
        xaxis.setDataType(DataType.DOUBLE);
        xaxis.setDimensions("x");
        xaxis.addAttribute(new Attribute("long_name", "projection x coordinate"));
        xaxis.addAttribute(new Attribute("units", "km"));
        xaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoX"));
        double[] data = new double[nx];
        if (proj == 1) {
            double lon_1 = lon1;
            double lon_2 = lon2;
            if (lon1 < 0.0) {
                lon_1 += 360.0;
            }
            if (lon2 < 0.0) {
                lon_2 += 360.0;
            }
            double dx = (lon_2 - lon_1) / (double)(nx - 1);
            for (int i = 0; i < data.length; ++i) {
                double ln = lon1 + (double)i * dx;
                ProjectionPoint pt = projection.latLonToProj((LatLonPoint)new LatLonPointImpl(lat1, ln));
                data[i] = pt.getX();
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                data[i] = startx + (double)i * dxKm;
            }
        }
        dataA = Array.factory((Class)DataType.DOUBLE.getPrimitiveClassType(), (int[])new int[]{nx}, (Object)data);
        xaxis.setCachedData(dataA, false);
        ncfile.addVariable(null, xaxis);
        Variable yaxis = new Variable(ncfile, null, null, "y");
        yaxis.setDataType(DataType.DOUBLE);
        yaxis.setDimensions("y");
        yaxis.addAttribute(new Attribute("long_name", "projection y coordinate"));
        yaxis.addAttribute(new Attribute("units", "km"));
        yaxis.addAttribute(new Attribute("_CoordinateAxisType", "GeoY"));
        data = new double[ny];
        double endy = starty + dyKm * (double)(data.length - 1);
        if (proj == 1) {
            double dy = (lat2 - lat1) / (double)(ny - 1);
            for (int i = 0; i < data.length; ++i) {
                double la = lat2 - (double)i * dy;
                ProjectionPoint pt = projection.latLonToProj((LatLonPoint)new LatLonPointImpl(la, lon1));
                data[i] = pt.getY();
            }
        } else {
            for (int i = 0; i < data.length; ++i) {
                data[i] = endy - (double)i * dyKm;
            }
        }
        dataA = Array.factory((Class)DataType.DOUBLE.getPrimitiveClassType(), (int[])new int[]{ny}, (Object)data);
        yaxis.setCachedData(dataA, false);
        ncfile.addVariable(null, yaxis);
        Variable ct = new Variable(ncfile, null, null, projection.getClassName());
        ct.setDataType(DataType.CHAR);
        ct.setDimensions("");
        for (Parameter p : projection.getProjectionParameters()) {
            ct.addAttribute(new Attribute(p));
        }
        ct.addAttribute(new Attribute("_CoordinateTransformType", "Projection"));
        ct.addAttribute(new Attribute("_CoordinateAxes", "x y "));
        dataA = Array.factory((Class)DataType.CHAR.getPrimitiveClassType(), (int[])new int[0]);
        dataA.setChar(dataA.getIndex(), ' ');
        ct.setCachedData(dataA, false);
        ncfile.addVariable(null, ct);
        ncfile.addAttribute(null, new Attribute("Conventions", "_Coordinates"));
        ncfile.finish();
    }

    int[] getCalibrationInfo(ByteBuffer bos, int phys_elem, int ent_id) {
        bos.position(46);
        byte nv = bos.get();
        short navcal = DataType.unsignedByteToShort((byte)nv);
        int[] calcods = null;
        if (navcal == 128) {
            int scale = 10000;
            int jscale = 100000000;
            byte[] unsb = new byte[8];
            bos.get(unsb);
            bos.position(55);
            nv = bos.get();
            int calcod = DataType.unsignedByteToShort((byte)nv);
            if (calcod > 0) {
                int i;
                calcods = new int[5 * calcod + 1];
                calcods[0] = calcod;
                for (i = 0; i < calcod; ++i) {
                    bos.position(56 + i * 16);
                    int minb = bos.getInt() / 10000;
                    int maxb = bos.getInt() / 10000;
                    int mind = bos.getInt();
                    int maxd = bos.getInt();
                    int idscal = 1;
                    while (mind % idscal == 0 && maxd % idscal == 0) {
                        idscal *= 10;
                    }
                    if ((idscal /= 10) < jscale) {
                        jscale = idscal;
                    }
                    calcods[1 + i * 5] = mind;
                    calcods[2 + i * 5] = maxd;
                    calcods[3 + i * 5] = minb;
                    calcods[4 + i * 5] = maxb;
                    calcods[5 + i * 5] = 0;
                }
                if (jscale > scale) {
                    jscale = scale;
                }
                if (this.gini_GetPhysElemID(phys_elem, ent_id).contains("Precipitation") && (scale /= jscale) < 100) {
                    jscale /= 100 / scale;
                    scale = 100;
                }
                for (i = 0; i < calcod; ++i) {
                    int n = 1 + i * 5;
                    calcods[n] = calcods[n] / jscale;
                    int n2 = 2 + i * 5;
                    calcods[n2] = calcods[n2] / jscale;
                    calcods[5 + i * 5] = scale;
                }
            }
        }
        return calcods;
    }

    int gini_GetCompressType() {
        return this.Z_type;
    }

    String gini_GetSectorID(int ent_id) {
        String name;
        switch (ent_id) {
            case 0: {
                name = "Northern Hemisphere Composite";
                break;
            }
            case 1: {
                name = "East CONUS";
                break;
            }
            case 2: {
                name = "West CONUS";
                break;
            }
            case 3: {
                name = "Alaska Regional";
                break;
            }
            case 4: {
                name = "Alaska National";
                break;
            }
            case 5: {
                name = "Hawaii Regional";
                break;
            }
            case 6: {
                name = "Hawaii National";
                break;
            }
            case 7: {
                name = "Puerto Rico Regional";
                break;
            }
            case 8: {
                name = "Puerto Rico National";
                break;
            }
            case 9: {
                name = "Supernational";
                break;
            }
            case 10: {
                name = "NH Composite - Meteosat/GOES E/ GOES W/GMS";
                break;
            }
            case 11: {
                name = "Central CONUS";
                break;
            }
            case 12: {
                name = "East Floater";
                break;
            }
            case 13: {
                name = "West Floater";
                break;
            }
            case 14: {
                name = "Central Floater";
                break;
            }
            case 15: {
                name = "Polar Floater";
                break;
            }
            default: {
                name = "Unknown-ID";
            }
        }
        return name;
    }

    String gini_GetEntityID(int ent_id) {
        String name;
        switch (ent_id) {
            case 2: {
                name = "Miscellaneous";
                break;
            }
            case 3: {
                name = "JERS";
                break;
            }
            case 4: {
                name = "ERS/QuikSCAT/Scatterometer";
                break;
            }
            case 5: {
                name = "POES/NPOESS";
                break;
            }
            case 6: {
                name = "Composite";
                break;
            }
            case 7: {
                name = "DMSP satellite Image";
                break;
            }
            case 8: {
                name = "GMS satellite Image";
                break;
            }
            case 9: {
                name = "METEOSAT satellite Image";
                break;
            }
            case 10: {
                name = "GOES-7 satellite Image";
                break;
            }
            case 11: {
                name = "GOES-8 satellite Image";
                break;
            }
            case 12: {
                name = "GOES-9 satellite Image";
                break;
            }
            case 13: {
                name = "GOES-10 satellite Image";
                break;
            }
            case 14: {
                name = "GOES-11 satellite Image";
                break;
            }
            case 15: {
                name = "GOES-12 satellite Image";
                break;
            }
            case 16: {
                name = "GOES-13 satellite Image";
                break;
            }
            case 17: {
                name = "GOES-14 satellite Image";
                break;
            }
            case 18: {
                name = "GOES-15 satellite Image";
                break;
            }
            case 19: {
                name = "GOES-16 satellite Image";
                break;
            }
            case 99: {
                name = "RADAR-MOSIAC Composite Image";
                break;
            }
            default: {
                name = "Unknown";
            }
        }
        return name;
    }

    String gini_GetPhysElemID(int phys_elem, int ent_id) {
        String name;
        switch (phys_elem) {
            case 1: {
                name = "VIS";
                break;
            }
            case 3: {
                name = "IR_WV";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                name = "IR";
                break;
            }
            case 13: {
                name = "LI";
                break;
            }
            case 14: {
                name = "PW";
                break;
            }
            case 15: {
                name = "SFC_T";
                break;
            }
            case 16: {
                name = "LI";
                break;
            }
            case 17: {
                name = "PW";
                break;
            }
            case 18: {
                name = "SFC_T";
                break;
            }
            case 19: {
                name = "CAPE";
                break;
            }
            case 20: {
                name = "T";
                break;
            }
            case 21: {
                name = "WINDEX";
                break;
            }
            case 22: {
                name = "DMPI";
                break;
            }
            case 23: {
                name = "MDPI";
                break;
            }
            case 25: {
                if (ent_id == 99) {
                    name = "HHC";
                    break;
                }
                name = "Volcano_imagery";
                break;
            }
            case 26: {
                name = "EchoTops";
                break;
            }
            case 27: {
                if (ent_id == 99) {
                    name = "Reflectivity";
                    break;
                }
                name = "CTP";
                break;
            }
            case 28: {
                if (ent_id == 99) {
                    name = "Reflectivity";
                    break;
                }
                name = "Cloud_Amount";
                break;
            }
            case 29: {
                name = "VIL";
                break;
            }
            case 30: 
            case 31: {
                name = "Precipitation";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                name = "sounder_imagery";
                break;
            }
            case 59: {
                name = "VIS_sounder";
                break;
            }
            default: {
                name = "Unknown";
            }
        }
        return name;
    }

    String getPhysElemUnits(int phys_elem, int ent_id) {
        switch (phys_elem) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 25: 
            case 43: 
            case 48: 
            case 50: 
            case 51: 
            case 52: 
            case 55: 
            case 57: 
            case 59: {
                return "N/A";
            }
            case 26: {
                return "kft";
            }
            case 27: {
                if (ent_id == 99) {
                    return "dBz";
                }
                return "N/A";
            }
            case 28: {
                if (ent_id == 99) {
                    return "dBz";
                }
                return "N/A";
            }
            case 29: {
                return "kg m-2";
            }
            case 30: {
                return "IN";
            }
            case 31: {
                return "IN";
            }
        }
        return "Unknown";
    }

    String getPhysElemLongName(int phys_elem, int ent_id) {
        switch (phys_elem) {
            case 1: {
                return "Imager Visible";
            }
            case 2: {
                return "Imager 3.9 micron IR";
            }
            case 3: {
                return "Imager 6.7/6.5 micron IR (WV)";
            }
            case 4: {
                return "Imager 11 micron IR";
            }
            case 5: {
                return "Imager 12 micron IR";
            }
            case 6: {
                return "Imager 13 micron IR";
            }
            case 7: {
                return "Imager 1.3 micron IR";
            }
            case 13: {
                return "Lifted Index LI";
            }
            case 14: {
                return "Precipitable Water PW";
            }
            case 15: {
                return "Surface Skin Temperature";
            }
            case 16: {
                return "Lifted Index LI";
            }
            case 17: {
                return "Precipitable Water PW";
            }
            case 18: {
                return "Surface Skin Temperature";
            }
            case 19: {
                return "Convective Available Potential Energy";
            }
            case 20: {
                return "land-sea Temperature";
            }
            case 21: {
                return "Wind Index";
            }
            case 22: {
                return "Dry Microburst Potential Index";
            }
            case 23: {
                return "Microburst Potential Index";
            }
            case 24: {
                return "Derived Convective Inhibition";
            }
            case 25: {
                if (ent_id == 99) {
                    return "1km National Hybrid Hydrometeor Classification Composite (Unidata)";
                }
                return "Volcano_imagery";
            }
            case 26: {
                if (ent_id == 99) {
                    return "1 km National Echo Tops Composite (Unidata)";
                }
                return "4 km National Echo Tops";
            }
            case 27: {
                if (ent_id == 99) {
                    return "1 km National Base Reflectivity Composite (Unidata)";
                }
                return "Cloud Top Pressure or Height";
            }
            case 28: {
                if (ent_id == 99) {
                    return "1 km National Reflectivity Composite (Unidata)";
                }
                return "Cloud Amount";
            }
            case 29: {
                if (ent_id == 99) {
                    return "1 km National Vertically Integrated Liquid Water (Unidata)";
                }
                return "4 km National Vertically Integrated Liquid Water";
            }
            case 30: {
                if (ent_id == 99) {
                    return "1 km National 1-hour Precipitation (Unidata)";
                }
                return "Surface wind speeds over oceans and Great Lakes";
            }
            case 31: {
                if (ent_id == 99) {
                    return "4 km National Storm Total Precipitation (Unidata)";
                }
                return "Surface Wetness";
            }
            case 32: {
                return "Ice concentrations";
            }
            case 33: {
                return "Ice type";
            }
            case 34: {
                return "Ice edge";
            }
            case 35: {
                return "Cloud water content";
            }
            case 36: {
                return "Surface type";
            }
            case 37: {
                return "Snow indicator";
            }
            case 38: {
                return "Snow/water content";
            }
            case 39: {
                return "Derived volcano imagery";
            }
            case 41: {
                return "Sounder 14.71 micron imagery";
            }
            case 42: {
                return "Sounder 14.37 micron imagery";
            }
            case 43: {
                return "Sounder 14.06 micron imagery";
            }
            case 44: {
                return "Sounder 13.64 micron imagery";
            }
            case 45: {
                return "Sounder 13.37 micron imagery";
            }
            case 46: {
                return "Sounder 12.66 micron imagery";
            }
            case 47: {
                return "Sounder 12.02 micron imagery";
            }
            case 48: {
                return "11.03 micron sounder image";
            }
            case 49: {
                return "Sounder 11.03 micron imagery";
            }
            case 50: {
                return "7.43 micron sounder image";
            }
            case 51: {
                return "7.02 micron sounder image";
            }
            case 52: {
                return "6.51 micron sounder image";
            }
            case 53: {
                return "Sounder 4.57 micron imagery";
            }
            case 54: {
                return "Sounder 4.52 micron imagery";
            }
            case 55: {
                return "4.45 micron sounder image";
            }
            case 56: {
                return "Sounder 4.13 micron imagery";
            }
            case 57: {
                return "3.98 micron sounder image";
            }
            case 58: {
                return "Sounder 3.74 micron imagery";
            }
            case 59: {
                return "VIS sounder image ";
            }
        }
        return "unknown physical element " + phys_elem;
    }

    String getPhysElemSummary(int phys_elem, int ent_id) {
        switch (phys_elem) {
            case 1: {
                return "Satellite Product Imager Visible";
            }
            case 2: {
                return "Satellite Product Imager 3.9 micron IR";
            }
            case 3: {
                return "Satellite Product Imager 6.7/6.5 micron IR (WV)";
            }
            case 4: {
                return "Satellite Product Imager 11 micron IR";
            }
            case 5: {
                return "Satellite Product Imager 12 micron IR";
            }
            case 6: {
                return "Satellite Product Imager 13 micron IR";
            }
            case 7: {
                return "Satellite Product Imager 1.3 micron IR";
            }
            case 13: {
                return "Imager Based Derived Lifted Index LI";
            }
            case 14: {
                return "Imager Based Derived Precipitable Water PW";
            }
            case 15: {
                return "Imager Based Derived Surface Skin Temperature";
            }
            case 16: {
                return "Sounder Based Derived Lifted Index LI";
            }
            case 17: {
                return "Sounder Based Derived Precipitable Water PW";
            }
            case 18: {
                return "Sounder Based Derived Surface Skin Temperature";
            }
            case 19: {
                return "Derived Convective Available Potential Energy CAPE";
            }
            case 20: {
                return "Derived land-sea Temperature";
            }
            case 21: {
                return "Derived Wind Index WINDEX";
            }
            case 22: {
                return "Derived Dry Microburst Potential Index DMPI";
            }
            case 23: {
                return "Derived Microburst Day Potential Index MDPI";
            }
            case 43: {
                return "Satellite Product 14.06 micron sounder image";
            }
            case 48: {
                return "Satellite Product 11.03 micron sounder image";
            }
            case 50: {
                return "Satellite Product 7.43 micron sounder image";
            }
            case 51: {
                return "Satellite Product 7.02 micron sounder image";
            }
            case 52: {
                return "Satellite Product 6.51 micron sounder image";
            }
            case 55: {
                return "Satellite Product 4.45 micron sounder image";
            }
            case 57: {
                return "Satellite Product 3.98 micron sounder image";
            }
            case 59: {
                return "Satellite Product VIS sounder visible image ";
            }
            case 25: {
                if (ent_id == 99) {
                    return "National Hybrid Hydrometeor Classification Composite at Resolution 1 km";
                }
                return "Satellite Derived Volcano_imagery";
            }
            case 26: {
                if (ent_id == 99) {
                    return "Nexrad Level 3 National Echo Tops at Resolution 1 km";
                }
                return "Nexrad Level 3 National Echo Tops at Resolution 4 km";
            }
            case 27: {
                if (ent_id == 99) {
                    return "Nexrad Level 3 Base Reflectivity National Composition at Resolution 1 km";
                }
                return "Gridded Cloud Top Pressure or Height";
            }
            case 28: {
                if (ent_id == 99) {
                    return "Nexrad Level 3 National 248 nm Base Composite Reflectivity at Resolution 2 km";
                }
                return "Gridded Cloud Amount";
            }
            case 29: {
                if (ent_id == 99) {
                    return "Nexrad Level 3 National Vertically Integrated Liquid Water at Resolution 1 km";
                }
                return "Nexrad Level 3 National Vertically Integrated Liquid Water at Resolution 4 km";
            }
            case 30: {
                return "Nexrad Level 3 1 Hour Precipitation National Composition at Resolution 2 km";
            }
            case 31: {
                return "Nexrad Level 3 Storm Total Precipitation National Composition at Resolution 4 km";
            }
        }
        return "unknown";
    }

    private double readScaledInt(ByteBuffer buf) {
        short s1 = buf.getShort();
        short s2 = DataType.unsignedByteToShort((byte)buf.get());
        int posneg = 1 - ((s1 & 0x8000) >> 14);
        int nn = ((s1 & Short.MAX_VALUE) << 8 | s2) * posneg;
        return (double)nn / 10000.0;
    }

    static class Vinfo {
        long begin;
        int nx;
        int ny;
        int[] levels;

        Vinfo(long begin, int x, int y) {
            this.begin = begin;
            this.nx = x;
            this.ny = y;
        }

        Vinfo(long begin, int x, int y, int[] levels) {
            this.begin = begin;
            this.nx = x;
            this.ny = y;
            this.levels = levels;
        }
    }
}

