/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm.nc2;

import dap4.cdm.CDMTypeFcns;
import dap4.cdm.CDMUtil;
import dap4.cdm.nc2.CDMArray;
import dap4.cdm.nc2.CDMArrayAtomic;
import dap4.core.data.DSP;
import dap4.core.data.DataCursor;
import dap4.core.dmr.DapStructure;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.DapException;
import dap4.core.util.DapUtil;
import dap4.core.util.Slice;
import dap4.dap4lib.LibTypeFcns;
import java.nio.ByteBuffer;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.ForbiddenConversionException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;
import ucar.nc2.Group;

class CDMArrayStructure
extends ArrayStructure
implements CDMArray {
    protected Group cdmroot = null;
    protected DSP dsp = null;
    protected DapVariable template = null;
    protected DapType basetype = null;
    protected long dimsize = 0L;
    protected int nmembers = 0;
    protected DataCursor data = null;
    protected FieldArrays[] records = null;

    CDMArrayStructure(Group cdmroot, DataCursor data) {
        super(CDMArrayStructure.computemembers((DapVariable)data.getTemplate()), CDMUtil.computeEffectiveShape(((DapVariable)data.getTemplate()).getDimensions()));
        this.template = (DapVariable)data.getTemplate();
        assert (data.getScheme() == DataCursor.Scheme.STRUCTARRAY);
        this.dsp = data.getDSP();
        this.cdmroot = cdmroot;
        this.basetype = this.template.getBaseType();
        this.dimsize = DapUtil.dimProduct((List)this.template.getDimensions());
        this.nmembers = ((DapStructure)this.template.getBaseType()).getFields().size();
        this.data = data;
        this.sdata = new StructureDataA[(int)this.dimsize];
        this.records = new FieldArrays[(int)this.dimsize];
        int i = 0;
        while ((long)i < this.dimsize) {
            this.sdata[i] = new StructureDataA((ArrayStructure)this, i);
            this.records[i] = new FieldArrays(this.nmembers);
            ++i;
        }
    }

    void add(long recno, int fieldno, Array field) {
        FieldArrays fs = this.records[(int)recno];
        if (fs == null) {
            this.records[(int)recno] = fs = new FieldArrays(this.nmembers);
        }
        fs.fields[fieldno] = field;
    }

    @Override
    public DSP getDSP() {
        return this.dsp;
    }

    @Override
    public DapVariable getTemplate() {
        return this.template;
    }

    @Override
    public DapType getBaseType() {
        return this.basetype;
    }

    public long getSize() {
        return this.dimsize;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        DapVariable var = this.template;
        DapStructure struct = (DapStructure)var.getBaseType();
        int i = 0;
        while ((long)i < this.dimsize) {
            List fields = struct.getFields();
            if ((long)i < this.dimsize - 1L) {
                buf.append("\n");
            }
            buf.append("Structure {\n");
            if (fields != null) {
                for (int j = 0; j < this.nmembers; ++j) {
                    Array field = this.records[i].fields[j];
                    String sfield = field == null ? "null" : fields.toString();
                    buf.append(sfield + "\n");
                }
            }
            buf.append(String.format("} [%d/%d]", i, this.dimsize));
            ++i;
        }
        return buf.toString();
    }

    public StructureData getStructureData(int index) {
        assert (this.sdata != null);
        if (index < 0 || (long)index >= this.dimsize) {
            throw new IllegalArgumentException(index + " >= " + this.sdata.length);
        }
        assert (this.sdata[index] != null);
        return this.sdata[index];
    }

    public double getScalarDouble(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getDouble(0);
    }

    public float getScalarFloat(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getFloat(0);
    }

    public byte getScalarByte(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getByte(0);
    }

    public short getScalarShort(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getShort(0);
    }

    public int getScalarInt(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getInt(0);
    }

    public long getScalarLong(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getLong(0);
    }

    public char getScalarChar(int index, StructureMembers.Member m) {
        CDMArrayAtomic data = this.getAtomicArray(index, m);
        return data.getChar(0);
    }

    public String getScalarString(int recnum, StructureMembers.Member m) {
        Array data = m.getDataArray();
        return data.getObject(recnum).toString();
    }

    public double[] getJavaArrayDouble(int recnum, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(recnum, m);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (double[])LibTypeFcns.convertVector((DapType)DapType.FLOAT64, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public float[] getJavaArrayFloat(int index, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(index, m);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (float[])LibTypeFcns.convertVector((DapType)DapType.FLOAT32, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public byte[] getJavaArrayByte(int index, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(index, m);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (byte[])LibTypeFcns.convertVector((DapType)DapType.INT8, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public short[] getJavaArrayShort(int index, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(index, m);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (short[])LibTypeFcns.convertVector((DapType)DapType.INT16, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public int[] getJavaArrayInt(int index, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(index, m);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (int[])LibTypeFcns.convertVector((DapType)DapType.INT32, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public long[] getJavaArrayLong(int index, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(index, m);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (long[])LibTypeFcns.convertVector((DapType)DapType.INT64, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public char[] getJavaArrayChar(int index, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(index, m);
        if (!array.getBaseType().isNumericType()) {
            throw new IllegalArgumentException("Cannot convert non-numeric type");
        }
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (char[])LibTypeFcns.convertVector((DapType)DapType.CHAR, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public String[] getJavaArrayString(int index, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(index, m);
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (String[])LibTypeFcns.convertVector((DapType)DapType.STRING, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public ByteBuffer[] getJavaArrayOpaque(int index, StructureMembers.Member m) {
        CDMArrayAtomic array = this.getAtomicArray(index, m);
        DapType atomtype = array.getBaseType();
        try {
            List<Slice> slices = CDMUtil.shapeToSlices(m.getShape());
            Object vector = this.data.read(slices);
            return (ByteBuffer[])LibTypeFcns.convertVector((DapType)DapType.OPAQUE, (DapType)atomtype, (Object)vector);
        }
        catch (DapException de) {
            throw new UnsupportedOperationException(de);
        }
    }

    public StructureData getScalarStructure(int index, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new ForbiddenConversionException("Atomic field cannot be converted to Structure");
        }
        Array ca = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (ca.getDataType() != DataType.STRUCTURE && ca.getDataType() != DataType.SEQUENCE) {
            throw new ForbiddenConversionException("Attempt to access non-structure member");
        }
        CDMArrayStructure as = (CDMArrayStructure)ca;
        return as.getStructureData(0);
    }

    public ArrayStructure getArrayStructure(int index, StructureMembers.Member m) {
        if (m.getDataType() != DataType.STRUCTURE) {
            throw new ForbiddenConversionException("Atomic field cannot be converted to Structure");
        }
        Array dd = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (dd.getDataType() != DataType.STRUCTURE && dd.getDataType() != DataType.SEQUENCE) {
            throw new ForbiddenConversionException("Attempt to access non-structure member");
        }
        return (CDMArrayStructure)dd;
    }

    public ArraySequence getArraySequence(StructureMembers.Member m) {
        throw new UnsupportedOperationException("CDMArraySequence");
    }

    public Array copy() {
        return this;
    }

    public Array getArray(int recno, StructureMembers.Member m) {
        return this.memberArray(recno, CDMArrayStructure.memberIndex(m));
    }

    protected StructureData makeStructureData(ArrayStructure as, int index) {
        if (this.sdata[index] == null) {
            this.sdata[index] = new StructureDataA(as, index);
        }
        return this.sdata[index];
    }

    static StructureMembers computemembers(DapVariable var) {
        DapStructure ds = (DapStructure)var.getBaseType();
        StructureMembers sm = new StructureMembers(ds.getShortName());
        List fields = ds.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            DapVariable field = (DapVariable)fields.get(i);
            DapType dt = field.getBaseType();
            DataType cdmtype = CDMTypeFcns.daptype2cdmtype(dt);
            StructureMembers.Member m = sm.addMember(field.getShortName(), "", null, cdmtype, CDMUtil.computeEffectiveShape(field.getDimensions()));
            m.setDataParam(i);
            if (!dt.getTypeSort().isStructType()) continue;
            StructureMembers subsm = CDMArrayStructure.computemembers(field);
            m.setStructureMembers(subsm);
        }
        return sm;
    }

    protected Array memberArray(int recno, int memberindex) {
        DapVariable var = this.getTemplate();
        DapStructure struct = (DapStructure)var.getBaseType();
        DapVariable field = struct.getField(memberindex);
        DapType base = field.getBaseType();
        if (base == null) {
            throw new IllegalStateException("Unknown field type: " + field);
        }
        Object[] values = new Object[(int)field.getCount()];
        FieldArrays fs = this.records[recno];
        Array fa = fs.fields[memberindex];
        return fa;
    }

    protected static int memberIndex(StructureMembers.Member m) {
        return m.getDataParam();
    }

    protected CDMArrayAtomic getAtomicArray(int index, StructureMembers.Member m) {
        Array dd = this.memberArray(index, CDMArrayStructure.memberIndex(m));
        if (dd.getDataType() != DataType.STRUCTURE && dd.getDataType() != DataType.SEQUENCE) {
            return (CDMArrayAtomic)dd;
        }
        throw new ForbiddenConversionException("Cannot convert structure to AtomicArray");
    }

    protected static class FieldArrays {
        public Array[] fields;

        FieldArrays(int nfields) {
            this.fields = new Array[nfields];
        }
    }
}

