/*
 * Decompiled with CFR 0.152.
 */
package dap4.cdm;

import dap4.cdm.CDMArray;
import dap4.cdm.CDMDataset;
import dap4.cdmshared.CDMUtil;
import dap4.core.dmr.AtomicType;
import dap4.core.dmr.DapType;
import dap4.core.dmr.DapVariable;
import dap4.core.util.Convert;
import dap4.core.util.DapUtil;
import dap4.dap4shared.D4DSP;
import dap4.dap4shared.D4DataAtomic;
import dap4.dap4shared.DSP;
import dap4.dap4shared.Dap4Util;
import java.io.IOException;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;

public class CDMArrayAtomic
extends Array
implements CDMArray {
    protected CDMDataset root = null;
    protected D4DSP dsp = null;
    protected DapVariable template = null;
    protected long bytesize = 0L;
    protected DapType basetype = null;
    protected AtomicType primitivetype = null;
    protected D4DataAtomic d4data = null;
    protected int elementsize = 0;
    protected long dimsize = 0L;
    protected long totalsize = 0L;
    protected boolean isbytestring = false;
    protected int[] bytestrings = null;
    protected int totalbytestringsize = 0;

    CDMArrayAtomic(D4DSP dsp, CDMDataset root, D4DataAtomic d4data) {
        super(CDMUtil.daptype2cdmtype((DapType)((DapVariable)d4data.getTemplate()).getBaseType()), CDMUtil.computeEffectiveShape((List)((DapVariable)d4data.getTemplate()).getDimensions()));
        this.dsp = dsp;
        this.root = root;
        this.d4data = d4data;
        this.template = (DapVariable)d4data.getTemplate();
        this.basetype = this.template.getBaseType();
        this.primitivetype = this.basetype.getPrimitiveType();
        this.isbytestring = this.primitivetype.isStringType() || this.primitivetype.isOpaqueType();
        this.dimsize = DapUtil.dimProduct((List)this.template.getDimensions());
        this.elementsize = Dap4Util.daptypeSize((AtomicType)this.primitivetype);
        this.bytesize = this.computeTotalSize();
    }

    @Override
    public DSP getDSP() {
        return this.dsp;
    }

    @Override
    public CDMDataset getRoot() {
        return this.root;
    }

    @Override
    public DapVariable getTemplate() {
        return this.template;
    }

    @Override
    public long getByteSize() {
        return this.bytesize;
    }

    @Override
    public DapType getBaseType() {
        return this.basetype;
    }

    @Override
    public AtomicType getPrimitiveType() {
        return this.primitivetype;
    }

    public long getSize() {
        return this.dimsize;
    }

    public D4DataAtomic getData() {
        return this.d4data;
    }

    void setup(int index) {
        if (index < 0 || (long)index > this.dimsize) {
            throw new IndexOutOfBoundsException("Dap4Array: " + index);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        DapType basetype = this.getBaseType();
        String sbt = basetype == null ? "?" : basetype.toString();
        String st = this.template == null ? "?" : this.template.getShortName();
        buf.append(String.format("%s %s[%d]", sbt, st, this.dimsize));
        return buf.toString();
    }

    protected long computeTotalSize() {
        this.totalsize = this.isbytestring ? (long)this.totalbytestringsize : (long)this.elementsize * this.dimsize;
        return this.totalsize;
    }

    public Class getElementType() {
        DataType dt = CDMUtil.daptype2cdmtype((DapType)this.basetype);
        if (dt == null) {
            throw new IllegalArgumentException("Unknown datatype: " + this.basetype);
        }
        return CDMUtil.cdmElementClass((DataType)dt);
    }

    public double getDouble(int index) {
        this.setup(index);
        try {
            Object value = this.d4data.read((long)index);
            return Convert.doubleValue((DapType)this.basetype, (Object)value);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public float getFloat(int index) {
        this.setup(index);
        try {
            Object value = this.d4data.read((long)index);
            return (float)Convert.doubleValue((DapType)this.basetype, (Object)value);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public long getLong(int index) {
        this.setup(index);
        try {
            Object value = this.d4data.read((long)index);
            return Convert.longValue((DapType)this.basetype, (Object)value);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public int getInt(int index) {
        this.setup(index);
        try {
            Object value = this.d4data.read((long)index);
            return (int)Convert.longValue((DapType)this.basetype, (Object)value);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public short getShort(int index) {
        this.setup(index);
        try {
            Object value = this.d4data.read((long)index);
            return (short)Convert.longValue((DapType)this.basetype, (Object)value);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public byte getByte(int index) {
        this.setup(index);
        try {
            Object value = this.d4data.read((long)index);
            return (byte)(Convert.longValue((DapType)this.basetype, (Object)value) & 0xFFL);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public char getChar(int index) {
        this.setup(index);
        try {
            Object value = this.d4data.read((long)index);
            return (char)(Convert.longValue((DapType)this.basetype, (Object)value) & 0xFFL);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public boolean getBoolean(int index) {
        this.setup(index);
        try {
            Object value = this.d4data.read((long)index);
            return Convert.longValue((DapType)this.basetype, (Object)value) != 0L;
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public Object getObject(int index) {
        this.setup(index);
        try {
            return this.d4data.read((long)index);
        }
        catch (IOException ioe) {
            throw new IndexOutOfBoundsException(ioe.getMessage());
        }
    }

    public double getDouble(Index idx) {
        return this.getDouble(idx.currentElement());
    }

    public float getFloat(Index idx) {
        return this.getFloat(idx.currentElement());
    }

    public long getLong(Index idx) {
        return this.getLong(idx.currentElement());
    }

    public int getInt(Index idx) {
        return this.getInt(idx.currentElement());
    }

    public short getShort(Index idx) {
        return this.getShort(idx.currentElement());
    }

    public byte getByte(Index idx) {
        return this.getByte(idx.currentElement());
    }

    public char getChar(Index idx) {
        return this.getChar(idx.currentElement());
    }

    public boolean getBoolean(Index idx) {
        return this.getBoolean(idx.currentElement());
    }

    public Object getObject(Index idx) {
        return this.getObject(idx.currentElement());
    }

    public void setDouble(Index ima, double value) {
        throw new UnsupportedOperationException();
    }

    public void setFloat(Index ima, float value) {
        throw new UnsupportedOperationException();
    }

    public void setLong(Index ima, long value) {
        throw new UnsupportedOperationException();
    }

    public void setInt(Index ima, int value) {
        throw new UnsupportedOperationException();
    }

    public void setShort(Index ima, short value) {
        throw new UnsupportedOperationException();
    }

    public void setByte(Index ima, byte value) {
        throw new UnsupportedOperationException();
    }

    public void setChar(Index ima, char value) {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(Index ima, boolean value) {
        throw new UnsupportedOperationException();
    }

    public void setObject(Index ima, Object value) {
        throw new UnsupportedOperationException();
    }

    public void setDouble(int elem, double value) {
        throw new UnsupportedOperationException();
    }

    public void setFloat(int elem, float value) {
        throw new UnsupportedOperationException();
    }

    public void setLong(int elem, long value) {
        throw new UnsupportedOperationException();
    }

    public void setInt(int elem, int value) {
        throw new UnsupportedOperationException();
    }

    public void setShort(int elem, short value) {
        throw new UnsupportedOperationException();
    }

    public void setByte(int elem, byte value) {
        throw new UnsupportedOperationException();
    }

    public void setChar(int elem, char value) {
        throw new UnsupportedOperationException();
    }

    public void setBoolean(int elem, boolean value) {
        throw new UnsupportedOperationException();
    }

    public void setObject(int elem, Object value) {
        throw new UnsupportedOperationException();
    }

    public Object getStorage() {
        throw new UnsupportedOperationException();
    }

    protected void copyTo1DJavaArray(IndexIterator indexIterator, Object o) {
        throw new UnsupportedOperationException();
    }

    protected void copyFrom1DJavaArray(IndexIterator iter, Object javaArray) {
        throw new UnsupportedOperationException();
    }

    protected Array createView(Index index) {
        return this;
    }
}

